/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.history;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVMusicInfo;
import com.yy.hiyo.channel.component.base.ui.widget.BottomSecondaryPanel;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.ISelectSongListener;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.history.KTVHistoryMvp;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.view.KTVMusicItemAdapter;
import java.util.List;

public class KTVHistoryView
extends BottomSecondaryPanel
implements KTVHistoryMvp.IView,
View.OnClickListener,
KTVMusicItemAdapter.ItemClickListener {
    private KTVHistoryMvp.IPresenter mPresenter;
    private YYImageView closeIv;
    private RecyclerView mRvHistory;
    private CommonStatusLayout mHistoryStatusLayout;
    private KTVMusicItemAdapter mHistoryAdapter;
    private ISelectSongListener mSelectSongListener;

    public KTVHistoryView(Context context) {
        super(context);
        this.createView();
    }

    private void createView() {
        View.inflate((Context)this.mContext, (int)R.layout.layout_history_channel, (ViewGroup)this);
        ((YYTextView)this.findViewById(R.id.tv_title)).setText((CharSequence)ResourceUtils.getString((int)R.string.title_ktv_record));
        this.closeIv = (YYImageView)this.findViewById(R.id.iv_close);
        this.findViewById(R.id.ll_container).setOnClickListener((View.OnClickListener)this);
        this.closeIv.setOnClickListener((View.OnClickListener)this);
        this.initHistoryPager();
    }

    private void initHistoryPager() {
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        this.mRvHistory = (RecyclerView)this.findViewById(R.id.rv_song_history);
        this.mHistoryStatusLayout = (CommonStatusLayout)this.findViewById(R.id.csl_status);
        this.mHistoryAdapter = new KTVMusicItemAdapter(this.getContext(), 2);
        this.mHistoryAdapter.setOnItemClickListener(this);
        this.mRvHistory.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mRvHistory.setAdapter((RecyclerView.Adapter)this.mHistoryAdapter);
        this.mHistoryStatusLayout.showNoData(R.drawable.icon_default_no_data, ResourceUtils.getString((int)R.string.short_tips_no_song), null);
    }

    @Override
    public void updateHistory(List<KTVMusicInfo> list) {
        if (FP.empty(list)) {
            this.mHistoryStatusLayout.showNoData(R.drawable.icon_default_no_data, ResourceUtils.getString((int)R.string.short_tips_no_song), null);
        } else {
            this.mHistoryStatusLayout.hideNoData();
        }
        this.mHistoryAdapter.setData(list);
    }

    public void setPresenter(KTVHistoryMvp.IPresenter presenter) {
        this.mPresenter = presenter;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.iv_close) {
            this.closeIv.setEnabled(false);
            this.hideView();
        }
    }

    @Override
    public void onItemClick(KTVMusicInfo song) {
        if (null != this.mSelectSongListener) {
            this.mSelectSongListener.selectSong(song, "2");
        }
    }

    public void setOnSelectSongListener(ISelectSongListener listener) {
        this.mSelectSongListener = listener;
    }
}

