/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.list.musiclibrary;

import android.content.Context;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.PanelLayer;
import com.yy.hiyo.channel.cbase.channelhiido.RadioUtils;
import com.yy.hiyo.channel.cbase.module.ktv.KTVCommonCallback;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVMusicInfo;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomData;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomSongInfo;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVHandler;
import com.yy.hiyo.channel.plugins.ktv.common.base.KTVCommonPresenter;
import com.yy.hiyo.channel.plugins.ktv.common.callback.IKTVProtoCallback;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.IKTVMusicLibraryOperator;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.IPanelHideListener;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.ISelectSongListener;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.KTVLibraryContract;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.history.KTVHistoryPresenter;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.ranking.KTVRankingPresenter;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.singers.KTVSingersPresenter;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.view.KTVLibraryPanel;
import com.yy.hiyo.channel.plugins.ktv.model.room.KTVRoomServices;
import com.yy.hiyo.channel.plugins.ktv.model.songList.KTVMusicListProvider;
import com.yy.hiyo.channel.plugins.ktv.utils.KTVEventReportUtil;
import com.yy.hiyo.mvp.base.callback.IDestroyable;
import com.yy.hiyo.mvp.base.callback.WeakCallback;
import java.util.ArrayList;
import java.util.List;
import net.ihago.ktv.api.search.ErrCode;

public class KTVLibraryPresenter
extends KTVCommonPresenter
implements KTVLibraryContract.Presenter,
ISelectSongListener {
    public static final String TAG = "KTVLibraryPresenter";
    public static final int MODE_KTV = 0;
    public static final int MODE_KRADIO = 1;
    private PanelLayer mLayer;
    private KTVMusicInfo mRequestMusic;
    private KTVLibraryOperator mOperator;
    private KTVLibraryContract.View mView;
    private KTVSingersPresenter mSingersPresenter;
    private KTVRankingPresenter mRankingPresenter;
    private KTVHistoryPresenter mHistoryPresenter;
    private List<IPanelHideListener> panelHideListeners = new ArrayList<IPanelHideListener>();
    private boolean mHasNext;
    public static int mMode;
    private final KvoBinder mBinder = new KvoBinder((Object)this);
    private CheckSelsectPolicyRunable mCheckSelsectPolicyRunable = new CheckSelsectPolicyRunable();

    public KTVLibraryPresenter(PanelLayer layer, @NonNull IKTVHandler iktvHandle) {
        super(iktvHandle);
        this.mLayer = layer;
        this.mOperator = new KTVLibraryOperator();
    }

    @KvoMethodAnnotation(name="mKTVRoomSongInfoList", sourceClass=KTVRoomServices.class)
    public void onSongListChanged(KvoEventIntent data) {
        final List<KTVRoomSongInfo> list = ((KTVRoomServices)data.source()).getKTVRoomSongInfoList();
        FeatureLog.i((String)"FTKTVList_KTVLibraryPresenter", (String)"onSongListChanged, size = %s", (Object[])new Object[]{list == null ? 0 : list.size()});
        if (YYTaskExecutor.isMainThread()) {
            if (this.mView != null) {
                this.mView.updateSongListCount(list.size());
            }
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (KTVLibraryPresenter.this.mView != null) {
                        KTVLibraryPresenter.this.mView.updateSongListCount(list.size());
                    }
                }
            });
        }
    }

    @Override
    public void onKTVDestroy() {
        this.mBinder.clearAllKvoConnections();
        if (this.mView != null) {
            this.mView.hide();
        }
        this.mLayer = null;
        this.mView = null;
    }

    @KvoMethodAnnotation(sourceClass=KTVMusicListProvider.class, name="libraryDataChanged")
    public void onLibraryChanged(KvoEventIntent data) {
        final List<KTVMusicInfo> list = ((KTVMusicListProvider)data.source()).getLibraryList();
        FeatureLog.i((String)"FTKTVList", (String)"onLibraryChanged, size = %s", (Object[])new Object[]{list == null ? 0 : list.size()});
        if (YYTaskExecutor.isMainThread()) {
            if (this.mView != null) {
                this.mView.updateLibrary(list, true);
            }
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (KTVLibraryPresenter.this.mView != null) {
                        KTVLibraryPresenter.this.mView.updateLibrary(list, true);
                    }
                }
            });
        }
    }

    public void setHasNext(boolean hasNext) {
        this.mHasNext = hasNext;
    }

    public void onKTVCreate() {
        this.mBinder.clearAllKvoConnections();
        this.mBinder.singleBindSourceTo((KvoSource)this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData());
    }

    public void start() {
        FeatureLog.i((String)"FTKTVList_KTVLibraryPresenter", (String)"start", (Object[])new Object[0]);
        this.getSongList(true);
        this.mBinder.singleBindSourceTo((KvoSource)((KTVMusicListProvider)this.getHandler().getKTVManager().getKTVMusicListProvider()));
        this.mBinder.singleBindSourceTo((KvoSource)((KTVRoomServices)this.getHandler().getKTVManager().getKTVRoomServices()));
    }

    @Override
    public void stop() {
        FeatureLog.i((String)"FTKTVList_KTVLibraryPresenter", (String)"stop", (Object[])new Object[0]);
        this.mBinder.clearKvoConnection(KTVMusicListProvider.class.getName());
        this.mBinder.clearKvoConnection(KTVRoomServices.class.getName());
    }

    @KvoMethodAnnotation(sourceClass=KTVRoomData.class, name="mPolicy", thread=1)
    public void onPolicyChanged(KvoEventIntent event) {
        this.checkSelectSongPolicy(KTVRoomData.getSelectSongPolicy((int)((Integer)event.oldValue())), KTVRoomData.getSelectSongPolicy((int)((Integer)event.newValue())));
    }

    private void checkSelectSongPolicy(int oldPolicy, int newPolicy) {
        if (oldPolicy == 1 && newPolicy == 2) {
            this.mCheckSelsectPolicyRunable.run();
        }
    }

    @Override
    public void openSongListPanel() {
        if (this.mView != null) {
            this.mView.hide();
        }
        this.getHandler().getKTVOperateProvider().getIKTVSongListOperator().showSongListPanel();
    }

    @Override
    public void getSongList(final boolean isFirstPage) {
        this.getHandler().getKTVManager().getKTVMusicListProvider().getPagingMusicList(isFirstPage, new IKTVProtoCallback<KTVMusicListProvider.KTVSongListResponse>(){

            @Override
            public void onSuccess(@NonNull KTVMusicListProvider.KTVSongListResponse data) {
                KTVLibraryPresenter.this.mHasNext = data.hasNext;
                if (KTVLibraryPresenter.this.mView != null) {
                    KTVLibraryPresenter.this.mView.updateLibrary(data.songList, isFirstPage);
                }
            }

            @Override
            public void onError(int code, String errorMessage) {
                if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
                }
            }
        });
    }

    @Override
    public void requestSong(KTVMusicInfo songInfo, String pgType) {
        if (!this.getHandler().getmRoomDataContainer().getSeatData().isInSeat(AccountUtil.getUid()) && !this.getHandler().getKTVManager().getKTVRoomServices().hasWhiteRoomConfig()) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tip_multi_video_no_inseat_click_song), (int)0);
            return;
        }
        this.mRequestMusic = songInfo;
        this.mCheckSelsectPolicyRunable.pgType = pgType;
        if (this.checkSelectSongPolicyWithRunable()) {
            this.requestMusic(songInfo, pgType);
        } else if (this.mView != null && songInfo != null) {
            KTVEventReportUtil.reportClickSong(songInfo.getSongId(), pgType, "2", "4");
        }
    }

    private void requestMusic(final KTVMusicInfo musicInfo, final String pgType) {
        FeatureLog.i((String)"FTKTVList", (String)"requestMusic, musicInfo : %s", (Object[])new Object[]{musicInfo});
        if (musicInfo != null) {
            if (!this.getHandler().getKTVManager().getKTVRoomServices().isMySong(musicInfo.getSongId())) {
                if (!this.getHandler().getKTVManager().getKTVRoomServices().canAddSong()) {
                    TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.tips_request_song_reach_limit), (int)0);
                    if (this.mView != null) {
                        String reason = "";
                        if (this.getHandler().getKTVManager().getKTVRoomServices().getMySongList().size() >= 25) {
                            reason = "3";
                        } else if (this.getHandler().getKTVManager().getKTVRoomServices().getKTVRoomSongInfoList().size() >= 50) {
                            reason = "2";
                        }
                        KTVEventReportUtil.reportClickSong(musicInfo.getSongId(), pgType, "2", reason);
                    }
                    return;
                }
                if (this.mView != null) {
                    this.mView.showLoading();
                }
                MLog.info((Object)"KTVAddSong", (String)"start add song current time: %s", (Object[])new Object[]{System.currentTimeMillis()});
                this.getHandler().getKTVManager().getKTVRoomServices().addSong(musicInfo.getSongId(), (KTVCommonCallback)new KTVCommonCallback<Boolean>(){

                    public void onSuccess(Boolean data) {
                        if (KTVLibraryPresenter.this.mView != null) {
                            KTVLibraryPresenter.this.mView.hideLoading();
                            KTVEventReportUtil.reportClickSong(musicInfo.getSongId(), pgType, "1", "");
                        }
                        KTVLibraryPresenter.this.mRequestMusic = null;
                        KTVLibraryPresenter.this.getHandler().getKTVManager().getKTVMusicListProvider().setMusicRequestStatus(musicInfo.getSongId(), true);
                    }

                    public void onFail(int code, String errorMessage) {
                        if (KTVLibraryPresenter.this.mView != null) {
                            KTVLibraryPresenter.this.mView.hideLoading();
                        }
                        KTVLibraryPresenter.this.mRequestMusic = null;
                        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
                        }
                        if (code == ErrCode.kErrNotFound.getValue()) {
                            TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.tips_song_not_exist), (int)0);
                            if (KTVLibraryPresenter.this.mView != null) {
                                KTVEventReportUtil.reportClickSong(musicInfo.getSongId(), pgType, "1", "5");
                            }
                        } else if (code == ErrCode.kErrSongStatusDiscontinued.getValue()) {
                            TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.tips_song_removed), (int)0);
                            if (KTVLibraryPresenter.this.mView != null) {
                                KTVEventReportUtil.reportClickSong(musicInfo.getSongId(), pgType, "1", "6");
                            }
                        }
                    }
                });
            } else if (this.mView != null) {
                KTVEventReportUtil.reportClickSong(musicInfo.getSongId(), pgType, "2", "8");
            }
        }
    }

    @Override
    public void openSearchWindow() {
        MsgDispatcher.getInstance().sendMessage(BaseMsgDef.OPEN_SEARCH_SONG_WINDOW, (Object)this.getHandler());
    }

    @Override
    public boolean getHasNext() {
        return this.mHasNext;
    }

    public KTVLibraryOperator getContract() {
        return this.mOperator;
    }

    @Override
    public boolean addSongFromChat(final String songId, final KTVCommonCallback callback) {
        boolean checkSelectSongPlicy = this.checkSelectSongPolicyWithRunable(new ISitDownCallback(){

            @Override
            public void onSuccess() {
                if (null == KTVLibraryPresenter.this.getHandler() || null == KTVLibraryPresenter.this.getHandler().getKTVManager()) {
                    FeatureLog.i((String)"FTKTVBase", (String)"addSongFromChat data=null", (Object[])new Object[0]);
                    return;
                }
                KTVLibraryPresenter.this.getHandler().getKTVManager().getKTVRoomServices().addSong(songId, (KTVCommonCallback)new KTVCommonCallback<Boolean>(){

                    public void onSuccess(Boolean data) {
                        if (null != callback) {
                            callback.onSuccess((Object)data);
                        }
                        if (null != KTVLibraryPresenter.this.getHandler() && null != KTVLibraryPresenter.this.getHandler().getKTVManager()) {
                            KTVLibraryPresenter.this.getHandler().getKTVManager().getKTVMusicListProvider().setMusicRequestStatus(songId, true);
                        }
                    }

                    public void onFail(int code, String errorMessage) {
                        if (null != callback) {
                            callback.onFail(code, errorMessage);
                        }
                    }
                });
            }
        });
        FeatureLog.i((String)"FTKTVBase", (String)"addSongFromChat songId:%s, checkSelectSongPlicy:%s", (Object[])new Object[]{songId, checkSelectSongPlicy});
        return checkSelectSongPlicy;
    }

    private boolean checkSelectSongPolicyWithRunable() {
        return this.checkSelectSongPolicyWithRunable(null);
    }

    private boolean checkSelectSongPolicyWithRunable(final ISitDownCallback sitDownCallback) {
        if (this.getHandler().getKTVManager().getKTVRoomServices().hasWhiteRoomConfig()) {
            return true;
        }
        if (this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData().getSelectSongPolicy() == 1 && !this.getHandler().getKTVManager().getContext().getRoomData().getSeatData().isInSeat(AccountUtil.getUid())) {
            if (this.getHandler().getKTVManager().getContext().getRoomData().getGameInfo().getMode() == 15) {
                return true;
            }
            if (this.getHandler().getKTVManager().getContext().getRoomData().getSeatData().isSeatFullWithLocked()) {
                TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.select_song_must_inseat), (int)0);
                if (this.mCheckSelsectPolicyRunable != null) {
                    this.mCheckSelsectPolicyRunable.reset();
                }
                return false;
            }
            final Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.select_song_must_inseat), (int)0);
                    if (KTVLibraryPresenter.this.mCheckSelsectPolicyRunable != null) {
                        KTVLibraryPresenter.this.mCheckSelsectPolicyRunable.reset();
                    }
                }
            };
            if (null != this.getHandler().getKTVOperateProvider().getRoomOperater()) {
                this.getHandler().getKTVOperateProvider().getRoomOperater().getExtRoomOperater().onSitDownRandom((Callback)WeakCallback.of((IDestroyable)this, (Callback)new Callback(){

                    public void onResponse(Object data) {
                        if (data == null) {
                            runnable.run();
                        } else if (sitDownCallback != null) {
                            sitDownCallback.onSuccess();
                        }
                    }
                }));
            }
            return false;
        }
        if (this.mCheckSelsectPolicyRunable != null) {
            this.mCheckSelsectPolicyRunable.reset();
        }
        if (sitDownCallback != null) {
            sitDownCallback.onSuccess();
        }
        return true;
    }

    @Override
    public void onPanelHidden() {
        for (IPanelHideListener listener : this.panelHideListeners) {
            if (null == listener) continue;
            listener.onPanelHiden();
        }
    }

    @Override
    public void onSingersClick(Context context, ViewGroup wrapper) {
        if (null == this.mSingersPresenter) {
            this.mSingersPresenter = new KTVSingersPresenter(context, this.getHandler(), wrapper);
            this.mSingersPresenter.setOnSelectSongListener(this);
            this.panelHideListeners.add(this.mSingersPresenter);
        }
        this.mSingersPresenter.showView();
        if (mMode == 0) {
            KTVEventReportUtil.reportSingersClick();
        } else {
            RadioUtils.INSTANCE.reportSingersClick();
        }
    }

    @Override
    public void onRankingClick(Context context, ViewGroup wrapper) {
        if (null == this.mRankingPresenter) {
            this.mRankingPresenter = new KTVRankingPresenter(context, this.getHandler(), wrapper);
            this.mRankingPresenter.setOnSelectSongListener(this);
            this.panelHideListeners.add(this.mRankingPresenter);
        }
        this.mRankingPresenter.showView();
        if (mMode == 0) {
            KTVEventReportUtil.reportRankingsClick();
        } else {
            RadioUtils.INSTANCE.reportRankingsClick();
        }
    }

    @Override
    public void onRecordClick(Context context, ViewGroup wrapper) {
        if (null == this.mHistoryPresenter) {
            this.mHistoryPresenter = new KTVHistoryPresenter(context, this.getHandler(), wrapper);
            this.mHistoryPresenter.setOnSelectSongListener(this);
            this.panelHideListeners.add(this.mHistoryPresenter);
        }
        this.mHistoryPresenter.showView();
    }

    @Override
    public void selectSong(KTVMusicInfo song, String pgType) {
        this.requestSong(song, pgType);
    }

    private static interface ISitDownCallback {
        public void onSuccess();
    }

    class CheckSelsectPolicyRunable
    implements Runnable {
        boolean isNeedOplib = false;
        String pgType = "1";

        CheckSelsectPolicyRunable() {
        }

        @Override
        public void run() {
            if (this.isNeedOplib && KTVLibraryPresenter.this.mOperator != null) {
                KTVLibraryPresenter.this.mOperator.showMusicLibrary();
            }
            KTVLibraryPresenter.this.requestMusic(KTVLibraryPresenter.this.mRequestMusic, this.pgType);
            this.reset();
        }

        public void reset() {
            this.isNeedOplib = false;
            KTVLibraryPresenter.this.mRequestMusic = null;
        }
    }

    public class KTVLibraryOperator
    implements IKTVMusicLibraryOperator {
        @Override
        public void showMusicLibrary() {
            ((KTVLibraryPresenter)KTVLibraryPresenter.this).mCheckSelsectPolicyRunable.isNeedOplib = true;
            if (!KTVLibraryPresenter.this.checkSelectSongPolicyWithRunable()) {
                return;
            }
            if (KTVLibraryPresenter.this.mView == null) {
                KTVLibraryPresenter.this.mView = new KTVLibraryPanel(KTVLibraryPresenter.this.mLayer);
                KTVLibraryPresenter.this.mView.setPresenter(KTVLibraryPresenter.this);
            }
            KTVLibraryPresenter.this.mView.show();
            KTVLibraryPresenter.this.mCheckSelsectPolicyRunable.reset();
        }

        @Override
        public void hideMusicLibrary() {
            if (KTVLibraryPresenter.this.mView != null) {
                KTVLibraryPresenter.this.mView.hide();
            }
        }

        @Override
        public void setMode(int mode) {
            mMode = mode;
        }
    }
}

