/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.upload.scan;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.data.MusicPlaylistDBBean;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.channel.cbase.module.ktv.base.IKTVScanLocalMusicWindow;
import com.yy.hiyo.channel.plugins.ktv.DR;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.upload.scan.KTVLocalMusicItemAdapter;
import com.yy.hiyo.channel.plugins.ktv.upload.scan.KTVScanLocalMusicController;
import java.util.List;

public class KTVScanLocalMusicWindow
extends DefaultWindow
implements View.OnClickListener,
IKTVScanLocalMusicWindow,
KTVLocalMusicItemAdapter.OnItemClickListener {
    private YYTextView mTvTitle;
    private YYTextView mTvRescan;
    private YYImageView mIvBack;
    private RecyclerView mRvMusicList;
    private CommonStatusLayout mCslStatus;
    private KTVLocalMusicItemAdapter mAdapter;
    private KTVScanLocalMusicController mCallback;

    public KTVScanLocalMusicWindow(Context context, KTVScanLocalMusicController callBacks) {
        super(context, (UICallBacks)callBacks, "KTVScan");
        this.mCallback = callBacks;
        this.createView();
    }

    private void createView() {
        View rootView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.window_ktv_scan_local_music_channel, (ViewGroup)this.getBarLayer(), true);
        this.mIvBack = (YYImageView)rootView.findViewById(R.id.iv_back);
        this.mTvTitle = (YYTextView)rootView.findViewById(R.id.tv_title);
        this.mTvRescan = (YYTextView)rootView.findViewById(R.id.tv_rescan);
        this.mCslStatus = (CommonStatusLayout)rootView.findViewById(R.id.csl_status);
        this.mRvMusicList = (RecyclerView)rootView.findViewById(R.id.rv_music_list);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        this.mRvMusicList.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mAdapter = new KTVLocalMusicItemAdapter(this.getContext());
        this.mRvMusicList.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mAdapter.setOnItemClickListener(this::onItemClick);
        this.mIvBack.setOnClickListener(this::onClick);
        this.mTvRescan.setOnClickListener(this::onClick);
    }

    public void updateMusicList(List<MusicPlaylistDBBean> list) {
        this.mRvMusicList.setVisibility(0);
        if (!FP.empty(list)) {
            this.mTvTitle.setText((CharSequence)ResourceUtils.getString((int)R.string.tip_choose_local_song));
        } else {
            this.mTvTitle.setText((CharSequence)ResourceUtils.getString((int)R.string.title_local_music));
        }
        this.mAdapter.setData(list);
    }

    public void showLoading() {
        this.mTvTitle.setText((CharSequence)ResourceUtils.getString((int)R.string.title_local_music));
        this.mCslStatus.showLoading(ResourceUtils.getString((int)R.string.tips_scanning), DR.music_scanning_grey, ResolutionUtils.dip2Px((float)130.0f), ResolutionUtils.dip2Px((float)130.0f));
    }

    public void hideLoading() {
        this.mCslStatus.hideLoading();
    }

    public void showNoData() {
        this.mCslStatus.showNoDataCenter(R.drawable.icon_search_result_no_data, ResourceUtils.getString((int)R.string.tips_no_music_available), null);
    }

    public void hideNoData() {
        this.mCslStatus.hideNoData();
    }

    public void onClick(View v) {
        if (v.getId() == R.id.iv_back) {
            this.mCallback.closeWindow();
        } else if (v.getId() == R.id.tv_rescan) {
            this.mRvMusicList.setVisibility(8);
            this.mCallback.getMusicFiles(true);
        }
    }

    @Override
    public void onItemClick(MusicPlaylistDBBean music) {
        MsgDispatcher.getInstance().sendMessage(BaseMsgDef.KTV_SEL_UPLOAD_SONG, (Object)music);
        this.mCallback.closeWindow();
    }
}

