/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.model.songList;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.gson.reflect.TypeToken;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoFieldAnnotation;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.channel.cbase.module.ktv.KTVCommonCallback;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVMusicInfo;
import com.yy.hiyo.channel.plugins.ktv.apiservice.KTVProtoService;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVManager;
import com.yy.hiyo.channel.plugins.ktv.common.base.KTVBaseContext;
import com.yy.hiyo.channel.plugins.ktv.common.base.KTVBaseModel;
import com.yy.hiyo.channel.plugins.ktv.common.bean.KTVRankingInfo;
import com.yy.hiyo.channel.plugins.ktv.common.callback.IKTVProtoCallback;
import com.yy.hiyo.channel.plugins.ktv.common.callback.IKTVQueryCallback;
import com.yy.hiyo.channel.plugins.ktv.list.searchsong.KTVAssociateSearchModel;
import com.yy.hiyo.channel.plugins.ktv.model.songList.IKTVMusicList;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import net.ihago.ktv.api.search.DirectlySearchRsp;
import net.ihago.ktv.api.search.GetHotResponse;
import net.ihago.ktv.api.search.GetRankingRsp;
import net.ihago.ktv.api.search.GetSongBySingerRsp;
import net.ihago.ktv.api.search.GetSuggestResponse;
import net.ihago.ktv.api.search.RankingType;
import net.ihago.ktv.api.search.RepoGetResponse;
import net.ihago.ktv.api.search.SearchRecord;
import net.ihago.ktv.api.search.SearchResponse;
import net.ihago.ktv.api.search.SearchType;
import net.ihago.ktv.api.search.Song;
import net.ihago.ktv.api.search.SuggestedRecord;

public class KTVMusicListProvider
extends KTVBaseModel
implements IKTVMusicList {
    public static final String MUSIC_HISTORY_FILE_NAME = "Music_History";
    public static final String SEARCH_HISTROY_FILE_NAME = "Search_History";
    public static final String MUSIC_LIST_FILE_NAME = "Music_List";
    public static final int MUSIC_HISTORY_LIMIT = 20;
    public static final int SEARCH_HISTORY_LIMIT = 10;
    private Set<String> mLibraryIds = new HashSet<String>();
    private Set<String> mMusicHistoryIds = new HashSet<String>();
    private Set<String> mSearchIds = new HashSet<String>();
    private Set<String> mSingerSongIds = new HashSet<String>();
    private Set<String> mCacheIds = new HashSet<String>();
    private CopyOnWriteArraySet<String> mSearchKeys = new CopyOnWriteArraySet();
    private CopyOnWriteArrayList<String> mSearchHistory = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<KTVMusicInfo> mLibraryList = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<KTVMusicInfo> mMusicHistoryList = new CopyOnWriteArrayList();
    private List<KTVMusicInfo> mSearchList = new ArrayList<KTVMusicInfo>();
    private CopyOnWriteArrayList<KTVMusicInfo> mSingerSongList = new CopyOnWriteArrayList();
    private String mLibraryCursor;
    private String mSearchCuror = "";
    private String mSingerSongCuror;
    private ConcurrentHashMap<String, KTVMusicInfo> mCacheSongMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, KTVRankingInfo> mRankingDataMap = new ConcurrentHashMap();
    public static final String kvo_libraryDataChanged = "libraryDataChanged";
    @KvoFieldAnnotation(name="libraryDataChanged")
    private Object libraryDataChanged = new Object();
    public static final String kvo_historyDataChanged = "historyDataChanged";
    @KvoFieldAnnotation(name="historyDataChanged")
    private Object historyDataChanged = new Object();
    public static final String kvo_searchDataChanged = "searchDataChanged";
    @KvoFieldAnnotation(name="searchDataChanged")
    private Object searchDataChanged = new Object();
    public static final String kvo_rankingDataChanged = "rankingDataChanged";
    @KvoFieldAnnotation(name="rankingDataChanged")
    private Object rankingDataChanged = new Object();
    public static final String kvo_singerSongDataChanged = "singerSongDataChanged";
    @KvoFieldAnnotation(name="singerSongDataChanged")
    private Object singerSongDataChanged = new Object();
    private String mRoomId = "";

    public KTVMusicListProvider(IKTVManager iktvManager) {
        super(iktvManager);
    }

    private static String getPath(long uid, String fileName) {
        File dir = new File(FileStorageUtils.getInstance().getExternalCacheRootDir());
        if (dir != null) {
            return dir.getAbsolutePath() + File.separator + uid + "_KTV_" + fileName + ".txt";
        }
        return "/sdcard/" + RuntimeContext.sPackageName + File.separator + uid + "_KTV_" + fileName + ".txt";
    }

    @Override
    public void onCreate(KTVBaseContext context) {
        super.onCreate(context);
        this.mRoomId = context.getRoomData().getRoomId();
        this.cacheMusicHistoryFromFile();
        this.cacheSearchHistoryFromFile();
        this.cacheMusicListFromFile();
        this.initRankingDataList();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mRoomId = "";
        this.mLibraryIds.clear();
        this.mMusicHistoryIds.clear();
        this.mSearchIds.clear();
        this.mCacheIds.clear();
        this.mSingerSongIds.clear();
        this.mLibraryList.clear();
        this.mMusicHistoryList.clear();
        this.mSearchList.clear();
        this.mSingerSongList.clear();
        this.mLibraryCursor = "";
        this.mSearchCuror = "";
        this.mSingerSongCuror = "";
        this.mCacheSongMap.clear();
        this.mSearchKeys.clear();
        this.mSearchHistory.clear();
        for (Map.Entry<Integer, KTVRankingInfo> entry : this.mRankingDataMap.entrySet()) {
            if (null == entry.getValue()) continue;
            entry.getValue().clear();
        }
    }

    private void initRankingDataList() {
        this.mRankingDataMap.clear();
        this.mRankingDataMap.put(RankingType.kRankingWeek.getValue(), new KTVRankingInfo());
        this.mRankingDataMap.put(RankingType.kRankingMonth.getValue(), new KTVRankingInfo());
        this.mRankingDataMap.put(RankingType.kRankingAll.getValue(), new KTVRankingInfo());
    }

    @Override
    public void getPagingMusicList(final boolean isFirstPage, final IKTVProtoCallback<KTVSongListResponse> callback) {
        if (isFirstPage) {
            this.mLibraryCursor = "";
        } else if (this.mLibraryCursor == null) {
            return;
        }
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVList", (String)"getPagingMusicList, isFirstPage = %s", (Object[])new Object[]{isFirstPage});
        }
        KTVProtoService.getInstance().fetchSongLibrary(this.mRoomId, this.mLibraryCursor, new IKTVProtoCallback<GetHotResponse>(){

            @Override
            public void onSuccess(@NonNull GetHotResponse data) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTKTVList", (String)"getPagingMusicList, onSelected, cursor = %s, hasNext = %s, count = %s", (Object[])new Object[]{KTVMusicListProvider.this.mLibraryCursor, data.has_next, data.hot_queries.size()});
                }
                if (TextUtils.isEmpty((CharSequence)KTVMusicListProvider.this.mLibraryCursor)) {
                    KTVMusicListProvider.this.mLibraryIds.clear();
                    KTVMusicListProvider.this.mLibraryList.clear();
                }
                KTVMusicListProvider.this.mLibraryCursor = data.cursor;
                if (data.hot_queries.size() > 0) {
                    for (SearchRecord item : data.hot_queries) {
                        if (item == null || item.song == null) continue;
                        KTVMusicInfo songInfo = KTVMusicInfo.convertTo((Song)item.song);
                        KTVMusicListProvider.this.addMusicToCache(songInfo);
                        if (KTVMusicListProvider.this.mLibraryIds.contains(songInfo.getSongId())) continue;
                        KTVMusicListProvider.this.mLibraryIds.add(songInfo.getSongId());
                        if (KTVMusicListProvider.this.getKtvManager().getKTVRoomServices().isMySong(songInfo.getSongId())) {
                            songInfo.setRequested(true);
                        } else {
                            songInfo.setRequested(false);
                        }
                        KTVMusicListProvider.this.mLibraryList.add(songInfo);
                    }
                }
                KTVSongListResponse response = new KTVSongListResponse(data.has_next, KTVMusicListProvider.this.mLibraryList, false);
                if (callback != null) {
                    callback.onSuccess(response);
                }
                if (isFirstPage) {
                    KTVMusicListProvider.this.updateFile(KTVMusicListProvider.MUSIC_LIST_FILE_NAME);
                }
            }

            @Override
            public void onError(int code, String errorMessage) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTKTVList", (String)"getPagingSongList, onError, code = %s, message = %s", (Object[])new Object[]{code, errorMessage});
                }
                if (callback != null) {
                    callback.onError(code, errorMessage);
                }
            }
        });
    }

    @Override
    public void getRankingList(RankingType type, final boolean isRefresh, final IKTVProtoCallback<KTVSongListResponse> callback) {
        String cursor;
        final KTVRankingInfo rankingInfo = this.mRankingDataMap.get(type.getValue());
        if (null == rankingInfo) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTKTVRoomService", (String)"\u83b7\u53d6\u6392\u884c\u699c\u5217\u8868 rankingInfo=null", (Object[])new Object[0]);
            }
            return;
        }
        String string2 = cursor = isRefresh ? "" : rankingInfo.getCursor();
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVRoomService", (String)"\u83b7\u53d6\u6392\u884c\u699c\u5217\u8868 mRoomId:%s, type:%s, isRefresh:%s, cursor:%s", (Object[])new Object[]{this.mRoomId, type.getValue(), isRefresh, cursor});
        }
        if (null == cursor) {
            if (null != callback) {
                callback.onError(-1, "");
            }
            return;
        }
        KTVProtoService.getInstance().fetchRankingList(this.mRoomId, type, cursor, new IKTVProtoCallback<GetRankingRsp>(){

            @Override
            public void onSuccess(@NonNull GetRankingRsp data) {
                rankingInfo.setCursor(data.cursor);
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTKTVRoomService", (String)"\u83b7\u53d6\u6392\u884c\u699c\u5217\u8868 \u6210\u529f mHasNext:%s, size:%s", (Object[])new Object[]{data.has_next, data.records.size()});
                }
                if (isRefresh) {
                    rankingInfo.getRankingIds().clear();
                    rankingInfo.getRankingList().clear();
                }
                for (SearchRecord item : data.records) {
                    if (item == null || item.song == null) continue;
                    KTVMusicInfo songInfo = KTVMusicInfo.convertTo((Song)item.song);
                    KTVMusicListProvider.this.addMusicToCache(songInfo);
                    if (rankingInfo.getRankingIds().contains(songInfo.getSongId())) continue;
                    rankingInfo.getRankingIds().add(songInfo.getSongId());
                    if (KTVMusicListProvider.this.getKtvManager().getKTVRoomServices().isMySong(songInfo.getSongId())) {
                        songInfo.setRequested(true);
                    } else {
                        songInfo.setRequested(false);
                    }
                    rankingInfo.getRankingList().add(songInfo);
                }
                if (null != callback) {
                    callback.onSuccess(new KTVSongListResponse(data.has_next, rankingInfo.getRankingList(), false));
                }
            }

            @Override
            public void onError(int code, String errorMessage) {
                FeatureLog.e((String)"FTKTVRoomService", (String)"\u83b7\u53d6\u6392\u884c\u699c\u5217\u8868 \u5931\u8d25, code:%s", (Object[])new Object[]{code});
                if (isRefresh && null != callback) {
                    callback.onError(code, errorMessage);
                }
            }
        });
    }

    @Override
    public void getSingerSongList(long singerId, final boolean isRefresh, final IKTVProtoCallback<KTVSongListResponse> callback) {
        String cursor;
        String string2 = cursor = isRefresh ? "" : this.mSingerSongCuror;
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVRoomService", (String)"\u83b7\u53d6\u6392\u884c\u699c\u5217\u8868 mRoomId:%s, singerid:%s, isRefresh:%s, cursor:%s", (Object[])new Object[]{this.mRoomId, singerId, isRefresh, cursor});
        }
        if (null == cursor) {
            if (null != callback) {
                callback.onError(-1, "");
            }
            return;
        }
        KTVProtoService.getInstance().fetchSingerSongList(this.mRoomId, singerId, cursor, new IKTVProtoCallback<GetSongBySingerRsp>(){

            @Override
            public void onSuccess(@NonNull GetSongBySingerRsp data) {
                KTVMusicListProvider.this.mSingerSongCuror = data.cursor;
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTKTVRoomService", (String)"\u83b7\u53d6\u6392\u884c\u699c\u5217\u8868 \u6210\u529f mHasNext:%s, size:%s", (Object[])new Object[]{data.has_next, data.records.size()});
                }
                if (isRefresh) {
                    KTVMusicListProvider.this.mSingerSongIds.clear();
                    KTVMusicListProvider.this.mSingerSongList.clear();
                }
                for (SearchRecord item : data.records) {
                    if (item == null || item.song == null) continue;
                    KTVMusicInfo songInfo = KTVMusicInfo.convertTo((Song)item.song);
                    KTVMusicListProvider.this.addMusicToCache(songInfo);
                    if (KTVMusicListProvider.this.mSingerSongIds.contains(songInfo.getSongId())) continue;
                    KTVMusicListProvider.this.mSingerSongIds.add(songInfo.getSongId());
                    if (KTVMusicListProvider.this.getKtvManager().getKTVRoomServices().isMySong(songInfo.getSongId())) {
                        songInfo.setRequested(true);
                    } else {
                        songInfo.setRequested(false);
                    }
                    KTVMusicListProvider.this.mSingerSongList.add(songInfo);
                }
                if (null != callback) {
                    callback.onSuccess(new KTVSongListResponse(data.has_next, KTVMusicListProvider.this.mSingerSongList, false));
                }
            }

            @Override
            public void onError(int code, String errorMessage) {
                FeatureLog.e((String)"FTKTVRoomService", (String)"\u83b7\u53d6\u6392\u884c\u699c\u5217\u8868 \u5931\u8d25, code:%s", (Object[])new Object[]{code});
                if (isRefresh && null != callback) {
                    callback.onError(code, errorMessage);
                }
            }
        });
    }

    @Override
    public void searchMusic(boolean isFirstPage, String keyword, SearchType searchType, final IKTVProtoCallback<KTVSongListResponse> callback) {
        if (isFirstPage) {
            this.mSearchCuror = "";
            if (!StringUtils.isEmpty((String)keyword)) {
                this.updateSearchHistory(keyword);
            }
        }
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVList", (String)"searchMusic, isFirstPage = %s", (Object[])new Object[]{isFirstPage});
        }
        KTVProtoService.getInstance().search(this.mRoomId, keyword, this.mSearchCuror, searchType, new IKTVProtoCallback<SearchResponse>(){

            @Override
            public void onSuccess(@NonNull SearchResponse data) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTKTVList", (String)"searchMusic, onSelected, cursor = %s, hasNext = %s, count = %s", (Object[])new Object[]{KTVMusicListProvider.this.mSearchCuror, data.has_next, data.search_records.size()});
                }
                if (TextUtils.isEmpty((CharSequence)KTVMusicListProvider.this.mSearchCuror)) {
                    KTVMusicListProvider.this.mSearchIds.clear();
                    KTVMusicListProvider.this.mSearchList.clear();
                }
                KTVMusicListProvider.this.mSearchCuror = data.cursor;
                if (data.search_records.size() > 0) {
                    for (SearchRecord item : data.search_records) {
                        if (item == null || item.song == null) continue;
                        KTVMusicInfo songInfo = KTVMusicInfo.convertTo((Song)item.song);
                        KTVMusicListProvider.this.addMusicToCache(songInfo);
                        if (KTVMusicListProvider.this.mSearchIds.contains(songInfo.getSongId())) continue;
                        KTVMusicListProvider.this.mSearchIds.add(songInfo.getSongId());
                        if (KTVMusicListProvider.this.getKtvManager().getKTVRoomServices().isMySong(songInfo.getSongId())) {
                            songInfo.setRequested(true);
                        } else {
                            songInfo.setRequested(false);
                        }
                        KTVMusicListProvider.this.mSearchList.add(songInfo);
                    }
                }
                KTVSongListResponse response = data.err_code == 404L ? new KTVSongListResponse(data.has_next, KTVMusicListProvider.this.mSearchList, true) : new KTVSongListResponse(data.has_next, KTVMusicListProvider.this.mSearchList, false);
                if (callback != null) {
                    callback.onSuccess(response);
                }
            }

            @Override
            public void onError(int code, String errorMessage) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTKTVList", (String)"searchMusic, onError, code = %s, message = %s", (Object[])new Object[]{code, errorMessage});
                }
                if (callback != null) {
                    callback.onError(code, errorMessage);
                }
            }
        });
    }

    private void updateSearchHistory(String keyword) {
        if (!this.mSearchKeys.contains(keyword)) {
            if (this.mSearchHistory.size() >= 10) {
                String removedKey = this.mSearchHistory.remove(this.mSearchHistory.size() - 1);
                this.mSearchKeys.remove(removedKey);
            }
            this.mSearchHistory.add(0, keyword);
            this.mSearchKeys.add(keyword);
            this.updateFile(SEARCH_HISTROY_FILE_NAME);
        }
    }

    @Override
    public List<String> getSearchHistory() {
        return this.mSearchHistory;
    }

    @Override
    public void setMusicRequestStatus(String songId, boolean isRequested) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVList", (String)"setMusicRequestStatus, songId = %s, isRequested = %s", (Object[])new Object[]{songId, isRequested});
        }
        for (KTVMusicInfo kTVMusicInfo : this.mLibraryList) {
            if (kTVMusicInfo == null || !StringUtils.equal((String)songId, (String)kTVMusicInfo.getSongId())) continue;
            kTVMusicInfo.setRequested(isRequested);
            if (!FeatureLog.isLogLevelBlowInfo()) continue;
            FeatureLog.i((String)"FTKTVList", (String)"setMusicRequestStatus, set music library", (Object[])new Object[0]);
        }
        for (KTVMusicInfo kTVMusicInfo : this.mSearchList) {
            if (kTVMusicInfo == null || !StringUtils.equal((String)songId, (String)kTVMusicInfo.getSongId())) continue;
            kTVMusicInfo.setRequested(isRequested);
            if (!FeatureLog.isLogLevelBlowInfo()) continue;
            FeatureLog.i((String)"FTKTVList", (String)"setMusicRequestStatus, set search result", (Object[])new Object[0]);
        }
        for (Map.Entry entry : this.mRankingDataMap.entrySet()) {
            if (null == entry || null == entry.getValue()) continue;
            for (KTVMusicInfo songInfo : ((KTVRankingInfo)entry.getValue()).getRankingList()) {
                if (songInfo == null || !StringUtils.equal((String)songId, (String)songInfo.getSongId())) continue;
                songInfo.setRequested(isRequested);
                if (!FeatureLog.isLogLevelBlowInfo()) continue;
                FeatureLog.i((String)"FTKTVList", (String)"setMusicRequestStatus, set ranking result. type:%s", (Object[])new Object[]{entry.getKey()});
            }
        }
        for (KTVMusicInfo kTVMusicInfo : this.mSingerSongList) {
            if (kTVMusicInfo == null || !StringUtils.equal((String)songId, (String)kTVMusicInfo.getSongId())) continue;
            kTVMusicInfo.setRequested(isRequested);
            FeatureLog.i((String)"FTKTVList", (String)"setMusicRequestStatus, set singerSong result", (Object[])new Object[0]);
        }
        KTVMusicInfo musicInfo = this.getMusicInfo(songId, null);
        this.updateHistory(musicInfo, isRequested);
        this.setLibraryDataChanged(new Object());
        this.setSearchDataChanged(new Object());
        this.setRankingDataChanged(new Object());
        this.setSingerSongDataChanged(new Object());
    }

    @Override
    public List<KTVMusicInfo> getSearchResult() {
        return this.mSearchList;
    }

    @Override
    public List<KTVMusicInfo> getLibraryList() {
        return this.mLibraryList;
    }

    @Override
    public ConcurrentHashMap<Integer, KTVRankingInfo> getRankingDataMap() {
        return this.mRankingDataMap;
    }

    @Override
    public List<KTVMusicInfo> getSingerSongList() {
        return this.mSingerSongList;
    }

    @Override
    public List<KTVMusicInfo> getMusicHistoryList() {
        return this.mMusicHistoryList;
    }

    @Override
    public void clearSearchResult() {
        this.mSearchIds.clear();
        this.mSearchList.clear();
    }

    @Override
    public void clearSearchHistory() {
        this.mSearchHistory.clear();
        this.mSearchKeys.clear();
        this.updateFile(SEARCH_HISTROY_FILE_NAME);
    }

    private void updateHistory(KTVMusicInfo musicInfo, boolean isRequested) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVList", (String)"updateHistory, musicInfo : %s, isRequested : %s", (Object[])new Object[]{musicInfo, isRequested});
        }
        if (musicInfo != null) {
            if (isRequested) {
                if (!this.mMusicHistoryIds.contains(musicInfo.getSongId())) {
                    if (this.mMusicHistoryList.size() == 20) {
                        KTVMusicInfo musicRemoved = this.mMusicHistoryList.remove(this.mMusicHistoryList.size() - 1);
                        if (musicRemoved != null) {
                            this.mMusicHistoryIds.remove(musicRemoved.getSongId());
                        }
                        if (FeatureLog.isLogLevelBlowInfo()) {
                            FeatureLog.i((String)"FTKTVList", (String)"updateHistory, reach limit, remove the first", (Object[])new Object[0]);
                        }
                    }
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTKTVList", (String)"updateHistory, add one to history", (Object[])new Object[0]);
                    }
                    musicInfo.setRequested(isRequested);
                    this.mMusicHistoryIds.add(musicInfo.getSongId());
                    this.mMusicHistoryList.add(0, musicInfo);
                    this.updateFile(MUSIC_HISTORY_FILE_NAME);
                } else {
                    for (KTVMusicInfo item : this.mMusicHistoryList) {
                        if (!StringUtils.equal((String)item.getSongId(), (String)musicInfo.getSongId())) continue;
                        item.setRequested(isRequested);
                        FeatureLog.i((String)"FTKTVList", (String)"updateHistory, add one to history", (Object[])new Object[0]);
                        break;
                    }
                }
            } else {
                for (KTVMusicInfo item : this.mMusicHistoryList) {
                    if (!StringUtils.equal((String)item.getSongId(), (String)musicInfo.getSongId())) continue;
                    item.setRequested(isRequested);
                    if (!FeatureLog.isLogLevelBlowInfo()) break;
                    FeatureLog.i((String)"FTKTVList", (String)"updateHistory, set request status", (Object[])new Object[0]);
                    break;
                }
            }
            this.setHistoryDataChanged(new Object());
        }
    }

    private void cacheMusicHistoryFromFile() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    String response;
                    List list;
                    byte[] bs = YYFileUtils.readBytes((String)KTVMusicListProvider.getPath(AccountUtil.getUid(), KTVMusicListProvider.MUSIC_HISTORY_FILE_NAME));
                    if (bs != null && !FP.empty((Collection)(list = (List)JsonParser.parseJsonObject((String)(response = StringUtils.byteToStringUtf8((byte[])bs)), (Type)new TypeToken<List<KTVMusicInfo>>(){}.getType())))) {
                        KTVMusicListProvider.this.mMusicHistoryList = new CopyOnWriteArrayList(list);
                        for (KTVMusicInfo songInfo : KTVMusicListProvider.this.mMusicHistoryList) {
                            if (KTVMusicListProvider.this.getKtvManager().getKTVRoomServices().isMySong(songInfo.getSongId())) {
                                songInfo.setRequested(true);
                            } else {
                                songInfo.setRequested(false);
                            }
                            KTVMusicListProvider.this.mMusicHistoryIds.add(songInfo.getSongId());
                            KTVMusicListProvider.this.addMusicToCache(songInfo);
                        }
                    }
                }
                catch (Exception e) {
                    FeatureLog.i((String)"FTKTVList", (String)"cacheMusicHistoryFromFile, exception : %s", (Object[])new Object[]{e});
                }
            }
        });
    }

    private void cacheSearchHistoryFromFile() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    String response;
                    List list;
                    byte[] bs = YYFileUtils.readBytes((String)KTVMusicListProvider.getPath(AccountUtil.getUid(), KTVMusicListProvider.SEARCH_HISTROY_FILE_NAME));
                    if (bs != null && !FP.empty((Collection)(list = (List)JsonParser.parseJsonObject((String)(response = StringUtils.byteToStringUtf8((byte[])bs)), (Type)new TypeToken<List<String>>(){}.getType())))) {
                        KTVMusicListProvider.this.mSearchHistory = new CopyOnWriteArrayList(list);
                        for (String word : KTVMusicListProvider.this.mSearchHistory) {
                            KTVMusicListProvider.this.mSearchKeys.add(word);
                        }
                    }
                }
                catch (Exception e) {
                    FeatureLog.i((String)"FTKTVList", (String)"cacheSearchHistoryFromFile, exception : %s", (Object[])new Object[]{e});
                }
            }
        });
    }

    private void cacheMusicListFromFile() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] bs = YYFileUtils.readBytes((String)KTVMusicListProvider.getPath(AccountUtil.getUid(), KTVMusicListProvider.MUSIC_LIST_FILE_NAME));
                    if (bs != null) {
                        String response = StringUtils.byteToStringUtf8((byte[])bs);
                        List list = (List)JsonParser.parseJsonObject((String)response, (Type)new TypeToken<List<KTVMusicInfo>>(){}.getType());
                        if (!FP.empty((Collection)list)) {
                            KTVMusicListProvider.this.mLibraryList = new CopyOnWriteArrayList(list);
                            for (KTVMusicInfo musicInfo : KTVMusicListProvider.this.mLibraryList) {
                                if (KTVMusicListProvider.this.getKtvManager().getKTVRoomServices().isMySong(musicInfo.getSongId())) {
                                    musicInfo.setRequested(true);
                                } else {
                                    musicInfo.setRequested(false);
                                }
                                KTVMusicListProvider.this.addMusicToCache(musicInfo);
                            }
                        }
                        KTVMusicListProvider.this.setLibraryDataChanged(new Object());
                    }
                }
                catch (Exception e) {
                    FeatureLog.i((String)"FTKTVList", (String)"cacheMusicListFromFile, exception : %s", (Object[])new Object[]{e});
                }
            }
        });
    }

    private void updateFile(final String fileName) {
        if (!TextUtils.isEmpty((CharSequence)fileName)) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    String json = "";
                    if (StringUtils.equal((String)fileName, (String)KTVMusicListProvider.MUSIC_HISTORY_FILE_NAME)) {
                        ArrayList list = new ArrayList(KTVMusicListProvider.this.mMusicHistoryList);
                        json = JsonParser.toJson(list, (Type)new TypeToken<List<KTVMusicInfo>>(){}.getType());
                    } else if (StringUtils.equal((String)fileName, (String)KTVMusicListProvider.MUSIC_LIST_FILE_NAME)) {
                        ArrayList list = new ArrayList(KTVMusicListProvider.this.mLibraryList);
                        json = JsonParser.toJson(list, (Type)new TypeToken<List<KTVMusicInfo>>(){}.getType());
                    } else if (StringUtils.equal((String)fileName, (String)KTVMusicListProvider.SEARCH_HISTROY_FILE_NAME)) {
                        ArrayList list = new ArrayList(KTVMusicListProvider.this.mSearchHistory);
                        json = JsonParser.toJson(list, (Type)new TypeToken<List<String>>(){}.getType());
                    }
                    YYFileUtils.saveToFile((String)json, (String)KTVMusicListProvider.getPath(AccountUtil.getUid(), fileName));
                }
            });
        }
    }

    private void addMusicToCache(KTVMusicInfo songInfo) {
        if (songInfo != null && !this.mCacheIds.contains(songInfo.getSongId())) {
            this.mCacheIds.add(songInfo.getSongId());
            this.mCacheSongMap.put(songInfo.getSongId(), songInfo);
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTKTVList", (String)"addMusicToCache, songId : %s", (Object[])new Object[]{songInfo.getSongId()});
            }
        }
    }

    @Override
    public KTVMusicInfo getMusicInfo(String resourceId, final @NonNull IKTVQueryCallback<KTVMusicInfo> callback) {
        KTVMusicInfo songInfo;
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVList", (String)"getMusicInfo, resourceId : %s", (Object[])new Object[]{resourceId});
        }
        if ((songInfo = this.mCacheSongMap.get(resourceId)) != null) {
            if (YYTaskExecutor.isMainThread()) {
                if (callback != null) {
                    callback.onSuccess(songInfo, true);
                }
            } else {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onSuccess(songInfo, true);
                        }
                    }
                });
            }
            FeatureLog.i((String)"FTKTVList", (String)"getMusicInfo, get music from cache, songInfo : %s", (Object[])new Object[]{songInfo});
            return songInfo;
        }
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVList", (String)"getMusicInfo, cache does not have the music, get from server", (Object[])new Object[0]);
        }
        this.queryMusic(resourceId, new KTVCommonCallback<KTVMusicInfo>(){

            public void onSuccess(KTVMusicInfo data) {
                if (callback != null) {
                    callback.onSuccess(data, false);
                }
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTKTVList", (String)"getMusicInfo, onSelected : %s", (Object[])new Object[]{data});
                }
            }

            public void onFail(int code, String errorMessage) {
                if (callback != null) {
                    callback.onFail(errorMessage);
                }
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTKTVList", (String)"getMusicInfo, onFail : code = %s, errorMessage = %s", (Object[])new Object[]{code, errorMessage});
                }
            }
        });
        return null;
    }

    @Override
    public void queryMusic(@NonNull String resourceId, final @NonNull KTVCommonCallback<KTVMusicInfo> callback) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVList", (String)"query song resource id: %s", (Object[])new Object[]{resourceId});
        }
        KTVProtoService.getInstance().fetchSongByResourceId(this.mRoomId, resourceId, new IKTVProtoCallback<RepoGetResponse>(){

            @Override
            public void onSuccess(@NonNull RepoGetResponse data) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTKTVList", (String)"query song onSelected", (Object[])new Object[0]);
                }
                if (callback != null) {
                    if (data.item != null && data.item.song != null) {
                        callback.onSuccess((Object)KTVMusicInfo.convertTo((Song)data.item.song));
                    } else {
                        callback.onFail(-1000, "no response");
                    }
                }
            }

            @Override
            public void onError(int code, String errorMessage) {
                FeatureLog.e((String)"FTKTVList", (String)"query song error: %s", (Object[])new Object[]{errorMessage});
                if (callback != null) {
                    callback.onFail(code, errorMessage);
                }
            }
        });
    }

    public void setLibraryDataChanged(Object libraryDataChanged) {
        this.setValue(kvo_libraryDataChanged, libraryDataChanged);
    }

    public void setHistoryDataChanged(Object dataChanged) {
        this.setValue(kvo_historyDataChanged, dataChanged);
    }

    public void setSearchDataChanged(Object dataChanged) {
        this.setValue(kvo_searchDataChanged, dataChanged);
    }

    public void setRankingDataChanged(Object dataChanged) {
        this.setValue(kvo_rankingDataChanged, dataChanged);
    }

    public void setSingerSongDataChanged(Object dataChanged) {
        this.setValue(kvo_singerSongDataChanged, dataChanged);
    }

    @Override
    public void ktvAssociateSearch(final String keyWord, final @NonNull KTVCommonCallback<List<KTVAssociateSearchModel>> callback) {
        KTVProtoService.getInstance().ktvAssociateSearch(this.mRoomId, keyWord, new IKTVProtoCallback<GetSuggestResponse>(){

            @Override
            public void onSuccess(final @NonNull GetSuggestResponse data) {
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        List mList = data.suggested_queries;
                        final ArrayList<KTVAssociateSearchModel> mRealList = new ArrayList<KTVAssociateSearchModel>();
                        for (int i = 0; i < mList.size(); ++i) {
                            SuggestedRecord record = (SuggestedRecord)mList.get(i);
                            String publicStr = KTVMusicListProvider.this.stringMax(keyWord, record.value);
                            KTVAssociateSearchModel.Builder builder = new KTVAssociateSearchModel.Builder();
                            KTVAssociateSearchModel model = builder.publicRecord(publicStr).record(record).build();
                            mRealList.add(model);
                        }
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                callback.onSuccess((Object)mRealList);
                            }
                        });
                    }
                });
            }

            @Override
            public void onError(int code, String errorMessage) {
            }
        });
    }

    @Override
    public void directlySearch(String keyWord, String cursor, final KTVCommonCallback<List<KTVMusicInfo>> callback) {
        if (!StringUtils.isEmpty((String)keyWord)) {
            this.updateSearchHistory(keyWord);
        }
        KTVProtoService.getInstance().directlySearch(this.mRoomId, keyWord, cursor, new IKTVProtoCallback<DirectlySearchRsp>(){

            @Override
            public void onSuccess(@NonNull DirectlySearchRsp data) {
                FeatureLog.i((String)"FTKTVList", (String)"directlySearch, onSuccess, count = %s", (Object[])new Object[]{data.search_records.size()});
                KTVMusicListProvider.this.mSearchIds.clear();
                KTVMusicListProvider.this.mSearchList.clear();
                if (data.search_records.size() > 0) {
                    for (SearchRecord item : data.search_records) {
                        if (item == null || item.song == null) continue;
                        KTVMusicInfo songInfo = KTVMusicInfo.convertTo((Song)item.song);
                        KTVMusicListProvider.this.addMusicToCache(songInfo);
                        if (KTVMusicListProvider.this.mSearchIds.contains(songInfo.getSongId())) continue;
                        KTVMusicListProvider.this.mSearchIds.add(songInfo.getSongId());
                        if (KTVMusicListProvider.this.getKtvManager().getKTVRoomServices().isMySong(songInfo.getSongId())) {
                            songInfo.setRequested(true);
                        } else {
                            songInfo.setRequested(false);
                        }
                        KTVMusicListProvider.this.mSearchList.add(songInfo);
                        if (KTVMusicListProvider.this.mSearchList.size() <= 50) continue;
                        break;
                    }
                }
                if (callback != null) {
                    callback.onSuccess((Object)KTVMusicListProvider.this.mSearchList);
                }
            }

            @Override
            public void onError(final int code, final String errorMessage) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTKTVList", (String)"directlySearch, onError, code = %s, message = %s", (Object[])new Object[]{code, errorMessage});
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onFail(code, errorMessage);
                        }
                    }
                });
            }
        });
    }

    private String stringMax(String s1, String s2) {
        boolean isContains;
        String sameString = null;
        if (s1.length() < s2.length()) {
            String temp = s1;
            s1 = s2;
            s2 = temp;
        }
        if (isContains = s1.contains(s2)) {
            return s2;
        }
        boolean b1 = false;
        for (int i = 0; i < s2.length(); ++i) {
            block1: for (int j = 0; j <= i; ++j) {
                String str = s2.substring(j, s2.length() - i + j);
                System.out.println("\u7b2c" + i + "\u6b21\u6bd4\u8f83\uff1a" + str);
                ArrayList<String> list = new ArrayList<String>();
                this.dfs("", str, list, 0);
                for (int k = 0; k < list.size(); ++k) {
                    String key = (String)list.get(k);
                    if (!s1.contains(key)) continue;
                    sameString = key;
                    b1 = true;
                    continue block1;
                }
            }
            if (s2.substring(0, s2.length() - i).length() == 2) {
                System.out.println("\u6ca1\u6709\u76f8\u540c\u7684\u5b50\u5b57\u7b26\u4e32");
                b1 = true;
                break;
            }
            if (b1) break;
        }
        return sameString;
    }

    public void dfs(String pre, String s, List<String> res, int index) {
        if (index == s.length()) {
            res.add(pre);
        } else {
            char ch = s.charAt(index);
            if (!Character.isLetter(ch)) {
                this.dfs(pre + ch, s, res, index + 1);
            } else {
                ch = Character.toLowerCase(ch);
                this.dfs(pre + ch, s, res, index + 1);
                ch = Character.toUpperCase(ch);
                this.dfs(pre + ch, s, res, index + 1);
            }
        }
    }

    public static class KTVSongListResponse {
        public boolean hasNext;
        public List<KTVMusicInfo> songList;
        public boolean isPopularSongs = false;

        public KTVSongListResponse(boolean hasNext, List<KTVMusicInfo> list, boolean isPopularSongs) {
            this.hasNext = hasNext;
            this.songList = list;
            this.isPopularSongs = isPopularSongs;
        }
    }
}

