/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.upload;

import android.content.Context;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.appbase.data.MusicPlaylistDBBean;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.appbase.ui.widget.image.RoundConerImageView;
import com.yy.appbase.ui.widget.status.LoadingStatusLayout;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.channel.cbase.module.ktv.base.IKTVUploadMusicWindow;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.upload.KTVUploadMusicController;
import com.yy.hiyo.channel.plugins.ktv.utils.KTVEventReportUtil;
import java.util.Random;

public class KTVUploadMusicWindow
extends DefaultWindow
implements View.OnClickListener,
IKTVUploadMusicWindow {
    private ImageView mIvBlack;
    private RelativeLayout mAddLayout;
    private RelativeLayout mInfoLayout;
    private RoundConerImageView mIvSongPhoto;
    private TextView mTvSongName;
    private TextView mTvSinger;
    private EditText mEtSongName;
    private View mSongNameBaseLine;
    private TextView mTvSongNameTip;
    private EditText mEtSinger;
    private View mSingerBaseLine;
    private TextView mTvSingerTip;
    private TextView mTvUploadBtn;
    private RelativeLayout mTipLayout;
    private TextView mTvOk;
    private LoadingStatusLayout mLoadingView;
    private KTVUploadMusicController mCallbacks;
    Runnable task = new Runnable(){

        @Override
        public void run() {
            KTVUploadMusicWindow.this.mLoadingView.setVisibility(8);
            KTVUploadMusicWindow.this.mTipLayout.setVisibility(0);
            KTVEventReportUtil.reportUploadSuccShow();
        }
    };

    public KTVUploadMusicWindow(Context context, KTVUploadMusicController callBacks) {
        super(context, (UICallBacks)callBacks, "KTVUpload");
        this.mCallbacks = callBacks;
        this.creatView();
    }

    private void creatView() {
        View rootView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.window_upload_music_channel, (ViewGroup)this.getBarLayer(), true);
        this.mIvBlack = (ImageView)rootView.findViewById(R.id.iv_left_back);
        this.mAddLayout = (RelativeLayout)rootView.findViewById(R.id.layout_add_song);
        this.mInfoLayout = (RelativeLayout)rootView.findViewById(R.id.layout_info_enter);
        this.mIvSongPhoto = (RoundConerImageView)rootView.findViewById(R.id.iv_upload_info_photo);
        this.mTvSongName = (TextView)rootView.findViewById(R.id.tv_song_name);
        this.mTvSinger = (TextView)rootView.findViewById(R.id.tv_singer);
        this.mEtSongName = (EditText)rootView.findViewById(R.id.et_upload_name);
        this.mSongNameBaseLine = rootView.findViewById(R.id.view_name_base_line);
        this.mTvSongNameTip = (TextView)rootView.findViewById(R.id.tv_name_error_tip);
        this.mEtSinger = (EditText)rootView.findViewById(R.id.et_upload_singer);
        this.mSingerBaseLine = rootView.findViewById(R.id.view_singer_base_line);
        this.mTvSingerTip = (TextView)rootView.findViewById(R.id.tv_singer_error_tip);
        this.mTvUploadBtn = (TextView)rootView.findViewById(R.id.tv_upload_btn);
        this.mTipLayout = (RelativeLayout)rootView.findViewById(R.id.layout_upload_success_tip);
        this.mTvOk = (TextView)rootView.findViewById(R.id.tv_tip_ok);
        this.mLoadingView = (LoadingStatusLayout)rootView.findViewById(R.id.lsl_loading);
        this.mIvBlack.setOnClickListener((View.OnClickListener)this);
        this.mAddLayout.setOnClickListener((View.OnClickListener)this);
        this.mInfoLayout.setOnClickListener((View.OnClickListener)this);
        this.mTvUploadBtn.setOnClickListener((View.OnClickListener)this);
        this.mTvOk.setOnClickListener((View.OnClickListener)this);
        this.mAddLayout.setVisibility(0);
        this.mInfoLayout.setVisibility(8);
        this.mTipLayout.setVisibility(8);
        this.mLoadingView.setVisibility(8);
        this.mTvSongNameTip.setVisibility(4);
        this.mTvSingerTip.setVisibility(4);
        this.updateUploadBtnState();
        this.mEtSongName.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start2, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start2, int before, int count) {
                if (s.toString().length() > 50) {
                    KTVUploadMusicWindow.this.mTvSongNameTip.setVisibility(0);
                    KTVUploadMusicWindow.this.mSongNameBaseLine.setBackgroundResource(R.color.red_ff4a);
                } else {
                    KTVUploadMusicWindow.this.mTvSongNameTip.setVisibility(4);
                    KTVUploadMusicWindow.this.mSongNameBaseLine.setBackgroundResource(R.color.color_eeeeee);
                }
                KTVUploadMusicWindow.this.updateUploadBtnState();
            }

            public void afterTextChanged(Editable s) {
            }
        });
        this.mEtSinger.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start2, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start2, int before, int count) {
                if (s.toString().length() > 50) {
                    KTVUploadMusicWindow.this.mTvSingerTip.setVisibility(0);
                    KTVUploadMusicWindow.this.mSingerBaseLine.setBackgroundResource(R.color.red_ff4a);
                } else {
                    KTVUploadMusicWindow.this.mTvSingerTip.setVisibility(4);
                    KTVUploadMusicWindow.this.mSingerBaseLine.setBackgroundResource(R.color.color_eeeeee);
                }
                KTVUploadMusicWindow.this.updateUploadBtnState();
            }

            public void afterTextChanged(Editable s) {
            }
        });
    }

    private boolean isUploadEnable() {
        if (this.mInfoLayout.getVisibility() == 8) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.mEtSongName.getText().toString())) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.mEtSinger.getText().toString())) {
            return false;
        }
        if (this.mTvSongNameTip.getVisibility() == 0) {
            return false;
        }
        return this.mTvSingerTip.getVisibility() != 0;
    }

    private void updateUploadBtnState() {
        this.mTvUploadBtn.setBackgroundResource(this.isUploadEnable() ? R.drawable.shape_red_radius_3dp : R.drawable.shape_upload_btn_bg);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.iv_left_back) {
            this.mCallbacks.closeWindow();
        } else if (v.getId() == R.id.layout_add_song) {
            MsgDispatcher.getInstance().sendMessage(BaseMsgDef.OPEN_KTV_SCAN_LOCAL_MUSIC_WINDOW);
        } else if (v.getId() == R.id.layout_info_enter) {
            MsgDispatcher.getInstance().sendMessage(BaseMsgDef.OPEN_KTV_SCAN_LOCAL_MUSIC_WINDOW);
        } else if (v.getId() == R.id.tv_upload_btn) {
            KTVEventReportUtil.reportUploadButClick();
            if (!this.isUploadEnable()) {
                TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.tip_choose_local_song), (int)0);
                return;
            }
            if (!NetworkUtils.isNetworkAvailable((Context)this.getContext())) {
                TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
                return;
            }
            this.mLoadingView.setVisibility(0);
            Random random = new Random();
            int duration = random.nextInt(5) * 1000;
            if (duration <= 0) {
                duration = 3000;
            }
            YYTaskExecutor.postToMainThread((Runnable)this.task, (long)duration);
        } else if (v.getId() == R.id.tv_tip_ok) {
            this.mCallbacks.closeWindow();
        }
    }

    public void onWindowDetach() {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.task);
    }

    public void updateSongInfo(MusicPlaylistDBBean music) {
        if (music != null) {
            ImageLoader.loadImage((RecycleImageView)this.mIvSongPhoto, (String)"", (int)R.drawable.icon_song_cover_default, (int)R.drawable.icon_song_cover_default);
            String musicName = music.getMusicName();
            this.mTvSongName.setText((CharSequence)(TextUtils.isEmpty((CharSequence)musicName) ? "" : musicName));
            String singer = music.getSinger();
            this.mTvSinger.setText((CharSequence)(TextUtils.isEmpty((CharSequence)singer) ? "" : singer));
            this.mAddLayout.setVisibility(8);
            this.mInfoLayout.setVisibility(0);
            this.updateUploadBtnState();
        }
    }
}

