/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.viewmodel;

import android.graphics.Typeface;
import android.os.Message;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import androidx.databinding.BindingAdapter;
import com.handmark.pulltorefresh.library.PullToRefreshListView;
import com.opensource.svgaplayer.SVGAImageView;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.DpToPxDef;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.data.UserOnlineDBBean;
import com.yy.appbase.im.ImPageSourceData;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.IOfficialAccountAuthCallback;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.horizontallist.HListView;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.user.UserMedalBubbleUtil;
import com.yy.appbase.user.official.HagoOfficialLabel;
import com.yy.appbase.util.ZodiacUtils;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.svga.YYSvgaImageView;
import com.yy.hiyo.channel.base.DR;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.EntryInfo;
import com.yy.hiyo.channel.base.FirstEntType;
import com.yy.hiyo.channel.base.IRoomService;
import com.yy.hiyo.channel.base.bean.create.CreateChannelParams;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.inner.DResource;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.widget.GameDownloadingView;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.im.ImBaseMsgDef;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.Relation;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.hiyo.relation.base.follow.FollowerUtils;
import com.yy.hiyo.relation.base.follow.view.FollowView;
import com.yy.hiyo.relation.base.follow.view.IFollowClickInterceptor;
import com.yy.hiyo.user.base.profilesource.ProfileReportBean;
import com.yy.hiyo.wallet.base.IAdService;
import com.yy.im.R;
import com.yy.im.model.AdChatSession;
import com.yy.im.model.ChatSession;
import com.yy.im.model.GamePublicChatSession;
import com.yy.im.model.GamePublicEntranceSession;
import com.yy.im.model.GamePushChatSession;
import com.yy.im.model.IContact;
import com.yy.im.model.SearchFriend;
import com.yy.im.model.SingleChatSession;
import com.yy.im.model.UserInfoViewItem;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.ui.adapter.DataBindingListAdapter;
import com.yy.im.ui.widget.MutipleAvatarView;
import com.yy.socialplatformbase.callback.IAdCallback;
import com.yy.socialplatformbase.data.AdEntity;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class ViewBindingUtils {
    private static final String TAG = "ViewBindingUtils";
    private static SimpleDateFormat newStrangeFormat = new SimpleDateFormat("dd-MM-yyyy", Locale.getDefault());

    @BindingAdapter(value={"goToUserPage"})
    public static void ggoToUserPage(CircleImageView v, final SearchFriend searchFriend) {
        if (v == null) {
            return;
        }
        v.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        v.setAlpha(0.6f);
                        break;
                    }
                    case 1: 
                    case 3: {
                        v.setAlpha(1.0f);
                        break;
                    }
                }
                return false;
            }
        });
        v.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (searchFriend.getViewState() == 4) {
                    MsgDispatcher.getInstance().sendMessage(ImBaseMsgDef.OPEN_NEW_ADD_FRIENDS_PAGE);
                } else if (searchFriend != null) {
                    ProfileReportBean bean = new ProfileReportBean();
                    bean.setUid(Long.valueOf(searchFriend.getUid()));
                    bean.setShowSource(Integer.valueOf(ProfileReportBean.ShowSource.getSearch()));
                    bean.setExtObject((Object)searchFriend);
                    bean.setSource(1);
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.OPEN_USER_NEW_PROFILE, (Object)bean));
                }
            }
        });
    }

    @BindingAdapter(value={"goExplore"})
    public static void goExplore(YYLinearLayout v, ChatSession chatSession) {
        if (v == null) {
            return;
        }
        v.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
    }

    @BindingAdapter(value={"goToUserPage"})
    public static void goToUserPage(MutipleAvatarView v, final ChatSession chatSession) {
        if (v == null || chatSession instanceof GamePublicChatSession || chatSession instanceof GamePublicEntranceSession || chatSession instanceof GamePushChatSession) {
            if (v != null) {
                v.setOnClickListener(null);
            }
            return;
        }
        v.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (chatSession != null && chatSession instanceof SingleChatSession) {
                    if (chatSession.getUserOnlineDBBean() != null && chatSession.getUserOnlineDBBean().isInRoom() && !TextUtils.isEmpty((CharSequence)chatSession.getUserOnlineDBBean().getChannelId())) {
                        EnterParam param = EnterParam.of((String)chatSession.getUserOnlineDBBean().getChannelId()).entry(145).entryInfo(new EntryInfo(FirstEntType.IM, "1", "2")).build();
                        ((IRoomService)ServiceManagerProxy.getServiceManager().getService(IRoomService.class)).enterRoom(param);
                    } else {
                        ProfileReportBean bean = new ProfileReportBean();
                        bean.setUid(Long.valueOf(chatSession.getUid()));
                        bean.setShowSource(Integer.valueOf(ProfileReportBean.ShowSource.getChatList()));
                        bean.setSource(5);
                        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.OPEN_USER_NEW_PROFILE, (Object)bean));
                    }
                    UserOnlineDBBean onlineDBBean = chatSession.getUserOnlineDBBean();
                    String singleStatus = onlineDBBean == null || !onlineDBBean.isOnline() ? "" : (onlineDBBean.isInRoom() && "radio_video".equals(onlineDBBean.getChannelPlugin()) ? "3" : (onlineDBBean.isInRoom() && "radio_video".equals(onlineDBBean.getChannelPlugin()) ? "2" : "1"));
                    IRelationService relationService = (IRelationService)ServiceManagerProxy.getService(IRelationService.class);
                    String userIdentity = "";
                    if (relationService != null) {
                        Relation relation = relationService.getRelationLocal(chatSession.getUid()).getRelation();
                        userIdentity = relation == Relation.FOLLOW ? "2" : (relation == Relation.FRIEND ? "3" : "1");
                    }
                    HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "message_click").put("message_type", "2").put("message_uit_amount_unread", String.valueOf(chatSession.getUnReadCounts())).put("is_include_no_action_strategy", ((SingleChatSession)chatSession).getStrategyType() > 0 ? "1" : "0").put("new_guide_strategy_type", String.valueOf(((SingleChatSession)chatSession).getNewGuideStrategyType())).put("single_status", singleStatus).put("user_indentity", userIdentity).put("click_part", "1"));
                    if (chatSession.isStrangerChat()) {
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023783").put("function_id", "head_click"));
                    } else {
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "head_click"));
                    }
                }
            }
        });
    }

    @BindingAdapter(value={"goToUserPage"})
    public static void goToUserPage(CircleImageView v, final UserInfoViewItem data2) {
        if (v == null) {
            return;
        }
        v.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        v.setAlpha(0.6f);
                        break;
                    }
                    case 1: 
                    case 3: {
                        v.setAlpha(1.0f);
                        break;
                    }
                }
                return false;
            }
        });
        v.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (data2 == null) {
                    return;
                }
                if (data2.getUserOnlineDBBean() != null && data2.getUserOnlineDBBean().isInRoom() && data2.getUserOnlineDBBean().getChannelId() != null) {
                    EnterParam enterParam = EnterParam.of((String)data2.getUserOnlineDBBean().getChannelId()).entry(186).entryInfo(new EntryInfo(FirstEntType.IM, "3", "3")).build();
                    ((IRoomService)ServiceManagerProxy.getService(IRoomService.class)).enterRoom(enterParam);
                    return;
                }
                if (data2.getUid() != 10L) {
                    ProfileReportBean bean = new ProfileReportBean();
                    bean.setUid(Long.valueOf(data2.getUid()));
                    bean.setShowSource(Integer.valueOf(ProfileReportBean.ShowSource.getFriends()));
                    bean.setSource(5);
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.OPEN_USER_NEW_PROFILE, (Object)bean));
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023789").put("function_id", "head_click"));
                }
            }
        });
    }

    @BindingAdapter(value={"goToUserPage"})
    public static void goToUserPage(YYTextView v, final SearchFriend searchFriend) {
        v.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (searchFriend.getViewState() == 4) {
                    MsgDispatcher.getInstance().sendMessage(ImBaseMsgDef.OPEN_NEW_ADD_FRIENDS_PAGE);
                } else if (searchFriend != null) {
                    ProfileReportBean bean = new ProfileReportBean();
                    bean.setUid(Long.valueOf(searchFriend.getUid()));
                    bean.setShowSource(Integer.valueOf(ProfileReportBean.ShowSource.getSearch()));
                    bean.setExtObject((Object)searchFriend);
                    bean.setSource(1);
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.OPEN_USER_NEW_PROFILE, (Object)searchFriend));
                }
            }
        });
    }

    @BindingAdapter(value={"goToAddNewFriends"})
    public static void goToAddNewFriends(YYRelativeLayout rl, IContact from) {
        rl.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MsgDispatcher.getInstance().sendMessage(ImBaseMsgDef.OPEN_NEW_ADD_FRIENDS_PAGE);
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023789").put("function_id", "add_friends_click"));
            }
        });
    }

    @BindingAdapter(value={"goToCreateChannel"})
    public static void goToCreateChannel(YYRelativeLayout rl, IContact from) {
        rl.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "contacter_create_channel_but_click"));
                Message message = Message.obtain();
                message.what = AppbaseMsgDef.ChannelMsgDef.OPEN_CHANNEL_CREATE;
                CreateChannelParams params = CreateChannelParams.obtain((String)"", (int)CreateChannelParams.From.my_channel_list);
                params.createFrom = 3;
                message.obj = params;
                MsgDispatcher.getInstance().sendMessage(message);
            }
        });
    }

    @BindingAdapter(value={"goToContactQuiz"})
    public static void goToContactQuiz(YYRelativeLayout rl, IContact from) {
        rl.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.CONTACT_QUIZ_OPEN_PAGE));
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028337").put("function_id", "ent_click").put("ent_id", "2"));
            }
        });
    }

    @BindingAdapter(value={"avatars"})
    public static void loadAvatars(MutipleAvatarView iv, List<String> avatar) {
        iv.setmAvatars(avatar);
    }

    @BindingAdapter(value={"bgColor"})
    public static void loadBgColor(MutipleAvatarView iv, int bgColor) {
        iv.setBgColor(bgColor);
    }

    @BindingAdapter(value={"defaultAvatar"})
    public static void loaddefaultAvatar(MutipleAvatarView iv, int defaultAvatar) {
        iv.setLocalResBg(defaultAvatar);
    }

    @BindingAdapter(value={"avatarType"})
    public static void loadAvatarType(MutipleAvatarView iv, int avatarType) {
        iv.setType(avatarType);
    }

    @BindingAdapter(value={"onLoadAvatar"})
    public static void loadAvatar(RecycleImageView iv, String url) {
        ImageLoader.loadImage((ImageView)iv, (String)(url + YYImageUtils.getThumbSmall()));
    }

    @BindingAdapter(value={"boldText"})
    public static void setTextBold(YYTextView tv, boolean bold) {
        tv.setTypeface(bold ? Typeface.DEFAULT_BOLD : Typeface.DEFAULT);
    }

    @BindingAdapter(value={"smallIcon"})
    public static void setSmallIcon(RecycleImageView iv, int drawableId) {
        iv.setImageResource(drawableId);
    }

    @BindingAdapter(value={"loadContactImg"})
    public static void loadContactImg(CircleImageView iv, UserInfoViewItem item) {
        if (item != null) {
            int defaultAvatar = item.getUid() == 10L ? R.drawable.icon_public_msg_avatar : AvatarUtils.getDefaultAvatar((int)item.getSex());
            ImageLoader.loadImage((ImageView)iv, (String)(item.getAvatarUrl() + YYImageUtils.getThumbnailPostfix((int)75)), (int)defaultAvatar);
        }
    }

    @BindingAdapter(value={"loadUserOnlineImg"})
    public static void loadUserOnlineImg(YYImageView iv, UserOnlineDBBean onlineStatus) {
        if (onlineStatus == null || !onlineStatus.isOnline()) {
            iv.setImageResource(0);
            return;
        }
        if (onlineStatus.isInRoom()) {
            iv.setImageResource(0);
        } else {
            iv.setImageResource(R.drawable.shape_contact_user_status_online_small);
        }
    }

    @BindingAdapter(value={"loadOnlineSvga"})
    public static void loadOnlineSvga(YYSvgaImageView iv, UserInfoViewItem data2) {
        if (data2 == null || data2.getUserOnlineDBBean() == null || !data2.getUserOnlineDBBean().isOnline() || !data2.getUserOnlineDBBean().isInRoom()) {
            iv.stopAnimation();
            iv.setVisibility(8);
            return;
        }
        iv.setVisibility(0);
        DResource svgaResource = null;
        svgaResource = StringUtils.equal((String)data2.getUserOnlineDBBean().getChannelPlugin(), (String)"radio_video") || StringUtils.equal((String)data2.getUserOnlineDBBean().getChannelPlugin(), (String)"multivideo") || StringUtils.equal((String)data2.getUserOnlineDBBean().getChannelPlugin(), (String)"radio") ? DR.follow_avatar_in_video_wave : DR.follow_avatar_in_channel_wave;
        DyResLoader.INSTANCE.loadSvga((SVGAImageView)iv, svgaResource, true);
    }

    @BindingAdapter(value={"loadUserStateInRoom"})
    public static void loadUserStateInRoom(YYImageView iv, @Nullable UserOnlineDBBean onlineStatus) {
        if (onlineStatus == null || !onlineStatus.isOnline() || !onlineStatus.isInRoom()) {
            iv.setImageResource(0);
            return;
        }
        if ("radio_video".equals(onlineStatus.getChannelPlugin()) || "multivideo".equals(onlineStatus.getChannelPlugin())) {
            iv.setImageResource(R.drawable.im_page_online_state_live);
        } else {
            iv.setImageResource(R.drawable.im_page_online_state_voice_room);
        }
    }

    @BindingAdapter(value={"loadHagoOfficial"})
    public static void loadHagoOfficial(final HagoOfficialLabel iv, long uid) {
        IUserInfoService userInfoService = (IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class);
        userInfoService.requestOfficialAccountAuth(uid, new IOfficialAccountAuthCallback(){

            public void onSuccess(boolean officialAccountAuth) {
                if (officialAccountAuth) {
                    iv.setVisibility(0);
                } else {
                    iv.setVisibility(8);
                }
            }

            public void onFailed() {
                iv.setVisibility(8);
            }
        });
    }

    @BindingAdapter(value={"loadBBSLogo"})
    public static void loadBBSLogo(final RecycleImageView iv, final UserInfoViewItem item) {
        IUserInfoService userInfoService = (IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class);
        userInfoService.requestOfficialAccountAuth(item.getUid(), new IOfficialAccountAuthCallback(){

            public void onSuccess(boolean officialAccountAuth) {
                if (officialAccountAuth) {
                    iv.setVisibility(0);
                } else {
                    ViewBindingUtils.setBBSLogo(iv, item);
                }
            }

            public void onFailed() {
                ViewBindingUtils.setBBSLogo(iv, item);
            }
        });
    }

    public static void setBBSLogo(RecycleImageView iv, UserInfoViewItem item) {
        if (item == null || TextUtils.isEmpty((CharSequence)item.getBbsLogo())) {
            iv.setVisibility(8);
        } else {
            iv.setVisibility(0);
            ImageLoader.loadImage((ImageView)iv, (String)item.getBbsLogo());
        }
    }

    @BindingAdapter(value={"showBBSMedalToast"})
    public static void showBBSMedalToast(final RecycleImageView iv, UserInfoViewItem item) {
        IUserInfoService userInfoService = (IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class);
        userInfoService.requestOfficialAccountAuth(item.getUid(), new IOfficialAccountAuthCallback(){

            public void onSuccess(boolean officialAccountAuth) {
                if (!officialAccountAuth) {
                    ViewBindingUtils.setBBSLogoOnClick(iv);
                }
            }

            public void onFailed() {
                ViewBindingUtils.setBBSLogoOnClick(iv);
            }
        });
    }

    public static void setBBSLogoOnClick(final RecycleImageView iv) {
        iv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UserMedalBubbleUtil.showBubble((View)iv);
            }
        });
    }

    @BindingAdapter(value={"loadSearchFriendImg"})
    public static void loadSearchFriendImg(CircleImageView iv, SearchFriend item) {
        if (item != null) {
            if (item.getViewState() == 4) {
                iv.setImageDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_friendlist_add_btn));
            } else {
                ImageLoader.loadImage((ImageView)iv, (String)(item.getAvatarUrl() + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)item.getSex()));
            }
        }
    }

    @BindingAdapter(value={"bindFollow"})
    public static void bindFollow(FollowView iv, SearchFriend item) {
        if (item != null) {
            iv.setFollowStatusListener((followStatus, oldStatus) -> iv.setEnabled(!followStatus.isFollow()));
            iv.setBoldStyle();
            final String enterType = String.valueOf(19);
            iv.setClickInterceptor(new IFollowClickInterceptor(){

                public boolean interceptor(RelationInfo followStatus) {
                    if (!followStatus.isFollow()) {
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "follow_click").put("follow_enter_type", enterType));
                    } else {
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "no_follow_click").put("follow_enter_type", enterType));
                    }
                    return false;
                }
            });
            iv.bindFollowStatus(item.getUid(), FollowerUtils.INSTANCE.enterType2ePath(enterType));
        }
    }

    @BindingAdapter(value={"bindText"})
    public static void bindText(YYTextView iv, UserInfoViewItem item) {
        if (item != null) {
            if (StringUtils.isEmpty((String)item.getCity())) {
                iv.setText((CharSequence)StringUtils.formatWitUSLocal((String)"%d", (Object[])new Object[]{DateUtils.getAge((String)item.getBirthday())}));
            } else {
                String msg = "%d , %s";
                iv.setText((CharSequence)StringUtils.formatWitUSLocal((String)msg, (Object[])new Object[]{DateUtils.getAge((String)item.getBirthday()), item.getCity()}));
            }
        }
    }

    @BindingAdapter(value={"bindFollow"})
    public static void bindFollow(FollowView iv, UserInfoViewItem item) {
        if (item != null) {
            if (item.getUid() != 10L) {
                iv.setBoldStyle();
                final String enterType = String.valueOf(21);
                iv.bindFollowStatus(item.getUid(), FollowerUtils.INSTANCE.enterType2ePath(enterType));
                iv.setVisibility(0);
                iv.setClickInterceptor(new IFollowClickInterceptor(){

                    public boolean interceptor(RelationInfo followStatus) {
                        if (!followStatus.isFollow()) {
                            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "follow_click").put("follow_enter_type", enterType));
                        } else {
                            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "no_follow_click").put("follow_enter_type", enterType));
                        }
                        return false;
                    }
                });
            } else {
                iv.setVisibility(8);
            }
        }
    }

    @BindingAdapter(value={"url", "sex", "viewType"})
    public static void loadSearchFriendImg(CircleImageView iv, String url, int sex, int viewState) {
        if (viewState == 4) {
            iv.setImageDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_friendlist_add_btn));
        } else {
            ImageLoader.loadImage((ImageView)iv, (String)(url + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)sex));
        }
    }

    @BindingAdapter(value={"setNewStrangeTime"})
    public static void setNewStrangeTime(YYTextView v, long time) {
        v.setText((CharSequence)newStrangeFormat.format(new Date(time)));
    }

    @BindingAdapter(value={"setTimeStr", "isNewStranger"}, requireAll=false)
    public static void setTimeStr(YYTextView tv, long ts, boolean isNewStranger) {
        if (isNewStranger) {
            tv.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_drawer_new));
        } else {
            long currentTs = System.currentTimeMillis();
            long distance = (currentTs - ts) / 1000L;
            if (distance <= 60L) {
                tv.setText((CharSequence)ResourceUtils.getString((int)R.string.now));
            } else if (distance <= 3600L) {
                int min = (int)(distance / 60L);
                tv.setText((CharSequence)ResourceUtils.getString((int)(min == 1 ? R.string.x_min : R.string.x_mins), (Object[])new Object[]{min}));
            } else if (distance <= 86400L) {
                int hour = (int)(distance / 60L / 60L);
                tv.setText((CharSequence)ResourceUtils.getString((int)(hour == 1 ? R.string.x_hour : R.string.x_hours), (Object[])new Object[]{hour}));
            } else if (distance <= 2592000L) {
                int days = (int)(distance / 24L / 60L / 60L);
                tv.setText((CharSequence)ResourceUtils.getString((int)(days == 1 ? R.string.x_day : R.string.x_days), (Object[])new Object[]{days}));
            } else {
                int month = (int)(distance / 30L / 24L / 60L / 60L);
                tv.setText((CharSequence)ResourceUtils.getString((int)(month == 1 ? R.string.x_month : R.string.x_month), (Object[])new Object[]{month}));
            }
        }
    }

    @BindingAdapter(value={"onClickAddFriendBtn"})
    public static void onClick(View view, final SearchFriend data2) {
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_ADD_FRIENDS, (Object)data2));
            }
        });
    }

    @BindingAdapter(value={"onClickAddFriendBtn", "from"})
    public static void onClick(YYRelativeLayout view, final SearchFriend data2, final String form) {
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_ADD_FRIENDS, (Object)data2));
                if (data2 != null && data2.getFromTag() == 2 && data2.getFromType() == 5 && "imSuggest".equals(form)) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023803").put("function_id", "1").put("ent_id", "2").put("page_id", "2").put("act_uid", String.valueOf(data2.getUid())));
                } else if (data2 != null && data2.getFromTag() == 3 && data2.getFromType() == 5 && "imSuggest".equals(form)) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023803").put("function_id", "1").put("ent_id", "2").put("page_id", "1").put("act_uid", String.valueOf(data2.getUid())));
                } else if (data2 != null && data2.getFromTag() == 3 && data2.getFromType() == 5 && "imFriend".equals(form)) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023803").put("function_id", "1").put("ent_id", "3").put("page_id", "1").put("act_uid", String.valueOf(data2.getUid())));
                } else if (data2 != null && data2.getFromTag() == 2 && data2.getFromType() == 5 && "imFriend".equals(form)) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023803").put("function_id", "1").put("ent_id", "3").put("page_id", "2").put("act_uid", String.valueOf(data2.getUid())));
                } else if (data2 != null && data2.getFromType() == 2) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023791").put("function_id", "search_add_friends"));
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023803").put("function_id", "1").put("ent_id", "4").put("act_uid", String.valueOf(data2.getUid())));
                }
            }
        });
    }

    @BindingAdapter(value={"goToIm", "from"})
    public static void goToIm(YYRelativeLayout view, final long uid, final String from) {
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (from.equals("imRecentMatch")) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023783").put("function_id", "head_click"));
                }
                if (from.equals("imContactUser")) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023789").put("function_id", "enter_message_click"));
                }
                ImPageSourceData imPageBean = new ImPageSourceData(uid, 0);
                if (ServiceManagerProxy.getService(ImService.class) != null) {
                    ((ImService)ServiceManagerProxy.getService(ImService.class)).openImPage(imPageBean);
                }
            }
        });
    }

    @BindingAdapter(value={"onBindingDownloadView"})
    public static void onBindingDownloadView(GameDownloadingView mDownloadView, ChatSession data2) {
        if (data2 instanceof GamePublicChatSession || data2 instanceof GamePushChatSession) {
            ImMessageDBBean imMessageDBBean = (ImMessageDBBean)data2.getLastMessage();
            GameInfo gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(imMessageDBBean.getReserve1());
            if (gameInfo != null) {
                mDownloadView.setMarkBackground(-1291845632);
                int width = DpToPxDef.RESOLUTION_30_DP;
                int pauseImgWidth = DpToPxDef.RESOLUTION_20_DP;
                mDownloadView.setVisibility(0);
                mDownloadView.setType(2);
                mDownloadView.setProgressBarWidth(width);
                mDownloadView.setBorderRadius(45);
                mDownloadView.setDefaultProgressBarWidth(width);
                mDownloadView.setPauseImgSize(pauseImgWidth);
                mDownloadView.setProgressBarDrawable(R.drawable.download_ffc102_progress_bar);
                mDownloadView.setPauseTextVisibility(8);
                mDownloadView.setProgressShow(true);
                mDownloadView.setDownloadViewType(2);
                mDownloadView.setGameInfo(gameInfo);
            }
        } else {
            mDownloadView.setVisibility(8);
        }
    }

    @BindingAdapter(value={"setDataBindingAdapter"})
    public static <Adapter extends DataBindingListAdapter> void setAdapter(AbsListView lv, Adapter mAdapter) {
        lv.setAdapter(mAdapter);
    }

    @BindingAdapter(value={"setDataBindingAdapter"})
    public static <Adapter extends DataBindingListAdapter> void setAdapter(PullToRefreshListView lv, Adapter mAdapter) {
        lv.setAdapter(mAdapter);
    }

    @BindingAdapter(value={"setDataBindingAdapter"})
    public static <Adapter extends DataBindingListAdapter> void setAdapter(HListView lv, Adapter mAdapter) {
        lv.setAdapter(mAdapter);
    }

    @BindingAdapter(value={"addAdViewToContainer"})
    public static void addAdViewToContainer(YYRelativeLayout v, ChatSession chatSession) {
    }

    @BindingAdapter(value={"setZodiacIcon"})
    public static void setZodiacIcon(YYTextView view, String birthday) {
        view.setCompoundDrawablesWithIntrinsicBounds(ZodiacUtils.INSTANCE.getZodiacIcon(birthday), 0, 0, 0);
    }

    @BindingAdapter(value={"ondataNew", "addAdViewToContainer"})
    public static void onAdSessionDataChange(final YYRelativeLayout ll, String data2, AdChatSession session) {
        if (ll == null) {
            return;
        }
        if (session instanceof AdChatSession) {
            IServiceManager serviceManager = session.getmServiceManager();
            ((IAdService)serviceManager.getService(IAdService.class)).loadAd(5, (ViewGroup)ll, new IAdCallback(){

                public void onAdLoadSuccess(AdEntity adEntity) {
                    if (ll != null) {
                        ll.setVisibility(0);
                        ViewGroup.LayoutParams layoutParams2 = ll.getLayoutParams();
                        layoutParams2.width = -1;
                        layoutParams2.height = -2;
                        ll.setLayoutParams(layoutParams2);
                    }
                }

                public void onError(int code, String error) {
                }

                public void onAdClickClose() {
                    super.onAdClickClose();
                    if (ll != null) {
                        ll.setVisibility(0);
                        ViewGroup.LayoutParams layoutParams2 = ll.getLayoutParams();
                        layoutParams2.height = 0;
                        ll.setLayoutParams(layoutParams2);
                        ll.removeAllViews();
                    }
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.CHAT_REMOVE_AD_SESSION));
                }
            });
        }
    }
}

