/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.viewmodel;

import android.app.Application;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.MutableLiveData;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.kvo.CheckStatus;
import com.yy.appbase.kvo.FindFriend;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.model.NetCheckUpload;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.im.ISuggestedFriendViewModel;
import com.yy.hiyo.im.base.SuggestFriendData;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.im.MultiPlatFormBizDataModel;
import com.yy.im.R;
import com.yy.im.interfaces.PlatformCallback;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.viewmodel.BizViewModel;
import com.yy.location.ILocationChangedListener;
import com.yy.location.LocationHelper;
import com.yy.location.LocationInfo;
import common.Header;
import ikxd.apigateway.ApiGateway;
import ikxd.apigateway.GetSuggestFriendsReq;
import ikxd.apigateway.Uri;
import ikxd.apigateway.UserInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SuggestedFriendViewModel
extends BizViewModel
implements ISuggestedFriendViewModel {
    private static final String TAG = "SuggestedFriendViewModel";
    private static final float MIN_NUM = 0.01f;
    public static final int CONTACT_AUTHORIZED = 1;
    public static final int CONTACT_UNAUTHORIZED = 2;
    public static final int CONTACT_EXPIRED = 3;
    public static final int NEARBY_OPEN = 1;
    public static final int NEARBY_CLOSE = 2;
    private static final int SEX_TYPE_ALL = 2;
    private static final int DATA_LIMIT = 30;
    private boolean hadLoadSuggestedFriendData;
    private boolean hadFinishCheck = false;
    private MutableLiveData<Integer> mContactState = new MutableLiveData();
    private MutableLiveData<Integer> mNearbyState = new MutableLiveData();
    private MutableLiveData<Integer> mZaloState = new MutableLiveData();
    private MutableLiveData<List<SuggestFriendData>> mSuggestFriends = new MutableLiveData();
    private MultiPlatFormBizDataModel bizModel;
    private Runnable mHandleSuggestFriendTask = new Runnable(){

        @Override
        public void run() {
            SuggestedFriendViewModel.this.handleSuggestFriendList();
        }
    };
    private ILocationChangedListener mLocationListener = new ILocationChangedListener(){

        public void onLocationFailed(int errorCode, String errorMsg) {
        }

        public void onLocationChanged(LocationInfo info, boolean isCache) {
            if (info != null) {
                MLog.info((Object)SuggestedFriendViewModel.TAG, (String)"on location change", (Object[])new Object[0]);
                SuggestedFriendViewModel.this.mNearbyState.postValue((Object)1);
            }
        }
    };

    public SuggestedFriendViewModel(@NonNull Application application) {
        super(application);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.WSCLIENT_CONNECT_SUCCESS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_BLACK_UID, (INotify)this);
        this.mContactState.setValue((Object)2);
        this.mNearbyState.setValue((Object)2);
        this.mZaloState.setValue((Object)CheckStatus.UNCHECK);
    }

    public MutableLiveData<List<SuggestFriendData>> getSuggestedFriendDatas() {
        return this.mSuggestFriends;
    }

    public MutableLiveData<Integer> getmContactState() {
        return this.mContactState;
    }

    public MutableLiveData<Integer> getmNearbyState() {
        return this.mNearbyState;
    }

    public MutableLiveData<Integer> getZaloState() {
        return this.mZaloState;
    }

    @Override
    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationDef.N_BLACK_UID && notification.extObj instanceof Long) {
            long uid = (Long)notification.extObj;
            this.removeSuggestFriends(uid);
        } else if (notification.id == NotificationDef.N_LOGIN_ACCOUNT_CHANGED && this.bizModel != null) {
            this.bizModel.reset();
        }
    }

    @Override
    public void onWindowShow() {
        super.onWindowShow();
        if (this.bizModel == null) {
            this.bizModel = new MultiPlatFormBizDataModel(this.getAty(), new PlatformCallback(){

                @Override
                public void onPermissionChange(int platForm, int state2) {
                    if (platForm == 1) {
                        int oldAuth;
                        boolean isAuth;
                        int newAuth;
                        if (SuggestedFriendViewModel.this.mContactState != null && (newAuth = (isAuth = state2 == CheckStatus.AUTH) ? 1 : 2) != (oldAuth = ((Integer)SuggestedFriendViewModel.this.mContactState.getValue()).intValue()) && newAuth == 1) {
                            SuggestedFriendViewModel.this.mContactState.setValue((Object)newAuth);
                        }
                    } else if (platForm != 0) {
                        int oldAuth;
                        boolean isAuth;
                        int newAuth;
                        if (platForm == 2) {
                            int oldAuth2;
                            int newAuth2 = state2 == CheckStatus.AUTH ? 1 : 2;
                            if (newAuth2 != (oldAuth2 = ((Integer)SuggestedFriendViewModel.this.mNearbyState.getValue()).intValue()) && newAuth2 == 1 && ProtoManager.getInstance().isWSConnected()) {
                                SuggestedFriendViewModel.this.mNearbyState.setValue((Object)newAuth2);
                            }
                        } else if (platForm == 3 && SuggestedFriendViewModel.this.mZaloState != null && (newAuth = (isAuth = state2 == CheckStatus.AUTH) ? CheckStatus.AUTH : CheckStatus.UNAUTH) != (oldAuth = ((Integer)SuggestedFriendViewModel.this.mZaloState.getValue()).intValue())) {
                            SuggestedFriendViewModel.this.mZaloState.setValue((Object)newAuth);
                            YYTaskExecutor.postToMainThread((Runnable)SuggestedFriendViewModel.this.mHandleSuggestFriendTask);
                        }
                    }
                    MLog.info((Object)SuggestedFriendViewModel.TAG, (String)"onPermissionChange load suggested friend Data,ready:%b, hasLoadBefore:%b, plat:%d, state:%d", (Object[])new Object[]{SuggestedFriendViewModel.this.bizModel.hasGrantedPermission(), SuggestedFriendViewModel.this.hadLoadSuggestedFriendData, platForm, state2});
                    if (SuggestedFriendViewModel.this.bizModel.hasGrantedPermission() && !SuggestedFriendViewModel.this.hadLoadSuggestedFriendData) {
                        YYTaskExecutor.postToMainThread((Runnable)SuggestedFriendViewModel.this.mHandleSuggestFriendTask);
                        SuggestedFriendViewModel.this.hadFinishCheck = true;
                    } else if (SuggestedFriendViewModel.this.bizModel.isAllPermissionDeny()) {
                        MLog.info((Object)SuggestedFriendViewModel.TAG, (String)"all permission deny", (Object[])new Object[0]);
                        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_CHAT_SESSION_PAGE_HIDE_LOADING));
                        SuggestedFriendViewModel.this.hadFinishCheck = true;
                    }
                }

                @Override
                public void onUploadFinish(int platform, boolean success) {
                    MLog.info((Object)SuggestedFriendViewModel.TAG, (String)"onUploadFinish:platform:%d,success:%b", (Object[])new Object[]{platform, success});
                    if (success) {
                        YYTaskExecutor.removeRunnableFromMainThread((Runnable)SuggestedFriendViewModel.this.mHandleSuggestFriendTask);
                        YYTaskExecutor.postToMainThread((Runnable)SuggestedFriendViewModel.this.mHandleSuggestFriendTask, (long)3000L);
                    }
                }

                @Override
                public void onNeedUpload(int platform, NetCheckUpload upload) {
                    MLog.info((Object)SuggestedFriendViewModel.TAG, (String)"onNeedUpload ,platform:%d, upload:%s", (Object[])new Object[]{platform, upload});
                }
            });
            this.bizModel.initKvo();
        }
        this.bizModel.start();
    }

    public boolean isHadFinishCheck() {
        return this.hadFinishCheck || this.hadLoadSuggestedFriendData;
    }

    @Override
    public void onWindowHide() {
        super.onWindowHide();
    }

    @Override
    public void onWindowDetach() {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mHandleSuggestFriendTask);
        LocationHelper.removeLocationListener((ILocationChangedListener)this.mLocationListener);
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.bizModel != null) {
            this.bizModel.checkPermission();
        }
    }

    @Override
    protected void resetWhenLogout() {
        if (this.mSuggestFriends != null && this.mSuggestFriends.getValue() != null) {
            ((List)this.mSuggestFriends.getValue()).clear();
        }
        MLog.info((Object)TAG, (String)"resetWhenLogout value is clear", (Object[])new Object[0]);
        this.hadLoadSuggestedFriendData = false;
        this.hadFinishCheck = false;
        this.mContactState.setValue((Object)2);
        this.mNearbyState.setValue((Object)2);
        LocationHelper.removeLocationListener((ILocationChangedListener)this.mLocationListener);
    }

    public void handleSuggestFriendList() {
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
            ArrayList suggestFriendDatas = new ArrayList();
            MLog.info((Object)TAG, (String)"handleSuggestFriendList netWork unavailable", (Object[])new Object[0]);
            this.mSuggestFriends.setValue(suggestFriendDatas);
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_CHAT_SESSION_PAGE_HIDE_LOADING));
            return;
        }
        this.hadLoadSuggestedFriendData = true;
        if (this.mSuggestFriends.getValue() == null || ((List)this.mSuggestFriends.getValue()).isEmpty()) {
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_CHAT_SESSION_PAGE_SHOW_LOADING));
        }
        LocationInfo locationInfo = LocationHelper.getLocationInfo((boolean)true);
        LocationHelper.removeLocationListener((ILocationChangedListener)this.mLocationListener);
        float longitude = 0.0f;
        float latitude = 0.0f;
        if (locationInfo == null) {
            MLog.info((Object)TAG, (String)"nearby location null,do not load near by friends,add a lisener to watch location change", (Object[])new Object[0]);
            LocationHelper.addLocationListener((ILocationChangedListener)this.mLocationListener);
        } else {
            longitude = (float)locationInfo.getLongitude();
            latitude = (float)locationInfo.getLatitude();
        }
        GetSuggestFriendsReq req = new GetSuggestFriendsReq.Builder().longitude(Float.valueOf(longitude)).latitude(Float.valueOf(latitude)).sex(Long.valueOf(2L)).limit(Long.valueOf(30L)).build();
        Header header2 = ProtoManager.getInstance().getHeader("ikxd_apigateway_d");
        ApiGateway ikxdApigateway = new ApiGateway.Builder().get_suggest_friends_req(req).uri(Uri.kUriGetSuggestFriendsReq).header(header2).build();
        MLog.info((Object)TAG, (String)"Start request suggest friends data!!!", (Object[])new Object[0]);
        ProtoManager.getInstance().send((AndroidMessage)ikxdApigateway, (IProtoCallback)new IProtoCallback<ApiGateway>(){

            public void onResponse(@Nullable ApiGateway resp) {
                ArrayList<SuggestFriendData> suggestFriendDatas = new ArrayList<SuggestFriendData>();
                if (resp != null && resp.uri == Uri.kUriGetSuggestFriendsRes) {
                    List infos = resp.get_suggest_friends_res.users;
                    MLog.info((Object)SuggestedFriendViewModel.TAG, (String)("get find friend data from server,size:" + (infos != null ? infos.size() : 0)), (Object[])new Object[0]);
                    if (infos != null && !infos.isEmpty()) {
                        for (UserInfo info : infos) {
                            FindFriend f = new FindFriend();
                            f.setUid(info.uid.longValue());
                            f.setAvatar(info.avatar);
                            f.setNick(info.nick);
                            f.setType(info.type.longValue());
                            f.setDist(info.dist.floatValue());
                            f.setOnlineStatus(info.online_status.longValue());
                            f.setbHagoFriend(info.bHagoFriend.longValue());
                            f.setAlias(info.alias);
                            f.setSex(FP.orInt((Long)info.sex));
                            RelationInfo relationInfo = ((IRelationService)ServiceManagerProxy.getService(IRelationService.class)).getRelationLocal(f.getUid());
                            SuggestFriendData suggestFriendData = new SuggestFriendData(f, relationInfo);
                            if (f.getType() == 1L) {
                                if ((Integer)SuggestedFriendViewModel.this.mContactState.getValue() != 1) continue;
                                suggestFriendDatas.add(suggestFriendData);
                                continue;
                            }
                            suggestFriendDatas.add(suggestFriendData);
                        }
                    }
                    SuggestedFriendViewModel.this.mSuggestFriends.setValue(suggestFriendDatas);
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_CHAT_SESSION_PAGE_HIDE_LOADING));
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.info((Object)SuggestedFriendViewModel.TAG, (String)("requestNearby retryWhenTimeout: " + canRetry), (Object[])new Object[0]);
                return true;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.info((Object)SuggestedFriendViewModel.TAG, (String)("requestNearby retryWhenError: " + canRetry + ", reason: " + reason), (Object[])new Object[0]);
                return true;
            }
        });
    }

    private void removeSuggestFriends(long uid) {
        List mList;
        if (this.mSuggestFriends != null && this.mSuggestFriends.getValue() != null && !(mList = (List)this.mSuggestFriends.getValue()).isEmpty()) {
            Iterator iterable = mList.iterator();
            boolean match = false;
            while (iterable.hasNext()) {
                SuggestFriendData friend = (SuggestFriendData)iterable.next();
                if (friend.mFriend.getUid() != uid) continue;
                match = true;
                iterable.remove();
                break;
            }
            if (match) {
                this.mSuggestFriends.setValue((Object)mList);
            }
        }
    }
}

