/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.viewmodel;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.widget.ListView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.Observable;
import androidx.databinding.ObservableBoolean;
import androidx.databinding.ObservableField;
import androidx.databinding.ObservableList;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.PullToRefreshListView;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.ui.widget.EndlessListScrollListener;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ImeUtil;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.im.ImRepository;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.hiyo.relation.base.friend.data.FriendInfo;
import com.yy.im.R;
import com.yy.im.model.SearchFriend;
import com.yy.im.model.SearchFriendDiv;
import com.yy.im.model.netmodel.NetSearchFriend;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.viewmodel.BizViewModel;
import com.yy.im.viewmodel.ChatSessionViewModel;
import com.yy.im.viewmodel.FriendListViewModel;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import okhttp3.Call;

public class SearchFriendViewModel
extends BizViewModel {
    private static final String TAG = "SearchFriendViewModel";
    private static final int SEARCH_FROM_DEFAULT_INDEX = 0;
    private static final int SEARCH_LIMIT = 10;
    public static final int SEARCH_CONTACTS = 0;
    public static final int SEARCH_NETWORK = 1;
    public static final long TIME_OUT_TS = 10000L;
    private int searchType = 1;
    private List<SearchFriend> mFbSuggestFriends = new ArrayList<SearchFriend>();
    private List<SearchFriend> mFbFriends = new ArrayList<SearchFriend>();
    private MediatorLiveData<List<SearchFriend>> mSearchedFBFriends = new MediatorLiveData();
    private MutableLiveData<List<SearchFriend>> mSearchedWithNickFriends = new MutableLiveData();
    public ObservableField<String> mSearchWords = new ObservableField((Object)"");
    public ObservableBoolean mShowTips1 = new ObservableBoolean(true);
    public ObservableField<String> mTips1Str = new ObservableField((Object)"");
    public ObservableField<String> mTipsIdStr = new ObservableField((Object)"");
    public ObservableBoolean mShowTips2 = new ObservableBoolean(true);
    public ObservableBoolean mShowTips3 = new ObservableBoolean(true);
    private int mFromIndex = 0;
    private UserInfoKS mUserInfo;
    private Observer<List<SearchFriend>> mSuggestFriendsObs;
    private Observer<List<SearchFriend>> mFbFriendsObs;
    private ObservableBoolean mLoadMoreEnable = new ObservableBoolean(false);
    private WeakReference<PullToRefreshListView> mLvRef;
    private WeakReference<CommonStatusLayout> mStatusLayoutRef;
    private FriendListViewModel mFriendListVM;
    private ChatSessionViewModel mChatSessionVM;
    public ObservableBoolean showSearchTips = new ObservableBoolean(false);
    private Runnable timeOutTask = new Runnable(){

        @Override
        public void run() {
            ToastUtils.showToast((Context)SearchFriendViewModel.this.getApplication(), (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
            SearchFriendViewModel.this.resetView();
        }
    };
    private EndlessListScrollListener.EndlessListener mLoadingListener = new EndlessListScrollListener.EndlessListener(){

        public void onLoadData() {
            if (SearchFriendViewModel.this.searchType == 1) {
                SearchFriendViewModel.this.searchNetWork((String)SearchFriendViewModel.this.mSearchWords.get(), SearchFriendViewModel.this.mFromIndex + 10);
            }
        }

        public boolean shouldLoadData() {
            return SearchFriendViewModel.this.mLoadMoreEnable.get();
        }
    };
    private PullToRefreshBase.OnRefreshListener<ListView> mPullToRefreshListener = new PullToRefreshBase.OnRefreshListener<ListView>(){

        public void onRefresh(PullToRefreshBase<ListView> refreshView) {
            SearchFriendViewModel.this.searchNetWork((String)SearchFriendViewModel.this.mSearchWords.get(), 0);
        }
    };

    public SearchFriendViewModel(@NonNull Application application) {
        super(application);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_OPEN_SEARCH_FRIENDS_PAGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_POP_SEARCH_FRIENDS_PAGE, (INotify)this);
        this.mSearchedWithNickFriends.observeForever((Observer)new Observer<List<SearchFriend>>(){

            public void onChanged(@Nullable List<SearchFriend> searchFriends) {
                SearchFriendViewModel.this.mShowTips1.set(searchFriends == null || searchFriends.isEmpty());
                SearchFriendViewModel.this.mShowTips2.set(false);
                SearchFriendViewModel.this.mShowTips3.set(false);
                SearchFriendViewModel.this.mTips1Str.set((Object)ResourceUtils.getString((int)R.string.no_result));
                SearchFriendViewModel.this.mTipsIdStr.set((Object)"");
            }
        });
        this.mSearchWords.addOnPropertyChangedCallback(new Observable.OnPropertyChangedCallback(){

            public void onPropertyChanged(Observable sender, int propertyId) {
                if ((SearchFriendViewModel.this.mSearchedWithNickFriends == null || SearchFriendViewModel.this.mSearchedWithNickFriends.getValue() == null || ((List)SearchFriendViewModel.this.mSearchedWithNickFriends.getValue()).isEmpty()) && TextUtils.isEmpty((CharSequence)((CharSequence)SearchFriendViewModel.this.mSearchWords.get()))) {
                    SearchFriendViewModel.this.mShowTips1.set(true);
                    SearchFriendViewModel.this.mShowTips2.set(true);
                    if (AccountUtil.isLoginByGuest()) {
                        SearchFriendViewModel.this.mShowTips3.set(false);
                    } else {
                        SearchFriendViewModel.this.mShowTips3.set(true);
                    }
                    SearchFriendViewModel.this.mTips1Str.set((Object)(SearchFriendViewModel.this.mUserInfo != null ? ((SearchFriendViewModel)SearchFriendViewModel.this).mUserInfo.nick : ""));
                    SearchFriendViewModel.this.mTipsIdStr.set((Object)(SearchFriendViewModel.this.mUserInfo != null ? String.valueOf(((SearchFriendViewModel)SearchFriendViewModel.this).mUserInfo.vid) : ""));
                }
            }
        });
        this.mSuggestFriendsObs = new Observer<List<SearchFriend>>(){

            public void onChanged(@Nullable List<SearchFriend> searchFriends) {
                SearchFriendViewModel.this.mFbSuggestFriends.clear();
                if (searchFriends != null) {
                    SearchFriendViewModel.this.mFbSuggestFriends.addAll(searchFriends);
                }
                SearchFriendViewModel.this.mixFriends();
            }
        };
        this.mFbFriendsObs = new Observer<List<SearchFriend>>(){

            public void onChanged(@Nullable List<SearchFriend> searchFriends) {
                SearchFriendViewModel.this.mFbFriends.clear();
                if (searchFriends != null) {
                    SearchFriendViewModel.this.mFbFriends.addAll(searchFriends);
                }
                SearchFriendViewModel.this.mixFriends();
            }
        };
    }

    public void setChatSessionViewModel(ChatSessionViewModel vm) {
        this.mChatSessionVM = vm;
    }

    public PullToRefreshBase.OnRefreshListener<ListView> getmPullToRefreshListener() {
        return this.mPullToRefreshListener;
    }

    public void setmLvRef(PullToRefreshListView mLvRef) {
        this.mLvRef = new WeakReference<PullToRefreshListView>(mLvRef);
    }

    public void setmStatusLayoutRef(CommonStatusLayout mStatusLayoutRef) {
        this.mStatusLayoutRef = new WeakReference<CommonStatusLayout>(mStatusLayoutRef);
    }

    private void resetView() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (SearchFriendViewModel.this.mLvRef != null && SearchFriendViewModel.this.mLvRef.get() != null) {
                    ((PullToRefreshListView)SearchFriendViewModel.this.mLvRef.get()).onRefreshComplete();
                }
                if (SearchFriendViewModel.this.mStatusLayoutRef != null && SearchFriendViewModel.this.mStatusLayoutRef.get() != null) {
                    ((CommonStatusLayout)SearchFriendViewModel.this.mStatusLayoutRef.get()).hideLoading();
                }
            }
        });
    }

    private void scroll2Top() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (SearchFriendViewModel.this.mLvRef != null && SearchFriendViewModel.this.mLvRef.get() != null) {
                    ((ListView)((PullToRefreshListView)SearchFriendViewModel.this.mLvRef.get()).getRefreshableView()).setSelection(0);
                }
            }
        });
    }

    private void mixFriends() {
        SearchFriendDiv div;
        ArrayList<SearchFriend> list = new ArrayList<SearchFriend>();
        if (!this.mFbSuggestFriends.isEmpty()) {
            div = new SearchFriendDiv(ResourceUtils.getString((int)R.string.suggested_friends));
            list.add(div);
            list.addAll(this.mFbSuggestFriends);
        }
        if (!this.mFbFriends.isEmpty()) {
            div = new SearchFriendDiv(ResourceUtils.getString((int)R.string.add_friend_div));
            list.add(div);
            list.addAll(this.mFbFriends);
        }
        this.mSearchedFBFriends.setValue(list);
    }

    public boolean onEditorAction(TextView var1, int actionId, KeyEvent var3) {
        if (actionId == 3) {
            String keyword = var1.getText().toString().trim();
            MLog.info((Object)TAG, (String)"searchType %d keyword %s", (Object[])new Object[]{this.searchType, keyword});
            if (TextUtils.isEmpty((CharSequence)keyword)) {
                return true;
            }
            if (this.searchType == 1) {
                this.searchNetWork(keyword, 0);
            } else if (this.searchType == 0) {
                this.searchLocalContacts(keyword);
            }
            ImeUtil.hideIME((Activity)this.getAty());
            this.showSearchTips.set(false);
        }
        return true;
    }

    public void onClickTipsSearch(View v) {
        String keyword = (String)this.mSearchWords.get();
        MLog.info((Object)TAG, (String)"searchType %d keyword %s", (Object[])new Object[]{this.searchType, keyword});
        if (TextUtils.isEmpty((CharSequence)keyword)) {
            return;
        }
        if (this.searchType == 1) {
            this.searchNetWork(keyword, 0);
        } else if (this.searchType == 0) {
            this.searchLocalContacts(keyword);
        }
        ImeUtil.hideIME((Activity)this.getAty());
        this.showSearchTips.set(false);
    }

    public void afterTextChanged(CharSequence s, int start, int before, int count) {
        this.mSearchWords.set((Object)s.toString());
        this.showSearchTips.set(!TextUtils.isEmpty((CharSequence)s));
    }

    public void onClickClear(View view) {
        this.mSearchWords.set((Object)"");
    }

    private void searchNetWork(String keyword, final int from) {
        String search;
        String string2 = search = keyword != null ? keyword.trim() : "";
        if (TextUtils.isEmpty((CharSequence)search)) {
            return;
        }
        this.mLoadMoreEnable.set(false);
        if (!NetworkUtils.isNetworkAvailable((Context)this.getApplication())) {
            ToastUtils.showToast((Context)this.getApplication(), (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
        }
        if (this.mStatusLayoutRef != null && this.mStatusLayoutRef.get() != null) {
            ((CommonStatusLayout)this.mStatusLayoutRef.get()).showLoading();
        }
        MLog.info((Object)TAG, (String)("search friend with nick:" + search + ", from:" + from), (Object[])new Object[0]);
        YYTaskExecutor.removeTask((Runnable)this.timeOutTask);
        YYTaskExecutor.postToMainThread((Runnable)this.timeOutTask, (long)10000L);
        ImRepository.searchFriendsWithNick((String)search, (int)from, (int)10, (INetRespCallback)new INetRespCallback<NetSearchFriend>(){

            public void onError(Call call, Exception e, int id2) {
                YYTaskExecutor.removeTask((Runnable)SearchFriendViewModel.this.timeOutTask);
                YYTaskExecutor.postToMainThread((Runnable)SearchFriendViewModel.this.timeOutTask);
            }

            public void onResponse(String response, BaseResponseBean<NetSearchFriend> data2, int id2) {
                YYTaskExecutor.removeTask((Runnable)SearchFriendViewModel.this.timeOutTask);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SearchFriendViewModel.this.resetView();
                        SearchFriendViewModel.this.mShowTips2.set(false);
                        SearchFriendViewModel.this.mShowTips3.set(false);
                    }
                });
                if (data2 != null && data2.isSuccess() && data2.data != null) {
                    MLog.info((Object)SearchFriendViewModel.TAG, (String)("search friend with nick:" + search + " success!size is " + (((NetSearchFriend)data2.data).mUserInfo != null ? ((NetSearchFriend)data2.data).mUserInfo.size() : 0)), (Object[])new Object[0]);
                    SearchFriendViewModel.this.mFromIndex = from;
                    List<SearchFriend> mData = ((NetSearchFriend)data2.data).mUserInfo;
                    if (mData == null) {
                        mData = new ArrayList<SearchFriend>();
                    }
                    SearchFriendViewModel.this.mLoadMoreEnable.set(mData.size() >= 10);
                    ArrayList mFriendUids = new ArrayList();
                    if (SearchFriendViewModel.this.mFriendListVM != null) {
                        mFriendUids = SearchFriendViewModel.this.mFriendListVM.getmFriendsUids();
                    }
                    Iterator<SearchFriend> iterator = mData.iterator();
                    while (iterator.hasNext()) {
                        SearchFriend friend = iterator.next();
                        if (friend == null || friend.getUid() == AccountUtil.getUid()) {
                            iterator.remove();
                            continue;
                        }
                        friend.setFrom(String.valueOf(friend.getVid()));
                        friend.setFromType(2);
                        RelationInfo info = ((IRelationService)ServiceManagerProxy.getService(IRelationService.class)).getRelationLocal(friend.getUid());
                        friend.setRelation(info);
                        if (!mFriendUids.contains(friend.getUid())) continue;
                        friend.setViewState(5);
                    }
                    if (from == 0) {
                        SearchFriendViewModel.this.mSearchedWithNickFriends.postValue(mData);
                        SearchFriendViewModel.this.scroll2Top();
                    } else {
                        ArrayList<SearchFriend> friends = (ArrayList<SearchFriend>)SearchFriendViewModel.this.mSearchedWithNickFriends.getValue();
                        if (friends == null) {
                            friends = new ArrayList<SearchFriend>();
                        }
                        friends.addAll(mData);
                        SearchFriendViewModel.this.mSearchedWithNickFriends.postValue(friends);
                    }
                } else {
                    MLog.info((Object)SearchFriendViewModel.TAG, (String)("search friend with nick:" + search + " fail! responce :" + response), (Object[])new Object[0]);
                }
            }
        });
    }

    private void searchLocalContacts(String keyword) {
        if (this.mFriendListVM != null && this.mFriendListVM.getmRawContacts() != null && !this.mFriendListVM.getmRawContacts().isEmpty()) {
            ObservableList<FriendInfo> list = this.mFriendListVM.getmRawContacts();
            if (list != null && !list.isEmpty()) {
                ArrayList<SearchFriend> data2 = new ArrayList<SearchFriend>();
                long uid = AccountUtil.getUid();
                for (FriendInfo friend : list) {
                    UserInfoKS info = friend.getUserInfo();
                    if (info.uid == uid || TextUtils.isEmpty((CharSequence)info.nick) || !info.nick.toLowerCase().contains(keyword.toLowerCase())) continue;
                    SearchFriend f = new SearchFriend();
                    f.setUid(info.uid);
                    f.setName(info.nick);
                    f.setAvatarUrl(info.avatar);
                    f.setViewState(6);
                    f.setSex(info.sex);
                    f.setFrom(String.valueOf(info.vid));
                    data2.add(f);
                }
                this.mSearchedWithNickFriends.setValue(data2);
            }
        } else {
            this.mSearchedWithNickFriends.setValue(new ArrayList());
        }
    }

    public MutableLiveData<List<SearchFriend>> getmSearchedFBFriends() {
        return this.mSearchedFBFriends;
    }

    public MutableLiveData<List<SearchFriend>> getmSearchedWithNickFriends() {
        return this.mSearchedWithNickFriends;
    }

    @Override
    public void onWindowDetach() {
        super.onWindowDetach();
        this.mSearchWords.set((Object)"");
        this.mSearchedWithNickFriends.setValue(new ArrayList());
        try {
            this.mSearchedFBFriends.removeObserver(this.mFbFriendsObs);
            this.mSearchedFBFriends.removeObserver(this.mSuggestFriendsObs);
        }
        catch (Exception e) {
            MLog.info((Object)TAG, (String)"onWindowDetach ex: %s", (Object[])new Object[]{e});
        }
    }

    @Override
    public void onWindowAttach() {
        super.onWindowAttach();
        this.mShowTips2.set(true);
        if (!AccountUtil.isLoginByGuest()) {
            this.mShowTips3.set(true);
        } else {
            this.mShowTips3.set(false);
        }
        if (this.mChatSessionVM != null) {
            try {
                this.mSearchedFBFriends.addSource(this.mChatSessionVM.getmSuggestedFbFriends(), this.mSuggestFriendsObs);
                this.mSearchedFBFriends.addSource(this.mChatSessionVM.getFbFriends(), this.mFbFriendsObs);
            }
            catch (Exception e) {
                MLog.info((Object)TAG, (String)"onWindowAttach ex: %s", (Object[])new Object[]{e});
            }
        }
        this.loadFriendList();
        this.getNickName();
    }

    private void getNickName() {
        this.mUserInfo = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(AccountUtil.getUid(), new OnProfileCallback(){

            public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                MLog.info((Object)SearchFriendViewModel.TAG, (String)("get user info success !:" + (userInfoKSList != null && !userInfoKSList.isEmpty() ? "nick:" + userInfoKSList.get((int)0).nick + " vid:" + userInfoKSList.get((int)0).vid : "null")), (Object[])new Object[0]);
            }

            public void onFail(int id2, String msg, String response) {
            }

            public int id() {
                return 0;
            }
        });
        if (this.mUserInfo != null) {
            Kvo.autoBindingTo((KvoSource)this.mUserInfo, (Object)this);
        }
    }

    @KvoMethodAnnotation(name="nick", sourceClass=UserInfoKS.class)
    public void onNickEvent(KvoEventIntent event) {
        if (this.mUserInfo != null) {
            this.mTips1Str.set((Object)this.mUserInfo.nick);
        }
    }

    @KvoMethodAnnotation(name="vid", sourceClass=UserInfoKS.class)
    public void onVidEvent(KvoEventIntent event) {
        if (this.mUserInfo != null) {
            this.mTipsIdStr.set((Object)String.valueOf(this.mUserInfo.vid));
        }
    }

    private void loadFriendList() {
        if (this.mFriendListVM != null) {
            this.mFriendListVM.getmRawContacts();
        }
    }

    @Override
    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == ImNotificationDef.IM_OPEN_SEARCH_FRIENDS_PAGE || notification.id == ImNotificationDef.IM_OPEN_SEARCH_FRIENDS_PAGE) {
            this.searchType = 1;
            if (notification.extObj instanceof Integer) {
                this.searchType = (Integer)notification.extObj;
            }
            this.mLoadMoreEnable.set(this.searchType == 1);
        }
    }

    public EndlessListScrollListener.EndlessListener getmLoadingListener() {
        return this.mLoadingListener;
    }

    public void setmFriendListVM(FriendListViewModel mFriendListVM) {
        this.mFriendListVM = mFriendListVM;
        if (mFriendListVM != null) {
            // empty if block
        }
    }
}

