/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.viewmodel;

import android.app.Application;
import android.content.Context;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.ObservableArrayList;
import androidx.databinding.ObservableList;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.data.UserOnlineDBBean;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.safelivedata.SafeLiveData;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.MyJoinChannelItem;
import com.yy.hiyo.im.Utils;
import com.yy.hiyo.relation.base.friend.IFriendServices;
import com.yy.hiyo.relation.base.friend.data.FriendInfo;
import com.yy.hiyo.relation.base.friend.data.FriendInfoList;
import com.yy.im.R;
import com.yy.im.interfaces.CusObservableListener;
import com.yy.im.interfaces.IRelationship;
import com.yy.im.model.CreateChannelEntrance;
import com.yy.im.model.IContact;
import com.yy.im.model.TimeDivisionViewItem;
import com.yy.im.model.UserCharViewItem;
import com.yy.im.model.UserInfoViewItem;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.viewmodel.BizViewModel;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FriendListViewModel
extends BizViewModel {
    private static final String TAG = "FriendListViewModel";
    private MutableLiveData<List<IContact>> mFriendContact = new SafeLiveData();
    private ObservableList<FriendInfo> mRawContacts = new ObservableArrayList();
    private ObservableList<Long> mFriendsUids = new ObservableArrayList();
    private boolean mLoadUidsSucc = false;
    private boolean mLoadingUids = false;
    private final List<RelationshipReq> mCacheCallback = new ArrayList<RelationshipReq>();
    private final List<WeakReference<FriendListObservable>> mFriendListCallBack = new ArrayList<WeakReference<FriendListObservable>>();
    private CreateChannelEntrance mCreateChannelEntrance = null;
    private boolean mShowCreateChannelEntry = false;
    private static final long HALF_YEAR_MILL = TimeUtils.MONTHS.toMillis((long)6L);
    private FriendInfoList mFriendInfoList;
    @Nullable
    private LiveData<Map<Long, UserOnlineDBBean>> friendsOnlineStatusLiveData = null;
    private final Map<Long, UserOnlineDBBean> friendsOnlineStatus = new HashMap<Long, UserOnlineDBBean>();
    private final Observer<Map<Long, UserOnlineDBBean>> friendsOnlineChangeObserver = this::friendsOnlineStatusChange;

    public FriendListViewModel(@NonNull Application application) {
        super(application);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_CHECK_RELATIONSHIP, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_UNREGISTER_FRIEND_LIST_CALLBACK, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_RECEIVE_NEW_FRIENDS_MSG, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_SUCCESS, (INotify)this);
        this.mFriendContact.setValue(new ArrayList());
        this.mFriendsUids.addOnListChangedCallback((ObservableList.OnListChangedCallback)new CusObservableListener<ObservableList<Long>>(){

            @Override
            public void onDataSetChange(ObservableList<Long> longs) {
                FriendListViewModel.this.notifyFriendListObs();
            }
        });
    }

    @Override
    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == ImNotificationDef.IM_CHECK_RELATIONSHIP && notification.extObj instanceof RelationshipReq) {
            this.checkRelationship((RelationshipReq)notification.extObj);
        } else if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS) {
            this.loadFriends();
        } else if (notification.id != ImNotificationDef.IM_RECEIVE_NEW_FRIENDS_MSG) {
            if (notification.id == ImNotificationDef.IM_UNREGISTER_FRIEND_LIST_CALLBACK && notification.extObj instanceof FriendListObservable) {
                this.unRegisterFriendCallback((FriendListObservable)notification.extObj);
            } else if (notification.id == NotificationDef.N_LOGIN_SUCCESS) {
                MLog.info((Object)TAG, (String)"N_LOGIN_SUCCESS loadfriends", (Object[])new Object[0]);
                this.loadFriends();
            } else if (notification.id == NotificationIdDef.CHANNEL_CREATE_SUCCESS) {
                this.checkCreateRoomPermiss();
            }
        }
    }

    private void checkUpdateEntry() {
        List value = (List)this.mFriendContact.getValue();
        if (this.mCreateChannelEntrance != null && value != null && !value.isEmpty()) {
            if (this.mShowCreateChannelEntry) {
                if (!value.contains(this.mCreateChannelEntrance)) {
                    ArrayList<CreateChannelEntrance> contacts = new ArrayList<CreateChannelEntrance>();
                    contacts.add(this.mCreateChannelEntrance);
                    contacts.addAll(value);
                    this.mFriendContact.postValue(contacts);
                }
            } else if (value.contains(this.mCreateChannelEntrance)) {
                ArrayList contacts = new ArrayList(value);
                contacts.remove(this.mCreateChannelEntrance);
                this.mFriendContact.postValue(contacts);
            }
            if (this.mCreateChannelEntrance != null & value.contains(this.mCreateChannelEntrance)) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "contacter_create_channel_but_show"));
            }
        }
    }

    private void checkCreateRoomPermiss() {
        MLog.info((Object)TAG, (String)"checkCreateRoomPermiss permiss", (Object[])new Object[0]);
        ((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getMyJoinedChannels(new IChannelCenterService.IGetMyJoinedChannelsCallBack(){

            public void onSuccess(ArrayList<MyJoinChannelItem> groupSummays) {
                boolean hasOwnerRoom = false;
                if (!FP.empty(groupSummays)) {
                    for (MyJoinChannelItem channelInfo : groupSummays) {
                        if (channelInfo.myRoleData == null || channelInfo.myRoleData.roleType != 15 || channelInfo.mPluginData != null && !"base".equals(channelInfo.mPluginData.getPluginId())) continue;
                        hasOwnerRoom = true;
                        break;
                    }
                }
                FriendListViewModel.this.mShowCreateChannelEntry = !hasOwnerRoom;
                FriendListViewModel.this.checkUpdateEntry();
            }

            public void onError(int errorCode, Exception e) {
            }
        }, true);
    }

    public MutableLiveData<List<IContact>> getFriends() {
        return this.mFriendContact;
    }

    public ObservableList<Long> getmFriendsUids() {
        return this.mFriendsUids;
    }

    public void loadFriends() {
        if (AccountUtil.getUid() <= 0L) {
            return;
        }
        if (this.mLoadUidsSucc) {
            return;
        }
        if (!this.mLoadingUids) {
            if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
            }
            this.mLoadingUids = true;
            this.requestFriendList(false);
        }
    }

    private void requestFriendList(boolean needTime) {
        this.mFriendInfoList = ((IFriendServices)ServiceManagerProxy.getService(IFriendServices.class)).reqFriendList(needTime);
        Kvo.autoUnbindingFrom((KvoSource)this.mFriendInfoList, (Object)this);
        Kvo.autoBindingTo((KvoSource)this.mFriendInfoList, (Object)this);
    }

    @KvoMethodAnnotation(name="friendList", sourceClass=FriendInfoList.class, thread=1)
    public void onFriendsList(KvoEventIntent event) {
        FriendInfoList list = (FriendInfoList)event.source();
        this.mLoadingUids = false;
        this.mLoadUidsSucc = true;
        if (list.getUidList().isEmpty()) {
            // empty if block
        }
        this.mFriendsUids.clear();
        if (!list.getUidList().isEmpty()) {
            List uids = list.getUidList();
            this.mFriendsUids.addAll((Collection)uids);
            this.notifyCallback();
            this.sortFriendList(list);
            IUserInfoService userInfoService = (IUserInfoService)ServiceManagerProxy.getInstance().getService(IUserInfoService.class);
            LiveData userOnlineDBBeanLiveData = null;
            if (userInfoService != null) {
                userOnlineDBBeanLiveData = userInfoService.getOnlineStatus(uids, true);
            }
            if (userOnlineDBBeanLiveData != null) {
                if (this.friendsOnlineStatusLiveData != null) {
                    this.friendsOnlineStatusLiveData.removeObserver(this.friendsOnlineChangeObserver);
                    this.friendsOnlineStatusLiveData = null;
                }
                this.friendsOnlineStatusLiveData = userOnlineDBBeanLiveData;
                this.friendsOnlineStatusLiveData.observeForever(this.friendsOnlineChangeObserver);
            }
        } else {
            this.notifyCallback();
            this.emptyFriend();
        }
    }

    @MainThread
    private synchronized void friendsOnlineStatusChange(Map<Long, UserOnlineDBBean> userOnlineDBBeanMap) {
        this.friendsOnlineStatus.putAll(userOnlineDBBeanMap);
        ArrayList<Long> tobeRemove = new ArrayList<Long>(10);
        for (Map.Entry<Long, UserOnlineDBBean> entry : this.friendsOnlineStatus.entrySet()) {
            boolean outOf10Min = Math.abs(entry.getValue().getUpdateTimestamp() - System.currentTimeMillis()) > 600000L;
            if (!outOf10Min) continue;
            tobeRemove.add(entry.getKey());
        }
        for (Long rmKey : tobeRemove) {
            this.friendsOnlineStatus.remove(rmKey);
        }
        MLog.debug((Object)TAG, (String)("friends online status: " + this.friendsOnlineStatus.toString()), (Object[])new Object[0]);
        List contacts = (List)this.mFriendContact.getValue();
        if (contacts != null && !contacts.isEmpty()) {
            for (IContact contact : contacts) {
                if (!(contact instanceof UserInfoViewItem)) continue;
                UserInfoViewItem userInfoContact = (UserInfoViewItem)contact;
                long uid = userInfoContact.getUid();
                UserOnlineDBBean userOnlineDBBean = this.friendsOnlineStatus.get(uid);
                userInfoContact.setUserOnlineDBBean(userOnlineDBBean);
            }
            this.mFriendContact.postValue((Object)contacts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void notifyCallback() {
        MLog.info((Object)TAG, (String)"notifyCallback friend return lifeCallback", (Object[])new Object[0]);
        List<RelationshipReq> list = this.mCacheCallback;
        synchronized (list) {
            if (this.mCacheCallback != null && !this.mCacheCallback.isEmpty()) {
                Iterator<RelationshipReq> iterator = this.mCacheCallback.iterator();
                while (iterator.hasNext()) {
                    RelationshipReq callback = iterator.next();
                    if (callback != null && callback.mCallback != null && callback.mCallback.get() != null && callback.uids != null && !callback.uids.isEmpty()) {
                        IRelationship call = (IRelationship)callback.mCallback.get();
                        List uid = callback.uids;
                        ArrayList<Integer> relations = new ArrayList<Integer>();
                        for (Long id2 : uid) {
                            relations.add(this.mFriendsUids.contains((Object)id2) ? 1 : 0);
                        }
                        if (this.mLoadUidsSucc) {
                            call.onSucc(uid, relations);
                        } else {
                            call.onError(uid, 0);
                        }
                    }
                    iterator.remove();
                }
            }
        }
    }

    private synchronized void sortFriendList(FriendInfoList friendInfoList) {
        this.getImMsg(friendInfoList);
    }

    private synchronized void sortData(FriendInfoList friendInfoList, List<Long> recently, List<Long> noInteract) {
        ArrayList<FriendInfo> list = new ArrayList<FriendInfo>(friendInfoList.getFriendList().size() + 1);
        list.addAll(friendInfoList.getFriendList());
        this.mRawContacts.clear();
        this.mRawContacts.addAll(list);
        List<IContact> insertedList = this.getInsertedList(list, recently, noInteract);
        this.mFriendContact.postValue(insertedList);
    }

    private synchronized void emptyFriend() {
        ArrayList<FriendInfo> list = new ArrayList<FriendInfo>(1);
        this.mRawContacts.clear();
        this.mRawContacts.addAll(list);
        this.mFriendContact.postValue(this.getInsertedList(list, null, null));
    }

    private List<IContact> getInsertedList(List<FriendInfo> friendList, List<Long> recently, List<Long> noInteract) {
        if (recently == null) {
            recently = new ArrayList<Long>(1);
        }
        ArrayList<IContact> recentlyItem = new ArrayList<IContact>(recently.size());
        ArrayList<UserInfoViewItem> noInteractItem = new ArrayList<UserInfoViewItem>(noInteract == null ? 0 : noInteract.size());
        UserCharViewItem userCharViewItem = new UserCharViewItem();
        userCharViewItem.setTxt(ResourceUtils.getString((int)R.string.title_have_friends, (Object[])new Object[]{friendList.size()}));
        recentlyItem.add(userCharViewItem);
        UserInfoViewItem info = new UserInfoViewItem(10L, ResourceUtils.getString((int)R.string.public_chat_name));
        recentlyItem.add(info);
        TreeMap map = new TreeMap();
        ArrayList unSort = new ArrayList();
        for (int i = 0; i < friendList.size(); ++i) {
            FriendInfo friendInfo = friendList.get(i);
            UserInfoViewItem item = new UserInfoViewItem(friendInfo);
            long uid = item.getUid();
            if (friendInfo.isNew() || recently.contains(uid)) {
                recentlyItem.add(item);
                continue;
            }
            noInteractItem.add(item);
        }
        if (recentlyItem.size() + noInteractItem.size() > 2) {
            TimeDivisionViewItem division = new TimeDivisionViewItem();
            recentlyItem.add(division);
        }
        recentlyItem.addAll(noInteractItem);
        return recentlyItem;
    }

    private void getImMsg(final FriendInfoList friendInfoList) {
        MyBox messageMyBox2 = ((IDBService)ServiceManagerProxy.getService(IDBService.class)).boxForCurUser(ImMessageDBBean.class);
        if (messageMyBox2 != null) {
            messageMyBox2.getAll((MyBox.IGetItemsCallBack)new MyBox.IGetItemsCallBack<ImMessageDBBean>(){

                public void onLoaded(final ArrayList<ImMessageDBBean> datas) {
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            FriendListViewModel.this.classify(friendInfoList, datas);
                        }
                    });
                }
            });
        }
    }

    private void classify(FriendInfoList friendInfoList, List<ImMessageDBBean> datas) {
        long cur = System.currentTimeMillis();
        ArrayList<Long> recently = new ArrayList<Long>();
        ArrayList<Long> noInteract = new ArrayList<Long>();
        if (FP.empty(datas)) {
            // empty if block
        }
        ArrayList<Long> uids = new ArrayList<Long>(friendInfoList.getUidList());
        uids.add(10L);
        long myUid = AccountUtil.getUid();
        block0: for (Long uid : uids) {
            String sessionId2 = Utils.getSessionId((long)myUid, (long)uid);
            boolean isSendByMe = false;
            boolean isSendByOther = false;
            for (ImMessageDBBean bean : datas) {
                if (!StringUtils.equal((String)sessionId2, (String)bean.getSessionId())) continue;
                if (!this.isLastHalfYear(cur, bean.getClientSendTime())) {
                    if (bean.isSendByMe()) {
                        isSendByMe = true;
                    } else {
                        isSendByOther = true;
                    }
                    if (!isSendByMe || !isSendByOther) continue;
                    recently.add(uid);
                    continue block0;
                }
                noInteract.add(uid);
                continue block0;
            }
        }
        this.sortData(friendInfoList, recently, noInteract);
    }

    private boolean isLastHalfYear(long current, long time) {
        return current - time > HALF_YEAR_MILL;
    }

    public ObservableList<FriendInfo> getmRawContacts() {
        this.loadFriends();
        return this.mRawContacts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRelationship(RelationshipReq req) {
        if (req.mCallback == null || req.mCallback.get() == null) {
            return;
        }
        List uids = req.uids;
        IRelationship mlistener = (IRelationship)req.mCallback.get();
        if (uids == null || uids.isEmpty()) {
            if (mlistener != null) {
                mlistener.onError(uids, 1);
            }
            return;
        }
        if (this.mLoadUidsSucc) {
            ArrayList<Integer> relations = new ArrayList<Integer>();
            for (Long uid : uids) {
                relations.add(this.mFriendsUids.contains((Object)uid) ? 1 : 0);
            }
            mlistener.onSucc(uids, relations);
        } else {
            List<RelationshipReq> list = this.mCacheCallback;
            synchronized (list) {
                this.mCacheCallback.add(new RelationshipReq(mlistener, uids));
            }
            this.loadFriends();
        }
    }

    @Override
    public void onWindowAttach() {
        super.onWindowAttach();
        this.requestFriendList(true);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.CHANNEL_CREATE_SUCCESS, (INotify)this);
        this.checkCreateRoomPermiss();
    }

    @Override
    public void onWindowDetach() {
        super.onWindowDetach();
        NotificationCenter.getGlobalInstance().unregister(NotificationIdDef.CHANNEL_CREATE_SUCCESS, (INotify)this);
    }

    @Override
    protected void resetWhenLogout() {
        super.resetWhenLogout();
        MLog.info((Object)TAG, (String)"resetWhenLogout", (Object[])new Object[0]);
        this.mFriendContact.setValue(new ArrayList());
        this.mRawContacts.clear();
        this.mFriendsUids.clear();
        this.mLoadUidsSucc = false;
        this.mLoadingUids = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unRegisterFriendCallback(FriendListObservable observable) {
        if (observable == null) {
            MLog.error((Object)TAG, (String)"unregisterFriendListObs obs null", (Object[])new Object[0]);
            return;
        }
        List<WeakReference<FriendListObservable>> list = this.mFriendListCallBack;
        synchronized (list) {
            ArrayList<WeakReference<FriendListObservable>> rm = new ArrayList<WeakReference<FriendListObservable>>();
            for (WeakReference<FriendListObservable> obsRef : this.mFriendListCallBack) {
                if (obsRef == null || obsRef.get() == null) {
                    rm.add(obsRef);
                    continue;
                }
                if (obsRef.get() != observable) continue;
                rm.add(obsRef);
                break;
            }
            if (!rm.isEmpty()) {
                this.mFriendListCallBack.removeAll(rm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFriendListObs() {
        List<WeakReference<FriendListObservable>> list = this.mFriendListCallBack;
        synchronized (list) {
            if (this.mFriendListCallBack.isEmpty()) {
                return;
            }
            Iterator<WeakReference<FriendListObservable>> iterator = this.mFriendListCallBack.iterator();
            while (iterator.hasNext()) {
                WeakReference<FriendListObservable> data2 = iterator.next();
                if (data2 == null || data2.get() == null) {
                    iterator.remove();
                    continue;
                }
                ((FriendListObservable)data2.get()).onFetchFriendList((List<Long>)this.mFriendsUids);
            }
        }
    }

    public static interface FriendListObservable {
        public void onFetchFriendList(List<Long> var1);
    }

    public static class RelationshipReq {
        private WeakReference<IRelationship> mCallback;
        private List<Long> uids;

        public RelationshipReq(IRelationship mCallback, List<Long> uids) {
            this.mCallback = new WeakReference<IRelationship>(mCallback);
            this.uids = uids;
        }
    }
}

