/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.widget.joinedchannel;

import android.content.Context;
import android.graphics.Rect;
import android.os.Message;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.JoinedChannelInfo;
import com.yy.im.R;
import com.yy.im.ui.SuggestFriendsRecyclerView;
import com.yy.im.ui.widget.joinedchannel.IJoinedChannelCallback;
import com.yy.im.ui.widget.joinedchannel.JoinedChannelAdapter;
import com.yy.im.ui.widget.joinedchannel.JoinedChannelManager;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;

public class JoinedChannelBanner
extends YYConstraintLayout
implements IJoinedChannelCallback {
    public static final String TAG = "JoinedChannelBanner";
    public static final int GROUP_COUNT = 4;
    private YYImageView mIvMore;
    private YYTextView mTvTitle;
    private SuggestFriendsRecyclerView mRvJoinedGroups;
    private JoinedChannelAdapter mAdapter;
    private JoinedChannelManager mManager;
    private boolean hasUpdated;
    private boolean pageShow = false;
    private boolean windowShow = true;
    private IChannelCenterService.IControlConfigOrJoinedChannelsListener mChannelListener = new IChannelCenterService.IControlConfigOrJoinedChannelsListener(){

        public void onMyJoinedChannelsListChange() {
            MLog.info((Object)JoinedChannelBanner.TAG, (String)"mChannelListener,onMyJoinedChannelsListChange", (Object[])new Object[0]);
            if (JoinedChannelBanner.this.mManager != null) {
                JoinedChannelBanner.this.mManager.getGroupData();
            }
        }

        public void onControlConfigChange() {
            MLog.info((Object)JoinedChannelBanner.TAG, (String)"mChannelListener,onControlConfigChange", (Object[])new Object[0]);
            if (JoinedChannelBanner.this.mManager != null) {
                JoinedChannelBanner.this.mManager.getBackground();
            }
        }
    };

    public JoinedChannelBanner(Context context) {
        this(context, null);
    }

    public JoinedChannelBanner(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public JoinedChannelBanner(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mManager = new JoinedChannelManager(4, this);
        this.createView();
    }

    private void createView() {
        this.setVisibility(8);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_joined_groups_banner, (ViewGroup)this);
        this.mIvMore = (YYImageView)this.findViewById(R.id.iv_more);
        this.mIvMore.setVisibility(8);
        this.mTvTitle = (YYTextView)this.findViewById(R.id.tv_title);
        this.mRvJoinedGroups = (SuggestFriendsRecyclerView)this.findViewById(R.id.rv_joined_groups);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this.getContext(), 0, LanguageUtils.isRtl());
        this.mAdapter = new JoinedChannelAdapter(4);
        this.mRvJoinedGroups.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.mRvJoinedGroups.addItemDecoration(new GroupItemDecoration());
        this.mRvJoinedGroups.setAdapter(this.mAdapter);
        this.mRvJoinedGroups.setDescendantFocusability(393216);
        this.mIvMore.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int msgId = RuntimeContext.useOldRoom() ? BaseMsgDef.OPEN_JOINED_GROUP : BaseMsgDef.OPEN_JOINED_CHANNEL;
                MsgDispatcher.getInstance().sendMessage(msgId);
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "im_group_card_more_click"));
            }
        });
        this.mAdapter.setOnItemClickListener(new JoinedChannelAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(JoinedChannelInfo info) {
                if (info == null) {
                    return;
                }
                EnterParam enterChannelParams = EnterParam.of((String)info.cid).entry(27).build();
                Message message = Message.obtain();
                message.what = AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL;
                message.obj = enterChannelParams;
                MsgDispatcher.getInstance().sendMessage(message);
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "im_group_card_click").put("room_id", info.cid));
            }
        });
        ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).addConfigOrMyJoinedChannelsListener(this.mChannelListener);
        this.mTvTitle.setText((CharSequence)ResourceUtils.getString((int)R.string.title_my_groups));
    }

    public void update() {
        MLog.info((Object)TAG, (String)"update, hasUpdated = %s", (Object[])new Object[]{this.hasUpdated});
        if (!this.hasUpdated) {
            this.mManager.getGroupData();
            this.mManager.getBackground();
            this.hasUpdated = true;
        }
    }

    @Override
    public void show() {
        this.setVisibility(0);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "im_group_card_show"));
    }

    @Override
    public void hide() {
        this.setVisibility(8);
    }

    @Override
    public void clear() {
        this.hasUpdated = false;
        this.hide();
    }

    @Override
    public void updateData(List<JoinedChannelInfo> list) {
        this.mIvMore.setVisibility(FP.size(list) > 4 ? 0 : 8);
        this.mAdapter.setData(list);
    }

    @Override
    public void updateBackground(List<String> colors) {
        this.mAdapter.setBackGround(colors);
    }

    @Override
    public void updateUserInfo(List<UserInfoKS> list) {
        this.mAdapter.setUserInfo(list);
    }

    public void onPageShow() {
        this.pageShow = true;
    }

    public void onPageHide() {
        this.pageShow = false;
    }

    public void onWindowShown() {
        this.windowShow = true;
        if (this.pageShow) {
            this.mManager.getGroupData();
        }
    }

    public void onWindowHiiden() {
        this.windowShow = false;
    }

    @Override
    public boolean isPageShow() {
        return this.pageShow;
    }

    public static class GroupItemDecoration
    extends RecyclerView.ItemDecoration {
        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state2) {
            super.getItemOffsets(outRect, view, parent, state2);
            int pos = parent.getChildAdapterPosition(view);
            outRect.left = pos == 0 ? ResolutionUtils.dip2Px((float)11.0f) : ResolutionUtils.dip2Px((float)8.0f);
            if (pos == parent.getAdapter().getItemCount() - 1) {
                outRect.right = ResolutionUtils.dip2Px((float)8.0f);
            }
        }
    }
}

