/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.widget;

import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.viewpager.widget.ViewPager;
import com.yy.base.utils.ScreenUtils;
import com.yy.im.R;

public class ScalePageTransformer
implements ViewPager.PageTransformer {
    public static final float MAX_SCALE = 1.0f;
    public static final float MIN_SCALE = 0.9f;
    public final int mMinHeight = ScreenUtils.getInstance().dip2px(160);
    public final int mMaxHeight = ScreenUtils.getInstance().dip2px(210);

    public void transformPage(View page2, float position) {
        if (position < -1.0f) {
            position = -1.0f;
        } else if (position > 1.0f) {
            position = 1.0f;
        }
        float tempScale = position < 0.0f ? 1.0f + position : 1.0f - position;
        float slope = 0.100000024f;
        float scaleValue = 0.9f + tempScale * slope;
        page2.setScaleX(scaleValue);
        page2.setScaleY(scaleValue);
        float lenSlop = this.mMaxHeight - this.mMinHeight;
        RelativeLayout cardLayout = (RelativeLayout)page2.findViewById(R.id.card_layout);
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)cardLayout.getLayoutParams();
        lp.height = (int)((float)this.mMinHeight + tempScale * lenSlop);
        cardLayout.setLayoutParams((ViewGroup.LayoutParams)lp);
        if (Build.VERSION.SDK_INT < 19) {
            page2.getParent().requestLayout();
        }
    }
}

