/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.widget;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.appbase.ui.widget.image.RoundConerImageView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.widget.GameLabelView;
import com.yy.im.R;
import com.yy.im.ui.widget.ClickAndScaleAutoFixButton;
import com.yy.im.ui.widget.ClickAndScaleButton;
import com.yy.im.ui.widget.GameCountdownView;
import java.util.Locale;

public class GameInviteCardLayout
extends YYRelativeLayout
implements GameCountdownView.ICountdownFinishListener,
View.OnClickListener {
    private static final int ONE_TEXT_SIZE = 16;
    private static final int TWO_TEXT_SIZE = 13;
    private static final int ONE_TITLE_BOTTOM = 20;
    private static final int TWO_TITLE_BOTTOM = 13;
    private ClickAndScaleButton mBtnCancel;
    private ClickAndScaleAutoFixButton mBtnDecline;
    private ClickAndScaleAutoFixButton mBtnJoin;
    private GameCountdownView mCountdownView;
    private YYTextView mGameTitle;
    private RecycleImageView mRivGameCover;
    private RoundConerImageView mGameCoverIv;
    private View mMaskLayout;
    private YYImageView mIvLight;
    private View mJoinLayout;
    private GameLabelView mGameLabel;
    private int mState = 1;
    private GameInfo mData;
    private IInviteOperateListener mOperateListener;
    private String mPkId;
    private String mGameModeName;
    private boolean mIsDownloading = false;
    private boolean mHadJoinGame = false;
    private Animation mLightAnim;
    private boolean cancelGameInviteByBack = false;

    public GameInviteCardLayout(Context context) {
        this(context, null);
    }

    public GameInviteCardLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GameInviteCardLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        GameInviteCardLayout.inflate((Context)context, (int)R.layout.im_game_invite_card_layout_a, (ViewGroup)this);
        this.mCountdownView = (GameCountdownView)this.findViewById(R.id.countdown_view);
        this.mBtnCancel = (ClickAndScaleButton)this.findViewById(R.id.btn_cancel);
        this.mBtnDecline = (ClickAndScaleAutoFixButton)this.findViewById(R.id.btn_decline);
        this.mBtnJoin = (ClickAndScaleAutoFixButton)this.findViewById(R.id.btn_join);
        this.mGameTitle = (YYTextView)this.findViewById(R.id.game_title_tv);
        this.mGameCoverIv = (RoundConerImageView)this.findViewById(R.id.rciv_game_cover);
        this.mRivGameCover = (RecycleImageView)this.findViewById(R.id.game_cover_iv);
        this.mMaskLayout = this.findViewById(R.id.mask_layout);
        this.mJoinLayout = this.findViewById(R.id.fl_join);
        this.mIvLight = (YYImageView)this.findViewById(R.id.iv_light);
        this.mGameLabel = (GameLabelView)this.findViewById(R.id.game_label);
        this.mCountdownView.setCountdownFinishListener(this);
        this.mBtnCancel.setOnClickListener(this);
        this.mBtnDecline.setOnClickListener(this);
        this.mBtnJoin.setOnClickListener(this);
        this.mCountdownView.setBackgroundColor(-872415232);
        this.mGameTitle.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.mBtnCancel.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.mBtnDecline.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.mBtnJoin.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.modifyJoinTextInRussian();
        this.changeJoinTextSize();
    }

    public void setOperateListener(IInviteOperateListener operateListener) {
        this.mOperateListener = operateListener;
    }

    public void setState(int state2) {
        this.mState = state2;
        this.mCountdownView.setState(state2);
        if (state2 == 2) {
            this.mBtnCancel.setVisibility(8);
            this.mBtnDecline.setVisibility(0);
            this.mBtnJoin.setVisibility(0);
            this.mJoinLayout.setVisibility(0);
            this.startLightAnim();
        } else if (state2 == 1) {
            this.mBtnCancel.setVisibility(0);
            this.mBtnDecline.setVisibility(8);
            this.mBtnJoin.setVisibility(8);
            this.mJoinLayout.setVisibility(8);
        }
    }

    public void setData(GameInfo data2, String pkId, String gameModeName) {
        this.mData = data2;
        this.mPkId = pkId;
        this.mGameModeName = gameModeName;
        ImageLoader.loadImage((ImageView)this.mGameCoverIv, (String)data2.getImIconUrl());
        if (!StringUtils.isEmpty((String)this.mGameModeName)) {
            this.mGameTitle.setText((CharSequence)(data2.getGname() + "-" + this.mGameModeName));
        } else {
            this.mGameTitle.setText((CharSequence)data2.getGname());
        }
        this.mGameLabel.setGameLabel(data2.getGameLabel());
    }

    public void startCountdown() {
        if (!this.mHadJoinGame) {
            this.mMaskLayout.setVisibility(0);
            this.mCountdownView.setVisibility(0);
            this.mCountdownView.startCountdown();
        }
    }

    public void setCoverHeight(int height) {
        if (this.mGameCoverIv != null && this.mMaskLayout != null) {
            RelativeLayout.LayoutParams layoutParams1 = (RelativeLayout.LayoutParams)this.mGameCoverIv.getLayoutParams();
            layoutParams1.height = height;
            this.mGameCoverIv.setLayoutParams((ViewGroup.LayoutParams)layoutParams1);
            RelativeLayout.LayoutParams layoutParams2 = (RelativeLayout.LayoutParams)this.mMaskLayout.getLayoutParams();
            layoutParams2.height = height;
            this.mMaskLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        }
    }

    public void setAnimValue(int value, boolean isExtend) {
        int sizeChangeValue = 3 * value / 400;
        int paddingChangeValue = 7 * value / 400;
        int titleSize = isExtend ? 13 + sizeChangeValue : 16 - sizeChangeValue;
        int titlePaddingBottom = isExtend ? 13 + paddingChangeValue : 20 - paddingChangeValue;
        this.mGameTitle.setTextSize((float)titleSize);
    }

    @Override
    public void countdownFinish() {
        if (this.mState == 1) {
            this.operateCallback(0, true);
        } else if (this.mState == 2) {
            this.operateCallback(1, true);
        }
    }

    public void onClick(View view) {
        if (view.getId() == R.id.btn_cancel) {
            MLog.info((Object)"GameInviteCardLayout", (String)"\u70b9\u51fbcancel", (Object[])new Object[0]);
            this.operateCallback(0, false);
            this.disableBtnAWhile(view);
        } else if (view.getId() == R.id.btn_decline) {
            this.operateCallback(1, false);
            this.disableBtnAWhile(view);
        } else if (view.getId() == R.id.btn_join) {
            if (this.mIsDownloading) {
                return;
            }
            if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
                return;
            }
            this.mBtnJoin.setText(R.string.im_game_launching);
            this.operateCallback(2, false);
            this.disableBtnAWhile(view);
        }
    }

    private void disableBtnAWhile(final View btn) {
        btn.setEnabled(false);
        btn.postDelayed(new Runnable(){

            @Override
            public void run() {
                btn.setEnabled(true);
            }
        }, 1000L);
    }

    private void operateCallback(int opr, boolean isTimeout) {
        this.mCountdownView.setVisibility(8);
        this.mMaskLayout.setVisibility(8);
        this.mCountdownView.destroy();
        if (this.mOperateListener != null) {
            this.mOperateListener.gameInviteOperate(opr, isTimeout, this.mData, this.mPkId, this, this.cancelGameInviteByBack);
            this.cancelGameInviteByBack = false;
        }
    }

    public void setOnlyOne(boolean onlyOne) {
        if (onlyOne) {
            this.mGameTitle.setTextSize(16.0f);
        } else {
            this.mGameTitle.setTextSize(13.0f);
        }
    }

    public GameInfo getData() {
        return this.mData;
    }

    public String getPkId() {
        return this.mPkId;
    }

    public int getState() {
        return this.mState;
    }

    public void popupCard() {
        this.mMaskLayout.setVisibility(8);
        this.mCountdownView.setVisibility(8);
        this.mCountdownView.destroy();
    }

    public void exitMessagePage() {
        if (this.mState != 2 && this.mState == 1 && this.mCountdownView.getVisibility() == 0) {
            this.cancelGameInviteByBack = true;
            this.mBtnCancel.performClick();
        }
        this.mCountdownView.destroy();
    }

    public void setDownloadState(boolean isDownloading) {
        this.mIsDownloading = isDownloading;
        this.mBtnJoin.setText(isDownloading ? R.string.im_download : R.string.join);
        this.modifyJoinTextInRussian();
        this.mBtnJoin.setDownloading(isDownloading);
        if (isDownloading) {
            this.stopLightAnim();
        } else {
            this.startLightAnim();
        }
    }

    public void setStartTime(long startTime) {
        this.mCountdownView.setStartTime(startTime);
    }

    public void setJoinGame() {
        this.mHadJoinGame = true;
        this.mCountdownView.setVisibility(8);
        this.mMaskLayout.setVisibility(8);
        this.mCountdownView.destroy();
    }

    private void startLightAnim() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GameInviteCardLayout.this.initLightAnim(GameInviteCardLayout.this.mBtnJoin.getMeasuredWidth() + GameInviteCardLayout.this.mIvLight.getMeasuredWidth());
                if (GameInviteCardLayout.this.mLightAnim != null) {
                    GameInviteCardLayout.this.mIvLight.startAnimation(GameInviteCardLayout.this.mLightAnim);
                }
            }
        });
    }

    private void stopLightAnim() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (GameInviteCardLayout.this.mLightAnim != null) {
                    GameInviteCardLayout.this.mLightAnim.cancel();
                }
            }
        });
    }

    private void initLightAnim(int width) {
        if (this.mLightAnim == null) {
            if (width <= 0) {
                return;
            }
            if (LanguageUtils.isRtl()) {
                width = -width;
            }
            this.mLightAnim = new TranslateAnimation(0.0f, (float)width, 0.0f, 0.0f);
            this.mLightAnim.setFillAfter(false);
            this.mLightAnim.setRepeatCount(-1);
            this.mLightAnim.setDuration(300L);
            this.mLightAnim.setStartOffset(1000L);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopLightAnim();
    }

    public void setJoinBtnStatus(boolean enable) {
        if (this.mBtnJoin != null) {
            this.mBtnJoin.setEnabled(enable);
        }
    }

    private void modifyJoinTextInRussian() {
        String joinStr = this.mBtnJoin.getText().toString();
        if (TextUtils.isEmpty((CharSequence)joinStr)) {
            return;
        }
        if (joinStr.equalsIgnoreCase(ResourceUtils.getString((int)R.string.join)) && "ru".equalsIgnoreCase(Locale.getDefault().getLanguage())) {
            this.mBtnJoin.setText(ResourceUtils.getString((int)R.string.accept));
        }
    }

    private void changeJoinTextSize() {
        if ("ru".equalsIgnoreCase(Locale.getDefault().getLanguage()) || "pt".equalsIgnoreCase(Locale.getDefault().getLanguage())) {
            this.mBtnJoin.setAutoFit(true);
            this.mBtnDecline.setAutoFit(true);
        } else {
            this.mBtnJoin.setAutoFit(false);
            this.mBtnDecline.setAutoFit(false);
        }
    }

    public static interface IInviteOperateListener {
        public void gameInviteOperate(int var1, boolean var2, GameInfo var3, String var4, GameInviteCardLayout var5, boolean var6);
    }
}

