/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.adapter;

import android.content.Context;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.FontUtils;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.im.R;
import java.util.ArrayList;
import java.util.List;

public class ShrinkGameAdapter
extends RecyclerView.Adapter<GameViewHolder>
implements View.OnClickListener {
    private ArrayList<GameInfo> mGameInfoList = new ArrayList();
    private OnItemClickListener mItemClickListener;
    private long lastTimeMillis;
    private static final long MIN_CLICK_INTERVAL = 1000L;

    public ShrinkGameAdapter(Context context) {
    }

    public void setDatas(List<GameInfo> list) {
        if (list != null) {
            this.mGameInfoList.clear();
            this.mGameInfoList.addAll(list);
            this.notifyDataSetChanged();
        }
    }

    public void setItemClickListener(OnItemClickListener itemClickListener) {
        this.mItemClickListener = itemClickListener;
    }

    public int getStartPageIndex(String gameId) {
        int index = 400;
        int remainder = index % (this.mGameInfoList.size() > 0 ? this.mGameInfoList.size() : 1);
        index -= remainder;
        for (int i = 0; i < this.mGameInfoList.size(); ++i) {
            if (TextUtils.isEmpty((CharSequence)this.mGameInfoList.get(i).getGid()) || !this.mGameInfoList.get(i).getGid().equals(gameId)) continue;
            index += i;
            break;
        }
        return index;
    }

    @NonNull
    public GameViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.im_shrink_game_item, parent, false);
        view.setOnClickListener((View.OnClickListener)this);
        return new GameViewHolder(view);
    }

    public void onBindViewHolder(@NonNull GameViewHolder holder, int position) {
        if (FP.empty(this.mGameInfoList)) {
            return;
        }
        int index = position % this.mGameInfoList.size();
        if (index < this.mGameInfoList.size()) {
            GameInfo gameInfo = this.mGameInfoList.get(index);
            if (gameInfo != null) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)"ShrinkGameAdapter", (String)"name : %s icon:%s", (Object[])new Object[]{gameInfo.getGname(), gameInfo.getImIconUrl()});
                }
                holder.itemView.setTag((Object)gameInfo);
                ImageLoader.loadImage((ImageView)holder.gameIcon, (String)gameInfo.getImIconUrl());
                holder.gameTitle.setText((CharSequence)gameInfo.getGname());
            } else if (RuntimeContext.sIsDebuggable) {
                MLog.info((Object)"ShrinkGameAdapter", (String)"name null icon null", (Object[])new Object[0]);
            }
        } else if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)"ShrinkGameAdapter", (String)"name null icon null", (Object[])new Object[0]);
        }
    }

    public int getItemCount() {
        return this.mGameInfoList == null || this.mGameInfoList.size() == 0 ? 0 : Math.max(this.mGameInfoList.size(), 1000);
    }

    public void onClick(View v) {
        if (this.isTimeEnabled() && this.mItemClickListener != null) {
            this.mItemClickListener.onItemClick((GameInfo)v.getTag());
        }
    }

    protected boolean isTimeEnabled() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.lastTimeMillis > 1000L) {
            this.lastTimeMillis = currentTimeMillis;
            return true;
        }
        return false;
    }

    public static interface OnItemClickListener {
        public void onItemClick(GameInfo var1);
    }

    class GameViewHolder
    extends RecyclerView.ViewHolder {
        private RecycleImageView gameIcon;
        private YYTextView gameTitle;

        GameViewHolder(View itemView) {
            super(itemView);
            this.gameIcon = (RecycleImageView)itemView.findViewById(R.id.image);
            this.gameTitle = (YYTextView)itemView.findViewById(R.id.game_title_tv);
            Typeface typeface = FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi);
            this.gameTitle.setTypeface(typeface);
        }
    }
}

