/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ObservableArrayList;
import androidx.databinding.ObservableBoolean;
import androidx.databinding.ObservableList;
import androidx.databinding.ViewDataBinding;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import com.yy.im.R;
import com.yy.im.interfaces.CusObservableListener;
import com.yy.im.ui.adapter.IViewType;
import java.util.List;
import java.util.Map;

public abstract class DataBindingListAdapter<Data extends IViewType>
extends BaseAdapter {
    private static final int INVALID_VIEW_TYPE = -1;
    public ObservableBoolean isEmpty = new ObservableBoolean(true);
    public final ObservableBoolean isRemovable = new ObservableBoolean(false);
    private ObservableList<Data> mDatas = new ObservableArrayList();
    private LiveData<List<Data>> mRawData;
    private ObservableList.OnListChangedCallback<ObservableList<Data>> mDataListener = new CusObservableListener<ObservableList<Data>>(){

        @Override
        public void onDataSetChange(ObservableList<Data> data2) {
            if (DataBindingListAdapter.this.isRemovable.get()) {
                return;
            }
            DataBindingListAdapter.this.mDatas = data2;
            DataBindingListAdapter.this.filterItems();
            DataBindingListAdapter.this.notifyDataSetChanged();
            DataBindingListAdapter.this.onDataChange();
        }
    };
    private Observer<List<Data>> mDataObs = new Observer<List<Data>>(){

        public void onChanged(@Nullable List<Data> data2) {
            if (DataBindingListAdapter.this.isRemovable.get()) {
                return;
            }
            DataBindingListAdapter.this.mDatas.clear();
            if (data2 != null) {
                DataBindingListAdapter.this.mDatas.addAll(data2);
            }
            DataBindingListAdapter.this.filterItems();
            DataBindingListAdapter.this.notifyDataSetChanged();
            DataBindingListAdapter.this.onDataChange();
        }
    };

    public DataBindingListAdapter(LiveData<List<Data>> data2) {
        this.mRawData = data2;
        this.registerObj();
    }

    public DataBindingListAdapter(ObservableList<Data> datas) {
        if (datas == null) {
            throw new RuntimeException("DataBindingListAdapter datas is null");
        }
        this.mDatas = datas;
        this.registerObj();
    }

    public void registerObj() {
        if (this.mDatas != null) {
            this.mDatas.addOnListChangedCallback(this.mDataListener);
        }
        if (this.mRawData != null) {
            this.mRawData.observeForever(this.mDataObs);
        }
    }

    public void onStart() {
        this.registerObj();
    }

    public void onDestroy() {
        if (this.mDatas != null) {
            this.mDatas.removeOnListChangedCallback(this.mDataListener);
        }
        if (this.mRawData != null) {
            this.mRawData.removeObserver(this.mDataObs);
        }
    }

    public void removeObserver() {
        if (this.mDatas != null) {
            this.mDatas.removeOnListChangedCallback(this.mDataListener);
        }
        if (this.mRawData != null) {
            this.mRawData.removeObserver(this.mDataObs);
        }
    }

    public final int getCount() {
        return this.mDatas == null ? 0 : this.mDatas.size();
    }

    public final Data getItem(int i) {
        if (this.mDatas.size() > i) {
            return (Data)((IViewType)this.mDatas.get(i));
        }
        return null;
    }

    public long getItemId(int i) {
        return i;
    }

    public int getItemViewType(int position) {
        Object data2 = this.getItem(position);
        if (data2 == null) {
            return -1;
        }
        return data2.getListViewType();
    }

    public int getViewTypeCount() {
        return this.getLayoutIds().size();
    }

    public final View getView(int i, View view, ViewGroup viewGroup) {
        ViewDataBinding binding;
        int viewType = this.getItemViewType(i);
        if (viewType == -1) {
            return null;
        }
        int layoutId = this.getLayoutIds().get(viewType);
        if (view == null) {
            binding = DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)viewGroup.getContext()), (int)layoutId, (ViewGroup)viewGroup, (boolean)false);
            binding.getRoot().setTag(R.id.im_databinding_view_type, (Object)layoutId);
            this.onFirstBindingUi(binding);
        } else {
            binding = DataBindingUtil.getBinding((View)view);
            Object tag = binding.getRoot().getTag(R.id.im_databinding_view_type);
            if (!(tag instanceof Integer) || !tag.equals(layoutId)) {
                binding = DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)viewGroup.getContext()), (int)layoutId, (ViewGroup)viewGroup, (boolean)false);
                binding.getRoot().setTag(R.id.im_databinding_view_type, (Object)layoutId);
                this.onFirstBindingUi(binding);
            }
        }
        this.initItemWithData(binding, this.getItem(i), i);
        return binding.getRoot();
    }

    protected void onFirstBindingUi(ViewDataBinding binding) {
    }

    public ObservableList<Data> getDatas() {
        return this.mDatas;
    }

    public abstract void initItemWithData(ViewDataBinding var1, Data var2, int var3);

    public abstract Map<Integer, Integer> getLayoutIds();

    public void onDataChange() {
    }

    public void filterItems() {
    }
}

