/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.im.ImPageSourceData;
import com.yy.appbase.kvo.FindFriend;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.im.base.SuggestFriendData;
import com.yy.hiyo.relation.base.data.Relation;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.hiyo.relation.base.follow.FollowerUtils;
import com.yy.hiyo.relation.base.follow.view.IFollowClickInterceptor;
import com.yy.hiyo.relation.base.follow.view.IFollowStatusListener;
import com.yy.hiyo.user.base.profilesource.ProfileReportBean;
import com.yy.im.R;
import com.yy.im.interfaces.OnInviteMoreFriendsClick;
import com.yy.im.ui.widget.AddFriendsFollowView;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;
import java.util.Locale;

public class AddFriendVerticalAdapter
extends RecyclerView.Adapter<AddFriendsViewHolder> {
    private static final int TYPE_HEAD_TITLE = 1;
    private static final int TYPE_SUGGEST_FRIEND_ITEM = 2;
    private static final int TYPE_FOOTER_INVITE_MORE = 3;
    private List<SuggestFriendData> mDatas;
    private OnInviteMoreFriendsClick mInviteMoreFriendsClick;

    public AddFriendVerticalAdapter(List<SuggestFriendData> data2, OnInviteMoreFriendsClick inviteMoreFriendsClick) {
        this.mDatas = data2;
        this.mInviteMoreFriendsClick = inviteMoreFriendsClick;
    }

    public int getItemCount() {
        if (this.mDatas == null || this.mDatas.isEmpty()) {
            return 0;
        }
        return this.mDatas.size() + 2;
    }

    public int getItemViewType(int position) {
        if (position == 0) {
            return 1;
        }
        if (position == this.mDatas.size() + 1) {
            return 3;
        }
        return 2;
    }

    @NonNull
    public AddFriendsViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View root2 = null;
        root2 = viewType == 1 ? LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.im_suggest_friend_title, parent, false) : (viewType == 3 ? LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.im_suggest_friend_footer, parent, false) : LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.im_add_friend_item, parent, false));
        return new AddFriendsViewHolder(root2);
    }

    public void onBindViewHolder(@NonNull AddFriendsViewHolder holder, int position) {
        int itemViewType = this.getItemViewType(position);
        if (itemViewType != 1) {
            if (itemViewType == 3) {
                holder.findViewById(R.id.tv_invite_friends).setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (AddFriendVerticalAdapter.this.mInviteMoreFriendsClick != null) {
                            AddFriendVerticalAdapter.this.mInviteMoreFriendsClick.onInviteMoreFriendsClick(v);
                        }
                    }
                });
            } else {
                this.handleFriendItem(holder, this.mDatas.get(position - 1));
            }
        }
    }

    private void handleFriendItem(final AddFriendsViewHolder holder, SuggestFriendData suggestFriendData) {
        String nick;
        FindFriend findFriend = suggestFriendData.mFriend;
        suggestFriendData.fromType = 5;
        ImageLoader.loadImage((ImageView)holder.ivAvatar, (String)(findFriend.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)findFriend.getSex()));
        holder.tvName.setText((CharSequence)findFriend.getNick());
        long type = findFriend.getType();
        if (type == 0L) {
            holder.ivFbTag.setImageResource(R.drawable.icon_facebook_little);
            nick = findFriend.getAlias();
            if (nick != null && nick.length() > 12) {
                nick = nick.substring(0, 12) + "...";
            }
            holder.tvContent.setText((CharSequence)ResourceUtils.getString((int)R.string.xx_on_fb, (Object[])new Object[]{nick}));
        } else if (type == 1L) {
            holder.ivFbTag.setImageResource(R.drawable.icon_contact_little);
            nick = findFriend.getAlias();
            holder.tvContent.setText((CharSequence)ResourceUtils.getString((int)R.string.xx_on_contact, (Object[])new Object[]{nick}));
        } else if (type == 9L) {
            holder.ivFbTag.setImageResource(R.drawable.icon_zalo_little);
            nick = findFriend.getAlias();
            holder.tvContent.setText((CharSequence)ResourceUtils.getString((int)R.string.xx_on_zalo, (Object[])new Object[]{nick}));
        } else if (type == 2L) {
            holder.ivFbTag.setImageResource(R.drawable.icon_nearby_little);
            holder.tvContent.setText((CharSequence)this.formalDistance(findFriend.getDist()));
        }
        holder.rlytContainer.setTag((Object)suggestFriendData.mFriend.getUid());
        holder.rlytContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                long uid = (Long)v.getTag();
                ImPageSourceData imPageBean = new ImPageSourceData(uid, 5);
                if (ServiceManagerProxy.getService(ImService.class) != null) {
                    ((ImService)ServiceManagerProxy.getService(ImService.class)).openImPage(imPageBean);
                }
            }
        });
        holder.ivAvatar.setTag((Object)suggestFriendData);
        holder.ivAvatar.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SuggestFriendData friend = (SuggestFriendData)v.getTag();
                if (friend != null && friend.mFriend != null) {
                    ProfileReportBean bean = new ProfileReportBean();
                    bean.setShowSource(Integer.valueOf(ProfileReportBean.ShowSource.getFriends()));
                    bean.setUid(Long.valueOf(friend.mFriend.getUid()));
                    bean.setExtObject((Object)friend);
                    bean.setSource(6);
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.OPEN_USER_NEW_PROFILE, (Object)bean));
                }
            }
        });
        holder.mFollowView.setTag(suggestFriendData);
        holder.mFollowView.setFollowStatusListener(new IFollowStatusListener(){

            public void updateFollowStatus(RelationInfo followStatus, @Nullable Relation oldStatus) {
                holder.mFollowView.setEnabled(!followStatus.isFollow());
            }
        });
        final String enterType = String.valueOf(18);
        holder.mFollowView.bindFollowStatus(suggestFriendData.mFriend.getUid(), FollowerUtils.INSTANCE.enterType2ePath(enterType));
        holder.mFollowView.setClickInterceptor(new IFollowClickInterceptor(){

            public boolean interceptor(RelationInfo followStatus) {
                if (!followStatus.isFollow()) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "follow_click").put("follow_enter_type", enterType));
                } else {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "no_follow_click").put("follow_enter_type", enterType));
                }
                return false;
            }
        });
    }

    private String formalDistance(float distance) {
        if (distance >= 1.0f) {
            return String.format(Locale.getDefault(), "%.2f km", Float.valueOf(distance));
        }
        if ((double)distance < 0.01) {
            return "<10m";
        }
        return String.format(Locale.getDefault(), "%d m", (int)(distance *= 1000.0f));
    }

    class AddFriendsViewHolder
    extends RecyclerView.ViewHolder {
        private View view;
        public YYRelativeLayout rlytContainer;
        public CircleImageView ivAvatar;
        public YYImageView ivFbTag;
        public YYTextView tvName;
        public YYTextView tvContent;
        public AddFriendsFollowView mFollowView;

        AddFriendsViewHolder(View itemView) {
            super(itemView);
            this.view = itemView;
            this.rlytContainer = (YYRelativeLayout)this.findViewById(R.id.rlyt_container);
            this.ivAvatar = (CircleImageView)this.findViewById(R.id.iv_avatar);
            this.ivFbTag = (YYImageView)this.findViewById(R.id.iv_fb_tag);
            this.tvName = (YYTextView)this.findViewById(R.id.tv_name);
            this.tvContent = (YYTextView)this.findViewById(R.id.tv_content);
            this.mFollowView = (AddFriendsFollowView)((Object)this.findViewById(R.id.follow_view));
        }

        private <T extends View> T findViewById(int id2) {
            View viewById = this.view.findViewById(id2);
            return (T)viewById;
        }
    }
}

