/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.session.presenter;

import android.view.View;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.game.base.GameModel;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import com.yy.hiyo.game.service.protocol.IMatchGameLifecycle;
import com.yy.hiyo.im.Utils;
import com.yy.im.ImModuleData;
import com.yy.im.R;
import com.yy.im.model.ChatSession;
import com.yy.im.model.SingleChatSession;
import com.yy.im.model.StrangerEntranceSession;
import com.yy.im.model.StrangerMessage;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.report.ChatSessionEventReporter;
import com.yy.im.session.ISessionPresenter;
import com.yy.im.session.bean.SessionClzConfig;
import com.yy.im.session.bean.SessionConfig;
import com.yy.im.session.presenter.BaseSessionPresenter;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;

public class StrangerSessionPresenter
extends BaseSessionPresenter {
    private static final String TAG = "StrangerSessionPresenter";
    private SessionConfig mSessionConfig = new SessionConfig(1, 0);
    private SessionClzConfig mSessionClzConfig = new SessionClzConfig(4, StrangerMessage.class, StrangerEntranceSession.class);
    private IMatchGameLifecycle mMatchGameLifecycle = new IMatchGameLifecycle(){

        public void prepareGameMatch(GameInfo ginfo, @Nonnull GameMatchContext matchConfig) {
        }

        public void onGameMatchStart(GameInfo info, @Nonnull GameMatchContext matchConfig) {
        }

        public void onMatchFinish(GameInfo gameInfo, @Nonnull GameMatchContext matchContext, int matchType) {
            if (matchType == 0) {
                if (gameInfo.getGameMode() == 7) {
                    return;
                }
                StrangerSessionPresenter.this.handleGameEvent(matchContext.update2GameModel(gameInfo));
            }
        }
    };

    @Override
    public long getUserUid(@NotNull ChatSession temp) {
        if (temp instanceof SingleChatSession) {
            return ((SingleChatSession)temp).getTargetUid();
        }
        return 0L;
    }

    @Override
    public SessionClzConfig getSessionClzConfig() {
        return this.mSessionClzConfig;
    }

    @Override
    public void handleClickItem(ChatSession chatSession, View v, int position, int from) {
        super.handleClickItem(chatSession, v, position, from);
    }

    @Override
    protected void clearUnRead(ChatSession session) {
        this.mISessionCallback.ignoreUnRead(session.getSessionId());
    }

    @Override
    public void start(Environment environment, ISessionPresenter.ISessionCallback callback) {
        super.start(environment, callback);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_ENTER_STRANGER_SESSION, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_EXIT_STRANGER_SESSION, (INotify)this);
        ((IGameCenterService)ServiceManagerProxy.getServiceManager().getService(IGameCenterService.class)).registerGameMatchEvent(this.mMatchGameLifecycle);
    }

    @Override
    public void notify(Notification notification) {
        ChatSession session;
        if (notification.id == ImNotificationDef.IM_ENTER_STRANGER_SESSION) {
            KvoSource moduleData = KvoModuleManager.getModuleData(ImModule.class);
            if (moduleData instanceof ImModuleData) {
                ((ImModuleData)moduleData).mStrangerSessionUnread.setSuperUnread(false);
            }
        } else if (notification.id == ImNotificationDef.IM_EXIT_STRANGER_SESSION && (session = this.getTargetSession("-3")) instanceof StrangerEntranceSession) {
            KvoSource moduleData = KvoModuleManager.getModuleData(ImModule.class);
            if (moduleData instanceof ImModuleData) {
                session.setUnReadCounts(((ImModuleData)moduleData).mStrangerSessionUnread.getCount());
            }
            this.mISessionCallback.updateNormalSession(session);
        }
    }

    private void handleGameEvent(GameModel model2) {
        UserInfoKS userInfo = null;
        if (model2 == null || (userInfo = model2.getOtherInfo()) == null) {
            MLog.info((Object)TAG, (String)("handleGameEvent model\uff1a" + model2 + "info\uff1a " + userInfo), (Object[])new Object[0]);
            return;
        }
        long uid = userInfo.uid;
        ChatSession session = this.getTargetSession(Utils.getSessionId((long)AccountUtil.getUid(), (long)uid));
        if (session != null) {
            MLog.info((Object)TAG, (String)("recent match block, uid:" + uid + " in your chat session list"), (Object[])new Object[0]);
            if (session.isStrangerChat()) {
                session.update(this.generateMatchSuccessMsg(model2));
                this.mISessionCallback.updateStrangerSession(session);
            }
        } else {
            SingleChatSession newSession = new SingleChatSession(this.generateMatchSuccessMsg(model2));
            newSession.setSessionFrom("1");
            this.mISessionCallback.updateStrangerSession(newSession);
            newSession.bindData(this.mISessionCallback.getISingleChatDataChange());
        }
        ChatSessionEventReporter.INSTANCE.addReportMessageTimeArrived(session);
    }

    private ImMessageDBBean generateMatchSuccessMsg(GameModel model2) {
        ImMessageDBBean messageDBBean = new ImMessageDBBean();
        long uid = model2.getOtherInfo().uid;
        messageDBBean.setSessionId(Utils.getSessionId((long)AccountUtil.getUid(), (long)uid));
        messageDBBean.setUid(uid);
        messageDBBean.setToUserId(AccountUtil.getUid());
        messageDBBean.setSendByMe(false);
        long curTs = System.currentTimeMillis();
        messageDBBean.setSendTime(curTs);
        messageDBBean.setClientSendTime(curTs);
        messageDBBean.setContentType(0);
        GameInfo gameInfo = null;
        messageDBBean.setToUserName(model2.getOtherInfo().nick);
        IServiceManager mService = null;
        mService = ServiceManagerProxy.getServiceManager();
        if (mService != null && mService.getService(IGameInfoService.class) != null && (gameInfo = ((IGameInfoService)mService.getService(IGameInfoService.class)).getGameInfoByGid(model2.getGameInfo().getGid())) != null) {
            messageDBBean.setContent(StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.short_summary_just_play_game), (Object[])new Object[]{gameInfo.getGname()}));
        }
        messageDBBean.setExtObj((Object)true);
        return messageDBBean;
    }

    @Override
    public SessionConfig getSessionConfig() {
        return this.mSessionConfig;
    }
}

