/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.session.presenter;

import android.content.Context;
import android.view.View;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.data.UserOnlineDBBean;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.framework.core.ui.dialog.popmenu.ButtonItem;
import com.yy.im.ImEventReporter;
import com.yy.im.R;
import com.yy.im.model.ChannelEntranceSession;
import com.yy.im.model.ChannelNoticeEntranceSession;
import com.yy.im.model.ChatSession;
import com.yy.im.model.CommonMsgChatSession;
import com.yy.im.model.GamePublicChatSession;
import com.yy.im.model.GamePushChatSession;
import com.yy.im.model.OfficialAccountChatSession;
import com.yy.im.model.RechargeAccountChatSession;
import com.yy.im.model.SingleChatSession;
import com.yy.im.model.StrangerEntranceSession;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.report.ChatSessionEventReporter;
import com.yy.im.session.ISessionPresenter;
import com.yy.im.session.presenter.DeleteSessionListener;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public abstract class BaseSessionPresenter
implements ISessionPresenter,
INotify {
    protected DialogLinkManager mDialogLinkManager;
    protected ISessionPresenter.ISessionCallback mISessionCallback;
    protected Environment mEnvironment;

    public void notify(Notification notification) {
    }

    @Override
    public void start(Environment environment, ISessionPresenter.ISessionCallback callback) {
        this.mISessionCallback = callback;
        this.mDialogLinkManager = new DialogLinkManager(environment.getContext());
        this.mEnvironment = environment;
        ChatSession.installClazz(this.getSessionClzConfig());
    }

    @Override
    public ChatSession getTargetSession(String sessionId2) {
        if (this.mISessionCallback != null) {
            return this.mISessionCallback.getTargetSession(sessionId2);
        }
        return null;
    }

    @Override
    public int getUnread(ChatSession item) {
        if (item == null) {
            return 0;
        }
        return item.getUnReadCounts();
    }

    @Override
    public void updateUserOnline(ChatSession session, UserOnlineDBBean bean) {
    }

    @Override
    public boolean isStrangerChat(@NotNull ChatSession session) {
        return false;
    }

    @Override
    public void handleLongClickItem(ChatSession chatSession, View v, int position, int from) {
        this.showDialogBottom(chatSession);
    }

    public ButtonItem getCommonDeleteBtnItem(DeleteSessionListener listener) {
        return new ButtonItem(ResourceUtils.getString((int)R.string.button_delete), () -> {
            if (listener != null) {
                listener.onOk();
            }
        });
    }

    private void showDialogBottom(ChatSession session) {
        ArrayList<ButtonItem> buttonList = new ArrayList<ButtonItem>();
        ButtonItem deleteButton2 = this.getCommonDeleteBtnItem(() -> {
            this.clearUnRead(session);
            ((ImModule)KvoModuleManager.getModule(ImModule.class)).deleteSession(session.getSessionId());
        });
        ButtonItem ignoreButton2 = new ButtonItem(ResourceUtils.getString((int)R.string.tips_ignore), () -> this.clearUnRead(session));
        ButtonItem stickTopButton = new ButtonItem(ResourceUtils.getString((int)(session.isStickTop() ? R.string.btn_msg_cancel_stick_top : R.string.btn_msg_stick_top)), () -> {
            boolean stickTop = !session.isStickTop();
            session.setStickTop(stickTop);
            session.setPresentationTime(System.currentTimeMillis());
            session.setPresentWeight(stickTop ? 5 : 0);
            ((ImModule)KvoModuleManager.getModule(ImModule.class)).updateSession((Object)session);
            ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, session.isStickTop() ? "10" : "9");
        });
        if (session instanceof SingleChatSession || session instanceof ChannelEntranceSession) {
            buttonList.add(deleteButton2);
            if (session.getUnReadCounts() > 0) {
                buttonList.add(ignoreButton2);
            }
            if (session instanceof SingleChatSession) {
                buttonList.add(stickTopButton);
            }
        } else if (session instanceof RechargeAccountChatSession) {
            if (session.getUnReadCounts() > 0) {
                buttonList.add(ignoreButton2);
            }
            buttonList.add(stickTopButton);
        } else if (session.getUnReadCounts() > 0) {
            buttonList.add(ignoreButton2);
        } else {
            return;
        }
        if (this.mEnvironment != null) {
            this.mDialogLinkManager.updateContext((Context)this.mEnvironment.getActivity());
        }
        this.mDialogLinkManager.showCommonPopupDialog(buttonList, true, true);
    }

    protected void clearUnRead(ChatSession session) {
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_IGNORE_SINGLE_SESSION_UNREAD, (Object)session.getSessionId()));
    }

    @Override
    public void handleClickItem(ChatSession chatSession, View v, int position, int from) {
        if (chatSession != null && chatSession.getUnReadCounts() > 0) {
            String type = null;
            if (chatSession instanceof SingleChatSession && !chatSession.isStrangerChat()) {
                type = "1";
            } else if (chatSession instanceof StrangerEntranceSession) {
                type = "2";
            } else if (chatSession instanceof ChannelEntranceSession) {
                type = "3";
            } else if (chatSession instanceof ChannelNoticeEntranceSession) {
                type = "5";
            } else if (chatSession instanceof CommonMsgChatSession) {
                type = "6";
                ImMessageDBBean lastMessage = (ImMessageDBBean)((CommonMsgChatSession)chatSession).getLastMessage();
                if (lastMessage != null && StringUtils.safeParseBoolean((String)lastMessage.getReserve5())) {
                    type = "9";
                }
            } else if (chatSession instanceof GamePushChatSession) {
                type = "7";
                if (((ImMessageDBBean)((GamePushChatSession)chatSession).getLastMessage()).getFromType() == 2) {
                    type = "8";
                }
            } else {
                type = "99";
            }
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "message_pg_red_click").put("message_red_type", type));
        }
    }

    @Override
    public void reportManagePopShow(ChatSession chatSession) {
        if (chatSession instanceof GamePublicChatSession) {
            GamePublicChatSession gameChatSession = (GamePublicChatSession)chatSession;
            ImEventReporter.INSTANCE.reportManagePopShow(((ImMessageDBBean)gameChatSession.getLastMessage()).getReserve1());
        } else if (chatSession instanceof OfficialAccountChatSession) {
            OfficialAccountChatSession officialChatSession = (OfficialAccountChatSession)chatSession;
            ImEventReporter.INSTANCE.reportManagePopShow(((ImMessageDBBean)officialChatSession.getLastMessage()).getReserve5());
        } else {
            ImEventReporter.INSTANCE.reportManagePopShow("");
        }
    }
}

