/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.session;

import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.im.model.ChatSession;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u001a\u001a\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0003\u001a$\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u001a\u0010\t\u001a\u00020\u00032\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0006\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"TAG", "", "updateOfficialAccountSessionExposure", "", "session", "Lcom/yy/im/model/ChatSession;", "exposure", "presentationTime", "", "updateOfficialAccountSessionsExposure", "sessions", "", "im_debug"})
public final class OfficialAccountPositionStrategyKt {
    private static final String TAG = "OfficialAccountPosition";

    private static final boolean updateOfficialAccountSessionExposure(ChatSession<?> session, boolean exposure, long presentationTime) {
        MLog.debug((Object)TAG, (String)"updateOfficialAccountSessionExposure", (Object[])new Object[0]);
        int sessionType = session.getSessionType();
        if (!(sessionType == 3 || sessionType == 0 && ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).requestOfficialAccountAuthCache(session.getUid()))) {
            return false;
        }
        if (!exposure == session.isMsgNotExposed()) {
            return false;
        }
        if (!exposure && session.getPresentWeight() > 1) {
            return false;
        }
        if (exposure && session.getPresentWeight() != 1) {
            return false;
        }
        session.setMsgNotExposed(!exposure);
        session.setPresentationTime(presentationTime);
        session.setPresentWeight(exposure ? 0 : 1);
        return true;
    }

    public static final boolean updateOfficialAccountSessionExposure(@NotNull ChatSession<?> session, boolean exposure) {
        Intrinsics.checkParameterIsNotNull(session, (String)"session");
        return OfficialAccountPositionStrategyKt.updateOfficialAccountSessionExposure(session, exposure, System.currentTimeMillis());
    }

    public static final boolean updateOfficialAccountSessionsExposure(@NotNull List<?> sessions, boolean exposure) {
        Intrinsics.checkParameterIsNotNull(sessions, (String)"sessions");
        if (sessions.isEmpty()) {
            return false;
        }
        if (!(CollectionsKt.first(sessions) instanceof ChatSession)) {
            return false;
        }
        List<?> list = sessions;
        if (list == null) {
            return false;
        }
        List<?> sessionsFinal = list;
        int adjustTimeMillis = 0;
        boolean hasUpdate = false;
        for (ChatSession session : sessionsFinal) {
            hasUpdate = OfficialAccountPositionStrategyKt.updateOfficialAccountSessionExposure(session, exposure, System.currentTimeMillis() + (long)adjustTimeMillis) || hasUpdate;
            --adjustTimeMillis;
        }
        return hasUpdate;
    }
}

