/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.pushnotify;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.constant.WindowNameDef;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.oas.OfficialAccountsDb;
import com.yy.appbase.data.oas.OfficialAccountsMsgDb;
import com.yy.appbase.extlayer.IExtViewService;
import com.yy.appbase.extlayer.IHagoFloatView;
import com.yy.appbase.floatnotice.FloatNoticeInfo;
import com.yy.appbase.growth.GrowthMsgDef;
import com.yy.appbase.growth.IGameDownloadCallback;
import com.yy.appbase.im.GameMessageModel;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.notify.NotifyPushChannelToastInfo;
import com.yy.appbase.notify.NotifyPushToastInfo;
import com.yy.appbase.notify.OnPushLayoutAnimateListener;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnKSProfileListCallback;
import com.yy.appbase.service.home.IHomeService;
import com.yy.appbase.service.home.IMainPageState;
import com.yy.appbase.service.home.PageType;
import com.yy.appbase.useractionstat.UserEnterActionStat;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlagBaseKeys;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SpannableStringUtil;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemServiceUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.DeviceManager;
import com.yy.framework.core.ui.IHidePushToast;
import com.yy.hiyo.amongus.base.AmongUsUtil;
import com.yy.hiyo.amongus.base.IAmongUsService;
import com.yy.hiyo.amongus.base.ITeamUpRoomSimpleCallback;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.EntryInfo;
import com.yy.hiyo.channel.base.FirstEntType;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.IRoomService;
import com.yy.hiyo.channel.base.bean.ChannelToastMsg;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.hiido.ChannelBaseTrack;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.recommend.ChannelInviteMgr;
import com.yy.hiyo.coins.base.ICoinsService;
import com.yy.hiyo.game.base.BaseGameReqBean;
import com.yy.hiyo.game.base.IMGamePkAcceptNotifyBean;
import com.yy.hiyo.game.base.IMGamePkCancelNotifyBean;
import com.yy.hiyo.game.base.IMGamePkNotifyBean;
import com.yy.hiyo.game.base.IMGameResBean;
import com.yy.hiyo.game.base.IMPKAcceptReqBean;
import com.yy.hiyo.game.base.IMPKAcceptResBean;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.singlegame.indie.IndieGamePlayContext;
import com.yy.hiyo.game.base.teamgame.TeamInviteResCodeHelper;
import com.yy.hiyo.game.service.IGameAudioService;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameInviteService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.game.service.bean.Game2V2MatchContext;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.bean.GameTeamMatchContext;
import com.yy.hiyo.game.service.bean.pkgame.PkGamePlayContext;
import com.yy.hiyo.game.service.callback.IIMPKGameListener;
import com.yy.hiyo.game.service.callback.IIMTeamGameListener;
import com.yy.hiyo.game.service.callback.IIndepGameAcceptCallback;
import com.yy.hiyo.game.service.protocol.GameLifeWrapper;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.game.service.protocol.IMatchGameLifecycle;
import com.yy.hiyo.im.ImBaseMsgDef;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.im.Utils;
import com.yy.hiyo.main.base.ActivityTaskUtils;
import com.yy.hiyo.user.interest.IInterestLabelService;
import com.yy.im.R;
import com.yy.im.floatnotice.FloatNoticeView;
import com.yy.im.floatnotice.INoticeViewCallback;
import com.yy.im.interfaces.IRelationship;
import com.yy.im.model.JumpBBSDetailsData;
import com.yy.im.module.room.utils.IMTrack;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.pushnotify.BaseMessageToastView;
import com.yy.im.pushnotify.MessageToastView;
import com.yy.im.pushnotify.MessageToastViewFactory;
import com.yy.im.pushnotify.MsgJumpHelper;
import com.yy.im.session.bean.ImOasSessionBean;
import com.yy.im.viewmodel.FriendListViewModel;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import common.ERet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import net.ihago.money.api.comnotify.OutSideMsg;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

public class NotifyPushToastController
extends DefaultController
implements MessageToastView.OnPushClickListener,
OnPushLayoutAnimateListener {
    private static final String TAG = "NotifyPushToastController";
    private static final String PUSH_NOTIFY_SHOW = "notify_push_show";
    private static final String PUSH_NOTIFY_CLICK = "click";
    private static final String CHANNEL_ENTER_FROM = "channel_enter_from";
    private FloatToastData mCurrentFloatData;
    private LinkedList<FloatToastData> mTaskQueue = new LinkedList();
    private Boolean mUsePriority;
    private boolean mDisableShowToastView;
    private final Runnable mHideNotifyTask = new Runnable(){

        @Override
        public void run() {
            View view;
            if (NotifyPushToastController.this.mCurrentFloatData != null && (view = ((NotifyPushToastController)NotifyPushToastController.this).mCurrentFloatData.view) instanceof BaseMessageToastView) {
                ((BaseMessageToastView)view).onActivelyHide(true);
            }
        }
    };
    GameLifeWrapper mGameLifeWrapper = new GameLifeWrapper(){

        public void onPreloadGame(GamePlayContext context) {
            super.onPreloadGame(context);
            NotifyPushToastController.this.hideFloatToastView();
        }

        public void onGameExited(GamePlayContext context, int gameExitType) {
            super.onGameExited(context, gameExitType);
            NotifyPushToastController.this.hideFloatToastView();
        }
    };
    IMatchGameLifecycle iMatchGameLifecycle = new IMatchGameLifecycle(){

        public void prepareGameMatch(GameInfo ginfo, GameMatchContext matchConfig) {
        }

        public void onGameMatchStart(GameInfo info, GameMatchContext matchConfig) {
            NotifyPushToastController.this.hideFloatToastView();
        }

        public void onMatchFinish(GameInfo gameInfo, GameMatchContext matchContext, int matchType) {
        }
    };

    public NotifyPushToastController(Environment env) {
        super(env);
        this.registerMessage(BaseMsgDef.NOTIFY_CANCEL_PK);
        this.registerMessage(BaseMsgDef.MSG_HIDE_NOTIFY_TOAST);
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).registerGameLifecycle((IGameLifecycle)this.mGameLifeWrapper);
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).registerGameMatchEvent(this.iMatchGameLifecycle);
    }

    private boolean userToastPriority() {
        if (this.mUsePriority == null) {
            this.mUsePriority = SettingFlagBaseKeys.isNotifyToastPriorityEnable();
        }
        MLog.debug((Object)TAG, (String)("userToastPriority: " + this.mUsePriority), (Object[])new Object[0]);
        return this.mUsePriority;
    }

    public void handleMessage(final Message msg) {
        super.handleMessage(msg);
        if (msg.what == BaseMsgDef.NOTIFY_RECEIVE_PK) {
            GameMessageModel gameMessageModel = (GameMessageModel)msg.obj;
            if (gameMessageModel == null) {
                return;
            }
            MLog.info((Object)TAG, (String)"NOTIFY_RECEIVE_PK gameId=%s", (Object[])new Object[]{gameMessageModel.getGameId()});
            IUserInfoService userInfoService = (IUserInfoService)this.getServiceManager().getService(IUserInfoService.class);
            if (userInfoService == null) {
                return;
            }
            UserInfoKS userInfoBean = userInfoService.getUserInfo(gameMessageModel.getToUserId());
            if (userInfoBean != null && userInfoBean.ver > 0L) {
                FloatToastData toastData = new FloatToastData();
                toastData.gameMessageModel = gameMessageModel;
                toastData.notifyType = 0;
                if (SystemUtils.isAI((long)gameMessageModel.getFromUserId())) {
                    toastData.priority = 1;
                }
                toastData.pushSource = "2";
                this.showFloatToastView(toastData);
            }
        } else if (msg.what == BaseMsgDef.NOTIFY_CANCEL_PK) {
            GameMessageModel gameMessageModel;
            String pkId = (String)msg.obj;
            if (TextUtils.isEmpty((CharSequence)pkId)) {
                return;
            }
            if (this.mCurrentFloatData != null && (gameMessageModel = this.mCurrentFloatData.gameMessageModel) != null && gameMessageModel.getPkId().equals(pkId)) {
                this.hideFloatToastView();
            }
        } else if (msg.what == BaseMsgDef.MSG_HIDE_NOTIFY_TOAST) {
            GameMessageModel gameMessageModel;
            if (this.mCurrentFloatData != null && (gameMessageModel = this.mCurrentFloatData.gameMessageModel) != null) {
                this.hideFloatToastView();
            }
        } else if (msg.what == ImBaseMsgDef.OPEN_MATCH_SUCCESS_TOAST) {
            long weMeetToUid = (Long)msg.obj;
            FloatToastData toastData = new FloatToastData();
            toastData.targetUid = weMeetToUid;
            toastData.notifyType = 2;
            this.showFloatToastView(toastData);
        } else if (msg.what == ImBaseMsgDef.QUIZ_REGISTER_SUCCESS_TOAST) {
            Bundle bundle = (Bundle)msg.obj;
            FloatToastData toastData = new FloatToastData();
            toastData.targetUid = bundle.getLong("uid");
            toastData.extMap = new HashMap<String, Object>();
            toastData.extMap.put("quiz_content", bundle.getString("text", ""));
            toastData.pushSource = bundle.getString("push_source", "");
            toastData.notifyType = 5;
            this.showFloatToastView(toastData);
        } else if (msg.what == BaseMsgDef.VOICE_ROOM_INVITE_TOAST) {
            Bundle bundle = (Bundle)msg.obj;
            String pushSource = bundle.getString("push_source", "");
            FloatToastData toastData = new FloatToastData();
            toastData.targetUid = bundle.getLong("fromUid");
            toastData.priority = 1;
            toastData.extMap = new HashMap<String, Object>();
            toastData.extMap.put("roomId", bundle.getString("roomId", ""));
            toastData.extMap.put("roomToken", bundle.getString("roomPwdToken", ""));
            toastData.extMap.put("source", bundle.getString("source", ""));
            toastData.extMap.put("inviteUrl", bundle.getString("inviteUrl", ""));
            toastData.extMap.put("fromUid", toastData.targetUid);
            toastData.extMap.put("roomSource", bundle.getString("room_source", ""));
            toastData.extMap.put("push_source", pushSource);
            toastData.notifyType = 6;
            toastData.pushSource = pushSource;
            this.showFloatToastView(toastData);
        } else if (msg.what == BaseMsgDef.CHANNEL_INVITE_TOAST) {
            Bundle bundle = (Bundle)msg.obj;
            String pushSource = bundle.getString("push_source", "");
            FloatToastData toastData = new FloatToastData();
            toastData.targetUid = bundle.getLong("fromUid");
            toastData.extMap = new HashMap<String, Object>();
            toastData.extMap.put("roomId", bundle.getString("roomId", ""));
            toastData.extMap.put("roomToken", bundle.getString("roomPwdToken", ""));
            toastData.extMap.put("source", bundle.getString("source", ""));
            toastData.extMap.put("push_source", pushSource);
            String text = bundle.getString("content", "");
            toastData.extMap.put("content", TextUtils.isEmpty((CharSequence)text) ? ResourceUtils.getString((int)R.string.tips_channel_invite_toast) : text);
            toastData.notifyType = 9;
            toastData.pushSource = pushSource;
            this.showFloatToastView(toastData);
        } else if (msg.what == BaseMsgDef.SHOW_CHANNEL_TOAST_MSG) {
            if (msg.obj instanceof ChannelToastMsg) {
                FloatToastData toastData = new FloatToastData();
                toastData.extMap = new HashMap<String, Object>();
                toastData.notifyType = 10;
                toastData.extMap.put("channel_toast_msg", msg.obj);
                toastData.extMap.put("channel_toast_from", msg.arg1);
                HashMap extra = ((ChannelToastMsg)msg.obj).getExtra();
                if (extra != null) {
                    for (Map.Entry entry : extra.entrySet()) {
                        toastData.extMap.put((String)entry.getKey(), entry.getValue());
                    }
                }
                this.showFloatToastView(toastData);
            }
        } else if (msg.what == BaseMsgDef.SHOW_DEEPLINK_GAME_TOAST) {
            MLog.info((Object)TAG, (String)"SHOW_DEEPLINK_GAME_TOAST obj:%s", (Object[])new Object[]{msg.obj});
            if (msg.obj instanceof String) {
                FloatToastData toastData = new FloatToastData();
                toastData.deeplinkGameId = (String)msg.obj;
                toastData.notifyType = 11;
                this.showFloatToastView(toastData);
            }
        } else if (msg.what == BaseMsgDef.OFFICIAL_GAME_TO_CHANNEL) {
            if (msg.obj instanceof NotifyPushChannelToastInfo) {
                FloatToastData toastData = new FloatToastData();
                toastData.info = (NotifyPushChannelToastInfo)msg.obj;
                this.showFloatToastView(toastData);
            }
        } else if (msg.what == BaseMsgDef.MSG_BBS_TYPE) {
            FloatToastData toastData = new FloatToastData();
            toastData.notifyType = 13;
            toastData.extMap = new HashMap<String, Object>();
            Bundle bundle = (Bundle)msg.obj;
            toastData.extMap.put("title", bundle.getString("title", ""));
            toastData.extMap.put("avatar", bundle.getString("avatar", ""));
            toastData.extMap.put("content", bundle.getString("content", ""));
            toastData.extMap.put("uid", bundle.getLong("uid", 0L));
            toastData.extMap.put("sex", bundle.getInt("sex", 1));
            toastData.extMap.put("jump_bbs_detail", new JumpBBSDetailsData(bundle.getInt("bbsType"), bundle.getString("ppostid"), bundle.getString("postid"), bundle.getInt("posttype"), true, bundle.getInt("jumpType"), bundle.getInt("ppostsource"), bundle.getString("channelid"), bundle.getInt("notice_type", 0) == 1, bundle.getInt("ptype", 0)));
            toastData.pushSource = bundle.getString("push_source", "");
            this.showFloatToastView(toastData);
        } else if (msg.what == BaseMsgDef.MSG_DISABLE_SHOW_NOTIFY_TOAST) {
            this.mDisableShowToastView = msg.arg1 <= 0;
            YYTaskExecutor.postToMainThread(() -> {
                this.mDisableShowToastView = false;
            }, (long)20000L);
        } else if (msg.what == BaseMsgDef.MSG_SHOW_NOTIFY_TOAST) {
            Bundle bundle = msg.getData();
            if (bundle != null) {
                FloatToastData toastData = new FloatToastData();
                toastData.info = (NotifyPushToastInfo)bundle.get("base_toast_info_type");
                toastData.priority = bundle.getInt("base_toast_priority", 0);
                toastData.pushSource = bundle.getString("push_source", "");
                this.showFloatToastView(toastData);
            }
        } else if (msg.what == ImBaseMsgDef.MSG_SHOW_FLOAT_NOTICE) {
            if (msg.obj instanceof FloatNoticeInfo) {
                FloatToastData toastData = new FloatToastData();
                toastData.info = (FloatNoticeInfo)msg.obj;
                toastData.priority = msg.arg1;
                this.showFloatToastView(toastData);
            }
        } else if (msg.what == ImBaseMsgDef.MSG_HIDE_FLOAT_NOTICE) {
            if (msg.obj instanceof String) {
                String noticeId = (String)msg.obj;
                this.handleCancelFloatNotice(noticeId);
            }
        } else if (msg.what == ImBaseMsgDef.MSG_UPDATE_FLOAT_NOTICE) {
            if (msg.obj instanceof FloatNoticeInfo) {
                this.updateFloatNotice((FloatNoticeInfo)msg.obj);
            }
        } else if (msg.what == ImBaseMsgDef.MSG_HAGO_CERTIFICATION) {
            FloatToastData toastData = new FloatToastData();
            toastData.notifyType = 14;
            toastData.extMap = new HashMap<String, Object>();
            Bundle bundle = (Bundle)msg.obj;
            toastData.extMap.put("title", bundle.getString("title", ""));
            toastData.extMap.put("avatar", bundle.getString("avatar", ""));
            toastData.extMap.put("content", bundle.getString("content", ""));
            toastData.extMap.put("url", bundle.getString("url", ""));
            toastData.pushSource = bundle.getString("push_source", "");
            this.showFloatToastView(toastData);
        } else if (msg.what == ImBaseMsgDef.MSG_PLAT_FRIEND) {
            FloatToastData toastData = new FloatToastData();
            toastData.notifyType = 15;
            toastData.extMap = new HashMap<String, Object>();
            Bundle bundle = (Bundle)msg.obj;
            toastData.extMap.put("title", bundle.getString("title", ""));
            toastData.extMap.put("avatar", bundle.getString("avatar", ""));
            toastData.extMap.put("content", bundle.getString("content", ""));
            toastData.extMap.put("url", bundle.getString("url", ""));
            toastData.pushSource = bundle.getString("push_source");
            this.showFloatToastView(toastData);
        } else if (msg.what == ImBaseMsgDef.MSG_SHOW_GAME_OFFICIAL_TOAST_NOTIFY) {
            final FloatToastData toastData = new FloatToastData();
            toastData.notifyType = 16;
            toastData.extMap = new HashMap<String, Object>();
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (msg.obj instanceof ImOasSessionBean) {
                        ImOasSessionBean bean = (ImOasSessionBean)msg.obj;
                        OfficialAccountsDb db = bean.getOasDb();
                        OfficialAccountsMsgDb msg2 = (OfficialAccountsMsgDb)db.getMsgs().get(0);
                        try {
                            JSONObject payload = JsonParser.obtainJSONObject((String)msg2.getPayload());
                            toastData.extMap.put("uid", bean.getFromUid());
                            toastData.extMap.put("title", payload.optString("title"));
                            toastData.extMap.put("avatar", db.getAvatar());
                            toastData.extMap.put("content", msg2.getText());
                            toastData.extMap.put("url", msg2.getJumpUrl());
                            toastData.extMap.put("data", bean);
                            toastData.pushSource = bean.getPushSource();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                NotifyPushToastController.this.showFloatToastView(toastData);
                            }
                        });
                    }
                }
            });
        } else if (msg.what == BaseMsgDef.SHOW_INTEREST_LABEL_NOTIFY_TOAST) {
            FloatToastData toastData = new FloatToastData();
            toastData.notifyType = 17;
            this.showFloatToastView(toastData);
        } else if (BaseMsgDef.MSG_SHOW_FOLLOW_MOST_ACTIVE_ROOM == msg.what) {
            this.showFollowMostActiveRoomNotify(msg);
        } else if (msg.what == BaseMsgDef.SHOW_MESSAGE_TOAST) {
            FloatToastData toastData = new FloatToastData();
            toastData.info = msg.obj;
            this.handlePriority(toastData, msg.obj);
            this.showFloatToastView(toastData);
        }
    }

    private void handlePriority(FloatToastData toastData, Object obj) {
        if (obj instanceof NotifyPushToastInfo) {
            toastData.priority = ((NotifyPushToastInfo)obj).getPriority();
        }
    }

    @Override
    public void statClick() {
        if (this.mCurrentFloatData != null) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025571").put("function_id", "push_click").put("push_source", this.mCurrentFloatData.pushSource).put("push_position", "3"));
        }
    }

    private void reportShow() {
        if (this.mCurrentFloatData != null) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025571").put("function_id", "show").put("push_source", this.mCurrentFloatData.pushSource).put("push_position", "3"));
        }
    }

    private void handleShowFloatToast(@NonNull FloatToastData toastData) {
        this.mCurrentFloatData = toastData;
        Object info = toastData.info;
        boolean success = false;
        if (this.mDisableShowToastView) {
            MLog.info((Object)TAG, (String)"disable show toastView", (Object[])new Object[0]);
            success = false;
        } else if (info instanceof NotifyPushChannelToastInfo) {
            NotifyPushChannelToastInfo notifyPushChannelToastInfo = (NotifyPushChannelToastInfo)info;
            success = this.handleShowFloatToast(toastData.uuid, notifyPushChannelToastInfo, toastData.duration);
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20035809").put("function_id", "guide_goto_channel_show").put("remind_type", Integer.toString(2)).put("gid", notifyPushChannelToastInfo.getGameId()));
        } else if (info instanceof NotifyPushToastInfo) {
            int duration = ((NotifyPushToastInfo)info).getDuration();
            success = this.handleShowFloatToast(toastData.uuid, (NotifyPushToastInfo)info, duration != 0 ? (long)duration : toastData.duration);
        } else {
            success = info instanceof FloatNoticeInfo ? this.handleShowFloatToast(toastData.uuid, (FloatNoticeInfo)info) : (info instanceof OutSideMsg ? this.handleShowFloatToast(toastData.uuid, (OutSideMsg)info) : this.handleShowFloatToast(toastData.uuid, toastData.notifyType, toastData.duration));
        }
        if (!success) {
            this.mCurrentFloatData = null;
            YYTaskExecutor.postToMainThread(() -> this.showFloatToastView(this.mTaskQueue.poll()));
        } else {
            this.reportShow();
        }
    }

    private boolean handleShowFloatToast(String uuid, @NonNull OutSideMsg info) {
        AbstractWindow window = this.getCurrentWindow();
        String currentName = "";
        if (window == null) {
            MLog.error((Object)TAG, (String)"getCurrentWindow null", (Object[])new Object[0]);
        } else {
            currentName = window.getName();
        }
        if (this.mCurrentFloatData == null || !StringUtils.equal((String)uuid, (String)this.mCurrentFloatData.uuid) || info.shield_windows.contains(currentName)) {
            MLog.debug((Object)TAG, (String)"handleShowFloatToast ignore, currentFloatData is null or uuid not equal", (Object[])new Object[0]);
            return false;
        }
        final View messageToastView = MessageToastViewFactory.INSTANCE.getMessageToastView(this.mContext, info, this, this);
        if (messageToastView == null) {
            return false;
        }
        this.mCurrentFloatData.view = messageToastView;
        IHagoFloatView iHagoFloatView = new IHagoFloatView(){

            public void onReAttachWindow() {
                if (RuntimeContext.isHagoPartySdk() && messageToastView.getContext() instanceof Activity) {
                    DeviceManager.fullScreenOffsetView((Activity)((Activity)messageToastView.getContext()), (View)messageToastView);
                }
            }

            public View getFloatView() {
                return messageToastView;
            }

            public void hideView() {
                NotifyPushToastController.this.hideFloatToastView();
            }
        };
        ((IExtViewService)this.getServiceManager().getService(IExtViewService.class)).addNoticeContentView(iHagoFloatView);
        DeviceManager.fullScreenOffsetView((Activity)this.getEnvironment().getActivity(), (View)messageToastView);
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mHideNotifyTask);
        YYTaskExecutor.postToMainThread((Runnable)this.mHideNotifyTask, (long)5000L);
        return true;
    }

    private boolean handleShowFloatToast(String uuid, @NonNull NotifyPushChannelToastInfo info, long duration) {
        if (this.mCurrentFloatData == null || !StringUtils.equal((String)uuid, (String)this.mCurrentFloatData.uuid)) {
            MLog.debug((Object)TAG, (String)"handleShowFloatToast ignore, currentFloatData is null or uuid not equal", (Object[])new Object[0]);
            return false;
        }
        final MessageToastView messageToastView = new MessageToastView(RuntimeContext.sApplicationContext, this, this.mCurrentFloatData.gameMessageModel);
        this.mCurrentFloatData.view = messageToastView;
        messageToastView.setType(12, new SpannableStringBuilder((CharSequence)info.getContent()), info.getTitle(), "", 0);
        messageToastView.setOnNotifyPushClickListener(this);
        ((IExtViewService)this.getServiceManager().getService(IExtViewService.class)).addNoticeContentView(new IHagoFloatView(){

            public void onReAttachWindow() {
                if (RuntimeContext.isHagoPartySdk() && messageToastView.getContext() instanceof Activity) {
                    DeviceManager.fullScreenOffsetView((Activity)((Activity)messageToastView.getContext()), (View)messageToastView);
                }
            }

            public View getFloatView() {
                return messageToastView;
            }

            public void hideView() {
                NotifyPushToastController.this.hideFloatToastView();
            }
        });
        DeviceManager.fullScreenOffsetView((Activity)this.getEnvironment().getActivity(), (View)messageToastView);
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mHideNotifyTask);
        YYTaskExecutor.postToMainThread((Runnable)this.mHideNotifyTask, (long)duration);
        return true;
    }

    private boolean handleShowFloatToast(String uuid, FloatNoticeInfo info) {
        if (this.mCurrentFloatData == null || !StringUtils.equal((String)uuid, (String)this.mCurrentFloatData.uuid)) {
            MLog.debug((Object)TAG, (String)"handleShowFloatToast ignore, currentFloatData is null", (Object[])new Object[0]);
            return false;
        }
        if (this.checkCurWindowInList(info.getBlackWindowList(), false)) {
            MLog.info((Object)TAG, (String)"showFloatNotice in black window", (Object[])new Object[0]);
            return false;
        }
        if (!this.checkCurWindowInList(info.getWhiteWindowList(), true)) {
            MLog.info((Object)TAG, (String)"showFloatNotice no in white window", (Object[])new Object[0]);
            return false;
        }
        FragmentActivity context = this.getEnvironment().getActivity();
        if (context == null || !ActivityTaskUtils.INSTANCE.getCurActivity().equals(context)) {
            context = RuntimeContext.sApplicationContext;
        }
        final FloatNoticeView floatNoticeView = new FloatNoticeView((Context)context);
        this.mCurrentFloatData.view = floatNoticeView;
        floatNoticeView.setCallback(new INoticeViewCallback(){

            @Override
            public void onDismiss(@NotNull View view) {
                NotifyPushToastController.this.hideFloatToastView();
            }
        });
        ((IExtViewService)this.getServiceManager().getService(IExtViewService.class)).addNoticeContentView(new IHagoFloatView(){

            public void onReAttachWindow() {
            }

            public View getFloatView() {
                return floatNoticeView;
            }

            public void hideView() {
                NotifyPushToastController.this.hideFloatToastView();
            }
        });
        floatNoticeView.setNotice(info);
        return true;
    }

    private void updateFloatNotice(FloatNoticeInfo info) {
        if (this.mCurrentFloatData == null) {
            MLog.debug((Object)TAG, (String)"updateFloatNotice ignore, currentFloatData is null", (Object[])new Object[0]);
            return;
        }
        View view = this.mCurrentFloatData.view;
        if (view instanceof FloatNoticeView) {
            if (this.checkCurWindowInList(info.getBlackWindowList(), false)) {
                MLog.info((Object)TAG, (String)"updateFloatNotice in black window", (Object[])new Object[0]);
                return;
            }
            if (!this.checkCurWindowInList(info.getWhiteWindowList(), true)) {
                MLog.info((Object)TAG, (String)"updateFloatNotice no in white window", (Object[])new Object[0]);
                return;
            }
            FloatNoticeView noticeView = (FloatNoticeView)view;
            noticeView.update(info);
        }
    }

    @NonNull
    private FloatToastData checkTaskQueue(@NonNull FloatToastData wantData) {
        FloatToastData result = this.mTaskQueue.poll();
        if (result == null) {
            return wantData;
        }
        if (result.priority <= wantData.priority) {
            return this.checkTaskQueue(wantData);
        }
        this.mTaskQueue.offer(wantData);
        return result;
    }

    private boolean checkCurWindowInList(List<String> winList, boolean defaultValue) {
        if (FP.empty(winList)) {
            return defaultValue;
        }
        AbstractWindow window = this.getCurrentWindow();
        String currentName = "";
        if (window == null) {
            MLog.error((Object)TAG, (String)"getCurrentWindow null", (Object[])new Object[0]);
        } else {
            currentName = window.getName();
        }
        String withTabName = WindowNameDef.getNewNameIfHomeTab((String)currentName);
        return winList.contains(currentName) || winList.contains(withTabName);
    }

    private boolean handleShowFloatToast(String uuid, @NonNull NotifyPushToastInfo info, long duration) {
        IHomeService homeService;
        if (this.mCurrentFloatData == null || !StringUtils.equal((String)uuid, (String)this.mCurrentFloatData.uuid)) {
            MLog.debug((Object)TAG, (String)"handleShowFloatToast ignore, currentFloatData is null or uuid not equal", (Object[])new Object[0]);
            return false;
        }
        if (this.isNeedForbid()) {
            return false;
        }
        if (this.getServiceManager() != null && this.getServiceManager().getService(IGameCenterService.class) != null && ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).isPlaying()) {
            return false;
        }
        AbstractWindow window = this.getCurrentWindow();
        String currentName = "";
        int windowType = -1;
        if (window == null) {
            MLog.error((Object)TAG, (String)"getCurrentWindow null", (Object[])new Object[0]);
        } else {
            currentName = window.getName();
            windowType = window.getWindowType();
        }
        if (WindowNameDef.isHomePage((String)currentName) && (homeService = (IHomeService)this.getServiceManager().getService(IHomeService.class)) != null) {
            if (info.shieldHomeTab(homeService.getCurrentPageType())) {
                MLog.info((Object)TAG, (String)"shield home tab: %s", (Object[])new Object[]{homeService.getCurrentPageType().name()});
                return false;
            }
            currentName = WindowNameDef.getHomeTabName((PageType)homeService.getCurrentPageType());
        }
        if (info.shield(windowType) || info.shield(currentName)) {
            MLog.info((Object)TAG, (String)"shield window: %s", (Object[])new Object[]{currentName});
            return false;
        }
        if (window instanceof IHidePushToast && ((IHidePushToast)window).isHidePushToast()) {
            MLog.info((Object)TAG, (String)"currentWindow need hide", (Object[])new Object[0]);
            return false;
        }
        final MessageToastView messageToastView = new MessageToastView(RuntimeContext.sApplicationContext, this, this.mCurrentFloatData.gameMessageModel);
        this.mCurrentFloatData.view = messageToastView;
        messageToastView.updateView(info);
        messageToastView.addPushLayoutAnimateListener(info.getOnPushLayoutListener());
        messageToastView.setOnNotifyPushClickListener(this);
        ((IExtViewService)this.getServiceManager().getService(IExtViewService.class)).addNoticeContentView(new IHagoFloatView(){

            public void onReAttachWindow() {
                if (RuntimeContext.isHagoPartySdk() && messageToastView.getContext() instanceof Activity) {
                    DeviceManager.fullScreenOffsetView((Activity)((Activity)messageToastView.getContext()), (View)messageToastView);
                }
            }

            public View getFloatView() {
                return messageToastView;
            }

            public void hideView() {
                NotifyPushToastController.this.hideFloatToastView();
            }
        });
        if (!RuntimeContext.isHagoPartySdk()) {
            DeviceManager.fullScreenOffsetView((Activity)this.getEnvironment().getActivity(), (View)messageToastView);
        }
        if (info.getPushType() == 3) {
            this.mCurrentFloatData.sitDownInfo = info;
        }
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mHideNotifyTask);
        YYTaskExecutor.postToMainThread((Runnable)this.mHideNotifyTask, (long)duration);
        this.reportHiido(PUSH_NOTIFY_SHOW, info);
        return true;
    }

    @Override
    public void jumpToType(NotifyPushToastInfo notifyPushToastInfo, int id2) {
        if (notifyPushToastInfo == null) {
            if (RuntimeContext.isHagoPartySdk()) {
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_PARTY_SDK_BACK_ROOT_WINDOW, (Object)2000));
            }
            return;
        }
        boolean jump = false;
        if (id2 == R.id.tv_im_toast_action) {
            if (notifyPushToastInfo.getJumpType() == 2) {
                Message message = Message.obtain();
                Bundle bundle = new Bundle();
                bundle.putLong("target_uid", notifyPushToastInfo.getTargetUid());
                bundle.putInt("im_page_source", 8);
                message.setData(bundle);
                message.what = BaseMsgDef.IM_ROOM_SHOW;
                this.sendMessageSync(message);
                this.hideFloatToastView();
                this.reportHiido(PUSH_NOTIFY_CLICK, notifyPushToastInfo);
                jump = true;
            } else if (notifyPushToastInfo.getJumpType() == 10000) {
                ((IYYUriService)this.getServiceManager().getService(IYYUriService.class)).handleUriString(notifyPushToastInfo.getJumpUri());
                this.hideFloatToastView();
                IMTrack.INSTANCE.handleChannelActivityMsgReport("push_message_click", notifyPushToastInfo.getJumpUri());
                jump = true;
            } else if (notifyPushToastInfo.getJumpType() == 4) {
                MsgJumpHelper.jumpToVoiceChatList();
                this.hideFloatToastView();
                jump = true;
            } else if (notifyPushToastInfo.getJumpType() == 5) {
                this.hideFloatToastView();
                jump = true;
            }
        } else if (id2 == R.id.toast_action_container) {
            if (notifyPushToastInfo.getJumpType() == 1) {
                String cid;
                if (this.mCurrentFloatData != null) {
                    this.mCurrentFloatData.sitDownInfo = null;
                }
                if (StringUtils.isNotEmpty((String)(cid = (String)notifyPushToastInfo.getExt("cid", (Object)"")))) {
                    String goback = "";
                    goback = (String)notifyPushToastInfo.getExt("goback", (Object)"");
                    MLog.info((Object)TAG, (String)("goback: " + goback), (Object[])new Object[0]);
                    EnterParam param = EnterParam.of((String)cid).entry(40).putExtra("goback", (Object)goback).build();
                    if (this.isDiyPush(notifyPushToastInfo)) {
                        param.setExtra("needPushReport", (Object)true);
                        param.setExtra("pushId", (Object)this.getPushId(notifyPushToastInfo));
                        param.setExtra("pushState", (Object)"2");
                    }
                    ((IRoomService)this.getServiceManager().getService(IRoomService.class)).enterRoom(param);
                    this.hideFloatToastView();
                    this.reportChannelPushEvent("channel_notification_bar_click", notifyPushToastInfo);
                    jump = true;
                }
            }
        } else if (id2 == R.id.layout_normal) {
            if (notifyPushToastInfo.getJumpType() == 0) {
                Message message = Message.obtain();
                Bundle bundle = new Bundle();
                bundle.putLong("target_uid", 10L);
                message.setData(bundle);
                message.what = AppbaseMsgDef.GOTO_OFFICIAL_MESSAGE_PAGE;
                this.sendMessage(message);
                this.hideFloatToastView();
                this.reportHiido(PUSH_NOTIFY_CLICK, notifyPushToastInfo);
                jump = true;
            }
        } else if (id2 == R.id.content_layout) {
            if (notifyPushToastInfo.getJumpType() == 10000) {
                ((IYYUriService)this.getServiceManager().getService(IYYUriService.class)).handleUriString(notifyPushToastInfo.getJumpUri());
                IMTrack.INSTANCE.handleChannelActivityMsgReport("push_message_click", notifyPushToastInfo.getJumpUri());
                jump = true;
            } else if (notifyPushToastInfo.getJumpType() == 4) {
                MsgJumpHelper.jumpToVoiceChatList();
                jump = true;
            }
        }
        if (!jump && RuntimeContext.isHagoPartySdk()) {
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_PARTY_SDK_BACK_ROOT_WINDOW, (Object)2000));
        }
        if (this.isDiyPush(notifyPushToastInfo)) {
            ChannelBaseTrack.INSTANCE.reportPush("push_click", this.getPushId(notifyPushToastInfo), "2", (String)notifyPushToastInfo.getExt("cid", (Object)""));
        }
    }

    private void reportHiido(String functionId, NotifyPushToastInfo info) {
        if (info != null) {
            if (info.getPushType() == 1) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025571").put("function_id", functionId).put("push_source", info.getExtraString1()).put("business_order_no", info.getExtraString2()));
            } else if (info.getPushType() == 2) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024017").put("function_id", functionId).put("message_type", info.getExtraString1()).put("source", String.valueOf(info.getSource())));
            } else if (info.getPushType() == 3 || info.getPushType() == 4) {
                this.reportChannelPushEvent("channel_notification_bar_show", info);
            }
            if (this.isDiyPush(info)) {
                ChannelBaseTrack.INSTANCE.reportPush("push_show", this.getPushId(info), "2", (String)info.getExt("cid", (Object)""));
            }
        }
    }

    private boolean isDiyPush(NotifyPushToastInfo info) {
        if (info != null) {
            return (Boolean)info.getExt("isDiyPush", (Object)false);
        }
        return false;
    }

    private String getPushId(NotifyPushToastInfo info) {
        if (info != null) {
            return String.valueOf(info.getExt("pushId", (Object)0L));
        }
        return "";
    }

    private void reportChannelPushEvent(String functionId, NotifyPushToastInfo info) {
        String notificationBarType = (String)info.getExt("from", (Object)"1");
        String fromUid = (String)info.getExt("fromUid", (Object)"");
        String pushType = (String)info.getExt("push_type", (Object)"-1");
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", functionId).put("push_type", pushType).put("notification_bar_type", notificationBarType).put("other_uid", fromUid));
    }

    private void showFloatToastView(FloatToastData toastData) {
        if (toastData == null) {
            return;
        }
        if (this.mCurrentFloatData != null) {
            boolean usePriority = this.userToastPriority();
            if (usePriority) {
                if (this.mCurrentFloatData.priority <= toastData.priority) {
                    this.hideFloatToastView(false);
                    FloatToastData target = this.checkTaskQueue(toastData);
                    this.handleShowFloatToast(target);
                } else {
                    MLog.debug((Object)TAG, (String)"showFloatToastView offer notifyType %d, current priority: %d, new priority: %d", (Object[])new Object[]{toastData.notifyType, this.mCurrentFloatData.priority, toastData.priority});
                    this.mTaskQueue.offer(toastData);
                }
            } else {
                this.hideFloatToastView();
                this.handleShowFloatToast(toastData);
            }
        } else {
            this.handleShowFloatToast(toastData);
        }
    }

    private void handleCancelFloatNotice(String noticeId) {
        FloatNoticeView noticeView;
        View view;
        if (this.mCurrentFloatData != null && (view = this.mCurrentFloatData.view) instanceof FloatNoticeView && (noticeView = (FloatNoticeView)view).isSameNotice(noticeId)) {
            this.hideFloatToastView();
            return;
        }
        FloatNoticeInfo info = null;
        FloatToastData data2 = null;
        int targetIndex = -1;
        for (int i = 0; i < this.mTaskQueue.size(); ++i) {
            data2 = this.mTaskQueue.get(i);
            if (!(data2.info instanceof FloatNoticeInfo) || !StringUtils.equal((String)(info = (FloatNoticeInfo)data2.info).getNoticeId(), (String)noticeId)) continue;
            targetIndex = i;
            break;
        }
        if (targetIndex >= 0 && targetIndex < this.mTaskQueue.size()) {
            this.mTaskQueue.remove(targetIndex);
        }
    }

    private boolean isNeedForbid() {
        Object channelForbidToast = this.sendMessageSync(BaseMsgDef.CHANNEL_NEED_FORBID_TOAST);
        if (channelForbidToast instanceof Boolean && ((Boolean)channelForbidToast).booleanValue()) {
            MLog.error((Object)TAG, (String)"channel is playing game,block float bar", (Object[])new Object[0]);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleShowFloatToast(final String uuid, final int notifyType, final long duration) {
        if (this.mCurrentFloatData == null || !StringUtils.equal((String)uuid, (String)this.mCurrentFloatData.uuid)) {
            MLog.debug((Object)TAG, (String)"handleShowFloatToast ignore, currentFloatData is null or uuid not equal", (Object[])new Object[0]);
            return false;
        }
        AbstractWindow window = this.getCurrentWindow();
        String currentName = "";
        int windowType = -1;
        if (window == null) {
            MLog.error((Object)TAG, (String)"getCurrentWindow null", (Object[])new Object[0]);
        } else {
            currentName = window.getName();
            windowType = window.getWindowType();
        }
        if ("RoomCreateWindow".equals(currentName)) {
            MLog.info((Object)TAG, (String)"currentWindow name is roomCreate, not show toast", (Object[])new Object[0]);
            return false;
        }
        if (window instanceof IHidePushToast && ((IHidePushToast)window).isHidePushToast()) {
            MLog.info((Object)TAG, (String)"currentWindow need hide", (Object[])new Object[0]);
            return false;
        }
        MLog.info((Object)TAG, (String)"notifyType: %d, \u5f53\u524dWindow\u7684\u7c7b\u578b: %d", (Object[])new Object[]{notifyType, windowType});
        if (this.isNeedForbid()) {
            GameMessageModel gameMessageModel = this.mCurrentFloatData.gameMessageModel;
            if (notifyType != 0 || gameMessageModel == null || !SystemUtils.isAI((long)gameMessageModel.getFromUserId())) return false;
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024017").put("function_id", "receive_ai_invite").put("scence", "4"));
            return false;
        }
        if (windowType != 101 && windowType != 105 && windowType != 109 && windowType != 115 && windowType != 117 && windowType != 119 && windowType != 112 && windowType != 122) {
            long targetUid = 0L;
            long shadowUid = 0L;
            SpannableStringBuilder content = null;
            if (windowType == 103) {
                if (notifyType != 0 || this.mCurrentFloatData.gameMessageModel == null) return false;
                ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).notifyGameInvite((Object)this.mCurrentFloatData.gameMessageModel);
                return false;
            }
            if (notifyType == 13 && windowType != 114 && windowType != 100) {
                return this.handleShowFloatToast(uuid, notifyType, new SpannableStringBuilder((CharSequence)((String)this.mCurrentFloatData.extMap.get("content"))), (String)this.mCurrentFloatData.extMap.get("avatar"), (Integer)this.mCurrentFloatData.extMap.get("sex"), (String)this.mCurrentFloatData.extMap.get("title"), (Long)this.mCurrentFloatData.extMap.get("uid"), duration);
            }
            if (notifyType == 16) {
                if (this.mCurrentFloatData.extMap == null) {
                    return false;
                }
                String contentStr = "";
                if (this.mCurrentFloatData.extMap.get("content") instanceof String) {
                    contentStr = (String)this.mCurrentFloatData.extMap.get("content");
                }
                String avatar = "";
                if (this.mCurrentFloatData.extMap.get("avatar") instanceof String) {
                    avatar = (String)this.mCurrentFloatData.extMap.get("avatar");
                }
                String title = "";
                if (this.mCurrentFloatData.extMap.get("title") instanceof String) {
                    title = (String)this.mCurrentFloatData.extMap.get("title");
                }
                long fromUid = 0L;
                if (!(this.mCurrentFloatData.extMap.get("uid") instanceof Long)) return this.handleShowFloatToast(uuid, notifyType, new SpannableStringBuilder((CharSequence)contentStr), avatar, 0, title, fromUid, duration);
                fromUid = (Long)this.mCurrentFloatData.extMap.get("uid");
                return this.handleShowFloatToast(uuid, notifyType, new SpannableStringBuilder((CharSequence)contentStr), avatar, 0, title, fromUid, duration);
            }
            if (notifyType == 17) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025571").put("function_id", "push_show").put("push_source", "20210325"));
                return this.handleShowFloatToast(uuid, notifyType, null, "", 0, "", 0L, duration);
            }
            if (notifyType == 14 || notifyType == 15) {
                return this.handleShowFloatToast(uuid, notifyType, new SpannableStringBuilder((CharSequence)((String)this.mCurrentFloatData.extMap.get("content"))), (String)this.mCurrentFloatData.extMap.get("avatar"), 0, (String)this.mCurrentFloatData.extMap.get("title"), AccountUtil.getUid(), duration);
            }
            if (notifyType == 2) {
                if (windowType == 102) {
                    return false;
                }
                targetUid = this.mCurrentFloatData.targetUid;
                content = new SpannableStringBuilder((CharSequence)"");
            } else if (notifyType == 5) {
                Object obj;
                if (windowType == 102) {
                    return false;
                }
                targetUid = this.mCurrentFloatData.targetUid;
                String quizContent = "";
                if (this.mCurrentFloatData.extMap != null && (obj = this.mCurrentFloatData.extMap.get("quiz_content")) instanceof String) {
                    quizContent = (String)obj;
                }
                content = new SpannableStringBuilder((CharSequence)quizContent);
            } else if (notifyType == 6) {
                if (windowType == 102 || windowType == 114) {
                    return false;
                }
                targetUid = this.mCurrentFloatData.targetUid;
                content = new SpannableStringBuilder((CharSequence)ResourceUtils.getString((int)R.string.tips_channel_invite_toast));
            } else if (notifyType == 10) {
                if (this.mCurrentFloatData.extMap != null) {
                    Object obj = this.mCurrentFloatData.extMap.get("channel_toast_msg");
                    if (!(obj instanceof ChannelToastMsg)) return false;
                    ChannelToastMsg channelToastMsg = (ChannelToastMsg)obj;
                    if (channelToastMsg.msg == null) {
                        return false;
                    }
                    targetUid = channelToastMsg.msg.getFrom();
                    content = new SpannableStringBuilder(channelToastMsg.charSequenceContent);
                }
            } else if (notifyType == 9) {
                if (windowType == 102 || windowType == 114) {
                    return false;
                }
                targetUid = this.mCurrentFloatData.targetUid;
                if (this.mCurrentFloatData.extMap != null) {
                    Object obj = this.mCurrentFloatData.extMap.get("content");
                    String text = ResourceUtils.getString((int)R.string.tips_channel_invite_toast);
                    if (obj instanceof String) {
                        text = (String)obj;
                    }
                    content = new SpannableStringBuilder((CharSequence)text);
                }
            } else if (notifyType == 11) {
                if (StringUtils.isEmpty((String)this.mCurrentFloatData.deeplinkGameId)) {
                    MLog.info((Object)TAG, (String)"mDeepLinkGameId null!!!", (Object[])new Object[0]);
                    return false;
                }
                content = new SpannableStringBuilder((CharSequence)ResourceUtils.getString((int)R.string.tips_game_download_finish));
            } else {
                if (windowType == 102) {
                    return false;
                }
                if (windowType == 107) {
                    return false;
                }
                if (this.mCurrentFloatData.gameMessageModel == null) {
                    return false;
                }
                if (windowType == 106) {
                    if (this.mCurrentFloatData.gameMessageModel.getInviteType() == 1 || this.mCurrentFloatData.gameMessageModel.getInviteType() == 0) {
                        return false;
                    }
                    if (!StringUtils.isEmpty((String)this.mCurrentFloatData.gameMessageModel.getPkId()) && this.mCurrentFloatData.gameMessageModel.getPkId().equals(((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).getPushPkId())) {
                        return false;
                    }
                }
                long temp = 0L;
                targetUid = this.mCurrentFloatData.gameMessageModel.getFromUserId();
                shadowUid = this.mCurrentFloatData.gameMessageModel.getShadowUid();
                if (shadowUid != 0L) {
                    temp = targetUid;
                    targetUid = shadowUid;
                    shadowUid = temp;
                }
                MLog.info((Object)TAG, (String)"\u6d6e\u5c42\u5c55\u793a\u65f6\u5019\u5bf9\u65b9\u7684\u5f71\u5b50uid:%d, \u6765\u6e90uid: %d", (Object[])new Object[]{targetUid, shadowUid});
                ImService imService = (ImService)this.getServiceManager().getService(ImService.class);
                if (imService == null) {
                    return false;
                }
                if (windowType != 106 && targetUid == imService.getCurrChatUid() && targetUid != 0L && windowType == 100) {
                    MLog.info((Object)TAG, (String)"current window im", (Object[])new Object[0]);
                    return false;
                }
                IGameInfoService iGameInfoService = (IGameInfoService)this.getServiceManager().getService(IGameInfoService.class);
                if (iGameInfoService == null) {
                    return false;
                }
                String gid = this.mCurrentFloatData.gameMessageModel.getGameId();
                GameInfo gameInfo = iGameInfoService.getGameInfoByGid(gid);
                if (TextUtils.isEmpty((CharSequence)gid)) {
                    MLog.info((Object)"PushNotify", (String)"gameId\u4e3a\u7a7a", (Object[])new Object[0]);
                }
                if (gameInfo == null) {
                    MLog.info((Object)"PushNotify", (String)"\u83b7\u53d6\u5230\u7684gameInfo\u4e3a\u7a7a", (Object[])new Object[0]);
                    return false;
                }
                content = SpannableStringUtil.getSpannableString((SpannableStringUtil.ISpannableBlock[])new SpannableStringUtil.ISpannableBlock[]{new SpannableStringUtil.SpannableStringBlock((CharSequence)ResourceUtils.getString((int)R.string.im_push_game_accept_content), -16055035), new SpannableStringUtil.SpannableStringBlock((CharSequence)gameInfo.getGname(), -46483)});
            }
            final IUserInfoService iUserInfoService = (IUserInfoService)this.getServiceManager().getService(IUserInfoService.class);
            if (iUserInfoService == null) {
                return false;
            }
            final SpannableStringBuilder finalContent = content;
            if (notifyType == 0) {
                if (windowType == 114) {
                    return false;
                }
                if (!TextUtils.isEmpty((CharSequence)this.mCurrentFloatData.gameMessageModel.getFromUserAvatar()) && !TextUtils.isEmpty((CharSequence)this.mCurrentFloatData.gameMessageModel.getFromUserName())) {
                    return this.handleShowFloatToast(uuid, notifyType, content, this.mCurrentFloatData.gameMessageModel.getFromUserAvatar(), this.mCurrentFloatData.gameMessageModel.getFromUserSex(), this.mCurrentFloatData.gameMessageModel.getFromUserName(), this.mCurrentFloatData.gameMessageModel.getFromUserId(), duration);
                }
                final long shadowAi = shadowUid;
                iUserInfoService.requestUserInfoFromServer(targetUid, new OnKSProfileListCallback(){

                    public void onUISuccess(@NonNull List<UserInfoKS> list) {
                        if (list != null && list.size() > 0) {
                            UserInfoKS userInfo = list.get(0);
                            if (shadowAi != 0L) {
                                UserInfoKS aiInfo = iUserInfoService.getUserInfo(shadowAi);
                                iUserInfoService.updateFromShadowInfo(userInfo, aiInfo);
                                aiInfo.setValue("shadowUid", (Object)userInfo.uid);
                            }
                            NotifyPushToastController.this.handleShowFloatToast(uuid, notifyType, finalContent, userInfo.avatar, userInfo.sex, userInfo.nick, userInfo.uid, duration);
                        }
                    }

                    public void onError(String reason, long code) {
                    }
                });
                if (WindowNameDef.isHomePage((String)currentName) && SystemUtils.isAI((long)this.mCurrentFloatData.gameMessageModel.getFromUserId())) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024017").put("function_id", "receive_ai_invite").put("scence", "1"));
                }
            } else if (notifyType == 6 || notifyType == 9) {
                IMainPageState state2;
                if (WindowNameDef.isHomePage((String)currentName) && (state2 = (IMainPageState)((IHomeService)this.getServiceManager().getService(IHomeService.class)).currentPageState().getValue()) != null && state2.getType() == PageType.DISCOVERY) {
                    return false;
                }
                iUserInfoService.requestUserInfoFromServer(targetUid, new OnKSProfileListCallback(){

                    public void onUISuccess(List<UserInfoKS> list) {
                        if (list != null && list.size() > 0 && NotifyPushToastController.this.mCurrentFloatData != null && ((NotifyPushToastController)NotifyPushToastController.this).mCurrentFloatData.extMap != null) {
                            UserInfoKS userInfo = list.get(0);
                            NotifyPushToastController.this.handleShowFloatToast(uuid, notifyType, finalContent, userInfo.avatar, userInfo.sex, userInfo.nick, userInfo.uid, (String)((NotifyPushToastController)NotifyPushToastController.this).mCurrentFloatData.extMap.get("roomId"), (String)((NotifyPushToastController)NotifyPushToastController.this).mCurrentFloatData.extMap.get("roomToken"), (String)((NotifyPushToastController)NotifyPushToastController.this).mCurrentFloatData.extMap.get("inviteUrl"), (String)((NotifyPushToastController)NotifyPushToastController.this).mCurrentFloatData.extMap.get("roomSource"), duration);
                        }
                    }

                    public void onError(String reason, long code) {
                    }
                });
            } else if (notifyType == 11) {
                GameInfo gameInfoByGid = ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(this.mCurrentFloatData.deeplinkGameId);
                if (gameInfoByGid != null) {
                    MLog.info((Object)TAG, (String)"TYPE_DEEPLINK_GAME_MSG gameInfo showMessageToastView", (Object[])new Object[0]);
                    return this.handleShowFloatToast(uuid, notifyType, content, gameInfoByGid.getIconUrl(), 0, gameInfoByGid.getGname(), 0L, duration);
                }
                MLog.info((Object)TAG, (String)"TYPE_DEEPLINK_GAME_MSG gameInfo null", (Object[])new Object[0]);
            } else {
                iUserInfoService.requestUserInfoFromServer(targetUid, new OnKSProfileListCallback(){

                    public void onUISuccess(List<UserInfoKS> list) {
                        if (list != null && list.size() > 0) {
                            UserInfoKS userInfo = list.get(0);
                            NotifyPushToastController.this.handleShowFloatToast(uuid, notifyType, finalContent, userInfo.avatar, userInfo.sex, userInfo.nick, userInfo.uid, duration);
                        }
                    }

                    public void onError(String reason, long code) {
                    }
                });
            }
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mHideNotifyTask);
            YYTaskExecutor.postToMainThread((Runnable)this.mHideNotifyTask, (long)duration);
            return true;
        }
        MLog.info((Object)TAG, (String)"show notify toast block because window not match!!!", (Object[])new Object[0]);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleShowFloatToast(String uuid, final int notifyType, SpannableStringBuilder content, String avatar, int sex, String userNick, long uid, long duration) {
        Object obj;
        if (this.mCurrentFloatData == null || !StringUtils.equal((String)uuid, (String)this.mCurrentFloatData.uuid)) {
            MLog.debug((Object)TAG, (String)"handleShowFloatToast ignore, currentFloatData is null or uuid not equal", (Object[])new Object[0]);
            return false;
        }
        this.mCurrentFloatData.user = uid;
        this.mCurrentFloatData.sex = sex;
        JumpBBSDetailsData jumpBBSDetailsData = null;
        if (this.mCurrentFloatData.extMap != null && (obj = this.mCurrentFloatData.extMap.get("jump_bbs_detail")) instanceof JumpBBSDetailsData) {
            jumpBBSDetailsData = (JumpBBSDetailsData)obj;
        }
        final MessageToastView messageToastView = new MessageToastView(RuntimeContext.sApplicationContext, this, this.mCurrentFloatData.gameMessageModel);
        this.mCurrentFloatData.view = messageToastView;
        if (jumpBBSDetailsData != null) {
            messageToastView.setJumpBBSDetailsData(jumpBBSDetailsData);
        }
        messageToastView.setOnNotifyPushClickListener(this);
        if (notifyType == 2) {
            UserInfoKS userInfoKS = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid());
            messageToastView.setWemeetMatchesType(notifyType, userNick, userInfoKS.avatar, avatar, userInfoKS.sex, sex);
        } else if (notifyType == 6 || notifyType == 9) {
            messageToastView.setExtParam(this.mCurrentFloatData.extMap);
            messageToastView.setType(notifyType, content, userNick, avatar, sex);
        } else if (notifyType == 10) {
            if (this.mCurrentFloatData.extMap == null) return false;
            Object obj2 = this.mCurrentFloatData.extMap.get("channel_toast_msg");
            if (!(obj2 instanceof ChannelToastMsg)) return false;
            ChannelToastMsg channelToastMsg = (ChannelToastMsg)obj2;
            if (channelToastMsg.params == null) {
                return false;
            }
            this.mCurrentFloatData.extMap.put("roomId", channelToastMsg.params.roomId);
            this.mCurrentFloatData.extMap.put("roomToken", channelToastMsg.params.password);
            messageToastView.setExtParam(this.mCurrentFloatData.extMap);
            messageToastView.setType(notifyType, content, userNick, avatar, sex);
        } else if (notifyType == 13) {
            messageToastView.setType(notifyType, content, userNick, avatar, sex);
        } else if (notifyType == 14 || notifyType == 15) {
            messageToastView.setType(notifyType, content, userNick, avatar, sex);
            messageToastView.setExtParam(this.mCurrentFloatData.extMap);
        } else if (notifyType == 16) {
            messageToastView.setType(notifyType, content, userNick, avatar, sex);
            messageToastView.setExtParam(this.mCurrentFloatData.extMap);
        } else {
            messageToastView.setType(notifyType, content, userNick, avatar, sex);
        }
        IHagoFloatView iHagoFloatView = new IHagoFloatView(){

            public void onReAttachWindow() {
            }

            public View getFloatView() {
                return messageToastView;
            }

            public void hideView() {
                NotifyPushToastController.this.hideFloatToastView();
            }
        };
        ((IExtViewService)this.getServiceManager().getService(IExtViewService.class)).addNoticeContentView(iHagoFloatView);
        if (!RuntimeContext.isHagoPartySdk()) {
            DeviceManager.fullScreenOffsetView((Activity)this.getEnvironment().getActivity(), (View)messageToastView);
        }
        if (uid == 0L || uid == AccountUtil.getUid()) {
            this.reportHiido(notifyType);
        } else {
            this.checkFriendShip(uid, new Function1<Integer, Unit>(){

                public Unit invoke(Integer isFriend) {
                    NotifyPushToastController.this.reportHiido(notifyType);
                    return null;
                }
            });
        }
        this.playNotifyVoice();
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mHideNotifyTask);
        YYTaskExecutor.postToMainThread((Runnable)this.mHideNotifyTask, (long)duration);
        return true;
    }

    private boolean handleShowFloatToast(String uuid, final int notifyType, SpannableStringBuilder content, String avatar, int sex, String userNick, long uid, String roomId, String voiceRoomPwdToken, String familyDetailUrl, String roomSource, long duration) {
        if (this.mCurrentFloatData == null || !StringUtils.equal((String)uuid, (String)this.mCurrentFloatData.uuid)) {
            MLog.debug((Object)TAG, (String)"handleShowFloatToast ignore, currentFloatData is null or uuid not equal", (Object[])new Object[0]);
            return false;
        }
        this.mCurrentFloatData.user = uid;
        this.mCurrentFloatData.sex = sex;
        final MessageToastView messageToastView = new MessageToastView(RuntimeContext.sApplicationContext, this, this.mCurrentFloatData.gameMessageModel);
        this.mCurrentFloatData.view = messageToastView;
        messageToastView.setOnNotifyPushClickListener(this);
        if (notifyType == 6 || notifyType == 9) {
            HashMap<String, Object> extMap = new HashMap<String, Object>();
            extMap.put("roomId", roomId);
            extMap.put("roomToken", voiceRoomPwdToken);
            extMap.put("inviteUrl", familyDetailUrl);
            extMap.put("fromUid", uid);
            extMap.put("roomSource", roomSource);
            messageToastView.setExtParam(extMap);
            messageToastView.setType(notifyType, content, userNick, avatar, sex);
        }
        IHagoFloatView iHagoFloatView = new IHagoFloatView(){

            public void onReAttachWindow() {
                if (RuntimeContext.isHagoPartySdk() && messageToastView.getContext() instanceof Activity) {
                    DeviceManager.fullScreenOffsetView((Activity)((Activity)messageToastView.getContext()), (View)messageToastView);
                }
            }

            public View getFloatView() {
                return messageToastView;
            }

            public void hideView() {
                NotifyPushToastController.this.hideFloatToastView();
            }
        };
        ((IExtViewService)this.getServiceManager().getService(IExtViewService.class)).addNoticeContentView(iHagoFloatView);
        if (!RuntimeContext.isHagoPartySdk()) {
            DeviceManager.fullScreenOffsetView((Activity)this.getEnvironment().getActivity(), (View)messageToastView);
        }
        if (uid == 0L || uid == AccountUtil.getUid()) {
            this.reportHiido(notifyType);
        } else {
            this.checkFriendShip(uid, new Function1<Integer, Unit>(){

                public Unit invoke(Integer isFriend) {
                    NotifyPushToastController.this.reportHiido(notifyType);
                    return null;
                }
            });
        }
        this.playNotifyVoice();
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mHideNotifyTask);
        YYTaskExecutor.postToMainThread((Runnable)this.mHideNotifyTask, (long)duration);
        return true;
    }

    private void checkFriendShip(long uid, final Function1<Integer, Unit> callback) {
        ArrayList<Long> uidList = new ArrayList<Long>(1);
        uidList.add(uid);
        FriendListViewModel.RelationshipReq req = new FriendListViewModel.RelationshipReq(new IRelationship(){

            @Override
            public void onSucc(List<Long> uids, final List<Integer> relations) {
                if (relations == null || relations.size() == 0) {
                    return;
                }
                if (YYTaskExecutor.isMainThread()) {
                    NotifyPushToastController.this.setRelation(relations.get(0), (Function1<Integer, Unit>)callback);
                } else {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            NotifyPushToastController.this.setRelation((Integer)relations.get(0), (Function1<Integer, Unit>)callback);
                        }
                    });
                }
            }

            @Override
            public void onError(List<Long> uids, int errCode) {
            }
        }, uidList);
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_CHECK_RELATIONSHIP, (Object)req));
    }

    private void setRelation(int relation, Function1<Integer, Unit> callback) {
        View view;
        if (this.mCurrentFloatData != null && this.mCurrentFloatData.view != null && (view = this.mCurrentFloatData.view) instanceof MessageToastView) {
            MessageToastView toastView = (MessageToastView)view;
            if (1 == relation) {
                this.mCurrentFloatData.isFriend = 1;
                toastView.showFriendTag();
                callback.invoke((Object)1);
            } else {
                this.mCurrentFloatData.isFriend = 0;
                toastView.hideFriendTag();
                callback.invoke((Object)0);
            }
        }
    }

    private void hideFloatToastView() {
        if (this.userToastPriority()) {
            this.hideFloatToastView(true);
        } else {
            this.hideFloatToastView(false);
        }
    }

    private void hideFloatToastView(boolean turnNext) {
        MLog.debug((Object)TAG, (String)("hideFloatToastView turnNext:" + turnNext), (Object[])new Object[0]);
        if (this.mCurrentFloatData != null) {
            View view = this.mCurrentFloatData.view;
            if (view != null) {
                ((IExtViewService)this.getServiceManager().getService(IExtViewService.class)).removeNoticeContentView(view);
                this.mCurrentFloatData.view = null;
            }
            if (NAB.A.equals((Object)NewABDefine.CHANNEL_TAB_NOTIFY.getTest())) {
                if (this.mCurrentFloatData.sitDownInfo != null && this.mCurrentFloatData.sitDownInfo.getPushType() == 3) {
                    Message msg = Message.obtain();
                    msg.what = ImBaseMsgDef.MSG_CHANNEL_SIT_DOWN_FLOAT_LAYER_HIDE;
                    msg.obj = this.mCurrentFloatData.sitDownInfo.getImgUrl();
                    this.sendMessage(msg);
                }
                this.mCurrentFloatData.sitDownInfo = null;
            }
            this.mCurrentFloatData = null;
        }
        if (turnNext) {
            YYTaskExecutor.postToMainThread(() -> this.showFloatToastView(this.mTaskQueue.poll()), (long)1000L);
        }
    }

    @Override
    public void onHide() {
        this.hideFloatToastView();
    }

    private void reportHiido(int notifyType) {
        String gid;
        if (this.mCurrentFloatData == null) {
            return;
        }
        String string2 = gid = this.mCurrentFloatData.gameMessageModel == null ? "" : this.mCurrentFloatData.gameMessageModel.getGameId();
        if (notifyType == 0) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20042069").put("function_id", "home_game_invite_show").put("gid", gid).put("is_ai", SystemUtils.isAI((long)this.mCurrentFloatData.user) ? "1" : "2"));
            if (this.mCurrentFloatData.isFriend == 0) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024017").put("function_id", "show").put("location", "1").put("message_type", "im_pk_game").put("user_type", "2").put("push_uid", String.valueOf(this.mCurrentFloatData.user)).put("source", String.valueOf(this.mCurrentFloatData.gameMessageModel != null ? this.mCurrentFloatData.gameMessageModel.getSource() : -1)));
            } else if (this.mCurrentFloatData.isFriend == 1) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024017").put("function_id", "show").put("location", "1").put("message_type", "im_pk_game").put("user_type", "1").put("push_uid", String.valueOf(this.mCurrentFloatData.user)).put("source", String.valueOf(this.mCurrentFloatData.gameMessageModel != null ? this.mCurrentFloatData.gameMessageModel.getSource() : -1)));
            }
        } else if (notifyType == 1) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024017").put("function_id", "show").put("location", "1").put("message_type", "friend").put("location", "1").put("push_uid", String.valueOf(this.mCurrentFloatData.user)).put("source", String.valueOf(this.mCurrentFloatData.gameMessageModel != null ? this.mCurrentFloatData.gameMessageModel.getSource() : -1)));
        } else if (notifyType == 6) {
            Map<String, Object> extMap = this.mCurrentFloatData.extMap;
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024017").put("function_id", "show").put("message_type", "chatroom_message").put("location", "1").put("push_uid", String.valueOf(this.mCurrentFloatData.user)).put("source", extMap == null ? "" : String.valueOf(extMap.get("source"))));
        } else if (notifyType == 9) {
            Map<String, Object> extMap = this.mCurrentFloatData.extMap;
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024017").put("function_id", "show").put("message_type", "channel_message").put("location", "1").put("push_uid", String.valueOf(this.mCurrentFloatData.user)).put("source", extMap == null ? "" : String.valueOf(extMap.get("source"))));
        } else if (notifyType == 10) {
            Object obj;
            Map<String, Object> extMap = this.mCurrentFloatData.extMap;
            int channelToastFrom = 0;
            if (extMap != null && (obj = extMap.get("channel_toast_from")) instanceof Integer) {
                channelToastFrom = (Integer)obj;
            }
            if (channelToastFrom == 1) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "channelpg_invite_guide_show"));
            }
        } else if (notifyType == 11) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024017").put("function_id", "show").put("message_type", "load_success").put("location", "1").put("gid", this.mCurrentFloatData.deeplinkGameId).put("push_uid", String.valueOf(this.mCurrentFloatData.user)).put("source", String.valueOf(this.mCurrentFloatData.gameMessageModel != null ? this.mCurrentFloatData.gameMessageModel.getSource() : -1)));
        }
    }

    @Override
    public void startGame(final GameMessageModel gameMessageModel) {
        MLog.info((Object)TAG, (String)"startGame", (Object[])new Object[0]);
        if (this.mCurrentFloatData != null) {
            if (this.mCurrentFloatData.user != 0L && this.mCurrentFloatData.isFriend == 0) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024017").put("function_id", "click_ok").put("message_type", "im_pk_game").put("location", "1").put("user_type", "2").put("push_uid", String.valueOf(this.mCurrentFloatData.user)).put("source", String.valueOf(this.mCurrentFloatData.gameMessageModel != null ? this.mCurrentFloatData.gameMessageModel.getSource() : -1)));
            } else if (this.mCurrentFloatData.user != 0L && this.mCurrentFloatData.isFriend == 1) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024017").put("function_id", "click_ok").put("message_type", "im_pk_game").put("location", "1").put("user_type", "1").put("push_uid", String.valueOf(this.mCurrentFloatData.user)).put("source", String.valueOf(this.mCurrentFloatData.gameMessageModel != null ? this.mCurrentFloatData.gameMessageModel.getSource() : -1)));
            }
            String gid = this.mCurrentFloatData.gameMessageModel == null ? "" : this.mCurrentFloatData.gameMessageModel.getGameId();
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20042069").put("function_id", "home_game_invite_click").put("gid", gid).put("is_ai", SystemUtils.isAI((long)this.mCurrentFloatData.user) ? "1" : "2"));
        }
        this.hideFloatToastView();
        if (gameMessageModel == null) {
            return;
        }
        if (gameMessageModel.getGameTimeLimitType() == 1 && !((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).isGameInviteExist(gameMessageModel.getPkId())) {
            ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.im_invitation_canceled_tips), (int)1);
            return;
        }
        IGameInfoService iGameInfoService = (IGameInfoService)this.getServiceManager().getService(IGameInfoService.class);
        if (iGameInfoService == null) {
            return;
        }
        final GameInfo gameInfo = iGameInfoService.getGameInfoByGid(gameMessageModel.getGameId());
        if (gameInfo == null) {
            this.showInvalidToast();
            return;
        }
        IUserInfoService iUserInfoService = (IUserInfoService)this.getServiceManager().getService(IUserInfoService.class);
        if (iUserInfoService == null) {
            return;
        }
        final UserInfoKS userInfoBean = iUserInfoService.getUserInfo(AccountUtil.getUid());
        if (userInfoBean == null || userInfoBean.ver <= 0L) {
            this.showInvalidToast();
            return;
        }
        IGameService iGameService = (IGameService)this.getServiceManager().getService(IGameService.class);
        final IGameInviteService gameInviteService = (IGameInviteService)this.getServiceManager().getService(IGameInviteService.class);
        if (iGameService == null) {
            return;
        }
        if (gameInviteService == null) {
            return;
        }
        boolean isGameValid = iGameService.isGameValid(gameInfo);
        AbstractWindow window = this.getCurrentWindow();
        int type = -1;
        if (window == null) {
            MLog.error((Object)TAG, (String)"getCurrentWindow null", (Object[])new Object[0]);
        } else {
            type = window.getWindowType();
        }
        if (gameMessageModel.getGameTimeLimitType() == 1) {
            if (isGameValid || type == 106) {
                this.acceptInvite(gameMessageModel, userInfoBean, gameInviteService, gameInfo);
            } else {
                MLog.info((Object)TAG, (String)"startGame download gameId=%s", (Object[])new Object[]{gameInfo.getGid()});
                if (gameMessageModel.getShadowUid() != 0L) {
                    Bundle dispatchBundle = new Bundle();
                    dispatchBundle.putString("game_id", gameInfo.gid);
                    Message dispatchMsg = new Message();
                    dispatchMsg.setData(dispatchBundle);
                    dispatchMsg.what = GrowthMsgDef.NEW_USER_SHADOW_AI_GAME_DOWNLOAD;
                    dispatchMsg.obj = new IGameDownloadCallback(){

                        public void onResult(String gameId, boolean result) {
                            if (result && StringUtils.equal((String)gameId, (String)gameInfo.gid)) {
                                NotifyPushToastController.this.acceptInvite(gameMessageModel, userInfoBean, gameInviteService, gameInfo);
                            }
                        }
                    };
                    MsgDispatcher.getInstance().sendMessage(dispatchMsg);
                } else {
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_ENTER_FROM_PUSH, (Object)gameMessageModel));
                    gameInfo.downloadInfo.setFrom(GameDownloadInfo.DownloadFrom.im);
                    iGameService.downloadGame(gameInfo);
                }
            }
        } else if (gameMessageModel.getGameTimeLimitType() == 2) {
            if (isGameValid) {
                ((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).getMsgInviteService().indepGameAccept(gameMessageModel.getRoomId(), new IIndepGameAcceptCallback(){

                    public void onIndepGameAcceptSuccess(String roomId) {
                        IndieGamePlayContext playContext = new IndieGamePlayContext.Builder(GameContextDef.JoinFrom.FROM_NOTIFY).roomId(gameMessageModel.getRoomId()).payload(gameMessageModel.getInfoPayload()).build();
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028013").put("function_id", "4").put("gid", gameMessageModel.getGameId()));
                        ((IGameCenterService)NotifyPushToastController.this.getServiceManager().getService(IGameCenterService.class)).joinGame(gameInfo, (GamePlayContext)playContext);
                        ((IGameInviteService)NotifyPushToastController.this.getServiceManager().getService(IGameInviteService.class)).removeGameInvite(gameMessageModel.getPkId());
                    }

                    public void onIndepGameAcceptFail(long code, String roomId) {
                        TeamInviteResCodeHelper.showToast((long)code);
                    }
                });
            } else {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_game_start_download), (int)1);
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_ENTER_FROM_PUSH, (Object)gameMessageModel));
                gameInfo.downloadInfo.setFrom(GameDownloadInfo.DownloadFrom.im);
                iGameService.downloadGame(gameInfo);
            }
        }
    }

    private void showInvalidToast() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ToastUtils.showToast((Context)NotifyPushToastController.this.mContext, (String)ResourceUtils.getString((int)R.string.game_invalid), (int)200);
            }
        });
    }

    private void acceptInvite(GameMessageModel gameMessageModel, UserInfoKS userInfoBean, IGameInviteService gameInviteService, GameInfo gameInfo) {
        IMPKAcceptReqBean reqBean = IMPKAcceptReqBean.newBuilder().pk_id(gameMessageModel.getPkId()).accept(true).isGoldGame(gameMessageModel.isGoldGame()).my_sex(userInfoBean.sex).my_nick(userInfoBean.nick).my_pic_url(userInfoBean.avatar).coinGradeType(gameMessageModel.getCoinGradeType()).gameVersion(gameInfo.getModulerVer()).build();
        if (!IMPKAcceptReqBean.checkBean((IMPKAcceptReqBean)reqBean)) {
            this.showInvalidToast();
            return;
        }
        if (gameMessageModel.isFromTeamInvite()) {
            if (gameInviteService.getGameTeamInviteService() != null) {
                gameInviteService.getGameTeamInviteService().teamImInviteAccept(gameInfo.getGid(), gameMessageModel.getGameTemplate(), gameMessageModel.getTeamId(), true, gameMessageModel.getFromUserId(), (IIMTeamGameListener)new TeamGameListener(gameMessageModel));
            }
        } else if (gameInviteService.getPkGameInviteService() != null) {
            gameInviteService.getPkGameInviteService().pkGameImPkAcceptReq(reqBean, (IIMPKGameListener)new PkGameListener(gameMessageModel));
        }
        ((IGameInviteService)this.getServiceManager().getService(IGameInviteService.class)).removeGameInvite(gameMessageModel.getPkId());
    }

    @Override
    public void jumpToChat(int type) {
        if (this.mCurrentFloatData == null) {
            return;
        }
        Message message = Message.obtain();
        Bundle bundle = new Bundle();
        bundle.putLong("target_uid", this.mCurrentFloatData.targetUid);
        bundle.putInt("im_page_source", 8);
        message.setData(bundle);
        message.what = BaseMsgDef.IM_ROOM_SHOW;
        this.sendMessageSync(message);
        this.hideFloatToastView();
    }

    @Override
    public void jumpToRoom(final String roomId, final String pwdToken, final long fromUid, String roomSource) {
        if (this.mCurrentFloatData == null) {
            return;
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024017").put("function_id", "click_ok").put("message_type", "chatroom_message").put("location", "1").put("push_uid", String.valueOf(this.mCurrentFloatData.user)).put("source", String.valueOf(this.mCurrentFloatData.gameMessageModel != null ? this.mCurrentFloatData.gameMessageModel.getSource() : -1)));
        HiidoEvent event = HiidoEvent.obtain().eventId("20023799").put("function_id", "chat_invite_click").put("act_uid", String.valueOf(this.mCurrentFloatData.targetUid)).put("room_id", roomId);
        HiidoStatis.reportEvent((HiidoEvent)event);
        this.hideFloatToastView();
        if ("hago.amongus".equals(roomSource)) {
            ((IAmongUsService)this.getServiceManager().getService(IAmongUsService.class)).getSimpleTeamUpRoomStatus(roomId, new ITeamUpRoomSimpleCallback(){

                public void onResult(boolean enterRoom) {
                    if (enterRoom) {
                        NotifyPushToastController.this.enterRoom(roomId, pwdToken, fromUid);
                    } else {
                        AmongUsUtil.toAmongUsPage(null);
                    }
                }
            });
        } else {
            this.enterRoom(roomId, pwdToken, fromUid);
        }
    }

    private void enterRoom(String roomId, String pwdToken, long fromUid) {
        Object pushSource;
        EnterParam param = EnterParam.of((String)roomId).pwdToken(pwdToken).entry(6).entryInfo(new EntryInfo(FirstEntType.SUB_WINDOW, "2", null)).showTipsUis(fromUid).isInvited(true).build();
        if (this.mCurrentFloatData != null && this.mCurrentFloatData.extMap != null && (pushSource = this.mCurrentFloatData.extMap.get("push_source")) instanceof String) {
            param.preSource = (String)pushSource;
        }
        ((IRoomService)ServiceManagerProxy.getServiceManager().getService(IRoomService.class)).enterRoom(param);
    }

    @Override
    public void jumpToChannel(String roomId, String pwdToken, int type) {
        EnterParam.Builder paramBuilder = EnterParam.of((String)roomId).pwdToken(pwdToken);
        int entryFrom = 6;
        if (this.mCurrentFloatData != null && this.mCurrentFloatData.extMap != null) {
            Object backTo;
            Object pushSource;
            Object entry;
            Object token = this.mCurrentFloatData.extMap.get("token");
            if (token instanceof String && !TextUtils.isEmpty((CharSequence)((String)token))) {
                paramBuilder.putExtra("token", token);
            }
            if ((entry = this.mCurrentFloatData.extMap.get(CHANNEL_ENTER_FROM)) instanceof Integer) {
                entryFrom = (Integer)entry;
            }
            if ((pushSource = this.mCurrentFloatData.extMap.get("push_source")) instanceof String) {
                paramBuilder.preSource((String)pushSource);
            }
            if ((backTo = this.mCurrentFloatData.extMap.get("back_to_module")) instanceof String) {
                paramBuilder.putExtra("back_to_module", backTo);
            }
        }
        paramBuilder.entry(entryFrom);
        paramBuilder.entryInfo(new EntryInfo(FirstEntType.SUB_WINDOW, "2", null));
        EnterParam param = paramBuilder.build();
        ((IRoomService)ServiceManagerProxy.getServiceManager().getService(IRoomService.class)).enterRoom(param);
        this.onJumpToChannelClick(roomId, type);
        this.hideFloatToastView();
    }

    @Override
    public void startGameFlow(GameContextDef.JoinFrom joinFrom) {
        if (this.mCurrentFloatData == null) {
            return;
        }
        if (StringUtils.isNotEmpty((String)this.mCurrentFloatData.deeplinkGameId)) {
            GameInfo gameInfoByGid = ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(this.mCurrentFloatData.deeplinkGameId);
            if (gameInfoByGid != null) {
                ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).startJoinGameFlow(gameInfoByGid, GameContextDef.JoinFrom.FROM_DEEP_LINK);
            }
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024017").put("function_id", "click_ok").put("message_type", "load_success").put("location", "1").put("gid", this.mCurrentFloatData.deeplinkGameId).put("push_uid", "0").put("source", String.valueOf(this.mCurrentFloatData.gameMessageModel != null ? this.mCurrentFloatData.gameMessageModel.getSource() : -1)));
            this.mCurrentFloatData.deeplinkGameId = null;
            this.hideFloatToastView();
        }
    }

    @Override
    public void jumpToGameChannel() {
        if (this.mCurrentFloatData == null) {
            return;
        }
        if (this.mCurrentFloatData.info instanceof NotifyPushChannelToastInfo) {
            NotifyPushChannelToastInfo notifyPushChannelToastInfo = (NotifyPushChannelToastInfo)this.mCurrentFloatData.info;
            EnterParam enterParam = EnterParam.obtain((String)notifyPushChannelToastInfo.getChannelId(), (int)39);
            enterParam.setExtra("key_guide_game_id", (Object)notifyPushChannelToastInfo.getGameId());
            enterParam.entryInfo = new EntryInfo(FirstEntType.SUB_WINDOW, "2", null);
            MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.ChannelMsgDef.OFFICIAL_MSG_GAME_USER_ENTER_CHANNEL, 2, -1, (Object)enterParam);
        }
    }

    @Override
    public void jumpToWeb(String url) {
        ((IWebService)this.getServiceManager().getService(IWebService.class)).loadUrl(url, "");
    }

    @Override
    public void handleUrl(String url) {
        ((IYYUriService)this.getServiceManager().getService(IYYUriService.class)).handleUriString(url);
    }

    @Override
    public void jumpToChooseInterestLabel() {
        ((IInterestLabelService)ServiceManagerProxy.getService(IInterestLabelService.class)).openChooseInterestLabel(1, null);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025571").put("function_id", "push_click").put("push_source", "20210325"));
    }

    public void onJumpToChannelClick(String roomId, int type) {
        if (this.mCurrentFloatData == null || this.mCurrentFloatData.extMap == null) {
            return;
        }
        Object obj = this.mCurrentFloatData.extMap.get("channel_toast_from");
        if (obj instanceof Integer) {
            int channelToastFrom = (Integer)obj;
            if (type == 10 && channelToastFrom == 1) {
                ChannelInviteMgr.onChannelClick();
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "channelpg_invite_guide_click"));
            } else if (type == 9) {
                if (channelToastFrom == 2) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "emain_active_notify_click").put("gid", (String)this.mCurrentFloatData.extMap.get("gid")).put("room_id", (String)this.mCurrentFloatData.extMap.get("room_id")).put("token", (String)this.mCurrentFloatData.extMap.get("token")));
                }
            } else {
                IChannel channel = ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).getChannel(roomId);
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "room_invite_success").put("room_id", roomId).put("invite_friend_enter", "9").put("invite_id", AccountUtil.getUid() + "").put("app_type", "8").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2").put("gid", this.getPluginId(channel)));
            }
        }
    }

    public String getPluginId(IChannel channel) {
        if (channel == null || channel.getPluginService() == null) {
            return "";
        }
        ChannelPluginData data2 = channel.getPluginService().getCurPluginData();
        if (data2 == null) {
            return "";
        }
        return data2.getPluginId() == null ? "" : data2.getPluginId();
    }

    private void onImInviteAcceptRes(GameMessageModel startGameModel, String gameId, boolean isAccept, String gameUrl, String roomId, String teamId, int coinGradeType, int teamTemplete, String pkId, boolean isGoldGame, String payload) {
        MLog.info((Object)TAG, (String)"onImInviteAcceptRes gameId=%s, isAccept=%b", (Object[])new Object[]{gameId, isAccept});
        if (startGameModel == null) {
            return;
        }
        IGameInfoService iGameInfoService = (IGameInfoService)this.getServiceManager().getService(IGameInfoService.class);
        if (iGameInfoService == null) {
            return;
        }
        GameInfo gameInfo = iGameInfoService.getGameInfoByGid(gameId);
        if (isAccept) {
            ImService imService;
            final IUserInfoService userInfoService = (IUserInfoService)this.getServiceManager().getService(IUserInfoService.class);
            if (userInfoService == null) {
                return;
            }
            long otherUserInfoUid = startGameModel.getFromUserId();
            final long otherShadowUid = startGameModel.getShadowUid();
            MLog.info((Object)TAG, (String)("onImInviteAcceptRes otherUserInfoUid: " + otherUserInfoUid + ", otherShadowUid: " + otherShadowUid), (Object[])new Object[0]);
            final UserInfoKS other = userInfoService.getUserInfo(otherUserInfoUid);
            other.setValue("shadowUid", (Object)otherShadowUid);
            UserInfoKS myUserInfo = userInfoService.getUserInfo(AccountUtil.getUid());
            if (otherShadowUid != 0L) {
                UserInfoKS shadowUserInfo = userInfoService.getUserInfo(otherShadowUid);
                if (shadowUserInfo.ver > 0L) {
                    userInfoService.updateFromShadowInfo(shadowUserInfo, other);
                } else {
                    userInfoService.requestUserInfoFromServer(otherShadowUid, new OnKSProfileListCallback(){

                        public void onUISuccess(List<UserInfoKS> userInfoList) {
                            if (userInfoList == null) {
                                return;
                            }
                            for (UserInfoKS u : userInfoList) {
                                if (u.uid != otherShadowUid) continue;
                                userInfoService.updateFromShadowInfo(u, other);
                                break;
                            }
                        }

                        public void onError(String reason, long code) {
                        }
                    });
                }
            } else if (other.ver <= 0L) {
                userInfoService.requestUserInfoFromServer(otherUserInfoUid, null);
            }
            if (StringUtils.isEmpty((String)other.nick)) {
                other.setValue("nick", (Object)(startGameModel.getFromUserName() == null ? "" : startGameModel.getFromUserName()));
            }
            if (StringUtils.isEmpty((String)other.avatar)) {
                other.setValue("avatar", (Object)(startGameModel.getFromUserAvatar() == null ? "" : startGameModel.getFromUserAvatar()));
            }
            AbstractWindow window = this.getCurrentWindow();
            int windowType = -1;
            if (window == null) {
                MLog.error((Object)TAG, (String)"getCurrentWindow null", (Object[])new Object[0]);
            } else {
                windowType = window.getWindowType();
            }
            if (windowType == 100 && (imService = (ImService)this.getServiceManager().getService(ImService.class)) != null) {
                MLog.info((Object)"JoinRoom", (String)("\u6d6e\u7a97\u8df3\u8f6c\u79bb\u5f00Room:" + Utils.getSessionId((long)AccountUtil.getUid(), (long)imService.getCurrChatUid())), (Object[])new Object[0]);
            }
            if (startGameModel.isFromTeamInvite()) {
                GameTeamMatchContext teamMatchContext = new GameTeamMatchContext(GameContextDef.JoinFrom.FROM_NOTIFY);
                teamMatchContext.setGameInfo(gameInfo);
                teamMatchContext.setMultiModeCode(teamTemplete);
                teamMatchContext.setTeamId(teamId);
                teamMatchContext.setInviteUid(startGameModel.getFromUserId());
                teamMatchContext.addExtendValue("coins_game_from_invite", (Object)true);
                ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).teamMatchGame(gameInfo, teamMatchContext);
            } else if (gameInfo.getGameMode() == 7) {
                Game2V2MatchContext gameMatchContext = new Game2V2MatchContext(GameContextDef.JoinFrom.FROM_NOTIFY);
                if (gameInfo.getExt() != null) {
                    gameMatchContext.addAllKV(gameInfo.getExt());
                }
                gameMatchContext.setPkId(pkId);
                gameMatchContext.setFriendUserInfo(other);
                ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).matchGame(gameInfo, (GameMatchContext)gameMatchContext, null);
            } else {
                PkGamePlayContext gamePlayContext = new PkGamePlayContext(GameContextDef.JoinFrom.FROM_NOTIFY);
                gamePlayContext.setGameUrl(gameUrl);
                gamePlayContext.setGameInfo(gameInfo);
                gamePlayContext.setRoomId(roomId);
                gamePlayContext.addExtendValue("coin_grade", (Object)((ICoinsService)ServiceManagerProxy.getService(ICoinsService.class)).getCoinGradeInfo(coinGradeType));
                gamePlayContext.updateUserInfo(other.uid, other);
                gamePlayContext.updateUserInfo(myUserInfo.uid, myUserInfo);
                gamePlayContext.addExtendValue("isGoldGame", (Object)isGoldGame);
                gamePlayContext.addExtendValue("game_from", (Object)GameContextDef.GameFrom.GAME_ACCEPT_GAME.getId());
                gamePlayContext.addExtendValue("extend_from_h5", (Object)payload);
                ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).joinGame(gameInfo, (GamePlayContext)gamePlayContext);
            }
        }
    }

    public void onShowed() {
        if (this.mCurrentFloatData != null && this.canVibrate(this.mCurrentFloatData.notifyType)) {
            this.startVibrate();
        }
    }

    public void onExit(View v, boolean isTimeOut, boolean isClick) {
        this.hideFloatToastView();
    }

    public void onReset(View v) {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mHideNotifyTask);
        YYTaskExecutor.postToMainThread((Runnable)this.mHideNotifyTask, (long)5000L);
    }

    public void onTouchDown(View v) {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mHideNotifyTask);
    }

    public void onTouchUp(View v) {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mHideNotifyTask);
        YYTaskExecutor.postToMainThread((Runnable)this.mHideNotifyTask, (long)5000L);
    }

    private void playNotifyVoice() {
        ((IGameAudioService)this.getServiceManager().getService(IGameAudioService.class)).play("notifyToastVoice");
    }

    private boolean canVibrate(int notifyType) {
        return notifyType == 0;
    }

    private void startVibrate() {
        try {
            Vibrator vibrator = SystemServiceUtils.getVibrator((Context)this.mContext);
            int duration = 200;
            if (vibrator != null) {
                if (Build.VERSION.SDK_INT >= 26) {
                    vibrator.vibrate(VibrationEffect.createOneShot((long)duration, (int)-1));
                } else {
                    vibrator.vibrate((long)duration);
                }
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    private void showFollowMostActiveRoomNotify(Message msg) {
        MLog.info((Object)TAG, (String)"showFollowMostActiveRoomNotify", (Object[])new Object[0]);
        AbstractWindow window = this.getCurrentWindow();
        String windowName = "";
        if (window == null) {
            MLog.error((Object)TAG, (String)"getCurrentWindow null", (Object[])new Object[0]);
        } else {
            windowName = window.getName();
        }
        if (!StringUtils.equalsIgnoreCase((String)windowName, (String)"HomePageNew")) {
            MLog.info((Object)TAG, (String)("showFollowMostActiveRoomNotify is not HomePageWindow: " + windowName), (Object[])new Object[0]);
            return;
        }
        FloatToastData toastData = new FloatToastData();
        toastData.notifyType = 9;
        toastData.extMap = new HashMap<String, Object>();
        Bundle bundle = (Bundle)msg.obj;
        toastData.targetUid = bundle.getLong("uid", 0L);
        toastData.extMap.put("title", bundle.getString("title", ""));
        toastData.extMap.put("avatar", bundle.getString("avatar", ""));
        toastData.extMap.put("roomId", bundle.getString("roomId", ""));
        toastData.extMap.put("content", bundle.getString("content", ""));
        toastData.extMap.put("gid", bundle.getString("gid", ""));
        toastData.extMap.put("channel_toast_from", bundle.getInt("channel_toast_from", -1));
        toastData.extMap.put("token", bundle.getString("token", ""));
        toastData.extMap.put(CHANNEL_ENTER_FROM, 155);
        this.showFloatToastView(toastData);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "emain_active_notify_show").put("gid", bundle.getString("gid", "")).put("room_id", bundle.getString("roomId", "")).put("token", bundle.getString("token", "")));
    }

    private void addNoticeView(View view, String noticeId, String noticeStatStr) {
        if (SettingFlags.getBoolean((String)"key_team_up_recommend_win_show", (boolean)false)) {
            return;
        }
        this.mWindowMgr.addExtLayerContent(view);
        UserEnterActionStat.onFloawToastShow((String)noticeId, (String)noticeStatStr);
    }

    private class TeamGameListener
    implements IIMTeamGameListener {
        private GameMessageModel mStartGameModel;

        public TeamGameListener(GameMessageModel startGameModel) {
            this.mStartGameModel = startGameModel;
        }

        public void onTeamGameImInviteSuccessRes(String gameId, String teamId, int gameTemplate) {
        }

        public void onTeamGameImInviteFailRes(long code, String gameId) {
        }

        public void onTeamGameImCancelSuccessRes(String teamId, long targetUid) {
        }

        public void onTeamGameImCancelFailRes(long code) {
        }

        public void onTeamGameImInviteAcceptRes(String gameId, String teamId, boolean accept, int teamTemplete) {
            NotifyPushToastController.this.onImInviteAcceptRes(this.mStartGameModel, gameId, true, null, null, teamId, 0, teamTemplete, teamId, false, "");
        }

        public void onTeamGameImInviteAcceptFailRes(String gameId, String teamId, boolean accept, long code) {
            GameInfo gameInfo = ((IGameInfoService)NotifyPushToastController.this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
            if (gameInfo == null) {
                return;
            }
            TeamInviteResCodeHelper.handleResCode((long)code, (Context)NotifyPushToastController.this.mContext, (GameInfo)gameInfo);
        }

        public void onTeamGameImAcceptNotify(String gameId, String teamId, int template, boolean isAccept) {
        }
    }

    private class PkGameListener
    implements IIMPKGameListener {
        private GameMessageModel mStartGameModel;

        public PkGameListener(GameMessageModel startGameModel) {
            this.mStartGameModel = startGameModel;
        }

        public void onPkGameImPkRes(IMGameResBean imGameResBean) {
        }

        public void onPkAcceptRes(IMPKAcceptResBean imGameResBean) {
            if (imGameResBean == null || this.mStartGameModel == null) {
                return;
            }
            if (imGameResBean.getCode() == (long)ERet.kRetErrImPkInviteOutOfDate.getValue()) {
                MLog.info((Object)NotifyPushToastController.TAG, (String)"onPkAcceptRes outOfDate", (Object[])new Object[0]);
                NotifyPushToastController.this.hideFloatToastView();
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ToastUtils.showToast((Context)NotifyPushToastController.this.mContext, (String)ResourceUtils.getString((int)R.string.im_invitation_canceled_tips), (int)0);
                    }
                });
                return;
            }
            NotifyPushToastController.this.onImInviteAcceptRes(this.mStartGameModel, imGameResBean.getGameId(), imGameResBean.isAccept(), imGameResBean.getResource().getUrl(), imGameResBean.getResource().getRoomid(), null, imGameResBean.getCoinGradeType(), 0, imGameResBean.getPkId(), imGameResBean.isGoldGame(), imGameResBean.getResource().getPayload());
        }

        public void onPKGameNotify(IMGamePkNotifyBean imGameResBean) {
        }

        public void onPKGameAccptNotify(IMGamePkAcceptNotifyBean imGameResBean) {
        }

        public void onPKGameCancelNotify(IMGamePkCancelNotifyBean imGameResBean) {
        }

        public void onPkCancelRes() {
        }

        public void onPkFail(BaseGameReqBean gameReqBean) {
        }
    }

    private static class FloatToastData {
        public final String uuid = "uuid_" + System.currentTimeMillis();
        public int notifyType;
        public long targetUid = 0L;
        @Nullable
        public GameMessageModel gameMessageModel;
        @Nullable
        public Map<String, Object> extMap;
        @Nullable
        public Object info;
        @Nullable
        public View view;
        public String deeplinkGameId;
        public NotifyPushToastInfo sitDownInfo;
        public int priority = 0;
        public long duration = 5000L;
        public int sex;
        public int isFriend;
        public long user;
        public String pushSource;
    }
}

