/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.protocol;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.gson.reflect.TypeToken;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im.model.chat.Content;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.PushContent;
import com.hummer.im.model.chat.contents.Notification;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.model.id.User;
import com.hummer.im.service.ChatService;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.ICIMService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.im.Utils;
import com.yy.hiyo.im.base.IMsgReqCallback;
import com.yy.hiyo.im.base.ImMsgReqParam;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.proto.GlobalBanInterface;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.im.MsgProtocolHelper;
import com.yy.im.cim.CIMMsgItem;
import com.yy.im.protocol.MsgProtocolSwitch;
import com.yy.im.protocol.MsgRequestResult;
import common.Header;
import ikxd.msg.ERet;
import ikxd.msg.IM;
import ikxd.msg.MsgInnerType;
import ikxd.msg.MsgItem;
import ikxd.msg.MsgType;
import ikxd.msg.Uri;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public enum MsgProtocolProxy {
    INSTANCE;

    public static final String LINK_KEY = "links";
    private static final String TAG = "[Hago-CIM]";
    private CIMMsgListenerImpl cimMsgListener = null;

    public void pullMsg(int pullType, final IMsgCallback callback) {
        boolean isSwitch = MsgProtocolSwitch.INSTANCE.isSwitch();
        FeatureLog.i((String)"FTMessage", (String)"pullMsg, isSwitch:%s", (Object[])new Object[]{isSwitch});
        if (!isSwitch && ProtoManager.getInstance().isWSConnected()) {
            IM messageBytes = MsgProtocolHelper.Instance.initPullMsgReq(pullType);
            MsgProtocolHelper.Instance.sendRequest(messageBytes, new IMsgReqCallback<IM>(){

                public void onSucceed(final IM message) {
                    if (message == null || message.pull_msg_res == null) {
                        return;
                    }
                    List msgList = message.pull_msg_res.msgs;
                    if (msgList == null) {
                        return;
                    }
                    ArrayList<MsgData> msgDataList = new ArrayList<MsgData>();
                    for (MsgItem item : msgList) {
                        MsgData msgData = MsgProtocolProxy.this.createMsgData(item);
                        msgDataList.add(msgData);
                    }
                    if (callback != null) {
                        callback.onSucceed(msgDataList, new IMsgCallback.IGetMsgParsedData(){

                            @Override
                            public void onParsed(List<String> msgs) {
                                if (msgs == null || msgs.size() == 0) {
                                    return;
                                }
                                MsgProtocolProxy.this.ackMsg(msgs, message.header);
                            }
                        });
                    }
                }

                public void onFailed(long code, String reason) {
                    if (callback != null) {
                        callback.onFailed(code, reason);
                    }
                }
            }, true);
        } else {
            FeatureLog.i((String)"FTMessage", (String)"CIM\u62c9\u53d6\u6d88\u606f", (Object[])new Object[0]);
        }
    }

    private void ackMsg(List<String> segList, Header header2) {
        boolean isSwitch = MsgProtocolSwitch.INSTANCE.isSwitch();
        FeatureLog.i((String)"FTMessage", (String)"ackMsg, isSwitch:%s", (Object[])new Object[]{isSwitch});
        if (!isSwitch) {
            IM reqBytes = MsgProtocolHelper.Instance.initAckMsgReq(segList, header2);
            MsgProtocolHelper.Instance.sendRequest(reqBytes, null, false);
        } else {
            FeatureLog.i((String)"FTMessage", (String)"CIM Not Impl,ToDo", (Object[])new Object[0]);
        }
    }

    public void sendMsg(String mySelfAvatar, final long toUserId, final ImMsgReqParam msgReqParamObject, final IMsgSendCallback callback) {
        boolean isSwitch = MsgProtocolSwitch.INSTANCE.isSwitch();
        FeatureLog.i((String)"FTMessage", (String)"sendMsg, isSwitch:%s", (Object[])new Object[]{isSwitch});
        if (GlobalBanInterface.INSTANCE.isBandAction() && msgReqParamObject != null) {
            long msgInnerType = msgReqParamObject.getInnerType();
            if ((long)MsgInnerType.kMsgInnerBigEmoji.getValue() == msgInnerType || (long)MsgInnerType.kMsgInnerEm.getValue() == msgInnerType || (long)MsgInnerType.kMsgInnerTxt.getValue() == msgInnerType || (long)MsgInnerType.kMsgInnerPic.getValue() == msgInnerType || (long)MsgInnerType.kMsgInnerGif.getValue() == msgInnerType || (long)MsgInnerType.kMsgInnerIMTxtPic.getValue() == msgInnerType || (long)MsgInnerType.kMsgInnerVoice.getValue() == msgInnerType || (long)MsgInnerType.kMsgInnerIndependentGameInvite.getValue() == msgInnerType || (long)MsgInnerType.kMsgInnerPK.getValue() == msgInnerType) {
                GlobalBanInterface.INSTANCE.notifyBanDialog();
                String msg = "ban action error: " + msgInnerType;
                MLog.error((Object)TAG, (String)msg, (Object[])new Object[0]);
                if (callback != null) {
                    callback.onFailed(-1L, msg);
                }
                return;
            }
        }
        if (!isSwitch) {
            IM messageBytes = MsgProtocolHelper.Instance.initMsgReq(msgReqParamObject);
            MsgProtocolHelper.Instance.sendRequest(messageBytes, new IMsgReqCallback<IM>(){

                public void onSucceed(IM message) {
                    if (message == null || message.send_msg_res == null) {
                        return;
                    }
                    if (callback != null) {
                        MsgRequestResult requestResult = new MsgRequestResult();
                        requestResult.setSendTime(message.send_msg_res.send_time);
                        requestResult.setSeq(message.send_msg_res.seq);
                        requestResult.setUri(message.uri);
                        requestResult.setServerSeq(message.send_msg_res.server_seq);
                        callback.onSucceed(requestResult);
                        if (msgReqParamObject.getInnerType() < (long)MsgInnerType.kMsgInnerPlaceholdMin.getValue()) {
                            MsgProtocolProxy.this.notifySendMsgSuccess(toUserId);
                        }
                    }
                }

                public void onFailed(long code, String reason) {
                    if (callback != null) {
                        callback.onFailed(code, reason);
                    }
                }
            }, false);
        } else {
            ICIMService icimService = (ICIMService)ServiceManagerProxy.getServiceManager().getService(ICIMService.class);
            if (icimService == null || !icimService.isOpened()) {
                return;
            }
            final Message chatMessage = new Message();
            CIMMsgItem kxdChatContent = new CIMMsgItem(0L, msgReqParamObject.getInnerType(), msgReqParamObject.getMsg());
            if (this.isNeedPush(msgReqParamObject.getInnerType())) {
                String limitPushContent = msgReqParamObject.getPushContent() == null ? "" : msgReqParamObject.getPushContent();
                PushContent kxdPushContent = new PushContent(msgReqParamObject.getPushTitle(), limitPushContent, msgReqParamObject.getPushPayload().getBytes(), mySelfAvatar == null ? "" : mySelfAvatar);
                if (kxdPushContent == null) {
                    if (callback != null) {
                        FeatureLog.i((String)"FTMessage", (String)"CIM\u6d88\u606f\u53d1\u9001:push\u53c2\u6570\u8d85\u8fc7\u9650\u5236", (Object[])new Object[0]);
                        MsgRequestResult requestResult = new MsgRequestResult();
                        requestResult.setSendTime(System.currentTimeMillis());
                        requestResult.setSeq(String.valueOf(System.currentTimeMillis()));
                        requestResult.setUri(Uri.kUriSendMsgRes);
                        requestResult.setServerSeq(chatMessage.getUuid());
                        callback.onSucceed(requestResult);
                    }
                    return;
                }
                chatMessage.setPushContent(kxdPushContent);
            }
            chatMessage.setReceiver((Identifiable)new User(toUserId));
            chatMessage.setContent((Content)kxdChatContent);
            ((ChatService)HMR.getService(ChatService.class)).send(chatMessage, new HMR.Completion(){

                public void onSuccess() {
                    FeatureLog.i((String)"FTMessage", (String)"CIM\u6d88\u606f\u53d1\u9001\u6210\u529f", (Object[])new Object[0]);
                    if (callback == null) {
                        return;
                    }
                    MsgRequestResult requestResult = new MsgRequestResult();
                    requestResult.setSendTime(chatMessage.getTimestamp());
                    requestResult.setSeq(String.valueOf(System.currentTimeMillis()));
                    requestResult.setUri(Uri.kUriSendMsgRes);
                    requestResult.setUuid(chatMessage.getUuid());
                    callback.onSucceed(requestResult);
                    if (msgReqParamObject.getInnerType() < (long)MsgInnerType.kMsgInnerPlaceholdMin.getValue()) {
                        MsgProtocolProxy.this.notifySendMsgSuccess(toUserId);
                    }
                }

                public void onFailed(Error err) {
                    FeatureLog.i((String)"FTMessage", (String)("CIM\u6d88\u606f\u53d1\u9001\u5931\u8d25, error: " + err), (Object[])new Object[0]);
                    if (callback == null) {
                        return;
                    }
                    if (err.code == ERet.kRetAIIllegalImage.getValue()) {
                        MsgRequestResult requestResult = new MsgRequestResult();
                        requestResult.setSendTime(chatMessage.getTimestamp());
                        requestResult.setSeq(String.valueOf(System.currentTimeMillis()));
                        requestResult.setUri(Uri.kUriSendMsgRes);
                        callback.onSucceed(requestResult);
                    } else {
                        callback.onFailed(err.code, err.desc);
                    }
                }
            });
        }
    }

    public void revokeMsg(ImMsgReqParam reqParam, final IMsgReqCallback callback) {
        final Message message = new Message();
        message.setUuid(reqParam.getUuid());
        message.setSender((Identifiable)new User(reqParam.getFromUid()));
        message.setReceiver((Identifiable)new User(reqParam.getToUid()));
        message.setTimestamp(System.currentTimeMillis());
        ((ChatService)HMR.getService(ChatService.class)).revoke(message, new HMR.Completion(){

            public void onSuccess() {
                if (callback != null) {
                    callback.onSucceed((Object)message);
                }
            }

            public void onFailed(Error err) {
                if (callback != null) {
                    callback.onFailed((long)err.code, err.desc);
                }
            }
        });
    }

    private MsgData createMsgData(MsgItem item) {
        MsgData msgData = new MsgData();
        msgData.setAvatar(item.avatar);
        msgData.setFromUid(item.from_uid.longValue());
        msgData.setMsg(item.msg);
        msgData.setMsgInnertype(item.msg_innertype.longValue());
        msgData.setMsgType(item.msg_type.longValue());
        msgData.setPushContent(item.push_content);
        msgData.setPushid(item.pushid.longValue());
        msgData.setPushContent(item.push_content);
        msgData.setPushPayload(item.push_payload);
        msgData.setPushTitle(item.push_title);
        msgData.setSendTime(item.send_time.longValue());
        msgData.setSeq(item.seq);
        msgData.setSessionId(item.session_id);
        return msgData;
    }

    public void registerCIMListener(CIMMsgListener listener) {
        if (this.cimMsgListener == null) {
            this.cimMsgListener = new CIMMsgListenerImpl(listener);
        }
    }

    private MsgData createMsgData(Long senderUid, Long receiverUid, Long timeStamp, Integer randSeq, CIMMsgItem kxdChatContent, PushContent pushContent, String uuid, Map<String, String> extra) {
        String linkJson;
        MsgData msgData = new MsgData();
        msgData.setAvatar(pushContent == null ? "" : pushContent.getIconUrl());
        msgData.setFromUid(senderUid.longValue());
        msgData.setMsg(kxdChatContent.getMsg());
        msgData.setMsgInnertype(kxdChatContent.getInnerType());
        msgData.setMsgType((long)MsgType.kMsgTypeUser.getValue());
        msgData.setPushContent(pushContent == null ? "" : pushContent.getContent());
        msgData.setPushid(kxdChatContent.getPushId());
        msgData.setPushPayload(pushContent == null ? "" : new String(pushContent.getPayload()));
        msgData.setPushTitle(pushContent == null ? "" : pushContent.getTitle());
        msgData.setSendTime(timeStamp.longValue());
        msgData.setUuid(uuid);
        long ts = timeStamp / 1000L * 65536L + (long)(randSeq % 65536);
        msgData.setSeq(String.valueOf(ts));
        String sessionId2 = Utils.getSessionId((long)senderUid, (long)receiverUid);
        msgData.setSessionId(sessionId2);
        if (extra != null && !TextUtils.isEmpty((CharSequence)(linkJson = extra.get(LINK_KEY)))) {
            try {
                Map linkMap = (Map)JsonParser.parseJsonTye((String)linkJson, (Type)new TypeToken<Map<String, Integer>>(){}.getType());
                if (linkMap != null) {
                    msgData.setLinkMap(linkMap);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return msgData;
    }

    private boolean isNeedPush(long innerType) {
        if (innerType >= (long)MsgInnerType.kMsgInnerPlaceholdMin.getValue() && innerType <= (long)MsgInnerType.kMsgInnerPlaceholdMax.getValue()) {
            return false;
        }
        return innerType != (long)MsgInnerType.kMsgInnerAcceptPk.getValue() && innerType != (long)MsgInnerType.kMsgInnerRejectPk.getValue() && innerType != (long)MsgInnerType.kMsgInnerCancelPk.getValue() && innerType != (long)MsgInnerType.kMsgInnerGLike.getValue() && innerType != (long)MsgInnerType.kMsgInnerBBSLike.getValue();
    }

    private void notifySendMsgSuccess(long toUserId) {
        com.yy.framework.core.Notification notification = com.yy.framework.core.Notification.obtain((int)NotificationIdDef.SEND_IM_MSG_SUCCESS);
        notification.extObj = toUserId;
        NotificationCenter.getGlobalInstance().notify(notification);
    }

    private class CIMMsgListenerImpl
    implements ChatService.MessageListener {
        private CIMMsgListener mCIMListener = null;

        CIMMsgListenerImpl(CIMMsgListener listener) {
            this.mCIMListener = listener;
            ((ChatService)HMR.getService(ChatService.class)).addMessageListener(null, (ChatService.MessageListener)this);
        }

        public void beforeSendingMessage(@NonNull Message message) {
        }

        public void afterSendingMessage(@NonNull Message message) {
        }

        public void beforeReceivingMessage(@NonNull Message message) {
        }

        public void afterReceivingMessage(@NonNull Message message) {
            if (!(message.getContent() instanceof CIMMsgItem) && !(message.getContent() instanceof Notification)) {
                return;
            }
            boolean isSwitch = MsgProtocolSwitch.INSTANCE.isSwitch();
            FeatureLog.i((String)"FTMessage", (String)"recv cim msg, isSwitch:%s, message:%s", (Object[])new Object[]{isSwitch, message});
            if (isSwitch) {
                boolean isGift;
                if (message.getContent() instanceof Notification) {
                    this.handleNotificationMessage(message);
                    return;
                }
                ArrayList<MsgData> msgDataList = new ArrayList<MsgData>();
                CIMMsgItem kxdChatContent = (CIMMsgItem)message.getContent();
                PushContent pushContent = message.getPushContent();
                MsgData msgData = MsgProtocolProxy.this.createMsgData(message.getSender().getId(), AccountUtil.getUid(), message.getTimestamp(), message.getUuid().hashCode(), kxdChatContent, pushContent, message.getUuid(), message.getKvExtra());
                msgDataList.add(msgData);
                boolean isFromMe = AccountUtil.getUid() == message.getSender().getId();
                boolean bl = isGift = msgData.getMsgInnertype() == (long)MsgInnerType.kMsgInnerRechargeGift.getValue();
                if (isFromMe && !isGift) {
                    MLog.warn((Object)MsgProtocolProxy.TAG, (String)("send by myself uuid:" + message.getUuid()), (Object[])new Object[0]);
                    return;
                }
                if (this.mCIMListener != null) {
                    this.mCIMListener.onRecv(msgDataList);
                } else {
                    MLog.warn((Object)MsgProtocolProxy.TAG, (String)"no msg item handler for MsgProtocolProxy", (Object[])new Object[0]);
                }
            }
        }

        public void onRevokeMessage(@NonNull Message message) {
            MLog.debug((Object)MsgProtocolProxy.TAG, (String)("onRevokeMessage = " + message), (Object[])new Object[0]);
            if (this.mCIMListener != null) {
                this.mCIMListener.onRevokeMessage(message);
            }
        }

        public void onDeleteMessage(@NonNull Message message) {
            MLog.debug((Object)MsgProtocolProxy.TAG, (String)("onRevokeMessage = " + message), (Object[])new Object[0]);
        }

        private void handleNotificationMessage(Message message) {
            FeatureLog.i((String)"FTMessage", (String)"recv notification msg", (Object[])new Object[0]);
            ArrayList<MsgData> msgDataList = new ArrayList<MsgData>();
            try {
                Notification notification = (Notification)message.getContent();
                JSONObject hagoMsg = JsonParser.obtainJSONObject((String)new String(notification.getNotification()));
                CIMMsgItem msgItemContent = new CIMMsgItem(hagoMsg);
                if (msgItemContent == null) {
                    MLog.warn((Object)MsgProtocolProxy.TAG, (String)("parse notify content to msgitem null:" + message.getContent()), (Object[])new Object[0]);
                    return;
                }
                if (AccountUtil.getUid() == message.getSender().getId()) {
                    MLog.warn((Object)MsgProtocolProxy.TAG, (String)("send by myself uuid:" + message.getUuid()), (Object[])new Object[0]);
                    return;
                }
                PushContent pushContent = message.getPushContent();
                MsgData msgData = MsgProtocolProxy.this.createMsgData(message.getSender().getId(), AccountUtil.getUid(), message.getTimestamp(), message.getUuid().hashCode(), msgItemContent, pushContent, message.getUuid(), message.getKvExtra());
                msgDataList.add(msgData);
                if (this.mCIMListener != null) {
                    this.mCIMListener.onRecv(msgDataList);
                } else {
                    MLog.warn((Object)MsgProtocolProxy.TAG, (String)"no msg item handler for MsgProtocolProxy", (Object[])new Object[0]);
                }
            }
            catch (Throwable t) {
                MLog.warn((Object)MsgProtocolProxy.TAG, (String)("parse notify content to msgitem null:" + message.getContent()), (Object[])new Object[0]);
            }
        }
    }

    public static interface CIMMsgListener {
        public void onRecv(List<MsgData> var1);

        public void onRevokeMessage(Message var1);
    }

    public static interface IMsgSendCallback {
        public void onSucceed(MsgRequestResult var1);

        public void onFailed(long var1, String var3);
    }

    public static interface IMsgCallback {
        public void onSucceed(List<MsgData> var1, IGetMsgParsedData var2);

        public void onFailed(long var1, String var3);

        public static interface IGetMsgParsedData {
            public void onParsed(List<String> var1);
        }
    }
}

