/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.parse.item;

import android.os.Bundle;
import android.os.Message;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.im.ImMsgUtils;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.im.base.data.MessageBuilder;
import com.yy.im.R;
import com.yy.im.parse.IImMsgParse;
import com.yy.im.parse.IMsgParseCtlCallback;
import org.json.JSONException;
import org.json.JSONObject;

public class MsgInnerRedPacketInvite
extends IImMsgParse {
    private IMsgParseCtlCallback ctlCallback;

    public MsgInnerRedPacketInvite(IMsgParseCtlCallback ctlCallback) {
        this.ctlCallback = ctlCallback;
    }

    @Override
    @Nullable
    public MessageBuilder parseMsg(MsgData item) {
        Pair pair = ImMsgUtils.parseMsgJson((String)item.getMsg());
        JSONObject msgJson = (JSONObject)pair.first;
        JSONObject payloadJson = (JSONObject)pair.second;
        MessageBuilder messageBuilder = MessageBuilder.newInstance();
        JSONObject vchatObject = msgJson.optJSONObject("vchat");
        JSONObject familyObject = msgJson.optJSONObject("family");
        if (null != vchatObject) {
            String pushSource = "10";
            if (StringUtils.isNotEmpty((String)item.getPushPayload())) {
                try {
                    JSONObject pushPayload = JsonParser.obtainJSONObject((String)item.getPushPayload());
                    if (StringUtils.isNotEmpty((String)pushPayload.optString("push_source"))) {
                        pushSource = pushPayload.optString("push_source");
                    }
                }
                catch (JSONException e) {
                    MLog.error((Object)this.TAG, (String)"parse push payload error", (Object[])new Object[0]);
                }
            }
            messageBuilder.content(ResourceUtils.getString((int)R.string.tips_channel_invite_im_content)).clientSendTime(item.getSendTime()).sendTime(item.getSendTime()).sendByMe(false).msgId(StringUtils.parseLong((String)item.getSeq())).sessionId(item.getSessionId()).msgType(30).uid(item.getFromUid()).roomId(vchatObject.optString("roomid")).imageUrl(vchatObject.optString("img_url")).reserve1(vchatObject.optString("packet_id")).roomName(vchatObject.optString("room_title")).roomHostAvatar(vchatObject.optString("owner_avatar")).roomPwdToken(vchatObject.optString("room_token")).reserve2(familyObject != null ? familyObject.optString("inviteUrl", "") : "");
            this.ctlCallback.showDefaultNotification(item, ResourceUtils.getString((int)R.string.tips_channel_invite_toast), "", pushSource);
            if (RuntimeContext.sIsForeground) {
                Message msg = Message.obtain();
                msg.what = BaseMsgDef.VOICE_ROOM_INVITE_TOAST;
                Bundle bundle = new Bundle();
                bundle.putString("roomId", vchatObject.optString("roomid"));
                bundle.putLong("fromUid", item.getFromUid());
                bundle.putString("roomPwdToken", vchatObject.has("room_token") ? vchatObject.optString("room_token") : "");
                bundle.putString("source", String.valueOf(msgJson.optInt("source")));
                bundle.putString("push_source", pushSource);
                bundle.putString("inviteUrl", familyObject != null ? familyObject.optString("inviteUrl", "") : "");
                msg.obj = bundle;
                MsgDispatcher.getInstance().sendMessage(msg);
            }
        }
        return messageBuilder;
    }
}

