/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.parse;

import android.content.Context;
import android.util.Pair;
import android.util.SparseArray;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.im.ImMsgUtils;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.im.base.data.IIMdata;
import com.yy.im.chatim.BaseImParse;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.ExpiredMsgFilter;
import com.yy.im.parse.IImMsgParse;
import com.yy.im.parse.IMsgParseCtlCallback;
import com.yy.im.parse.MsgParseHandler;
import com.yy.im.parse.item.MsgEnterTeamUpChannel;
import com.yy.im.parse.item.MsgFriendGuide;
import com.yy.im.parse.item.MsgImGameIncompatible;
import com.yy.im.parse.item.MsgImGameInvalid;
import com.yy.im.parse.item.MsgImOnline;
import com.yy.im.parse.item.MsgImUserLeaveRoom;
import com.yy.im.parse.item.MsgInnerAgreeFriend;
import com.yy.im.parse.item.MsgInnerBBSAttention;
import com.yy.im.parse.item.MsgInnerBBSCommonNotify;
import com.yy.im.parse.item.MsgInnerBBSDigest;
import com.yy.im.parse.item.MsgInnerBbsFollowNotice;
import com.yy.im.parse.item.MsgInnerBbsNotice;
import com.yy.im.parse.item.MsgInnerBbsShare;
import com.yy.im.parse.item.MsgInnerBigEmoji;
import com.yy.im.parse.item.MsgInnerBindPermission;
import com.yy.im.parse.item.MsgInnerCertification;
import com.yy.im.parse.item.MsgInnerChannelInvite;
import com.yy.im.parse.item.MsgInnerChannelInviteShare;
import com.yy.im.parse.item.MsgInnerChannelNotify;
import com.yy.im.parse.item.MsgInnerChannelSitDownNotify;
import com.yy.im.parse.item.MsgInnerContactsQuizOfficialWelcom;
import com.yy.im.parse.item.MsgInnerContactsQuizRegisterNotify;
import com.yy.im.parse.item.MsgInnerCustomerServiceNotify;
import com.yy.im.parse.item.MsgInnerEm;
import com.yy.im.parse.item.MsgInnerEmojiLike;
import com.yy.im.parse.item.MsgInnerFloating;
import com.yy.im.parse.item.MsgInnerFollowNotice;
import com.yy.im.parse.item.MsgInnerFriend;
import com.yy.im.parse.item.MsgInnerFriendInvite;
import com.yy.im.parse.item.MsgInnerGiftWall;
import com.yy.im.parse.item.MsgInnerImGift;
import com.yy.im.parse.item.MsgInnerImImgIllegalNotify;
import com.yy.im.parse.item.MsgInnerLike;
import com.yy.im.parse.item.MsgInnerMatchFriend;
import com.yy.im.parse.item.MsgInnerNewFriend;
import com.yy.im.parse.item.MsgInnerNoSupport;
import com.yy.im.parse.item.MsgInnerOfficialAccount;
import com.yy.im.parse.item.MsgInnerOutOfLine;
import com.yy.im.parse.item.MsgInnerPic;
import com.yy.im.parse.item.MsgInnerPkOverdue;
import com.yy.im.parse.item.MsgInnerPostLike;
import com.yy.im.parse.item.MsgInnerPostTagRemovedNotice;
import com.yy.im.parse.item.MsgInnerPush;
import com.yy.im.parse.item.MsgInnerRadioChannelNotify;
import com.yy.im.parse.item.MsgInnerRecharge;
import com.yy.im.parse.item.MsgInnerRechargeWarning;
import com.yy.im.parse.item.MsgInnerRecommendFriend;
import com.yy.im.parse.item.MsgInnerRedPacketInvite;
import com.yy.im.parse.item.MsgInnerReport;
import com.yy.im.parse.item.MsgInnerSmallShare;
import com.yy.im.parse.item.MsgInnerSocialTxtPic;
import com.yy.im.parse.item.MsgInnerStartShowNotice;
import com.yy.im.parse.item.MsgInnerTagAdmin;
import com.yy.im.parse.item.MsgInnerTxt;
import com.yy.im.parse.item.MsgInnerTxtPic;
import com.yy.im.parse.item.MsgInnerVoice;
import com.yy.im.parse.item.MsgInnerVoiceChatInvite;
import com.yy.im.parse.item.MsgInnerWinner;
import com.yy.im.parse.item.MsgInnnerFamilyRank;
import com.yy.im.parse.item.MsgTeamUpGameCard;
import ikxd.msg.MsgInnerType;
import org.json.JSONObject;

public class ImMsgParseDispatch {
    private static String TAG = "ImMsgParseDispatch";
    private final SparseArray<BaseImParse> msgParseList = new SparseArray();
    private final SparseArray<IImMsgParse> msg = new SparseArray();
    private final MsgInnerNoSupport msgInnerNoSupport;
    private IMsgParseCtlCallback callback;
    public static final int IM_ONLINE_MSG = 1000;
    public static final int GAME_INVALID_MSG = 1001;
    public static final int GAME_INCOMPATIBLE_MSG = 1002;
    public static final int IM_USER_LEAVE_ROOM_MSG = 1003;
    public static final int IM_GAME_RESULT_SAY_HELLO = 1004;
    public static final int IM_TEAM_UP_GAME_CARD = 1005;
    public static final int IM_INVITE_ENTER_TEAM_UP_CHANNEL = 1006;

    public ImMsgParseDispatch(Context context) {
        this.callback = new MsgParseHandler(context);
        this.registerParse(MsgInnerType.kMsgInnerTxt.getValue(), new MsgInnerTxt(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerPic.getValue(), new MsgInnerPic(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerTxtPic.getValue(), new MsgInnerTxtPic(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerLike.getValue(), new MsgInnerLike(this.callback));
        this.registerParse(1000, new MsgImOnline(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerAgreeFriend.getValue(), new MsgInnerAgreeFriend(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerMatchFriend.getValue(), new MsgInnerMatchFriend());
        this.registerParse(MsgInnerType.kMsgInnerEmojiLike.getValue(), new MsgInnerEmojiLike(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerReport.getValue(), new MsgInnerReport(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerEm.getValue(), new MsgInnerEm(this.callback));
        this.registerParse(1001, new MsgImGameInvalid(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerNewFriend.getValue(), new MsgInnerNewFriend(this.callback));
        this.registerParse(1002, new MsgImGameIncompatible());
        this.registerParse(MsgInnerType.kMsgInnerFriend.getValue(), new MsgInnerFriend(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerOutOfLine.getValue(), new MsgInnerOutOfLine());
        this.registerParse(MsgInnerType.kMsgInnerContactsQuizRegisterNotify.getValue(), new MsgInnerContactsQuizRegisterNotify(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerContactsQuizOfficialWelcome.getValue(), new MsgInnerContactsQuizOfficialWelcom(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerVoiceChatInvite.getValue(), new MsgInnerVoiceChatInvite(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerRoomRedPacket.getValue(), new MsgInnerRedPacketInvite(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerPush.getValue(), new MsgInnerPush(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerCustomerServiceNotify.getValue(), new MsgInnerCustomerServiceNotify(this.callback));
        this.registerParse(1003, new MsgImUserLeaveRoom());
        this.registerParse(MsgInnerType.kMsgInnerRechargeGift.getValue(), new MsgInnerImGift(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerRechargeWarn.getValue(), new MsgInnerRechargeWarning(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerIMTxtPic.getValue(), new MsgInnerTxtPic(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerFloating.getValue(), new MsgInnerFloating(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerWinner.getValue(), new MsgInnerWinner(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerChannelInvite.getValue(), new MsgInnerChannelInvite(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerClickTextJumpIM.getValue(), new MsgInnerRecommendFriend(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerFriendGuide.getValue(), new MsgFriendGuide());
        this.registerParse(MsgInnerType.kMsgInnerVoice.getValue(), new MsgInnerVoice(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerBigEmoji.getValue(), new MsgInnerBigEmoji(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerOfficialAccount.getValue(), new MsgInnerOfficialAccount(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerSocialTxtPic.getValue(), new MsgInnerSocialTxtPic(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerAnchorChannelSitdownNotify.getValue(), new MsgInnerChannelSitDownNotify.MgsInnerAnchorSitDownNotify(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerFriendChannelSitdownNotify.getValue(), new MsgInnerChannelSitDownNotify.MsgInnerFriendSitDownNotify(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerIMImageIllegalNotify.getValue(), new MsgInnerImImgIllegalNotify(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerChannelNotify.getValue(), new MsgInnerChannelNotify(this.callback));
        this.registerParse(MsgInnerType.kMsginnerShareSmallCard.getValue(), new MsgInnerSmallShare(this.callback));
        this.registerParse(MsgInnerType.KMsgInnerGiftwall.getValue(), new MsgInnerGiftWall(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerBBSPost.getValue(), new MsgInnerBBSAttention(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerBBSDigestPostNotify.getValue(), new MsgInnerBBSDigest(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerPKOverdue.getValue(), new MsgInnerPkOverdue(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerRecharge.getValue(), new MsgInnerRecharge(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerFollow.getValue(), new MsgInnerFollowNotice(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerCertification.getValue(), new MsgInnerCertification(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerChannelMemberInivte.getValue(), new MsgInnerChannelInviteShare(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerFriendsJoinHago.getValue(), new MsgInnerFriendInvite(this.callback));
        this.registerParse(MsgInnerType.KMsgInnerFamilyRank.getValue(), new MsgInnnerFamilyRank(this.callback));
        if (!RuntimeContext.isHagoPartySdk()) {
            this.registerParse(MsgInnerType.kMsgInnerBbsShare.getValue(), new MsgInnerBbsShare(this.callback));
            this.registerParse(MsgInnerType.kMsgInnerBBSLike.getValue(), new MsgInnerPostLike());
            this.registerParse(MsgInnerType.kMsgInnerBBS.getValue(), new MsgInnerBbsNotice(this.callback));
            this.registerParse(MsgInnerType.kMsgInnerBBSCommonNotify.getValue(), new MsgInnerBBSCommonNotify(this.callback));
            this.registerParse(MsgInnerType.kMsgInnerBBSNotify.getValue(), new MsgInnerBbsFollowNotice(this.callback));
            this.registerParse(MsgInnerType.kMsgInnerBBSPost.getValue(), new MsgInnerBBSAttention(this.callback));
            this.registerParse(MsgInnerType.kMsgInnerBBSDigestPostNotify.getValue(), new MsgInnerBBSDigest(this.callback));
            this.registerParse(MsgInnerType.kMsgInnerPostTagRemoved.getValue(), new MsgInnerPostTagRemovedNotice(this.callback));
            this.registerParse(MsgInnerType.kMsgInnerTagAdmin.getValue(), new MsgInnerTagAdmin(this.callback));
            this.registerParse(MsgInnerType.kMsgInnerRadioPush.getValue(), new MsgInnerRadioChannelNotify(this.callback));
            this.registerParse(MsgInnerType.kMsgInnerGuideBindFBContact.getValue(), new MsgInnerBindPermission(this.callback));
        }
        this.registerParse(1005, new MsgTeamUpGameCard(this.callback));
        this.registerParse(1006, new MsgEnterTeamUpChannel(this.callback));
        this.registerParse(MsgInnerType.kMsgInnerFollowHostNotice.getValue(), new MsgInnerStartShowNotice(this.callback));
        this.msgInnerNoSupport = new MsgInnerNoSupport();
    }

    public synchronized IIMdata parseMsg(MsgData msgItem) {
        if (msgItem == null) {
            return null;
        }
        int type = (int)msgItem.getMsgInnertype();
        MLog.info((Object)TAG, (String)"parseMsg sessionId:%s\uff0cmsgInnertype:%d", (Object[])new Object[]{msgItem.getSessionId(), type});
        IIMdata builder = null;
        if (!RuntimeContext.sIsDebuggable) {
            try {
                builder = this.getParse(msgItem, type);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        } else {
            builder = this.getParse(msgItem, type);
        }
        return builder;
    }

    public synchronized IIMdata parseMsg(ImMessageDBBean msgItem) {
        if (msgItem == null) {
            return null;
        }
        int type = msgItem.getMsgType();
        IIMdata builder = null;
        if (!RuntimeContext.sIsDebuggable) {
            try {
                builder = this.getIMData(msgItem, type);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        } else {
            builder = this.getIMData(msgItem, type);
        }
        return builder;
    }

    private IIMdata getIMData(ImMessageDBBean msgItem, int type) {
        BaseImParse parse = (BaseImParse)this.msgParseList.get(type);
        Object baseImData = parse != null ? parse.parseImDBBean(msgItem) : new ChatMessageData(msgItem);
        return baseImData;
    }

    private IIMdata getParse(MsgData msgItem, int type) {
        IImMsgParse oldParse;
        BaseImParse parse = (BaseImParse)this.msgParseList.get(type);
        Object imData = parse != null ? parse.parseMsg(msgItem) : ((oldParse = (IImMsgParse)this.msg.get(type)) != null ? oldParse.parseMsg(msgItem) : this.msgInnerNoSupport.parseMsg(msgItem));
        return this.appendCommonParam((IIMdata)imData, msgItem);
    }

    private void registerParse(int type, BaseImParse parse) {
        if (parse != null && this.msgParseList.get(type) == null) {
            this.msgParseList.put(type, (Object)parse);
        }
    }

    private void registerParse(int type, IImMsgParse parse) {
        if (parse != null && this.msg.get(type) == null) {
            this.msg.put(type, (Object)parse);
        }
    }

    private IIMdata appendCommonParam(IIMdata messageBuilder, MsgData item) {
        if (messageBuilder != null) {
            Pair pair = ImMsgUtils.parseMsgJson((String)item.getMsg());
            JSONObject msgJson = (JSONObject)pair.first;
            if (messageBuilder.getMessageDBBean() == null) {
                return messageBuilder;
            }
            if (msgJson != null) {
                if (msgJson.has("source")) {
                    messageBuilder.getMessageDBBean().setSource(msgJson.optInt("source"));
                }
                int ttl = msgJson.optInt("ttl", 0);
                messageBuilder.getMessageDBBean().setTtl(ttl);
                messageBuilder.getMessageDBBean().setFromDiscoveryPage(msgJson.optBoolean("isFromDiscoveryChange", false));
                if (ttl > 0) {
                    this.checkExpiredTask(ttl);
                }
            }
            messageBuilder.getMessageDBBean().setUuid(item.getUuid());
        }
        return messageBuilder;
    }

    private void checkExpiredTask(int ttl) {
        MLog.info((Object)TAG, (String)"checkExpiredTask ttl %d s", (Object[])new Object[]{ttl});
        YYTaskExecutor.postToMainThread(() -> new ExpiredMsgFilter().checkExpired(), (long)((ttl + 30) * 1000));
    }
}

