/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.sticker.view;

import android.content.Context;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.utils.FP;
import com.yy.im.module.room.sticker.IStickerHandlerCallback;
import com.yy.im.module.room.sticker.StickerInfo;
import com.yy.im.module.room.sticker.view.StickerHolder;
import com.yy.im.module.room.sticker.view.StickerItemView;
import java.util.ArrayList;
import java.util.List;

public class ImStickerPanelAdapter
extends RecyclerView.Adapter<StickerHolder> {
    private List<StickerInfo> mStickerInfoList = new ArrayList<StickerInfo>();
    private Context mContext;
    private IStickerHandlerCallback mCallback;

    public ImStickerPanelAdapter(Context context) {
        this.mContext = context;
    }

    public void setCallback(IStickerHandlerCallback callback) {
        this.mCallback = callback;
    }

    @NonNull
    public StickerHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        StickerItemView view = new StickerItemView(this.mContext);
        StickerHolder holder = new StickerHolder(view);
        holder.itemView.setOnClickListener(v -> {
            if (v.getTag() instanceof StickerInfo && this.mCallback != null) {
                this.mCallback.onItemClick((StickerInfo)v.getTag());
            }
        });
        return holder;
    }

    public void onBindViewHolder(@NonNull StickerHolder stickerHolder, int i) {
        StickerInfo info = this.mStickerInfoList.get(i);
        stickerHolder.setData(info);
    }

    public int getItemCount() {
        return FP.size(this.mStickerInfoList);
    }

    public void addDataList(List<StickerInfo> datas) {
        this.mStickerInfoList.clear();
        if (!FP.empty(datas)) {
            this.mStickerInfoList.addAll(datas);
        }
        this.notifyDataSetChanged();
    }
}

