/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.holder;

import android.graphics.Color;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.utils.LayoutUtil;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.wallet.base.GiftChannel;
import com.yy.hiyo.wallet.base.IGiftService;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.holder.ChatBaseHolder;

@DontProguardClass
public class WinnerMessageHolder
extends ChatBaseHolder {
    private static final String TAG = "WinnerMessageHolder";
    private TextView mTvTime;
    private TextView mTvDiamond;
    private LinearLayout mLlContent;

    public WinnerMessageHolder(View itemView, IMvpContext baseRecyclerAdapter) {
        super(itemView, baseRecyclerAdapter);
        this.mTvTime = (TextView)itemView.findViewById(R.id.tv_im_wealth_time);
        this.mTvDiamond = (TextView)itemView.findViewById(R.id.tv_wealth_im_diamond);
        this.mLlContent = (LinearLayout)itemView.findViewById(R.id.ll_wealth_im_content);
    }

    public static BaseItemBinder<ChatMessageData, WinnerMessageHolder> getBinder(final IMvpContext provider) {
        return new BaseItemBinder<ChatMessageData, WinnerMessageHolder>(){

            @NonNull
            protected WinnerMessageHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new WinnerMessageHolder(inflater.inflate(R.layout.layout_im_wealth_item, parent, false), provider);
            }
        };
    }

    public void setData(ChatMessageData data2) {
        super.setData((Object)data2);
        ImMessageDBBean message = data2.message;
        if (message == null) {
            MLog.error((Object)TAG, (String)"updateItem message is null", (Object[])new Object[0]);
            return;
        }
        long time = Long.valueOf(message.getReserve2());
        this.mTvTime.setText((CharSequence)TimeUtils.getTimeStringFromMillis((long)time, (String)"%04d-%02d-%02d %02d:%02d"));
        String price = message.getReserve1();
        this.mTvDiamond.setText((CharSequence)price);
        FontUtils.setFontType((TextView)this.mTvDiamond, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.mTvDiamond.setIncludeFontPadding(false);
        this.mLlContent.removeAllViews();
        String[] giftIdArray = message.getReserve3().split(",");
        String[] giftNumArray = message.getReserve4().split(",");
        int size = giftIdArray.length;
        for (int i = 0; i < size; ++i) {
            if (TextUtils.isEmpty((CharSequence)giftIdArray[i])) {
                FeatureLog.i((String)"FTWealth", (String)"gift null", (Object[])new Object[0]);
                continue;
            }
            GiftItemInfo giftItemInfo = ((IGiftService)ServiceManagerProxy.getServiceManager().getService(IGiftService.class)).getGift(GiftChannel.VOICE_ROOM_USED_CHANNEL.getChannel(), Integer.valueOf(giftIdArray[i]).intValue());
            if (giftItemInfo == null) {
                FeatureLog.i((String)"FTWealth", (String)"gift null", (Object[])new Object[0]);
                continue;
            }
            YYLinearLayout contentLayout2 = new YYLinearLayout(this.getContext());
            contentLayout2.setOrientation(1);
            LinearLayout.LayoutParams contentLayoutParams = new LinearLayout.LayoutParams(-2, -2);
            contentLayoutParams.rightMargin = ResolutionUtils.dip2Px((float)4.0f);
            LayoutUtil.setStartEndMargin((ViewGroup.MarginLayoutParams)contentLayoutParams);
            contentLayout2.setLayoutParams((ViewGroup.LayoutParams)contentLayoutParams);
            RecycleImageView rvGift = new RecycleImageView(this.getContext());
            LinearLayout.LayoutParams giftParams = new LinearLayout.LayoutParams(ResolutionUtils.dip2Px((float)35.0f), ResolutionUtils.dip2Px((float)35.0f));
            ImageLoader.loadImage((ImageView)rvGift, (String)giftItemInfo.getStaticIcon(), (int)R.drawable.icon_gift_default);
            rvGift.setLayoutParams((ViewGroup.LayoutParams)giftParams);
            contentLayout2.addView((View)rvGift);
            YYTextView tvPrice = new YYTextView(this.getContext());
            tvPrice.setText((CharSequence)("x" + giftNumArray[i]));
            tvPrice.setTextSize(10.0f);
            tvPrice.setGravity(17);
            tvPrice.setTextColor(Color.parseColor((String)"#000000"));
            LinearLayout.LayoutParams priceLayoutParams = new LinearLayout.LayoutParams(-2, -2);
            priceLayoutParams.topMargin = ResolutionUtils.dip2Px((float)3.0f);
            priceLayoutParams.gravity = 1;
            tvPrice.setLayoutParams((ViewGroup.LayoutParams)priceLayoutParams);
            contentLayout2.addView((View)tvPrice);
            this.mLlContent.addView((View)contentLayout2);
        }
    }
}

