/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.holder;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.DontProguardClass;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.im.ImResourceManager;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.holder.ChatBaseHolder;

@DontProguardClass
public class ChatOutOfLineHolder
extends ChatBaseHolder {
    private YYTextView mBlockBtn;
    private YYTextView mReportBtn;
    private YYTextView mNoMoreNoticeText;
    private ChatMessageData mMessageData;
    private ConstraintLayout mRootView;
    private int mPosition;

    public ChatOutOfLineHolder(View itemView, IMvpContext baseRecyclerAdapter) {
        super(itemView, baseRecyclerAdapter);
        this.initView();
    }

    public static BaseItemBinder<ChatMessageData, ChatOutOfLineHolder> getBinder(final IMvpContext context) {
        return new BaseItemBinder<ChatMessageData, ChatOutOfLineHolder>(){

            @NonNull
            protected ChatOutOfLineHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new ChatOutOfLineHolder(inflater.inflate(R.layout.im_item_out_of_line, parent, false), context);
            }
        };
    }

    public void setData(ChatMessageData data2) {
        super.setData((Object)data2);
        this.mMessageData = data2;
    }

    private void initView() {
        this.mBlockBtn = (YYTextView)this.itemView.findViewById(R.id.block_btn);
        this.mReportBtn = (YYTextView)this.itemView.findViewById(R.id.report_btn);
        this.mNoMoreNoticeText = (YYTextView)this.itemView.findViewById(R.id.no_more_notice);
        this.mRootView = (ConstraintLayout)this.itemView.findViewById(R.id.outOfLineRoot);
        this.mRootView.setBackgroundResource(ImResourceManager.INSTANCE.getReportBackground());
        this.mNoMoreNoticeText.setPaintFlags(this.mNoMoreNoticeText.getPaintFlags() | 8);
        this.mBlockBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ChatOutOfLineHolder.this.getEventCallback() != null) {
                    ChatOutOfLineHolder.this.getEventCallback().onBlock();
                }
            }
        });
        this.mReportBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ChatOutOfLineHolder.this.getEventCallback() != null) {
                    ChatOutOfLineHolder.this.getEventCallback().onReportOutOfLine(ChatOutOfLineHolder.this.mMessageData, ChatOutOfLineHolder.this.mPosition);
                }
            }
        });
        this.mNoMoreNoticeText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ChatOutOfLineHolder.this.getEventCallback() != null) {
                    ChatOutOfLineHolder.this.getEventCallback().onNoMoreNotice();
                }
            }
        });
    }

    public static interface IChatOutOfLineListener {
        public void onBlockClick(ChatMessageData var1, int var2);

        public void onReportClick(ChatMessageData var1, int var2);

        public void onNoMoreNoticeClick(ChatMessageData var1, int var2);
    }
}

