/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.holder;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import com.yy.appbase.kvo.HeadFrameType;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.widget.headframe.HeadFrameImageView;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.utils.DontProguardClass;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.im.ImResourceManager;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.holder.ChatChallengeMessageBaseHolder;

@DontProguardClass
public class ChatChallengeReceivedMessageHolder
extends ChatChallengeMessageBaseHolder {
    private HeadFrameImageView ivAvatar;
    private LinearLayout llContent;

    public ChatChallengeReceivedMessageHolder(View itemView, IMvpContext baseRecyclerAdapter) {
        super(itemView, baseRecyclerAdapter);
        this.ivAvatar = (HeadFrameImageView)itemView.findViewById(R.id.iv_user_avatar);
        this.llContent = (LinearLayout)itemView.findViewById(R.id.content);
        this.llContent.setBackgroundResource(ImResourceManager.INSTANCE.getImOtherBackground());
    }

    public static BaseItemBinder<ChatMessageData, ChatChallengeReceivedMessageHolder> getBinder(final IMvpContext context) {
        return new BaseItemBinder<ChatMessageData, ChatChallengeReceivedMessageHolder>(){

            @NonNull
            protected ChatChallengeReceivedMessageHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new ChatChallengeReceivedMessageHolder(inflater.inflate(R.layout.im_item_challenge_card_received, parent, false), context);
            }
        };
    }

    @Override
    public void setData(ChatMessageData data2) {
        super.setData(data2);
        UserInfoKS bean = this.getUserInfo(data2.message.getUid());
        this.showAvatar((RecycleImageView)this.ivAvatar.getCircleImageView(), bean);
        this.ivAvatar.setTag(R.id.chat_message_data, (Object)data2);
        this.ivAvatar.setOnClickListener((View.OnClickListener)this);
        HeadFrameType otherHeadFrameType = this.getOtherHeadFrameType();
        if (otherHeadFrameType != null) {
            Kvo.addKvoBinding((KvoSource)otherHeadFrameType, (Object)((Object)this), (String)"onOtherHeadFrameTypeUpdate");
        }
    }

    @KvoMethodAnnotation(name="headFrameType", sourceClass=HeadFrameType.class)
    public void onOtherHeadFrameTypeUpdate(KvoEventIntent event) {
        if (this.ivAvatar != null) {
            int frame = (int)((HeadFrameType)event.source()).headFrameType;
            this.ivAvatar.setHeadFrame(((IHonorService)this.getServiceManager().getService(IHonorService.class)).getHeadFrameUrlFromCache(frame));
        }
    }
}

