/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.holder;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.yy.appbase.kvo.HeadFrameType;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.widget.headframe.HeadFrameImageView;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.holder.BaseEmojiHolder;

public class BigEmojiReceiveHolder
extends BaseEmojiHolder {
    private YYTextView tvTime;
    private HeadFrameImageView ivAvatar;

    public BigEmojiReceiveHolder(View itemView, IMvpContext baseRecyclerAdapter) {
        super(itemView, baseRecyclerAdapter);
        this.tvTime = (YYTextView)itemView.findViewById(R.id.tv_time);
        this.ivAvatar = (HeadFrameImageView)itemView.findViewById(R.id.iv_user_avatar);
        this.ivAvatar.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (v.getTag(R.id.chat_message_data) instanceof ChatMessageData && BigEmojiReceiveHolder.this.getEventCallback() != null) {
                    BigEmojiReceiveHolder.this.getEventCallback().onUserAvatarClick(((ChatMessageData)v.getTag((int)R.id.chat_message_data)).message.getUid(), 8);
                }
            }
        });
        this.svBigFace.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (v.getTag(R.id.chat_message_data) instanceof ChatMessageData) {
                    if (BigEmojiReceiveHolder.this.getEventCallback() != null) {
                        BigEmojiReceiveHolder.this.getEventCallback().onChatMessageItemLongClick((ChatMessageData)v.getTag(R.id.chat_message_data), v);
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public static BaseItemBinder<ChatMessageData, BigEmojiReceiveHolder> getBinder(final IMvpContext context) {
        return new BaseItemBinder<ChatMessageData, BigEmojiReceiveHolder>(){

            @NonNull
            protected BigEmojiReceiveHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new BigEmojiReceiveHolder(inflater.inflate(R.layout.item_receive_big_emoji, parent, false), context);
            }
        };
    }

    @Override
    public void setData(ChatMessageData data2) {
        super.setData(data2);
        if (data2.message.getUid() == 10L || data2.message.getUid() == 14L) {
            this.ivAvatar.getCircleImageView().setImageResource(R.drawable.icon_public_msg_avatar);
        } else {
            this.showAvatar((RecycleImageView)this.ivAvatar.getCircleImageView(), this.getUserInfo(data2.message.getUid()));
        }
        HeadFrameType otherHeadFrameType = this.getOtherHeadFrameType();
        if (otherHeadFrameType != null) {
            Kvo.addKvoBinding((KvoSource)otherHeadFrameType, (Object)((Object)this), (String)"onOtherHeadFrameTypeUpdate");
        }
        this.setFormatTimeInfo((TextView)this.tvTime, data2);
        this.ivAvatar.setTag(R.id.chat_message_data, (Object)data2);
    }

    @KvoMethodAnnotation(name="headFrameType", sourceClass=HeadFrameType.class)
    public void onOtherHeadFrameTypeUpdate(KvoEventIntent event) {
        if (this.ivAvatar != null) {
            int frame = (int)((HeadFrameType)event.source()).headFrameType;
            this.ivAvatar.setHeadFrame(((IHonorService)this.getServiceManager().getService(IHonorService.class)).getHeadFrameUrlFromCache(frame));
        }
    }
}

