/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.data;

import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.style.ImageSpan;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.dyres.inner.DResource;
import com.yy.im.DR;
import com.yy.im.R;
import com.yy.im.module.room.data.EmojiTypeData;

public class InteractiveEmojiTypeHelper {
    public static final DResource SVGA_IM_INTERACTIVE_HEART = DR.im_interactive_emoji_heart;
    public static final DResource SVGA_IM_INTERACTIVE_CRY = DR.im_interactive_emoji_cry;
    public static final DResource SVGA_IM_INTERACTIVE_SMILE = DR.im_interactive_emoji_smile;
    public static final DResource SVGA_FULL_IM_INTERACTIVE_HEART = DR.im_emoji_full_heart;
    public static final DResource SVGA_FULL_IM_INTERACTIVE_CRY = DR.im_emoji_full_cry;
    public static final DResource SVGA_FULL_IM_INTERACTIVE_SMILE = DR.im_emoji_full_smile;
    private static final int EMOJI_IMAGE_WIDTH = ResolutionUtils.dip2Px((float)30.0f);
    private static final String CRY_STRING = "/" + ResourceUtils.getString((int)R.string.short_title_cry) + "/";
    private static final String SMILE_STRING = "/" + ResourceUtils.getString((int)R.string.short_title_smile) + "/";
    private static final String LOVE_STRING = "/" + ResourceUtils.getString((int)R.string.short_title_love) + "/";

    public static DResource[] getInteractiveEmotionArray() {
        DResource[] emotionArray = new DResource[]{SVGA_IM_INTERACTIVE_HEART, SVGA_IM_INTERACTIVE_SMILE, SVGA_IM_INTERACTIVE_CRY};
        return emotionArray;
    }

    public static DResource getImInteractiveFullSvga(EmojiTypeData emojiTypeData) {
        if (emojiTypeData.getType() == 100) {
            return SVGA_FULL_IM_INTERACTIVE_HEART;
        }
        if (emojiTypeData.getType() == 101) {
            return SVGA_FULL_IM_INTERACTIVE_CRY;
        }
        if (emojiTypeData.getType() == 102) {
            return SVGA_FULL_IM_INTERACTIVE_SMILE;
        }
        return null;
    }

    public static EmojiTypeData getInterEmojiTypeByUrl(DResource res) {
        if (SVGA_IM_INTERACTIVE_HEART == res) {
            return new EmojiTypeData(100);
        }
        if (SVGA_IM_INTERACTIVE_CRY == res) {
            return new EmojiTypeData(101);
        }
        if (SVGA_IM_INTERACTIVE_SMILE == res) {
            return new EmojiTypeData(102);
        }
        return null;
    }

    public static SpannableString getSpannableStringByType(int type) {
        SpannableString spannableString = new SpannableString((CharSequence)" ");
        Drawable drawable2 = null;
        if (type == 100) {
            drawable2 = ResourceUtils.getDrawable((int)R.drawable.im_interactive_emoji_image_span_heart);
        } else if (type == 101) {
            drawable2 = ResourceUtils.getDrawable((int)R.drawable.im_interactive_emoji_image_span_cry);
        } else if (type == 102) {
            drawable2 = ResourceUtils.getDrawable((int)R.drawable.im_interactive_emoji_image_span_smile);
        }
        if (drawable2 != null) {
            drawable2.setBounds(0, 0, EMOJI_IMAGE_WIDTH, EMOJI_IMAGE_WIDTH);
            ImageSpan imageSpan = new ImageSpan(drawable2);
            spannableString.setSpan((Object)imageSpan, 0, 1, 17);
        }
        return spannableString;
    }

    public static String getContentByEmojiData(EmojiTypeData emojiTypeData) {
        if (emojiTypeData.getType() == 100) {
            return LOVE_STRING;
        }
        if (emojiTypeData.getType() == 101) {
            return CRY_STRING;
        }
        if (emojiTypeData.getType() == 102) {
            return SMILE_STRING;
        }
        return "";
    }
}

