/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.viewpager.widget.PagerAdapter;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.base.logger.MLog;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.inner.DResource;
import com.yy.im.R;
import com.yy.im.module.room.data.EmojiTypeData;
import com.yy.im.module.room.data.InteractiveEmojiTypeHelper;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class InteractiveFacePagerAdapter
extends PagerAdapter {
    private static final String TAG = "InteractiveFacePagerAdapter";
    DResource[] emotionArray;
    Context mContext;
    private LinkedList<View> mDestroyViewList;
    private Map<Integer, View> mShownViewMap;
    private InteractiveFaceCallback callback;
    private long lastClickTimeStamp = 0L;

    public InteractiveFacePagerAdapter(Context context, DResource[] emotionArray, InteractiveFaceCallback callback) {
        this.mContext = context;
        this.emotionArray = emotionArray;
        this.callback = callback;
        this.mDestroyViewList = new LinkedList();
        this.mShownViewMap = new HashMap<Integer, View>();
    }

    public int getCount() {
        return this.emotionArray.length;
    }

    public boolean isViewFromObject(View view, Object o) {
        return view == o;
    }

    public void destroyItem(ViewGroup container2, int position, Object object) {
        container2.removeView((View)object);
        this.mDestroyViewList.add((View)object);
        this.mShownViewMap.remove(position);
    }

    public Object instantiateItem(ViewGroup container2, final int position) {
        ViewHolder viewHolder;
        View layout2;
        View view = layout2 = this.mDestroyViewList.size() > 0 ? this.mDestroyViewList.removeFirst() : null;
        if (layout2 == null) {
            layout2 = LayoutInflater.from((Context)this.mContext).inflate(R.layout.im_interactive_emoji_item, container2, false);
            viewHolder = new ViewHolder(layout2);
            layout2.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)layout2.getTag();
        }
        viewHolder.setEmojiEntity(InteractiveEmojiTypeHelper.getInterEmojiTypeByUrl(this.emotionArray[position]));
        DyResLoader.INSTANCE.loadSvga(viewHolder.svgaImageView, this.emotionArray[position], new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity entity) {
                if (position == 0 && viewHolder != null && viewHolder.svgaImageView != null) {
                    viewHolder.svgaImageView.startAnimation();
                }
            }

            public void onFailed(Exception e) {
                MLog.error((Object)InteractiveFacePagerAdapter.TAG, (String)"instantiateItem svga load error=%s", (Throwable)e, (Object[])new Object[0]);
            }
        });
        container2.addView(layout2);
        this.mShownViewMap.put(position, layout2);
        return layout2;
    }

    public void showAnimation(int position) {
        View preView = this.mShownViewMap.get(position);
        if (preView != null) {
            ViewHolder viewHolder = (ViewHolder)preView.getTag();
            viewHolder.svgaImageView.startAnimation();
        }
        this.stopPreAnimation(position - 1);
    }

    public void stopPreAnimation(int position) {
        View preView = this.mShownViewMap.get(position);
        if (preView != null) {
            ViewHolder viewHolder = (ViewHolder)preView.getTag();
            viewHolder.svgaImageView.stopAnimation();
        }
    }

    public void stopAnimation() {
        for (View view : this.mShownViewMap.values()) {
            if (view == null) continue;
            ViewHolder viewHolder = (ViewHolder)view.getTag();
            viewHolder.svgaImageView.stopAnimation();
        }
    }

    public static interface InteractiveFaceCallback {
        public void clickInteractiveFace(EmojiTypeData var1);
    }

    class ViewHolder {
        SVGAImageView svgaImageView;
        EmojiTypeData emojiTypeData;

        public void setEmojiEntity(EmojiTypeData emojiTypeData) {
            this.emojiTypeData = emojiTypeData;
        }

        ViewHolder(View convertView) {
            this.svgaImageView = (SVGAImageView)convertView.findViewById(R.id.svga_iv);
            this.svgaImageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (System.currentTimeMillis() - InteractiveFacePagerAdapter.this.lastClickTimeStamp > 1000L) {
                        InteractiveFacePagerAdapter.this.lastClickTimeStamp = System.currentTimeMillis();
                        if (InteractiveFacePagerAdapter.this.callback != null) {
                            InteractiveFacePagerAdapter.this.callback.clickInteractiveFace(ViewHolder.this.emojiTypeData);
                        }
                    }
                }
            });
        }
    }
}

