/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room;

import android.content.ClipData;
import android.content.Context;
import android.graphics.Rect;
import android.text.Editable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.yy.appbase.common.Callback;
import com.yy.appbase.service.IEmojiListCallback;
import com.yy.appbase.service.IFeatchEmojiListCallback;
import com.yy.appbase.ui.widget.edit.FixEditTextView;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.appbase.unifyconfig.config.CommonConfigData;
import com.yy.appbase.unifyconfig.config.EmoticonConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemServiceUtils;
import com.yy.hiyo.emotion.base.EmoticonContainerView;
import com.yy.hiyo.emotion.base.EmoticonHelper;
import com.yy.hiyo.emotion.base.EmoticonViewHandler;
import com.yy.hiyo.emotion.base.container.page.IPageSelectListener;
import com.yy.hiyo.emotion.base.container.page.PageEntity;
import com.yy.hiyo.emotion.base.container.page.PageViewInstantiateListener;
import com.yy.hiyo.emotion.base.container.widget.widget.EmoticonViewPager;
import com.yy.hiyo.emotion.base.customemoji.EmojiTabUICallback;
import com.yy.hiyo.emotion.base.emoji.EmojiEntity;
import com.yy.hiyo.emotion.base.emoji.EmojiManager;
import com.yy.hiyo.emotion.base.emoji.EmojiViewDelegate;
import com.yy.hiyo.emotion.base.gif.GifEventHandler;
import com.yy.hiyo.emotion.base.gif.GifViewDelegate;
import com.yy.hiyo.emotion.base.gif.bean.GifSet;
import com.yy.hiyo.emotion.base.gif.widget.FastSearchGifPopupWindow;
import com.yy.hiyo.emotion.base.hotemoji.HotEmojiItem;
import com.yy.hiyo.emotion.base.hotemoji.HotEmojiTabCallback;
import com.yy.im.R;
import com.yy.im.gift.free.ImFreeGiftNotifyInfo;
import com.yy.im.module.room.callback.IMessageDraftCallback;
import com.yy.im.module.room.data.EmojiTypeData;
import com.yy.im.module.room.game.panel.ImBottomGamePanel;
import com.yy.im.module.room.game.panel.PageItemData;
import com.yy.im.module.room.game.partygame.ImPartyGamePage;
import com.yy.im.module.room.game.pkgame.BottomGameTab;
import com.yy.im.module.room.game.pkgame.IGameListTab;
import com.yy.im.module.room.sticker.view.WhatsAppStickerPanel;
import com.yy.im.module.room.utils.IMTrack;
import com.yy.im.ui.widget.EmojiEmotionsView;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.List;
import net.ihago.im.srv.emoji.FavorItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputLayout
extends YYLinearLayout
implements View.OnClickListener,
IMessageDraftCallback,
EmoticonViewHandler.EmotionHandlerDelegate,
EmoticonViewHandler.EmoticonHandlerCallback,
View.OnTouchListener,
EmojiTabUICallback,
HotEmojiTabCallback {
    public static final int STATE_NONE = 0;
    public static final int STATE_SHOW_EMOJI = 1;
    public static final int STATE_SHOW_GAME_LIST = 2;
    public static final int STATE_SHOW_INPUT = 3;
    private ImageView ivFace;
    private FixEditTextView etInput;
    private ImageView ivPhoto;
    private ImageView ivSend;
    private RecycleImageView ivRedPoint;
    private YYImageView ivRecord;
    private Animation animImgBtnExit;
    private Animation animImgBtnEnter;
    private Animation animSendBtnExit;
    private Animation animSendBtnEnter;
    private int lengthBeforeTextChanged = 0;
    private boolean isRecordValid = false;
    private boolean isShowRecord = false;
    private boolean isMicOpen = false;
    private int lastMicStatus = -1;
    private IInputLayoutCallback inputLayoutCallback;
    private long picClickTs;
    private boolean isInteractiveAndDressUpEmoticonVisible = true;
    private EmoticonContainerView mEmoticonView;
    private PageEntity mEmojiPageEntity;
    private PageEntity mCustomEmojiEntity;
    private PageEntity mHotEmojiEntity;
    private PageEntity mBigFaceEntity;
    private PageEntity mInteractivePageEntity;
    private PageEntity mWhatsAppStickerEntity;
    private PageEntity gifPageEntity;
    private boolean isGifSearchOpened = false;
    private View mGameIcon;
    private boolean canShowGameIcon = true;
    private EmoticonViewHandler mEmoticonHandler;
    private IPageSelectListener mPageSelectListener;
    private IInputInterceptor mInputInterceptor;
    private View mContentView;
    private FastSearchGifPopupWindow fastSearchGifPopupWindow;
    private BottomGameTab.IGameOperateListener mIGameOperateListener;
    private int mViewState = 0;
    private int currentPage = 0;
    private ImBottomGamePanel mBottomGamePanel;
    private GifViewDelegate mGifViewDelegate = new GifViewDelegate(){

        public void onGifSelected(@NotNull GifSet gifSet) {
            if (InputLayout.this.inputLayoutCallback != null) {
                InputLayout.this.inputLayoutCallback.clickGif(gifSet);
            }
        }

        public void onGifSearchOpened(boolean opened) {
            InputLayout.this.isGifSearchOpened = opened;
        }
    };

    public void setPageSelectListener(IPageSelectListener pageSelectListener) {
        this.mPageSelectListener = pageSelectListener;
    }

    public void setInputInterceptor(IInputInterceptor interceptor) {
        this.mInputInterceptor = interceptor;
    }

    public InputLayout(Context context) {
        super(context);
        this.init(context);
    }

    public InputLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public InputLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        InputLayout.inflate((Context)context, (int)this.getLayout(), (ViewGroup)this);
        this.setOrientation(1);
        this.initViews();
        this.initListener();
    }

    private int getLayout() {
        return R.layout.layout_im_room_bottom_new;
    }

    private void initViews() {
        this.mContentView = this.findViewById(R.id.content_view);
        this.ivFace = (ImageView)this.findViewById(R.id.iv_face);
        this.ivPhoto = (ImageView)this.findViewById(R.id.iv_photo);
        this.etInput = (FixEditTextView)this.findViewById(R.id.et_input);
        this.ivSend = (ImageView)this.findViewById(R.id.iv_send);
        this.ivRedPoint = (RecycleImageView)this.findViewById(R.id.iv_red_point);
        this.ivRecord = (YYImageView)this.findViewById(R.id.record_icon);
        this.ivRedPoint.setVisibility(8);
        this.showRecordIcon(!this.isMicOpen);
        this.mEmoticonHandler = new EmoticonViewHandler((EmoticonViewHandler.EmotionHandlerDelegate)this);
        this.mEmoticonHandler.addEmoticonHandlerCallback((EmoticonViewHandler.EmoticonHandlerCallback)this);
        this.mEmoticonHandler.attachEditText((EditText)this.etInput, (View.OnTouchListener)this);
        if (FP.empty((CharSequence)this.etInput.getText())) {
            this.ivSend.setEnabled(false);
        }
        this.fastSearchGifPopupWindow = new FastSearchGifPopupWindow(this.getContext(), (EditText)this.etInput, this.mContentView, this.mGifViewDelegate);
        this.fastSearchGifPopupWindow.setFastSearchListener(new FastSearchGifPopupWindow.FastSearchListener(){

            public void onItemClickListener() {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("scene_type", "1").put("function_id", "face_connect_face_click"));
            }

            public void onScroll() {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("scene_type", "1").put("function_id", "face_connect_slither"));
            }

            public void onShow() {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("scene_type", "1").put("function_id", "face_connect_show"));
            }
        });
        this.mGameIcon = this.findViewById(R.id.mGameIcon);
    }

    public int getViewState() {
        return this.mViewState;
    }

    public void setRecordValid(boolean valid) {
        this.isRecordValid = valid;
        this.showRecordIcon(valid);
    }

    private void showRecordIcon(boolean show) {
        this.isShowRecord = show;
        if (this.inputLayoutCallback == null) {
            return;
        }
        if (this.isRecordValid && show) {
            this.ivSend.setVisibility(8);
            this.ivRecord.setVisibility(0);
            if (this.inputLayoutCallback != null) {
                this.inputLayoutCallback.createRecordView();
            }
        } else {
            this.ivSend.setVisibility(0);
            this.ivRecord.setVisibility(8);
        }
    }

    private void showGameICon(boolean show) {
        if (this.mGameIcon == null) {
            return;
        }
        this.mGameIcon.setVisibility(8);
    }

    public void onMicChanged(int status) {
        if (status == 1) {
            this.isMicOpen = true;
        } else if (status == 0) {
            this.isMicOpen = false;
        }
        if (this.lastMicStatus == -1 || this.lastMicStatus != status) {
            this.lastMicStatus = status;
            this.showRecordIcon(this.isShowRecord);
        }
    }

    public Rect getRecordIconRect() {
        Rect iconViewRect = new Rect();
        if (this.ivRecord.getVisibility() == 0) {
            this.ivRecord.getGlobalVisibleRect(iconViewRect);
        }
        return iconViewRect;
    }

    private void initCustomEmojiPanel() {
        if (this.inputLayoutCallback != null && this.inputLayoutCallback.hasCustomEmoji()) {
            if (this.mCustomEmojiEntity == null) {
                this.mCustomEmojiEntity = EmoticonHelper.INSTANCE.buildCustomEmjioPageEntity(this.getContext(), (EmojiTabUICallback)this);
            }
            this.mEmoticonView.addPageEntity(this.mCustomEmojiEntity);
        }
    }

    private void initHotEmojiPanel() {
        if (this.inputLayoutCallback != null && this.inputLayoutCallback.hasCustomEmoji()) {
            EmoticonHelper.INSTANCE.requestHotEmoji((Callback)new Callback<List<HotEmojiItem>>(){

                public void onResponse(List<HotEmojiItem> data2) {
                    if (!data2.isEmpty()) {
                        InputLayout.this.addHotEmoji();
                    }
                }
            });
        }
    }

    private void addHotEmoji() {
        if (this.mHotEmojiEntity == null) {
            this.mHotEmojiEntity = EmoticonHelper.INSTANCE.buildHotEmjioPageEntity(this.getContext(), (HotEmojiTabCallback)this);
        }
        this.mEmoticonView.addPageEntityBefore(this.mHotEmojiEntity, this.mCustomEmojiEntity);
        if (this.currentPage > 3) {
            this.mEmoticonView.setCurrentPagePosition(this.mEmoticonView.getCurrentPagePosition() + 1);
        }
    }

    private void initBigFacePanel() {
        View bigFacePage;
        if (this.inputLayoutCallback != null && (bigFacePage = this.inputLayoutCallback.getBigFacePage(this.getContext())) != null) {
            if (this.mBigFaceEntity == null) {
                this.mBigFaceEntity = new PageEntity.Builder().tabIconDrawable(R.drawable.icon_tab_face).viewInstantiateListener(new PageViewInstantiateListener(){

                    @Nullable
                    public View instantiateItem(@NotNull ViewGroup container2, int position) {
                        return bigFacePage;
                    }
                }).build();
            }
            this.mEmoticonView.addPageEntity(this.mBigFaceEntity);
        }
    }

    private boolean isShowGiftEnter() {
        return false;
    }

    private void initListener() {
        this.ivPhoto.setOnClickListener((View.OnClickListener)this);
        this.etInput.setOnClickListener((View.OnClickListener)this);
        this.ivSend.setOnClickListener((View.OnClickListener)this);
        this.ivFace.setOnClickListener((View.OnClickListener)this);
        this.etInput.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                InputLayout.this.lengthBeforeTextChanged = s.length();
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (InputLayout.this.lengthBeforeTextChanged <= 0 && s.length() > 0) {
                    InputLayout.this.ivSend.setEnabled(true);
                    InputLayout.this.showRecordIcon(false);
                    InputLayout.this.showGameICon(false);
                    InputLayout.this.showSendAndPhotoBtnWithAimation(true);
                } else if (InputLayout.this.lengthBeforeTextChanged > 0 && s.length() <= 0) {
                    InputLayout.this.showSendAndPhotoBtnWithAimation(false);
                    InputLayout.this.ivSend.setEnabled(false);
                    InputLayout.this.showRecordIcon(true);
                    InputLayout.this.showGameICon(true);
                }
            }
        });
        this.etInput.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus && InputLayout.this.inputLayoutCallback != null) {
                    InputLayout.this.inputLayoutCallback.hideFastInput();
                }
            }
        });
        this.etInput.setTextPasteCallback(new FixEditTextView.TextPasteCallback(){

            public void onTextPaste() {
                int index = InputLayout.this.etInput.getSelectionStart();
                Editable editText = InputLayout.this.etInput.getEditableText();
                ClipData clipData = SystemServiceUtils.getClipboardManager2((Context)RuntimeContext.sApplicationContext).getPrimaryClip();
                if (clipData != null && clipData.getItemAt(0) != null && clipData.getItemAt(0).getText() != null) {
                    String clipStr = clipData.getItemAt(0).getText().toString();
                    if (StringUtils.isEmpty((String)clipStr)) {
                        return;
                    }
                    String str = EmojiManager.INSTANCE.replaceSelfEmojiForCode(clipStr);
                    SpannableString emojiStr = EmojiManager.INSTANCE.getExpressionString(str);
                    if (index < 0 || index >= editText.length()) {
                        editText.append((CharSequence)emojiStr);
                    } else {
                        editText.insert(index, (CharSequence)emojiStr);
                    }
                }
            }
        });
        if (this.mGameIcon != null) {
            this.mGameIcon.setOnClickListener((View.OnClickListener)this);
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        return v == this.etInput && this.mInputInterceptor != null && this.mInputInterceptor.interceptInputTouch(v.getId(), event);
    }

    public void initEmoticonPanel() {
        this.mEmoticonView = new EmoticonContainerView(this.getContext());
        this.mEmoticonView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.addView((View)this.mEmoticonView);
        this.mEmoticonHandler.setEmoticonView(this.mEmoticonView);
        this.setUpEmoticonPageEntity();
    }

    public void onEmoticonPanelShow(View emoticonView) {
        this.hideGiftBtn();
        if (!this.isShowGiftEnter()) {
            this.ivFace.setBackgroundResource(R.drawable.input_face_active);
        }
        this.mViewState = 1;
    }

    public void onEmoticonPanelHide(View emoticonView) {
        if (!this.isShowGiftEnter()) {
            this.ivFace.setBackgroundResource(R.drawable.im_bottom_emoji_icon);
        }
        this.mViewState = 0;
    }

    public void beforeEmoticonShow() {
        this.hideGameListPanel();
        this.hideInputSoft();
    }

    public void beforeInputShow() {
        this.hideGameListPanel();
        this.hideEmojiPanel();
        this.mViewState = 3;
    }

    public void beforeGameListShow() {
        this.hideInputSoft();
        this.hideEmojiPanel();
    }

    @Override
    public void onGetDraftSuccess(String draft) {
        if (!TextUtils.isEmpty((CharSequence)draft) && this.etInput != null) {
            this.etInput.setText((CharSequence)EmojiManager.INSTANCE.getExpressionString(draft));
        }
    }

    private void setUpEmoticonPageEntity() {
        this.mEmojiPageEntity = EmoticonHelper.INSTANCE.buildEmojiPageEntity(this.getContext(), (EmojiViewDelegate)EmoticonHelper.INSTANCE.getDefaultEmojiViewDelegate((EditText)this.etInput, new EmoticonHelper.onEmojiSelectListener(){

            public void onEmojiSelected(@NotNull EmojiEntity emoji) {
                if (emoji != null) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "emoticon_click").put("picture_send_enter", "2").put("emoticon_big_type", "1").put("emoticon_type", emoji.getCode()));
                }
            }
        }));
        this.mEmoticonView.addPageEntity(this.mEmojiPageEntity);
        this.initBigFacePanel();
        this.initCustomEmojiPanel();
        this.initHotEmojiPanel();
        EmoticonConfig config = (EmoticonConfig)UnifyConfig.INSTANCE.getConfigData(BssCode.EMOTICON_CONFIG);
        if (config.isShowGifTab()) {
            GifEventHandler eventHandler = new GifEventHandler();
            eventHandler.addEvent(1, HiidoEvent.obtain().eventId("20028823").put("function_id", "gif_lookup_back_click").put("picture_send_enter", "2"));
            eventHandler.addEvent(2, HiidoEvent.obtain().eventId("20028823").put("function_id", "gif_lookup_clearup_click").put("picture_send_enter", "2"));
            eventHandler.addEvent(3, HiidoEvent.obtain().eventId("20028823").put("function_id", "gif_lookup_click").put("picture_send_enter", "2"));
            this.gifPageEntity = EmoticonHelper.INSTANCE.buildGifPageEntity(this.getContext(), eventHandler, this.mGifViewDelegate);
            this.mEmoticonView.addPageEntity(this.gifPageEntity);
        }
        this.buildInteractiveEmoticonPageEntity();
        this.initWhatsAppStickerPageEntity();
        this.mEmoticonView.notifyPageSetChanged();
        this.initEmoticonPanelEvent();
    }

    private void buildInteractiveEmoticonPageEntity() {
        if (!this.isInteractiveAndDressUpEmoticonVisible) {
            return;
        }
        this.mInteractivePageEntity = new PageEntity.Builder().tabIconDrawable(R.drawable.im_emoji_emotion_interactive_tag).viewInstantiateListener((container2, position) -> {
            EmojiEmotionsView interactiveEmojiView = new EmojiEmotionsView(this.getContext(), this.etInput, 1);
            interactiveEmojiView.setEmojiEmotionCallback(data2 -> {
                if (this.inputLayoutCallback != null) {
                    this.inputLayoutCallback.clickEmoji(data2);
                }
            });
            return interactiveEmojiView;
        }).build();
        this.mEmoticonView.addPageEntity(this.mInteractivePageEntity);
    }

    private void initWhatsAppStickerPageEntity() {
    }

    private void initEmoticonPanelEvent() {
        this.mEmoticonView.addEmoticonPageChangeListener(new EmoticonViewPager.OnEmoticonPageChangeListener(){

            public void onPageEntitySelected(@NotNull PageEntity pageEntity, int position) {
                if (InputLayout.this.mEmojiPageEntity != null && pageEntity == InputLayout.this.mEmojiPageEntity) {
                    InputLayout.this.currentPage = 0;
                } else if (InputLayout.this.mInteractivePageEntity != null && pageEntity == InputLayout.this.mInteractivePageEntity) {
                    InputLayout.this.currentPage = 5;
                } else if (InputLayout.this.mCustomEmojiEntity != null && pageEntity == InputLayout.this.mCustomEmojiEntity) {
                    IMTrack.INSTANCE.reportCustomEmojiTab();
                    InputLayout.this.currentPage = 2;
                } else if (InputLayout.this.mWhatsAppStickerEntity != null && pageEntity == InputLayout.this.mWhatsAppStickerEntity) {
                    if (InputLayout.this.inputLayoutCallback != null && InputLayout.this.inputLayoutCallback.getWhatsAppPage(InputLayout.this.getContext()) != null) {
                        InputLayout.this.inputLayoutCallback.getWhatsAppPage(InputLayout.this.getContext()).onPanelShow();
                    }
                    InputLayout.this.currentPage = 7;
                } else if (InputLayout.this.mHotEmojiEntity != null && pageEntity == InputLayout.this.mHotEmojiEntity) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "channel_hot_enter_click"));
                    InputLayout.this.currentPage = 3;
                } else if (InputLayout.this.mBigFaceEntity != null && pageEntity == InputLayout.this.mBigFaceEntity) {
                    InputLayout.this.currentPage = 1;
                } else if (InputLayout.this.gifPageEntity != null && pageEntity == InputLayout.this.gifPageEntity) {
                    InputLayout.this.currentPage = 4;
                }
                if (InputLayout.this.mPageSelectListener != null) {
                    InputLayout.this.mPageSelectListener.onSelectPage(pageEntity);
                }
                InputLayout.this.reportEmotionTabShow(InputLayout.this.getTabForReport(InputLayout.this.currentPage));
            }
        });
        if (this.isInteractiveAndDressUpEmoticonVisible) {
            if (this.ivRedPoint.getVisibility() == 0) {
                if (this.mWhatsAppStickerEntity != null) {
                    this.mEmoticonView.setCurrentPage(this.mWhatsAppStickerEntity);
                    this.ivRedPoint.setVisibility(8);
                } else {
                    this.ivRedPoint.setVisibility(8);
                }
            } else if (!SettingFlags.getBoolean((String)"show_interactive_emotion", (boolean)false)) {
                this.mEmoticonView.setCurrentPage(this.mInteractivePageEntity);
                SettingFlags.setBoolean((String)"show_interactive_emotion", (boolean)true);
                this.reportEmotionTabShow(this.getTabForReport(5));
            } else {
                this.mEmoticonView.setCurrentPage(this.mEmojiPageEntity);
                this.reportEmotionTabShow(this.getTabForReport(0));
            }
        } else {
            this.reportEmotionTabShow(this.getTabForReport(0));
            this.mEmoticonView.setCurrentPage(this.mEmojiPageEntity);
        }
    }

    private int getTabForReport(int currentTab) {
        switch (currentTab) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 7: {
                return 7;
            }
        }
        return 0;
    }

    private void reportEmotionTabShow(int tab) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "emotion_act").put("emotion_tab_show", String.valueOf(tab)));
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (this.mInputInterceptor != null && this.mInputInterceptor.interceptInputClick(id2)) {
            return;
        }
        if (id2 == R.id.iv_send) {
            if (this.inputLayoutCallback != null) {
                this.inputLayoutCallback.sendMessage(this.etInput.getText().toString());
                this.inputLayoutCallback.hideFastInput();
            }
        } else if (id2 == R.id.iv_photo) {
            long ts = System.currentTimeMillis();
            if (ts - this.picClickTs > 1000L) {
                this.picClickTs = ts;
                if (this.inputLayoutCallback != null) {
                    this.inputLayoutCallback.selectPhoto();
                    this.inputLayoutCallback.hideFastInput();
                }
            }
        } else if (id2 == R.id.et_input) {
            if (this.inputLayoutCallback != null) {
                this.inputLayoutCallback.onEditTextClick();
                this.inputLayoutCallback.hideFastInput();
            }
        } else if (id2 == R.id.iv_face) {
            if (this.mEmoticonHandler != null) {
                this.mEmoticonHandler.onEmoticonBtnClicked();
            }
        } else if (id2 == R.id.mGameIcon) {
            this.handleGameListShow();
        }
    }

    private void showSendAndPhotoBtnWithAimation(final boolean show) {
        Animation sendAnimation;
        Animation imgAnimation;
        if (!this.isShowGiftEnter()) {
            return;
        }
        if (show) {
            if (this.animImgBtnExit == null) {
                this.animImgBtnExit = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.im_img_btn_exit);
            }
            imgAnimation = this.animImgBtnExit;
            if (this.animSendBtnEnter == null) {
                this.animSendBtnEnter = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.im_send_btn_enter);
            }
            sendAnimation = this.animSendBtnEnter;
        } else {
            if (this.animImgBtnEnter == null) {
                this.animImgBtnEnter = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.im_img_btn_enter);
            }
            imgAnimation = this.animImgBtnEnter;
            if (this.animSendBtnExit == null) {
                this.animSendBtnExit = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.im_send_btn_exit);
            }
            sendAnimation = this.animSendBtnExit;
        }
        imgAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                InputLayout.this.ivPhoto.setVisibility(show ? 8 : 0);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        sendAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                InputLayout.this.ivSend.setVisibility(show ? 0 : 8);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.ivPhoto.setVisibility(0);
        this.ivPhoto.startAnimation(imgAnimation);
        this.ivSend.setVisibility(0);
        this.ivSend.startAnimation(sendAnimation);
    }

    public EmoticonViewHandler getEmoticonHandler() {
        return this.mEmoticonHandler;
    }

    public void hideInteractiveAndDressUpEmoticon() {
        this.isInteractiveAndDressUpEmoticonVisible = false;
        if (this.mEmoticonView != null) {
            this.mEmoticonView.removePageEntity(this.mInteractivePageEntity);
            this.mEmoticonView.notifyPageSetChanged();
        }
    }

    public boolean isGifSearchOpened() {
        return this.isGifSearchOpened;
    }

    public void onKeyboardShown(boolean isShow) {
        if (isShow) {
            this.hideGiftBtn();
        } else if (this.etInput.getText().length() > 0) {
            this.showPhotoBtn();
        }
    }

    private void hidePhotoBtn() {
        if (this.ivPhoto != null && this.ivPhoto.getVisibility() != 8) {
            this.ivPhoto.setVisibility(8);
        }
    }

    private void showPhotoBtn() {
        if (this.isShowGiftEnter() && this.ivPhoto != null && this.ivPhoto.getVisibility() != 0) {
            this.ivPhoto.setVisibility(0);
        }
    }

    public void onShowFreeGift(ImFreeGiftNotifyInfo info) {
        if (info == null) {
            return;
        }
    }

    public void setText(CharSequence text) {
        this.etInput.setText(text);
        this.etInput.setSelection(text.length());
    }

    public void setInputLayoutCallback(IInputLayoutCallback inputLayoutCallback) {
        this.inputLayoutCallback = inputLayoutCallback;
        if (inputLayoutCallback != null) {
            this.showRecordIcon(this.isShowRecord);
        }
    }

    public void showFaceRedNotify(boolean visable) {
        if (this.ivRedPoint != null) {
            if (visable) {
                this.ivRedPoint.setVisibility(0);
            } else {
                this.ivRedPoint.setVisibility(8);
            }
        }
    }

    public void hideGiftBtn() {
        if (this.isShowGiftEnter()) {
            // empty if block
        }
    }

    public void hideGameIcon() {
        if (this.mGameIcon != null) {
            this.canShowGameIcon = false;
            this.mGameIcon.setVisibility(8);
        }
    }

    public String getContent() {
        if (this.etInput != null) {
            return this.etInput.getText().toString();
        }
        return null;
    }

    public void openEmojiEditPage() {
        if (this.inputLayoutCallback != null) {
            this.inputLayoutCallback.openEmojiEditPage();
        }
    }

    public void fetchAllEmoji(boolean fromCache, @NotNull IFeatchEmojiListCallback callback) {
        if (this.inputLayoutCallback != null) {
            this.inputLayoutCallback.fetchAllEmoji(fromCache, callback);
        }
    }

    public void openHagoAlbum(@NotNull IEmojiListCallback callback) {
        if (this.inputLayoutCallback != null) {
            this.inputLayoutCallback.openHagoAlbum(callback);
        }
    }

    public void clickCustomEmojiItem(@NotNull FavorItem entity) {
        if (this.inputLayoutCallback != null) {
            this.inputLayoutCallback.clickCustomEmojiItem(entity);
        }
    }

    private void handleGameListShow() {
        if (this.inputLayoutCallback != null) {
            this.inputLayoutCallback.clickGameIcon();
        }
        if (this.mViewState == 2) {
            this.hideGameListPanel();
        } else {
            this.showGameListPanel(0);
        }
    }

    public void hideGameListPanel() {
        if (this.mBottomGamePanel != null) {
            this.mBottomGamePanel.setVisibility(8);
        }
        this.mViewState = 0;
        if (this.inputLayoutCallback != null) {
            this.inputLayoutCallback.onGamePanelShowOrHide(false);
        }
    }

    public void showGameListPanel(int selectedTabIndex) {
        this.beforeGameListShow();
        if (this.mBottomGamePanel == null) {
            this.mBottomGamePanel = new ImBottomGamePanel(this.getContext());
            this.initBottomGameTabs();
        }
        if (this.mBottomGamePanel.getParent() == null) {
            this.addView((View)this.mBottomGamePanel);
        }
        this.mBottomGamePanel.setVisibility(0);
        this.mBottomGamePanel.setCurrentItem(selectedTabIndex);
        this.mViewState = 2;
        if (this.inputLayoutCallback != null) {
            this.inputLayoutCallback.onGamePanelShowOrHide(true);
        }
    }

    public void showEmojiPanel() {
        this.beforeEmoticonShow();
        this.mEmoticonHandler.showEmoticonView();
    }

    public void hideEmojiPanel() {
        if (this.mViewState == 1) {
            this.mEmoticonHandler.onEmoticonBtnClicked();
        }
    }

    public void hideInputSoft() {
        this.mEmoticonHandler.hideSoftKeyboard();
    }

    public void showInputSoft() {
        this.beforeInputShow();
        this.mEmoticonHandler.showSoftKeyboard();
    }

    public boolean isGamePanelVisible() {
        return this.mBottomGamePanel != null && this.mBottomGamePanel.getVisibility() == 0;
    }

    public void setGameInviteOperateListener(BottomGameTab.IGameOperateListener listener) {
        this.mIGameOperateListener = listener;
    }

    public IGameListTab getGameListTab() {
        if (this.mBottomGamePanel == null) {
            return null;
        }
        View pageView = this.mBottomGamePanel.getPageView(0);
        if (pageView instanceof BottomGameTab) {
            return (BottomGameTab)pageView;
        }
        return null;
    }

    public int getCurrentPageType() {
        return this.currentPage;
    }

    public void clickEmojiItem(@NotNull HotEmojiItem entity) {
        if (this.inputLayoutCallback != null) {
            this.inputLayoutCallback.clickCustomEmojiItem(entity);
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "channel_hot_emotion_click").put("message_sence", "1").put("emotion_url", entity.url));
        }
    }

    private void initBottomGameTabs() {
        CommonConfigData data2;
        int source = 0;
        if (this.inputLayoutCallback != null) {
            source = this.inputLayoutCallback.getSource();
        }
        ArrayList<PageItemData> tabs = new ArrayList<PageItemData>(2);
        BottomGameTab pkGamePage = new BottomGameTab(this.getContext());
        pkGamePage.setMGameOperateListener(this.mIGameOperateListener);
        pkGamePage.setSource(source);
        PageItemData pkGameTab = new PageItemData(ResourceUtils.getString((int)R.string.short_tips_tab_1v1), pkGamePage);
        tabs.add(pkGameTab);
        boolean canShowPartyGameTab = false;
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.COMMON_CONFIG);
        if (config instanceof CommonConfig && (data2 = ((CommonConfig)config).getData()) != null) {
            canShowPartyGameTab = data2.canShowPartyGameTabInImPage;
        }
        if (canShowPartyGameTab) {
            ImPartyGamePage partyGamePage = new ImPartyGamePage(this.getContext());
            partyGamePage.setSource(source);
            PageItemData partyGameTab = new PageItemData(ResourceUtils.getString((int)R.string.tips_im_bottom_party_game_tab), partyGamePage);
            tabs.add(partyGameTab);
        }
        if (this.mBottomGamePanel != null) {
            this.mBottomGamePanel.setPageList(tabs);
        }
    }

    public static interface IInputInterceptor {
        public boolean interceptInputClick(int var1);

        public boolean interceptInputTouch(int var1, MotionEvent var2);
    }

    public static interface IInputLayoutCallback {
        public void sendMessage(String var1);

        public void selectPhoto();

        public void onEditTextClick();

        public void hideFastInput();

        public void clickEmoji(EmojiTypeData var1);

        public void clickGift();

        public void clickGif(GifSet var1);

        public void openEmojiEditPage();

        public void fetchAllEmoji(boolean var1, IFeatchEmojiListCallback var2);

        public void openHagoAlbum(IEmojiListCallback var1);

        public View getBigFacePage(Context var1);

        public void clickCustomEmojiItem(@NotNull FavorItem var1);

        public void clickCustomEmojiItem(@NotNull HotEmojiItem var1);

        public boolean hasCustomEmoji();

        public void createRecordView();

        public WhatsAppStickerPanel getWhatsAppPage(Context var1);

        public void clickGameIcon();

        public void onGamePanelShowOrHide(boolean var1);

        default public int getSource() {
            return 0;
        }
    }
}

