/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.model;

import android.text.TextUtils;
import androidx.databinding.Bindable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.unifyconfig.config.BussinessLogicOptConfig;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SpannableStringUtil;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.MyJoinChannelItem;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IFamilyLuckyBagService;
import com.yy.im.BR;
import com.yy.im.R;
import com.yy.im.model.ChannelEntranceMsg;
import com.yy.im.model.ChatSession;
import com.yy.im.model.ExpressionStringHelper;
import com.yy.im.model.OnStringBack;
import org.jetbrains.annotations.NotNull;

public class ChannelEntranceSession
extends ChatSession<ChannelEntranceMsg> {
    private static final String TAG = "ChannelEntranceSession";
    private static final long TWO_WEEK = 1209600000L;
    public boolean mHadLuckyBagActivity = false;
    private MsgStyle msgStyle = MsgStyle.NONE;
    public CharSequence atMeMsg = "";
    public boolean hasChannelActivity = false;
    public String channelActivityName = null;
    public String channelActivityId = null;
    public boolean hasAnnouncement = false;
    public String announcement = "";
    private String pid = "";

    public ChannelEntranceSession(ChannelEntranceMsg mLastMessage) {
        super(9, mLastMessage);
        long uid = 0L;
        if (mLastMessage.getMyJoinChannelItem() != null) {
            uid = mLastMessage.getMyJoinChannelItem().ownerUid;
        }
        if (uid > 0L) {
            UserInfoKS userInfo = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(uid);
            this.setUserInfo(userInfo);
            Kvo.addKvoBinding((KvoSource)userInfo, (Object)this, (String)"onUserInfoLoaded");
        }
    }

    @Override
    public void initial() {
        ChannelEntranceMsg channelEntranceMsg = (ChannelEntranceMsg)this.getLastMessage();
        MyJoinChannelItem myJoinChannelItem = null;
        if (channelEntranceMsg != null && (myJoinChannelItem = channelEntranceMsg.getMyJoinChannelItem()) != null) {
            this.setSessionId(myJoinChannelItem.cid);
            this.setUid(myJoinChannelItem.ownerUid);
            this.setTitle(myJoinChannelItem.name);
            this.setChannelCover(myJoinChannelItem.channelAvatar);
            this.handlePluginMode(myJoinChannelItem);
            this.handleUnReadAndIgnore(myJoinChannelItem);
            this.handleTimeStr(myJoinChannelItem);
            this.handleLastMsgShow(myJoinChannelItem);
            this.handleOldAndNewChannelStyle(myJoinChannelItem);
            this.handleFamily(myJoinChannelItem);
            this.handleGameLabel(myJoinChannelItem);
        }
    }

    public void handlePluginMode(MyJoinChannelItem joinChannelItem) {
        ChannelPluginData channelPluginData = joinChannelItem.mPluginData;
        this.setChannelPluginMode(channelPluginData == null ? -1 : channelPluginData.mode);
    }

    public void handleUnReadAndIgnore(MyJoinChannelItem joinChannelItem) {
        if (joinChannelItem.myRoleData != null && joinChannelItem.myRoleData.msgReceiveMode == 2) {
            this.setUnReadType(1);
            this.setShowIgnore(true);
        } else {
            this.setUnReadType(0);
            this.setShowIgnore(false);
        }
        if (BussinessLogicOptConfig.isChannelSessionDisturbOptOff()) {
            MLog.error((Object)TAG, (String)"isChannelSessionDisturbOptOff!", (Object[])new Object[0]);
            if (!YYTaskExecutor.isMainThread()) {
                YYTaskExecutor.postToMainThread(() -> this.checkDisturbMode(joinChannelItem));
            } else {
                this.checkDisturbMode(joinChannelItem);
            }
        }
        this.setUnReadCounts((int)joinChannelItem.unreadMsgNum);
    }

    private void checkDisturbMode(MyJoinChannelItem joinChannelItem) {
        IChannel channel;
        if (ServiceManagerProxy.getService(IChannelCenterService.class) != null && (channel = ((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getChannel(joinChannelItem.cid)) != null && channel.getMsgService() != null) {
            channel.getMsgService().isOpenDoNotDisturb(AccountUtil.getUid(), (channelId, uid, opened) -> {
                if (opened) {
                    this.setUnReadType(1);
                    this.setShowIgnore(true);
                } else {
                    this.setUnReadType(0);
                    this.setShowIgnore(false);
                }
            });
        }
    }

    public void handleTimeStr(MyJoinChannelItem joinChannelItem) {
        if (joinChannelItem.lastestUnReadMsgTs > 0L) {
            this.setTimeStr(joinChannelItem.lastestUnReadMsgTs);
            this.setPresentationTime(joinChannelItem.lastestUnReadMsgTs);
        } else if (joinChannelItem.lastReadMsgTime > 0L) {
            this.setTimeStr(joinChannelItem.lastReadMsgTime);
            this.setPresentationTime(joinChannelItem.lastReadMsgTime);
        } else if (this.getTimeStr() != 0L) {
            this.setTimeStr(this.getTimeStr());
            this.setPresentationTime(this.getTimeStr());
        } else {
            this.setTimeStr(System.currentTimeMillis());
            this.setPresentationTime(System.currentTimeMillis());
        }
    }

    public void handleLastMsgShow(MyJoinChannelItem joinChannelItem) {
        CharSequence tips = joinChannelItem.getLastMsgTips();
        if (tips instanceof String) {
            CharSequence cacheString = ExpressionStringHelper.INSTANCE.getCacheString(joinChannelItem.cid, (String)tips);
            if (cacheString != null) {
                this.setSubTitle(cacheString);
            } else {
                ExpressionStringHelper.INSTANCE.addParseTask(joinChannelItem.cid, (String)tips, new OnStringBack(){

                    @Override
                    public void onStringBack(@NotNull CharSequence sp) {
                        ChannelEntranceSession.this.setSubTitle(sp);
                    }
                });
            }
        } else {
            this.setSubTitle(tips);
        }
    }

    public void handleOldAndNewChannelStyle(MyJoinChannelItem joinChannelItem) {
        if (joinChannelItem.version == 1) {
            this.setNeedShoWUpdate(false);
            if (!FP.empty((CharSequence)joinChannelItem.channelAvatar)) {
                this.setAvatarUrl(joinChannelItem.channelAvatar);
                this.setNeedShowDefault(false);
            } else {
                this.setNeedShowDefault(true);
            }
        } else if (joinChannelItem.version == 0) {
            this.setNeedShoWUpdate(true);
            this.setNeedShowDefault(false);
        }
    }

    public void handleFamily(MyJoinChannelItem joinChannelItem) {
        if ("hago.family".equals(joinChannelItem.source)) {
            this.mHadLuckyBagActivity = ServiceManagerProxy.getService(IFamilyLuckyBagService.class) != null && ((IFamilyLuckyBagService)ServiceManagerProxy.getService(IFamilyLuckyBagService.class)).hasLuckyBagActivity();
            this.setNeedShowFamily(true);
            this.setNeedShowDefault(false);
        } else {
            this.setNeedShowFamily(false);
        }
    }

    public void handleGameLabel(MyJoinChannelItem joinChannelItem) {
        if ("hago.game".equals(joinChannelItem.source)) {
            if (TextUtils.isEmpty((CharSequence)joinChannelItem.indieGameName)) {
                this.setGameLabel(null);
            } else if (joinChannelItem.myRoleData.roleType == 15) {
                this.setGameLabel(ResourceUtils.getString((int)R.string.tag_channel_game_group_create, (Object[])new Object[]{joinChannelItem.indieGameName}));
            } else {
                this.setGameLabel(ResourceUtils.getString((int)R.string.tag_channel_game_group_join, (Object[])new Object[]{joinChannelItem.indieGameName}));
            }
        } else {
            this.setGameLabel(null);
        }
    }

    @KvoMethodAnnotation(name="finishAll", sourceClass=UserInfoKS.class, thread=1)
    public void onUserInfoLoaded(KvoEventIntent event) {
        ChannelEntranceMsg channelEntranceMsg = (ChannelEntranceMsg)this.getLastMessage();
        MyJoinChannelItem myJoinChannelItem = null;
        if (channelEntranceMsg != null && (myJoinChannelItem = channelEntranceMsg.getMyJoinChannelItem()) != null && myJoinChannelItem.version == 1 && !FP.empty((CharSequence)myJoinChannelItem.channelAvatar)) {
            return;
        }
        this.setDefaultAvatar(AvatarUtils.getDefaultAvatar((int)this.getUserInfo().sex));
        this.setAvatarUrl(this.userInfo.avatar);
    }

    @Override
    public int getListViewType() {
        return 3;
    }

    public boolean shouldUpdate(MyJoinChannelItem inputChannelItem) {
        if (inputChannelItem != null) {
            if (!StringUtils.equal((String)inputChannelItem.cid, (String)this.getSessionId())) {
                return true;
            }
            if (inputChannelItem.ownerUid != this.getUid()) {
                return true;
            }
            if (!StringUtils.equal((String)inputChannelItem.name, (String)this.getTitle())) {
                return true;
            }
            if (inputChannelItem.unreadMsgNum != (long)this.getUnReadCounts()) {
                return true;
            }
            if (inputChannelItem.lastestUnReadMsgTs != 0L && inputChannelItem.lastestUnReadMsgTs != this.getTimeStr()) {
                long lastestUnReadMsgTs = inputChannelItem.lastestUnReadMsgTs;
                long cur = System.currentTimeMillis();
                if (cur - lastestUnReadMsgTs <= 1209600000L) {
                    return true;
                }
            }
            if (inputChannelItem.myRoleData != null) {
                if (inputChannelItem.myRoleData.msgReceiveMode == 2 && this.getUnReadType() == 0) {
                    return true;
                }
                if (inputChannelItem.myRoleData.msgReceiveMode == 1 && this.getUnReadType() == 1) {
                    return true;
                }
            }
            if (inputChannelItem.getLastMsgTips() != null && !inputChannelItem.getLastMsgTips().equals(this.getSubTitle())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public CharSequence getSubTitle() {
        if (this.mHadLuckyBagActivity) {
            return SpannableStringUtil.getSpannableString((SpannableStringUtil.ISpannableBlock[])new SpannableStringUtil.ISpannableBlock[]{new SpannableStringUtil.SpannableStringBlock((CharSequence)ResourceUtils.getString((int)R.string.im_family_lucky_bag_activity_tips), -24832), new SpannableStringUtil.SpannableStringBlock(super.getSubTitle(), -6710887)});
        }
        return super.getSubTitle();
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        MLog.debug((Object)TAG, (String)("update channel session " + this.getSessionId() + " " + pid), (Object[])new Object[0]);
        this.pid = pid;
    }

    @Bindable
    public MsgStyle getMsgStyle() {
        return this.msgStyle;
    }

    public void setMsgStyle(MsgStyle msgStyle) {
        this.msgStyle = msgStyle;
        this.notifyPropertyChanged(BR.msgStyle);
    }

    public static enum MsgStyle {
        NONE,
        AT_ME,
        ACTIVITY,
        ANNOUNCEMENT,
        CHANNEL_STATE;

    }
}

