/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.localpush;

import android.content.SharedPreferences;
import android.net.Uri;
import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.abtest.ABTestManager;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.IGetABTestCallback;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.ImCommonPushConfig;
import com.yy.appbase.unifyconfig.config.ImRecomChannelConfig;
import com.yy.appbase.yyuri.YYUriCode;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.im.Utils;
import com.yy.hiyo.im.base.data.MessageBuilder;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.im.R;
import com.yy.im.interfaces.IGetImCommonPushCallback;
import com.yy.im.model.ChatSession;
import com.yy.im.model.CommonMsgChatSession;
import com.yy.im.msg.ImNotificationDef;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.ihago.room.api.rrec.ECategory;
import net.ihago.room.api.rrec.RandomRecomReq;
import net.ihago.room.api.rrec.RandomRecomRes;
import net.ihago.room.api.rrec.RoomTabItem;
import org.json.JSONObject;

public class ImCommonMsgPresenter {
    private static final String TAG = "ImCommonMsgPresenter";
    private boolean isJudged = false;
    public static final String KEY_LAST_RECOMM_CHANNEL_TS = "last_recom_chanel_ts";
    public static final String KEY_IM_RECOMM_CHANNELS = "im_recom_channels";

    public void judgeAndSendCommonMsg() {
        if (this.isJudged) {
            return;
        }
        this.isJudged = true;
        ImCommonPushConfig config = (ImCommonPushConfig)UnifyConfig.INSTANCE.getConfigData(BssCode.IM_COMMON_PUSH);
        if (config == null || FP.empty((Collection)config.getCommonPushContentList())) {
            MLog.info((Object)TAG, (String)"judgeNeedSendCommonMsg config is empty!!!", (Object[])new Object[0]);
            return;
        }
        for (int i = 0; i < config.getCommonPushContentList().size(); ++i) {
            ImCommonPushConfig.ImCommonPushContent content = (ImCommonPushConfig.ImCommonPushContent)config.getCommonPushContentList().get(i);
            if (content == null) continue;
            this.filterSendCommonMsg(content, new IGetImCommonPushCallback(){

                @Override
                public void onResponse(ImCommonPushConfig.ImCommonPushContent pushContent) {
                    if (pushContent == null) {
                        return;
                    }
                    YYTaskExecutor.postToMainThread(() -> ImCommonMsgPresenter.this.sendCommonMsg(pushContent, false));
                }
            });
        }
    }

    private void checkServerRecommend() {
        this.deleteBeforeRecom();
        long uid = AccountUtil.getUid();
        boolean inTwentyFourHours = AccountUtil.isInTwentyFourHours();
        IAB test = NewABDefine.IM_RANDOM_ROOM.getTest();
        final SharedPreferences defaultPrf = SharedPreferencesUtils.getDefaultPrf();
        long lastRequestTs = 0L;
        String channelIds = "";
        String[] channelTotal = new String[]{};
        if (defaultPrf != null) {
            lastRequestTs = defaultPrf.getLong(KEY_LAST_RECOMM_CHANNEL_TS, 0L);
            channelIds = defaultPrf.getString(KEY_IM_RECOMM_CHANNELS, "");
            if (StringUtils.isNotEmpty((String)channelIds)) {
                channelTotal = channelIds.split(",");
            }
        }
        MLog.info((Object)TAG, (String)"checkServerRecommend uid:%d, inTwentyFourHours:%b, test:%s, lastRequestTs:%d, channelIds:%s", (Object[])new Object[]{uid, inTwentyFourHours, test, lastRequestTs, channelIds});
        if (uid > 0L && !inTwentyFourHours && NAB.B.equals((Object)test) && (channelTotal == null || channelTotal.length < 3)) {
            RandomRecomReq build = new RandomRecomReq.Builder().cat_id(Integer.valueOf(ECategory.ENonBase.getValue())).num(Integer.valueOf(1)).build();
            final String finalChannelIds = channelIds;
            ProtoManager.getInstance().sendHttp((AndroidMessage)build, (IProtoCallback)new IProtoCallback<RandomRecomRes>(){

                public void onResponse(@NonNull RandomRecomRes message, long code, String msg) {
                    super.onResponse((AndroidMessage)message, code, msg);
                    List channelsList = message.channels;
                    MLog.info((Object)ImCommonMsgPresenter.TAG, (String)"onResponse code:%d, size:%d", (Object[])new Object[]{code, channelsList == null ? 0 : channelsList.size()});
                    if (ProtoManager.isSuccessCode((long)code) && !FP.empty((Collection)channelsList)) {
                        List randomSubText;
                        ImCommonPushConfig.ImCommonPushContent content = new ImCommonPushConfig.ImCommonPushContent();
                        RoomTabItem roomTabItem = (RoomTabItem)channelsList.get(0);
                        if (roomTabItem == null) {
                            MLog.error((Object)ImCommonMsgPresenter.TAG, (String)"roomTabItem null!!!", (Object[])new Object[0]);
                            return;
                        }
                        String channelId = roomTabItem.id;
                        content.jumpUrl = StringUtils.formatWitUSLocal((String)"hago://channel/exactlyChannel?channelId=%s&%s=%d", (Object[])new Object[]{channelId, "channel_entry", 50});
                        String text = ResourceUtils.getString((int)R.string.title_channel_recom);
                        AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.IM_RECOM_CHANNEL_CONFIG);
                        if (configData instanceof ImRecomChannelConfig && !FP.empty((Collection)(randomSubText = ((ImRecomChannelConfig)configData).getRandomSubText()))) {
                            text = (String)randomSubText.get(new Random().nextInt(randomSubText.size()));
                        }
                        content.text = text;
                        content.title = roomTabItem.name;
                        content.imageUrl = roomTabItem.url;
                        MLog.info((Object)ImCommonMsgPresenter.TAG, (String)"onResponse id:%s, text:%s, title:%s, url:%s", (Object[])new Object[]{channelId, text, roomTabItem.name, roomTabItem.url});
                        ImCommonMsgPresenter.this.sendCommonMsg(content, true);
                        if (defaultPrf != null) {
                            SharedPreferences.Editor edit = defaultPrf.edit();
                            edit.putString(ImCommonMsgPresenter.KEY_IM_RECOMM_CHANNELS, finalChannelIds + channelId + ",");
                            edit.putLong(ImCommonMsgPresenter.KEY_LAST_RECOMM_CHANNEL_TS, System.currentTimeMillis());
                            edit.apply();
                        }
                    }
                }

                public boolean retryWhenTimeout(boolean canRetry) {
                    MLog.error((Object)ImCommonMsgPresenter.TAG, (String)"retryWhenTimeout:%b", (Object[])new Object[]{canRetry});
                    return false;
                }

                public boolean retryWhenError(boolean canRetry, String reason, int code) {
                    MLog.error((Object)ImCommonMsgPresenter.TAG, (String)"retryWhenError, canRetry:%b, reason:%s, code:%d", (Object[])new Object[]{canRetry, reason, code});
                    return false;
                }
            });
        }
    }

    private void deleteBeforeRecom() {
        ImModule module = (ImModule)KvoModuleManager.getModule(ImModule.class);
        if (module != null) {
            module.getMatchSessions(o -> {
                ImMessageDBBean lastMessage;
                return o instanceof CommonMsgChatSession && StringUtils.safeParseBoolean((String)(lastMessage = (ImMessageDBBean)((CommonMsgChatSession)o).getLastMessage()).getReserve5());
            }, list -> {
                MLog.info((Object)TAG, (String)"delete size:%d", (Object[])new Object[]{list.size()});
                if (!list.isEmpty()) {
                    for (Object session : list) {
                        if (!(session instanceof ChatSession)) continue;
                        module.deleteSession(((ChatSession)session).getSessionId());
                    }
                }
            });
        }
    }

    private void sendCommonMsg(ImCommonPushConfig.ImCommonPushContent content, boolean randomRoom) {
        String jumpUrl = content.jumpUrl;
        if (!FP.empty((CharSequence)content.jumpUrlWithPlaceHolder) && !FP.empty((Collection)content.placeHolders)) {
            String random = (String)content.placeHolders.get(new Random().nextInt(content.placeHolders.size()));
            String jumpUrlTemp = StringUtils.formatWitUSLocal((String)content.jumpUrlWithPlaceHolder, (Object[])new Object[]{random});
            MLog.info((Object)TAG, (String)"placeUrl:%s, random:%s, result:%s", (Object[])new Object[]{content.jumpUrlWithPlaceHolder, random, jumpUrlTemp});
            if (StringUtils.isNotEmpty((String)jumpUrlTemp)) {
                jumpUrl = jumpUrlTemp;
            }
        }
        int code = ((IYYUriService)ServiceManagerProxy.getServiceManager().getService(IYYUriService.class)).matchCode(jumpUrl);
        String sessionId2 = "s_10_" + AccountUtil.getUid();
        MessageBuilder messageBuilder = MessageBuilder.newInstance();
        if (code == YYUriCode.jumpGame) {
            String gameId = this.getUriGameId(jumpUrl);
            MLog.info((Object)TAG, (String)"judgeAndSendCommonMsg get gameId: %s", (Object[])new Object[]{gameId});
            if (FP.empty((CharSequence)gameId)) {
                return;
            }
            sessionId2 = Utils.appendGameSessionId((String)sessionId2, (String)gameId);
            messageBuilder.content(content.text).clientSendTime(System.currentTimeMillis()).sendTime(System.currentTimeMillis()).sendByMe(false).msgId(System.currentTimeMillis()).sessionId(sessionId2).fromType(1).imageUrl(content.imageUrl).msgType(47).uid(10L).reverse1(gameId).reserve2(content.title).reserve5("false").reserve3(String.valueOf(content.id)).reserve4(String.valueOf(content.notify));
        } else {
            sessionId2 = Utils.appendGameSessionId((String)sessionId2, (String)content.jumpUrl);
            messageBuilder.content(content.text).clientSendTime(System.currentTimeMillis()).sendTime(System.currentTimeMillis()).sendByMe(false).msgId(System.currentTimeMillis()).imageUrl(content.imageUrl).sessionId(sessionId2).msgType(48).uid(10L).reverse1(jumpUrl).reserve2(content.title).reserve3(String.valueOf(content.id)).reserve4(String.valueOf(content.notify));
        }
        messageBuilder.reverse5(randomRoom ? "true" : "false");
        ImMessageDBBean receiveMsg = messageBuilder.builder();
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_RECEIVE_COMMON_SESSION, (Object)receiveMsg));
    }

    private String getUriGameId(String jumpUrl) {
        Uri uri = Uri.parse((String)jumpUrl);
        String gameId = uri.getQueryParameter("gameId");
        return gameId;
    }

    private void filterSendCommonMsg(final ImCommonPushConfig.ImCommonPushContent content, final IGetImCommonPushCallback commonPushCallback) {
        final long registerTime = AccountUtil.getRegisterTime();
        MLog.info((Object)TAG, (String)"filterSendCommonMsg registerTime: %s", (Object[])new Object[]{registerTime});
        if (registerTime <= 0L) {
            MLog.info((Object)TAG, (String)"filterSendCommonMsg registerTime is empty!!!!!", (Object[])new Object[0]);
            return;
        }
        if (content == null || FP.empty((CharSequence)content.jumpUrl) && FP.empty((CharSequence)content.jumpUrlWithPlaceHolder) && FP.empty((Collection)content.placeHolders) || FP.empty((Collection)content.mConditionList) || FP.empty((CharSequence)content.mABKey) || FP.empty((CharSequence)content.mABValue)) {
            return;
        }
        ABTestManager.getInstance().getABTestValueByKey(content.mABKey, new IGetABTestCallback(){

            public void onCallback(JSONObject json, int error) {
                UserInfoKS userInfoKS;
                if (json == null || error != 0) {
                    MLog.error((Object)ImCommonMsgPresenter.TAG, (String)"ABTestManager.getInstance().getABTestValueByKey, json ==null", (Object[])new Object[0]);
                    return;
                }
                MLog.info((Object)ImCommonMsgPresenter.TAG, (String)"filterSendCommonMsg getABTestValueByKey jumpUrl: %s  json: %s  error: %s  ABValue: %s", (Object[])new Object[]{content.jumpUrl, json.toString(), error, content.mABValue});
                String value = json.optString("action");
                if (!StringUtils.equalsIgnoreCase((String)value, (String)content.mABValue)) {
                    return;
                }
                int currUserAge = 0;
                if (KvoModuleManager.getModule(UserInfoModule.class) != null && (userInfoKS = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid())) != null) {
                    currUserAge = DateUtils.getAge((String)userInfoKS.birthday);
                }
                int todayOpenTimes = RuntimeContext.getTodayOpenTimes();
                MLog.info((Object)ImCommonMsgPresenter.TAG, (String)"todayOpenTimes: %s, currUserAge: %d", (Object[])new Object[]{todayOpenTimes, currUserAge});
                for (int j = 0; j < content.mConditionList.size(); ++j) {
                    ImCommonPushConfig.ImCommonPushCondition condition = (ImCommonPushConfig.ImCommonPushCondition)content.mConditionList.get(j);
                    if (condition == null || !ImCommonMsgPresenter.this.matchRegisterDay(registerTime, condition.registerDay) || !ImCommonMsgPresenter.this.matchOpenTimes(todayOpenTimes, condition.openAppCount) || !ImCommonMsgPresenter.this.matchAgeRange(currUserAge, condition.ageRange)) continue;
                    if (commonPushCallback != null) {
                        commonPushCallback.onResponse(content);
                    }
                    return;
                }
            }
        });
    }

    private boolean matchRegisterDay(long registerTime, int registerDay) {
        if (registerDay == 0) {
            return true;
        }
        long oneDay = 86400000L;
        long registerDate = registerTime / oneDay;
        long today = System.currentTimeMillis() / oneDay;
        MLog.debug((Object)TAG, (String)"matchRegisterDay %s  %s", (Object[])new Object[]{registerDate, today});
        long intervalDay = today - registerDate;
        return intervalDay == (long)(registerDay - 1);
    }

    private boolean matchOpenTimes(int openTimes, int expectTime) {
        if (expectTime == 0) {
            return true;
        }
        return openTimes == expectTime;
    }

    private boolean matchAgeRange(int age, int[] ageRange) {
        if (age == 0 || ageRange == null || ageRange.length < 2) {
            return true;
        }
        return age >= ageRange[0] && age <= ageRange[1];
    }
}

