/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.findfriend.v1.ui;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.listener.OnRefreshListener;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.env.RuntimeContext;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.im.R;
import com.yy.im.findfriend.v1.FindFriendControllerV1;
import com.yy.im.findfriend.v1.FindFriendsAdapter;
import com.yy.im.findfriend.v1.IOvershootInterpolator;
import com.yy.im.findfriend.v1.bean.FindFriendItem;
import com.yy.im.findfriend.v1.bean.callback.IFindFriendCallback;
import java.util.List;

public class FindFriendsWindowV1
extends DefaultWindow {
    private SimpleTitleBar mTitleBar;
    private RecyclerView mRvList;
    private FindFriendsAdapter mAdapter;
    private CommonStatusLayout mCommonStatusLayout;
    private SmartRefreshLayout mSmartRefreshLayout;
    private YYRelativeLayout moreNewFriendsContainer;
    private YYImageView bottomFloatArrow;
    private LinearLayoutManager mLinearLayoutManager;
    private FindFriendControllerV1 findFriendController;
    private Context context;
    private IFindFriendCallback mCallback;
    private Runnable mRefreshTimeout = new Runnable(){

        @Override
        public void run() {
            if (FindFriendsWindowV1.this.mSmartRefreshLayout != null) {
                FindFriendsWindowV1.this.mSmartRefreshLayout.finishRefresh();
            }
        }
    };
    private int fristAnimation = 0;
    private int secondAnimation = 0;
    private float arrowStartY = 0.0f;
    private int bottomContainerY = 0;
    private float bottomContainerStartY = 0.0f;
    private ObjectAnimator bottomAnimator;
    private ObjectAnimator animator;
    private Runnable findVisibleItemsRunable = new Runnable(){

        @Override
        public void run() {
            FindFriendsWindowV1.this.findVisibleItems();
        }
    };

    public FindFriendsWindowV1(Context context, final UICallBacks callBacks, final IFindFriendCallback mCallback) {
        super(context, callBacks, "FindFriends");
        this.context = context;
        this.mCallback = mCallback;
        this.findFriendController = (FindFriendControllerV1)callBacks;
        LayoutInflater.from((Context)context).inflate(R.layout.layout_find_friends_window_v1, this.getBaseLayer(), true);
        this.mTitleBar = (SimpleTitleBar)this.findViewById(R.id.stb);
        this.mTitleBar.setLeftTitle(ResourceUtils.getString((int)R.string.find_title));
        this.mRvList = (RecyclerView)this.findViewById(R.id.rv_find_friends);
        this.mSmartRefreshLayout = (SmartRefreshLayout)this.findViewById(R.id.refresh_layout);
        this.moreNewFriendsContainer = (YYRelativeLayout)this.findViewById(R.id.more_new_friends_container);
        this.bottomFloatArrow = (YYImageView)this.findViewById(R.id.bottom_float_arrow_img);
        this.mLinearLayoutManager = new LinearLayoutManager(this.getContext());
        this.mRvList.setLayoutManager((RecyclerView.LayoutManager)this.mLinearLayoutManager);
        this.mAdapter = new FindFriendsAdapter(mCallback);
        this.mRvList.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View view) {
                callBacks.onWindowExitEvent(true);
            }
        });
        this.mCommonStatusLayout = (CommonStatusLayout)this.findViewById(R.id.csl);
        if (!NetworkUtils.isNetworkAvailable((Context)context)) {
            this.mCommonStatusLayout.showNetworkError();
        }
        this.mSmartRefreshLayout.setEnableRefresh(true);
        this.mSmartRefreshLayout.setEnableLoadMore(false);
        this.mSmartRefreshLayout.setOnRefreshListener(new OnRefreshListener(){

            public void onRefresh(@NonNull RefreshLayout refreshLayout) {
                if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
                    FindFriendsWindowV1.this.mSmartRefreshLayout.finishRefresh();
                } else {
                    mCallback.autoRefresh();
                    YYTaskExecutor.postToMainThread((Runnable)FindFriendsWindowV1.this.mRefreshTimeout, (long)5000L);
                }
            }
        });
        this.moreNewFriendsContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FindFriendsWindowV1.this.findFriendController.moveNewFriendToTop();
                FindFriendsWindowV1.this.moreNewFriendsContainer.setVisibility(8);
                if (FindFriendsWindowV1.this.animator != null) {
                    FindFriendsWindowV1.this.animator.end();
                }
            }
        });
        this.mRvList.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView2, int dx, int dy) {
                super.onScrolled(recyclerView2, dx, dy);
                FindFriendsWindowV1.this.findVisibleItems();
            }
        });
        this.setWindowType(121);
    }

    public void autoRefresh() {
        if (this.mSmartRefreshLayout != null) {
            this.mSmartRefreshLayout.autoRefresh();
        }
    }

    private void findVisibleItems() {
        if (this.mCallback == null) {
            return;
        }
        int position = this.mLinearLayoutManager.findLastVisibleItemPosition();
        this.mCallback.updateLastVisibleItemPosition(position);
    }

    public void setDatas(List<FindFriendItem> datas) {
        this.mAdapter.setDatas(datas);
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.findVisibleItemsRunable);
        YYTaskExecutor.postToMainThread((Runnable)this.findVisibleItemsRunable, (long)200L);
    }

    public void updateAdapter() {
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void onDetached() {
        super.onDetached();
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.findVisibleItemsRunable);
    }

    public void isShowMoreNewFriends(boolean isShow) {
        if (isShow) {
            if (this.moreNewFriendsContainer.getVisibility() == 0) {
                return;
            }
            this.moreNewFriendsContainer.setVisibility(0);
            this.startBottomFloatAnimation();
        } else {
            this.moreNewFriendsContainer.setVisibility(8);
        }
    }

    private void startBottomFloatAnimation() {
        if (this.bottomAnimator == null || this.bottomContainerY == 0) {
            this.bottomContainerY = ResolutionUtils.dip2Px((float)33.0f);
            this.bottomContainerStartY = this.moreNewFriendsContainer.getTranslationY();
            this.bottomAnimator = ObjectAnimator.ofFloat((Object)this.moreNewFriendsContainer, (String)"translationY", (float[])new float[]{this.bottomContainerStartY + (float)this.bottomContainerY, this.bottomContainerStartY});
            this.bottomAnimator.setDuration(200L);
            this.bottomAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        }
        this.bottomAnimator.start();
        if (this.animator == null || this.fristAnimation == 0 || this.secondAnimation == 0) {
            this.fristAnimation = ResolutionUtils.dip2Px((float)5.0f);
            this.secondAnimation = ResolutionUtils.dip2Px((float)12.0f);
            this.arrowStartY = this.bottomFloatArrow.getTranslationY();
            this.animator = ObjectAnimator.ofFloat((Object)this.bottomFloatArrow, (String)"translationY", (float[])new float[]{this.arrowStartY - (float)this.fristAnimation, this.arrowStartY, this.arrowStartY + (float)this.secondAnimation});
            this.animator.setDuration(800L);
            this.animator.setStartDelay(200L);
            this.animator.setInterpolator((TimeInterpolator)new IOvershootInterpolator());
            this.animator.setRepeatCount(-1);
        }
        this.animator.start();
    }

    public void onSuccess(boolean hasData) {
        YYTaskExecutor.postToMainThread((Runnable)this.mRefreshTimeout);
        if (this.mCommonStatusLayout != null && (NetworkUtils.isNetworkAvailable((Context)this.getContext()) || hasData)) {
            this.mCommonStatusLayout.hideAllStatus();
        }
    }

    public void updateItem(int position) {
        this.mAdapter.notifyItemChanged(position);
    }

    public void scrollToPosition(int position) {
        if (this.mLinearLayoutManager == null) {
            return;
        }
        this.mLinearLayoutManager.scrollToPositionWithOffset(position, 0);
    }

    public void removeAnimation() {
        if (this.animator != null) {
            this.animator.end();
        }
    }
}

