/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.fb;

import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.UserInfoExt;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnKSProfileListCallback;
import com.yy.appbase.user.IGetUserInfoExtCallBack;
import com.yy.appbase.user.UserInfoExtHelper;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.hiyo.im.base.IFBService;
import com.yy.hiyo.im.base.OnGetFbFriendListCallBack;
import com.yy.hiyo.im.base.OnGetFbFriendWithoutContactCallback;
import com.yy.hiyo.relation.base.data.LoadState;
import com.yy.hiyo.relation.base.friend.IFriendServices;
import com.yy.hiyo.relation.base.friend.data.FriendInfoList;
import com.yy.socialplatformbase.AbsPlatformAdapter;
import com.yy.socialplatformbase.ThirdPartyPlatformHelper;
import com.yy.socialplatformbase.callback.IGetFirendListCallBack;
import com.yy.socialplatformbase.data.UserBaseInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class FBService
extends DefaultController
implements IFBService {
    private static final String TAG = "FBService";
    private FriendInfoList mFriendInfoList;
    private OnGetFbFriendWithoutContactCallback mCallBack;
    private List<Long> uids;
    private List<UserInfoKS> userInfoBeans;

    public FBService(Environment env) {
        super(env);
    }

    public void getFBFriendListWithoutContacts(final OnGetFbFriendWithoutContactCallback callBack) {
        this.getFBFriendList(new OnGetFbFriendListCallBack(){

            public void onGetFbFriendSuccess(List<UserInfoKS> userInfoBeans, List<Long> uids) {
                if (uids != null && !uids.isEmpty()) {
                    FBService.this.filterWithContacts(userInfoBeans, uids, callBack);
                } else if (callBack != null) {
                    callBack.onGetFbFriendSuccess(userInfoBeans, uids);
                }
            }

            public void onError(int errCode, String msg) {
                if (callBack != null) {
                    callBack.onError(errCode, msg);
                }
            }
        });
    }

    private void filterWithContacts(List<UserInfoKS> userInfoBeans, List<Long> uids, OnGetFbFriendWithoutContactCallback callBack) {
        this.userInfoBeans = new ArrayList<UserInfoKS>(userInfoBeans != null ? userInfoBeans : Collections.emptyList());
        this.mFriendInfoList = ((IFriendServices)ServiceManagerProxy.getService(IFriendServices.class)).reqFriendList(false);
        Kvo.autoBindingTo((KvoSource)this.mFriendInfoList, (Object)((Object)this));
        this.uids = uids;
        this.mCallBack = callBack;
    }

    @KvoMethodAnnotation(name="friendList", sourceClass=FriendInfoList.class, thread=1)
    public void onFriendsList(KvoEventIntent event) {
        FriendInfoList friendInfoList = (FriendInfoList)event.source();
        if (friendInfoList.getLoadState() == LoadState.SUCCESS) {
            if (!friendInfoList.getUidList().isEmpty()) {
                List friendUids = friendInfoList.getUidList();
                if (this.mCallBack != null) {
                    this.mCallBack.onGetFriendListUids(friendUids);
                }
                if (!FP.empty(this.userInfoBeans) && !FP.empty(this.uids)) {
                    Iterator<UserInfoKS> iterator = this.userInfoBeans.iterator();
                    while (iterator.hasNext()) {
                        UserInfoKS info = iterator.next();
                        if (info == null || !friendUids.contains(info.uid)) continue;
                        iterator.remove();
                        this.uids.remove(info.uid);
                    }
                }
            }
            if (this.mCallBack != null) {
                this.mCallBack.onGetFbFriendSuccess(this.userInfoBeans, this.uids);
                this.mCallBack = null;
            }
        } else if (friendInfoList.getLoadState() == LoadState.FAIL) {
            MLog.info((Object)TAG, (String)"load friend list fail %s", (Object[])new Object[]{friendInfoList.getFailStateMsg() == null ? "" : friendInfoList.getFailStateMsg().getMsg()});
            if (this.mCallBack != null) {
                this.mCallBack.onGetFbFriendSuccess(this.userInfoBeans, this.uids);
                this.mCallBack = null;
            }
        }
    }

    public void getFBFriendList(final OnGetFbFriendListCallBack callBack) {
        AbsPlatformAdapter absPlatformAdapter = ThirdPartyPlatformHelper.getInstance().getPlatform(5);
        if (absPlatformAdapter != null) {
            absPlatformAdapter.getFriendList(new IGetFirendListCallBack(){

                public void onSuccess(ArrayList<UserBaseInfo> list) {
                    if (list == null || list.isEmpty()) {
                        if (callBack != null) {
                            callBack.onGetFbFriendSuccess(new ArrayList(), new ArrayList());
                        }
                        return;
                    }
                    this.getFbUserDetails(list);
                }

                private void getFbUserDetails(ArrayList<UserBaseInfo> list) {
                    UserInfoExtHelper.getUserExtListByFacebookUsers((IUserInfoService)((IUserInfoService)FBService.this.getServiceManager().getService(IUserInfoService.class)), list, (IGetUserInfoExtCallBack)new IGetUserInfoExtCallBack(){

                        public void onSuccess(ArrayList<UserInfoExt> userInfos) {
                            if (userInfos != null && !userInfos.isEmpty()) {
                                ArrayList<Long> uids = new ArrayList<Long>();
                                for (UserInfoExt info : userInfos) {
                                    if (info.mOurUserInfo == null) continue;
                                    uids.add(info.mOurUserInfo.uid);
                                }
                                if (!uids.isEmpty()) {
                                    this.getUserInfoData(uids);
                                    return;
                                }
                            }
                            if (callBack != null) {
                                callBack.onGetFbFriendSuccess(new ArrayList(), new ArrayList());
                            }
                        }

                        public void onError(String errorCode, Exception e) {
                            if (callBack != null) {
                                callBack.onError(StringUtils.safeParseInt((String)errorCode), e.getMessage());
                            }
                        }
                    });
                }

                private void getUserInfoData(final List<Long> uids) {
                    ((IUserInfoService)FBService.this.getServiceManager().getService(IUserInfoService.class)).requestUserInfosFromServer(uids, new OnKSProfileListCallback(){

                        public void onUISuccess(List<UserInfoKS> userInfo) {
                            if (callBack != null) {
                                callBack.onGetFbFriendSuccess(userInfo, uids);
                            }
                        }

                        public void onError(String reason, long code) {
                            if (callBack != null) {
                                callBack.onError(0, reason);
                            }
                        }
                    });
                }

                public void onError(int errorCode, Exception e) {
                    if (errorCode == 101) {
                        MLog.error((Object)FBService.TAG, (String)"errorCode:token invalid", (Object[])new Object[0]);
                    } else {
                        MLog.error((Object)FBService.TAG, (Throwable)e);
                    }
                    if (callBack != null) {
                        callBack.onError(errorCode, e.getMessage());
                    }
                }
            });
        }
    }
}

