/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.controller;

import android.os.Bundle;
import android.os.Message;
import android.view.View;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.appsflyer.ThirdTrackEvent;
import com.yy.appbase.appsflyer.ThirdTrackHelper;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.base.utils.SettingFlags;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogId;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.base.widget.CommonTipsDialog;
import com.yy.hiyo.im.base.ITitleBarListener;
import com.yy.im.R;
import com.yy.im.addfriend.hiido.AddFriendReporter;
import com.yy.im.msg.ImModuleMsgDef;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.ui.window.FriendsListPageWindow;
import com.yy.im.utils.JumpUtil;
import com.yy.im.viewmodel.BizViewModel;
import com.yy.im.viewmodel.ChatSessionViewModel;
import com.yy.im.viewmodel.FriendListViewModel;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class FriendListController
extends DefaultWindowController
implements ITitleBarListener {
    private static final String TAB_TYPE = "tab_type";
    private FriendListViewModel mViewModel = BizViewModel.getVM(this.getActivity(), FriendListViewModel.class, this.getServiceManager(), this.mDialogLinkManager);
    private ChatSessionViewModel mChatSessionVm = BizViewModel.getVM(this.getActivity(), ChatSessionViewModel.class, this.getServiceManager(), this.mDialogLinkManager);
    FriendsListPageWindow mWindow;
    private int type = 0;

    public FriendListController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == ImModuleMsgDef.OPEN_FRIEND_LIST_PAGE) {
            this.type = 0;
            this.getSelectType(msg);
            if (this.mWindow == null) {
                this.mWindow = new FriendsListPageWindow(this.mContext, (UICallBacks)this, this, this.mChatSessionVm, this.mViewModel, this.type);
            }
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
            this.checkShowFollowGuide();
            ThirdTrackHelper.INSTANCE.reportEvent(new ThirdTrackEvent().eventId("Click_Friends"));
        } else if (msg.what == ImModuleMsgDef.CHECK_RELATIONSHIP && msg.obj instanceof FriendListViewModel.RelationshipReq) {
            this.mViewModel.checkRelationship((FriendListViewModel.RelationshipReq)msg.obj);
        }
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification == null) {
            return;
        }
        if (notification.id == ImNotificationDef.IM_OPEN_FRIEND_LIST_PAGE) {
            this.sendMessage(ImModuleMsgDef.OPEN_FRIEND_LIST_PAGE);
        }
    }

    public Object handleMessageSync(Message msg) {
        if (msg.what == ImModuleMsgDef.DATA_FRIEND_LIST) {
            return this.mViewModel.getmRawContacts();
        }
        if (msg.what == ImModuleMsgDef.DATA_FRIEND_UIDS) {
            return this.mViewModel.getmFriendsUids();
        }
        return super.handleMessageSync(msg);
    }

    private void checkShowFollowGuide() {
        boolean isShowed = SettingFlags.getBoolean((String)"key_follow_guide", (boolean)false);
        if (isShowed) {
            return;
        }
        DialogLinkManager dialogLinkManager = new DialogLinkManager(this.mContext);
        CommonTipsDialog followDialog = (CommonTipsDialog)new CommonTipsDialog.Builder(this.mContext, DialogId.FollowGuideDialog).setLayoutId(R.layout.dialog_follow_guide_dialog).create();
        dialogLinkManager.showDialog((BaseDialog)followDialog);
        SettingFlags.setBoolean((String)"key_follow_guide", (boolean)true);
        ((ImModule)KvoModuleManager.getModule(ImModule.class)).deleteSession("-1");
    }

    public void onLeftBtnClick(View v) {
        if (this.mWindow != null) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
        }
    }

    public void onRightBtnClick(View v) {
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mViewModel != null) {
            this.mViewModel.onWindowDetach();
        }
        this.mWindow = null;
    }

    public void onWindowAttach(AbstractWindow abstractWindow) {
        super.onWindowAttach(abstractWindow);
        if (this.mViewModel != null) {
            this.mViewModel.onWindowAttach();
        }
        this.jumpToPosition();
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
        if (this.mWindow != null) {
            this.mWindow.onWindowShow();
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023789").put("function_id", "show"));
        AddFriendReporter.INSTANCE.reportContractsPageShow(this.mViewModel.getmFriendsUids().size());
    }

    private void jumpToPosition() {
        if (this.mWindow != null && this.type > 0 && this.type <= 3 && this.mWindow.getSlidingTabLayout() != null) {
            JumpUtil.jumpToTab((ViewPager)this.mWindow.getViewPager(), this.mWindow.getTabAdapter(), this.type);
            this.mWindow.getSlidingTabLayout().setCurrentTab(this.type);
        }
    }

    private void getSelectType(Message msg) {
        Bundle bundle = (Bundle)msg.obj;
        if (bundle != null) {
            this.type = bundle.getInt(TAB_TYPE);
        }
    }
}

