/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.controller;

import android.app.Activity;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.MutableLiveData;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.data.UserOnlineDBBean;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.sword.SwordHelper;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.im.ContactUtils;
import com.yy.hiyo.im.IChatSessionController;
import com.yy.hiyo.im.IChatSessionPage;
import com.yy.hiyo.im.IMsgReceiveService;
import com.yy.hiyo.im.ImBaseMsgDef;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.im.Utils;
import com.yy.hiyo.im.base.ITitleBarListener;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.Relation;
import com.yy.im.interfaces.OnItemDataClickListener;
import com.yy.im.interfaces.OnItemDataLongClickListener;
import com.yy.im.model.BbsNoticeEntranceSession;
import com.yy.im.model.ChannelNoticeEntranceSession;
import com.yy.im.model.ChatSession;
import com.yy.im.model.GamePublicChatSession;
import com.yy.im.model.GamePublicEntranceSession;
import com.yy.im.model.OfficialAccountChatSession;
import com.yy.im.model.OfficialAccountEntranceSession;
import com.yy.im.model.PublicChatSession;
import com.yy.im.model.SingleChatSession;
import com.yy.im.model.StrangerEntranceSession;
import com.yy.im.model.WhoHasSeenMeSession;
import com.yy.im.module.room.callback.IChatSessionPageCallback;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.report.ChatSessionEventReporter;
import com.yy.im.ui.window.ChatSessionPage;
import com.yy.im.ui.window.GamePublicSessionWindow;
import com.yy.im.ui.window.StrangerSessionWindow;
import com.yy.im.ui.window.chattab.ChatTabPage;
import com.yy.im.viewmodel.BizViewModel;
import com.yy.im.viewmodel.ChannelGroupRecommendViewModel;
import com.yy.im.viewmodel.ChatSessionViewModel;
import com.yy.im.viewmodel.CrawlerGroupModel;
import com.yy.im.viewmodel.SuggestedFriendViewModel;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import ikxd.msg.PullType;
import java.util.List;
import net.ihago.bbs.srv.mgr.GetNewPostsNoticeReq;
import net.ihago.bbs.srv.mgr.GetNewPostsNoticeRes;

public class ChatSessionController
extends DefaultWindowController
implements OnItemDataClickListener<ChatSession>,
OnItemDataLongClickListener<ChatSession>,
IChatSessionPageCallback,
IChatSessionController {
    public static final String TAG = "ChatSessionController";
    private ChatSessionViewModel mViewModel;
    private IChatSessionPage mChatPage;
    private SuggestedFriendViewModel mSuggestedFriendViewModel;
    private ChannelGroupRecommendViewModel mChannelGroupRecommendViewModel;
    private CrawlerGroupModel mCrawlerGroupModel;
    private StrangerSessionWindow mStrangerWindow;
    private GamePublicSessionWindow mGamePublicSessionWindow;
    private GamePublicSessionWindow mOfficialAccountWindow;
    private boolean isCheckOfficeMsg = true;

    public ChatSessionController(Environment env) {
        super(env);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_CHAT_SESSION_PAGE_SHOW_LOADING, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_CHAT_SESSION_PAGE_HIDE_LOADING, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_LOGIN_OUT, (INotify)this);
    }

    public void onShow(boolean isFirstShow) {
        PermissionHelper.requestLocationPermission((Activity)this.getActivity(), null, (boolean)false);
        this.onShown(isFirstShow);
    }

    private void initChatVM() {
        if (this.mViewModel == null) {
            this.mViewModel = BizViewModel.getVM(this.getActivity(), ChatSessionViewModel.class, this.getServiceManager(), this.mDialogLinkManager);
        }
    }

    private void initSuggestVM() {
        if (this.mSuggestedFriendViewModel == null) {
            this.mSuggestedFriendViewModel = BizViewModel.getVM(this.getActivity(), SuggestedFriendViewModel.class, this.getServiceManager(), this.mDialogLinkManager);
        }
    }

    private void initChannelGroupRecommendVM() {
        if (this.mChannelGroupRecommendViewModel == null) {
            this.mChannelGroupRecommendViewModel = BizViewModel.getVM(this.getActivity(), ChannelGroupRecommendViewModel.class, this.getServiceManager(), this.mDialogLinkManager);
        }
    }

    private void initCrawlerGroupVM() {
        if (this.mCrawlerGroupModel == null) {
            this.mCrawlerGroupModel = BizViewModel.getVM(this.getActivity(), CrawlerGroupModel.class, this.getServiceManager(), this.mDialogLinkManager);
        }
    }

    private void initVm() {
        this.initChatVM();
        this.initSuggestVM();
        this.initChannelGroupRecommendVM();
        this.initCrawlerGroupVM();
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id != ImNotificationDef.IM_CHAT_SESSION_PAGE_SHOW_LOADING && notification.id != ImNotificationDef.IM_CHAT_SESSION_PAGE_HIDE_LOADING) {
            if (notification.id == NotificationDef.N_LOGIN_LOGIN_OUT) {
                if (this.mChatPage != null) {
                    this.mChatPage.onLogout();
                }
            } else if (notification.id == NotificationIdDef.CHANNEL_ENTERED) {
                Object game_extend;
                if (!(notification.extObj instanceof String)) {
                    return;
                }
                IChannelCenterService service2 = (IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class);
                if (service2 == null) {
                    return;
                }
                IChannel channel = service2.getChannel((String)notification.extObj);
                if (channel == null) {
                    return;
                }
                IPluginService pluginService = channel.getPluginService();
                if (pluginService == null) {
                    return;
                }
                ChannelPluginData pluginData = pluginService.getCurPluginData();
                if (pluginData == null) {
                    return;
                }
                String pluginId = pluginData.getPluginId();
                if (TextUtils.isEmpty((CharSequence)pluginId)) {
                    return;
                }
                if (pluginId.equals("MLBB")) {
                    SettingFlags.setLongValue((String)"key_time_to_enter_mbll_room", (long)System.currentTimeMillis());
                }
                if (channel.getEnterParam() != null && (game_extend = channel.getEnterParam().getExtra("game_extend", null)) instanceof String && "gangup".equals(game_extend)) {
                    SettingFlags.setLongValue((String)"KEY_TIME_TO_ENTER_MBLL_FROM_DEEPLINK", (long)System.currentTimeMillis());
                }
            }
        }
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == ImBaseMsgDef.OPEN_CHAT_STRANGER_PAGE) {
            this.openStrangerWindow();
        }
    }

    public Object handleMessageSync(Message msg) {
        if (msg.what == ImBaseMsgDef.GET_CHAT_SESSION_PAGE_CONTROLLER) {
            return this;
        }
        return null;
    }

    private void createChatPage() {
        if (this.mChatPage == null) {
            this.initVm();
            this.mChatPage = new ChatTabPage(this.mContext);
        }
    }

    private void querySquareEntrance() {
        GetNewPostsNoticeReq req = new GetNewPostsNoticeReq.Builder().build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetNewPostsNoticeRes>(){

            public void onResponse(@NonNull GetNewPostsNoticeRes message, long code, String msg) {
                if (ProtoManager.isSuccessCode((long)code) && message.notice != null) {
                    MLog.info((Object)ChatSessionController.TAG, (String)"querySquareEntrance onResponse id: %s content: %s  type: %s", (Object[])new Object[]{message.notice.topic_id, message.notice.content, message.notice.type});
                    if (ChatSessionController.this.mViewModel != null) {
                        ChatSessionController.this.mViewModel.setPostsNotice(message.notice);
                    }
                } else {
                    MLog.info((Object)ChatSessionController.TAG, (String)"querySquareEntrance onResponse error code: %s msg: %s", (Object[])new Object[]{code, msg});
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.info((Object)ChatSessionController.TAG, (String)"querySquareEntrance retryWhenTimeout", (Object[])new Object[0]);
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.info((Object)ChatSessionController.TAG, (String)"querySquareEntrance retryWhenError code: %s  msg: %s", (Object[])new Object[]{code, reason});
                return false;
            }
        });
    }

    @Nullable
    public IChatSessionPage getChatSessionPage() {
        this.createChatPage();
        return this.mChatPage;
    }

    public View getChatPageView() {
        return new ChatSessionPage(this.mContext, this, this.mViewModel, this.mSuggestedFriendViewModel, this.mChannelGroupRecommendViewModel, this.mCrawlerGroupModel, this, new ITitleBarListener(){

            public void onLeftBtnClick(View v) {
                MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.OPEN_HOME_SEARCH_WINDOW, 3);
            }

            public void onRightBtnClick(View v) {
                MsgDispatcher.getInstance().sendMessage(ImBaseMsgDef.OPEN_FRIEND_LIST_PAGE);
            }
        }, this, this.mWindowMgr.getCurrentRootWindow().getBaseLayer());
    }

    @Override
    public void onAttached() {
        this.initVm();
        if (this.mViewModel != null) {
            this.mViewModel.onWindowAttach();
        }
        if (this.mSuggestedFriendViewModel != null) {
            this.mSuggestedFriendViewModel.onWindowAttach();
        }
        if (this.mChannelGroupRecommendViewModel != null) {
            this.mChannelGroupRecommendViewModel.onWindowAttach();
        }
        if (this.mCrawlerGroupModel != null) {
            this.mCrawlerGroupModel.onWindowAttach();
        }
    }

    @Override
    public void onDetached() {
        if (this.mViewModel != null) {
            this.mViewModel.onWindowDetach();
        }
        if (this.mSuggestedFriendViewModel != null) {
            this.mSuggestedFriendViewModel.onWindowDetach();
        }
        if (this.mChannelGroupRecommendViewModel != null) {
            this.mChannelGroupRecommendViewModel.onWindowDetach();
        }
        if (this.mCrawlerGroupModel != null) {
            this.mCrawlerGroupModel.onWindowDetach();
        }
    }

    public void backShown() {
    }

    public void destroyChatPageView() {
        if (this.mChatPage != null) {
            this.mChatPage.onDestroy();
        }
        this.mChatPage = null;
    }

    private void onShown(boolean isFirstShow) {
        this.initVm();
        if (this.mViewModel != null) {
            this.mViewModel.onWindowShow();
        }
        if (this.mSuggestedFriendViewModel != null) {
            this.mSuggestedFriendViewModel.onWindowShow();
        }
        if (this.mChatPage != null) {
            this.mChatPage.onShow(isFirstShow);
            SwordHelper.checkViewLevelAndOverDraw((ViewGroup)((ViewGroup)this.mChatPage), (String)"chatPage");
        }
        this.querySquareEntrance();
        this.pullOfficeMsg();
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "show"));
        ImModule imModule = (ImModule)KvoModuleManager.getModule(ImModule.class);
        ChatSessionEventReporter.INSTANCE.reportEnterListCount(imModule.getMessageListCount(), imModule.getUnreadMessageCount(), imModule.getUnreadRedCount());
    }

    private void pullOfficeMsg() {
        ImService imService = (ImService)this.getServiceManager().getService(ImService.class);
        if (imService != null) {
            IMsgReceiveService iMessageService = imService.getReceiveMsg();
            iMessageService.pullMsg(PullType.Default.getValue());
            if (this.isCheckOfficeMsg) {
                this.checkOldVersionOfficeMsg();
                this.isCheckOfficeMsg = false;
            }
        }
    }

    private void checkOldVersionOfficeMsg() {
        MyBox msgBox = ((IDBService)this.getServiceManager().getService(IDBService.class)).boxForCurUser(ImMessageDBBean.class);
        if (msgBox == null) {
            return;
        }
        ImModule kvo = (ImModule)KvoModuleManager.getModule(ImModule.class);
        String sessionId2 = Utils.getSessionId((long)AccountUtil.getUid(), (long)10L);
        msgBox.getAll(dbList -> {
            if (dbList == null || dbList.size() <= 0) {
                MLog.info((Object)TAG, (String)"onLoaded dbList is null", (Object[])new Object[0]);
                return;
            }
            if (kvo != null) {
                boolean existNormalMsg = false;
                for (ImMessageDBBean msg : dbList) {
                    if (msg == null || !StringUtils.equal((String)msg.getSessionId(), (String)sessionId2)) continue;
                    if ((msg.getMsgType() == 8 || msg.getMsgType() == 10) && (TextUtils.isEmpty((CharSequence)msg.getReportContent()) || TextUtils.isEmpty((CharSequence)msg.getReportTitle()))) {
                        msgBox.deleteItem((BaseDBBean)msg);
                        continue;
                    }
                    existNormalMsg = true;
                }
                if (!existNormalMsg) {
                    kvo.deleteSession(sessionId2);
                }
            }
        });
    }

    public void onHide() {
        if (this.mViewModel != null) {
            this.mViewModel.onWindowHide();
        }
        if (this.mSuggestedFriendViewModel != null) {
            this.mSuggestedFriendViewModel.onWindowHide();
        }
        if (this.mChatPage != null) {
            this.mChatPage.onHide();
            SwordHelper.detachViewLevelAndOverDraw((ViewGroup)((ViewGroup)this.mChatPage));
        }
        ContactUtils.S_CAN_CONTACT_DIALOG_SHOW = false;
        ImModule imModule = (ImModule)KvoModuleManager.getModule(ImModule.class);
        ChatSessionEventReporter.INSTANCE.reportExitListCount(imModule.getMessageListCount(), imModule.getUnreadMessageCount(), imModule.getUnreadRedCount());
    }

    @Override
    public void onClickItem(View v, ChatSession session, int position) {
        if (session instanceof SingleChatSession) {
            ((SingleChatSession)session).setStrategyType(0);
            ChatSessionEventReporter.INSTANCE.reportPersonalUnreadClick(session.getUid(), session.getUnReadCounts(), this.parseStrategyType((SingleChatSession)session));
            UserOnlineDBBean onlineDBBean = session.getUserOnlineDBBean();
            String singleStatus = onlineDBBean == null || !onlineDBBean.isOnline() ? "" : (onlineDBBean.isInRoom() && "radio_video".equals(onlineDBBean.getChannelPlugin()) ? "3" : (onlineDBBean.isInRoom() && "radio_video".equals(onlineDBBean.getChannelPlugin()) ? "2" : "1"));
            IRelationService relationService = (IRelationService)ServiceManagerProxy.getService(IRelationService.class);
            String userIdentity = "";
            if (relationService != null) {
                Relation relation = relationService.getRelationLocal(session.getUid()).getRelation();
                userIdentity = relation == Relation.FOLLOW ? "2" : (relation == Relation.FRIEND ? "3" : "1");
            }
            HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "message_click").put("message_type", "2").put("message_uit_amount_unread", String.valueOf(session.getUnReadCounts())).put("is_include_no_action_strategy", ((SingleChatSession)session).getStrategyType() > 0 ? "1" : "0").put("new_guide_strategy_type", String.valueOf(((SingleChatSession)session).getNewGuideStrategyType())).put("single_status", singleStatus).put("user_indentity", userIdentity).put("click_part", "2"));
        } else if (session instanceof PublicChatSession) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "message_click").put("message_type", "13").put("message_uit_amount_unread", String.valueOf(session.getUnReadCounts())));
        } else if (session instanceof StrangerEntranceSession) {
            this.openStrangerWindow();
            HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "message_click").put("message_type", "9").put("message_uit_amount_unread", String.valueOf(session.getUnReadCounts())).put("is_include_no_action_strategy", "0"));
        } else if (session instanceof GamePublicChatSession) {
            ((ImModule)KvoModuleManager.getModule(ImModule.class)).updateSession(session.getSessionId());
        } else if (session instanceof GamePublicEntranceSession) {
            MutableLiveData data2;
            MutableLiveData sessions = data2 = ((ImModule)KvoModuleManager.getModule(ImModule.class)).getGamePublicChatSessions();
            ((ImModule)KvoModuleManager.getModule(ImModule.class)).updateSession(session.getSessionId());
            if (this.mGamePublicSessionWindow == null) {
                this.mGamePublicSessionWindow = new GamePublicSessionWindow(this.mContext, (UICallBacks)this, this, (MutableLiveData<List<ChatSession>>)sessions, session, this);
            }
            this.mWindowMgr.pushWindow((AbstractWindow)this.mGamePublicSessionWindow, true);
        } else if (session instanceof OfficialAccountChatSession) {
            ((ImModule)KvoModuleManager.getModule(ImModule.class)).updateSession(session.getSessionId());
        } else if (session instanceof OfficialAccountEntranceSession) {
            MutableLiveData data3;
            MutableLiveData sessions = data3 = ((ImModule)KvoModuleManager.getModule(ImModule.class)).getOfficialAccountChatSessions();
            ((ImModule)KvoModuleManager.getModule(ImModule.class)).updateSession(session.getSessionId());
            if (this.mOfficialAccountWindow == null) {
                this.mOfficialAccountWindow = new GamePublicSessionWindow(this.mContext, (UICallBacks)this, this, (MutableLiveData<List<ChatSession>>)sessions, session, this);
            }
            this.mWindowMgr.pushWindow((AbstractWindow)this.mOfficialAccountWindow, true);
        } else if (session instanceof WhoHasSeenMeSession) {
            HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "message_click").put("message_type", "10").put("message_uit_amount_unread", String.valueOf(session.getUnReadCounts())));
        } else if (session instanceof BbsNoticeEntranceSession) {
            HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "message_click").put("message_type", "11").put("message_uit_amount_unread", String.valueOf(session.getUnReadCounts())));
        } else if (session instanceof ChannelNoticeEntranceSession) {
            HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "message_click").put("message_type", "12").put("message_uit_amount_unread", String.valueOf(session.getUnReadCounts())));
        }
        ChatSessionEventReporter.INSTANCE.reportMessageAccountClick(session);
    }

    private void openStrangerWindow() {
        MutableLiveData data2;
        MutableLiveData sessions = data2 = ((ImModule)KvoModuleManager.getModule(ImModule.class)).getStrangerSessions();
        ((ImModule)KvoModuleManager.getModule(ImModule.class)).updateSession("-3");
        if (this.mStrangerWindow == null) {
            this.mStrangerWindow = new StrangerSessionWindow(this.mContext, (UICallBacks)this, this, (MutableLiveData<List<ChatSession>>)sessions, this);
        }
        this.mWindowMgr.pushWindow((AbstractWindow)this.mStrangerWindow, true);
    }

    @Override
    public void onLongClickItem(View v, ChatSession session, int position) {
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mStrangerWindow != null && this.mStrangerWindow == abstractWindow) {
            this.mStrangerWindow = null;
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_EXIT_STRANGER_SESSION));
        }
        if (this.mGamePublicSessionWindow != null && this.mGamePublicSessionWindow == abstractWindow) {
            this.mGamePublicSessionWindow = null;
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_EXIT_GAME_PUBLIC_SESSION));
        }
        if (this.mOfficialAccountWindow != null && this.mOfficialAccountWindow == abstractWindow) {
            this.mOfficialAccountWindow = null;
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_EXIT_OFFICIAL_ACCOUNT_SESSION));
        }
    }

    public void onWindowAttach(AbstractWindow abstractWindow) {
        super.onWindowAttach(abstractWindow);
        if (abstractWindow == this.mStrangerWindow) {
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_ENTER_STRANGER_SESSION));
        } else if (abstractWindow == this.mGamePublicSessionWindow) {
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_ENTER_GAME_PUBLIC_SESSION));
        } else if (abstractWindow == this.mOfficialAccountWindow) {
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_ENTER_OFFICIAL_ACCOUNT_SESSION));
        }
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
        if (abstractWindow == this.mGamePublicSessionWindow) {
            ((ImModule)KvoModuleManager.getModule(ImModule.class)).onShow();
        }
    }

    public void onWindowHidden(AbstractWindow abstractWindow) {
        super.onWindowHidden(abstractWindow);
        ((ImModule)KvoModuleManager.getModule(ImModule.class)).onHide();
    }

    private int parseStrategyType(SingleChatSession chatSession) {
        int strategyType = chatSession.getStrategyType();
        if (strategyType <= 0) {
            switch (chatSession.getNewGuideStrategyType()) {
                case 3: {
                    strategyType = 3;
                    break;
                }
                case 1: {
                    strategyType = 4;
                    break;
                }
                case 2: {
                    strategyType = 5;
                    break;
                }
            }
        }
        return strategyType;
    }
}

