/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.controller;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.view.View;
import com.yy.appbase.R;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.appsflyer.ThirdTrackEvent;
import com.yy.appbase.appsflyer.ThirdTrackHelper;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.appbase.kvo.CheckStatus;
import com.yy.appbase.kvo.moduledata.PlatformPermissionModuleData;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.PlatformPermissionModule;
import com.yy.appbase.login.IZaloAccountSwitch;
import com.yy.appbase.service.ISocialMediaService;
import com.yy.appbase.socialmdeia.SocialMediaInfo;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.guid.GuidFactory;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.im.base.ITitleBarListener;
import com.yy.hiyo.login.base.IBindThirdPartyAccountCallBack;
import com.yy.hiyo.login.base.IFacebookLoginCallback;
import com.yy.im.R;
import com.yy.im.interfaces.OnInviteMoreFriendsClick;
import com.yy.im.interfaces.OnSearchEntranceClick;
import com.yy.im.msg.ImModuleMsgDef;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.ui.window.AddFriendsWindow;
import com.yy.im.viewmodel.BizViewModel;
import com.yy.im.viewmodel.SuggestedFriendViewModel;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class AddFriendsController
extends DefaultWindowController
implements ITitleBarListener,
OnSearchEntranceClick,
OnInviteMoreFriendsClick {
    private static final String TAG = "AddFriendsController";
    private SuggestedFriendViewModel mSuggestedFriendVm;
    private AddFriendsWindow mWindow;
    private CheckStatus mFacebookState = null;
    private IBindThirdPartyAccountCallBack mBindThirdPartyAccountCallBack = new IBindThirdPartyAccountCallBack(){

        public void onSuccess() {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ToastUtils.showToast((Context)AddFriendsController.this.mContext, (int)R.string.bind_fb_success, (int)1);
                }
            });
        }

        public void onCancel() {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ToastUtils.showToast((Context)AddFriendsController.this.mContext, (int)R.string.fb_bind_cancel, (int)1);
                }
            });
        }

        public void onError(final int errorCode, Exception e) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (errorCode == 20410) {
                        ToastUtils.showToast((Context)AddFriendsController.this.mContext, (String)ResourceUtils.getString((int)R.string.fb_err_no_phone_login), (int)1);
                    } else if (errorCode == 20413) {
                        ToastUtils.showToast((Context)AddFriendsController.this.mContext, (String)ResourceUtils.getString((int)R.string.fb_err_account_has_bind_other_phone), (int)1);
                    } else if (errorCode == 20412) {
                        ToastUtils.showToast((Context)AddFriendsController.this.mContext, (String)ResourceUtils.getString((int)R.string.fb_err_phone_has_bind_other_account), (int)1);
                    } else if (errorCode == 20422) {
                        AddFriendsController.this.showSwitchAccountDialog();
                    } else {
                        ToastUtils.showToast((Context)AddFriendsController.this.mContext, (String)ResourceUtils.getString((int)R.string.fb_connect_fail), (int)1);
                    }
                }
            });
        }
    };

    public AddFriendsController(Environment env) {
        super(env);
        this.mSuggestedFriendVm = BizViewModel.getVM(this.getActivity(), SuggestedFriendViewModel.class, this.getServiceManager(), this.mDialogLinkManager);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_ACCOUNT_CHANGED, (INotify)this);
    }

    private boolean isAtTop() {
        return this.mWindow != null && this.mWindowMgr.getCurrentWindow() == this.mWindow;
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == ImNotificationDef.IM_OPEN_ADD_FRIENDS_PAGE) {
            this.sendMessage(ImModuleMsgDef.OPEN_ADD_FRIENDS_PAGE);
        } else if (notification.id == NotificationDef.N_FOREGROUND_CHANGE) {
            if (notification.extObj != null) {
                this.onForegroundChange((Boolean)notification.extObj);
            }
        } else if (notification.id == NotificationDef.N_LOGIN_ACCOUNT_CHANGED) {
            MLog.info((Object)TAG, (String)"on login account change", (Object[])new Object[0]);
            if (this.isAtTop() && AccountUtil.getUid() > 0L) {
                this.checkFacebookAuthStatus();
            }
        } else if (notification.id == ImNotificationDef.IM_CHAT_SESSION_PAGE_SHOW_LOADING) {
            if (this.mWindow != null) {
                this.mWindow.showLoading();
            }
        } else if (notification.id == ImNotificationDef.IM_CHAT_SESSION_PAGE_HIDE_LOADING && this.mWindow != null) {
            this.mWindow.hideLoading();
        }
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == ImModuleMsgDef.OPEN_ADD_FRIENDS_PAGE) {
            if (this.mWindow != null) {
                this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
            }
            this.mWindow = new AddFriendsWindow(this.mContext, this.mSuggestedFriendVm, (UICallBacks)this, this, this, this);
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
            ThirdTrackHelper.INSTANCE.reportEvent(new ThirdTrackEvent().eventId("Click_AddFriends"));
            ((ISocialMediaService)this.getServiceManager().getService(ISocialMediaService.class)).getAddFriendPage((ICommonCallback)new ICommonCallback<SocialMediaInfo>(){

                public void onSuccess(SocialMediaInfo info, Object ... ext) {
                    if (info.canShow() && AddFriendsController.this.mWindow != null) {
                        AddFriendsController.this.mWindow.showSocialMedia(info);
                    }
                }

                public void onFail(int errCode, String msg, Object ... ext) {
                    if (AddFriendsController.this.mWindow != null) {
                        AddFriendsController.this.mWindow.hideSocialMedia();
                    }
                }
            });
        }
    }

    public void onLeftBtnClick(View v) {
        if (this.mWindow != null) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
        }
    }

    public void onRightBtnClick(View v) {
        this.sendMessage(ImModuleMsgDef.OPEN_FRIEND_LIST_PAGE);
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        statContent.put("sfield", GuidFactory.getInstance().getGuid());
        statContent.put("sfieldtwo", AccountUtil.getUid());
        statContent.put("perftype", "opensfl");
        HiidoStatis.reportContent((StatisContent)statContent);
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
        if (this.mSuggestedFriendVm != null) {
            this.mSuggestedFriendVm.onWindowShow();
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023791").put("function_id", "show"));
    }

    public void onWindowHidden(AbstractWindow abstractWindow) {
        super.onWindowHidden(abstractWindow);
        if (this.mSuggestedFriendVm != null) {
            this.mSuggestedFriendVm.onWindowHide();
        }
        if (this.mWindow != null) {
            this.mWindow.hideSocialMedia();
        }
    }

    public void onWindowAttach(AbstractWindow abstractWindow) {
        super.onWindowAttach(abstractWindow);
        if (this.mSuggestedFriendVm != null) {
            this.mSuggestedFriendVm.onWindowAttach();
        }
        this.checkFacebookAuthStatus();
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mWindow == abstractWindow) {
            this.mWindow = null;
        }
        if (this.mSuggestedFriendVm != null) {
            this.mSuggestedFriendVm.onWindowDetach();
        }
    }

    @Override
    public void onSearchEntranceClick(View view) {
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_OPEN_SEARCH_FRIENDS_PAGE, (Object)1));
    }

    @Override
    public void onFacebookConnectClick() {
        this.bindFacebook();
    }

    @Override
    public void onZaloConnectClick() {
        if (AccountUtil.isLoginByGuest()) {
            Message msg = Message.obtain();
            msg.what = BaseMsgDef.MSG_GUEST_LOGIN_WITH_TYPE;
            Bundle bundle = new Bundle();
            bundle.putInt("key_login_type", 7);
            bundle.putInt("key_login_source", 6);
            msg.setData(bundle);
            this.sendMessage(msg);
        } else {
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).bindZalo(null);
        }
    }

    @Override
    public void onSocialMediaClick(SocialMediaInfo info) {
        ((ISocialMediaService)this.getServiceManager().getService(ISocialMediaService.class)).onSocialClick(info);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (AddFriendsController.this.mWindow != null) {
                    AddFriendsController.this.mWindow.hideSocialMedia();
                }
            }
        }, (long)500L);
    }

    @Override
    public void onInviteMoreFriendsClick(View view) {
        this.sendMessage(BaseMsgDef.MSG_SHARE_LIST);
    }

    private void onForegroundChange(boolean isForeground) {
        if (isForeground && this.mWindow != null) {
            this.mWindow.checkContactAuthStatus();
            this.checkFacebookPermission();
        }
    }

    public void checkFacebookAuthStatus() {
        KvoSource moduleData = KvoModuleManager.getModuleData(PlatformPermissionModule.class);
        if (!(moduleData instanceof PlatformPermissionModuleData)) {
            return;
        }
        PlatformPermissionModuleData moduleData1 = (PlatformPermissionModuleData)moduleData;
        this.mFacebookState = moduleData1.facebookState;
        Kvo.removeKvoBinding((KvoSource)this.mFacebookState, (Object)this, (String)"onFacebookPermissionChange");
        Kvo.addKvoBinding((KvoSource)this.mFacebookState, (Object)this, (String)"onFacebookPermissionChange");
        this.checkFacebookPermission();
    }

    private void checkFacebookPermission() {
        if (this.mFacebookState != null) {
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).facebookPermission(this.mFacebookState.permissionState);
        }
    }

    @KvoMethodAnnotation(name="permissionState", sourceClass=CheckStatus.class, thread=1)
    public void onFacebookPermissionChange(KvoEventIntent event) {
        if (this.mFacebookState == null || this.mFacebookState.permissionState == CheckStatus.UNCHECK) {
            return;
        }
        if (this.mWindow != null) {
            if (this.mFacebookState.permissionState == CheckStatus.UNAUTH) {
                this.mWindow.setFacebookItemVisibility(0);
            } else {
                this.mWindow.setFacebookItemVisibility(8);
            }
        }
    }

    private void bindFacebook() {
        if (this.mFacebookState == null) {
            return;
        }
        if (AccountUtil.isLoginByGuest()) {
            Message msg = Message.obtain();
            msg.what = BaseMsgDef.MSG_GUEST_LOGIN_WITH_TYPE;
            Bundle bundle = new Bundle();
            bundle.putInt("key_login_type", 1);
            bundle.putInt("key_login_source", 5);
            msg.setData(bundle);
            this.sendMessage(msg);
        } else if (this.mFacebookState.permissionState == CheckStatus.UNAUTH) {
            ((PlatformPermissionModule)KvoModuleManager.getModule(PlatformPermissionModule.class)).bindFacebook((Object)this.mBindThirdPartyAccountCallBack);
        }
    }

    private void showSwitchAccountDialog() {
        DialogLinkManager dialogLinkManager = new DialogLinkManager(this.mContext);
        OkCancelDialog tipsDialog2 = new OkCancelDialog((CharSequence)ResourceUtils.getString((int)R.string.facebook_switch_account), (CharSequence)ResourceUtils.getString((int)R.string.contact_dialog_ok), (CharSequence)ResourceUtils.getString((int)R.string.contact_dialog_cancel), true, new OkCancelDialogListener(){

            public void onCancel() {
            }

            public void onOk() {
                AddFriendsController.this.sendMessage(BaseMsgDef.MSG_FACEBOOK_SWITCH_BIND, -1, -1, new IFacebookLoginCallback(){

                    public void onSuccess() {
                        Message msg = Message.obtain();
                        msg.what = BaseMsgDef.GOTO_HOMEPAGE;
                        AddFriendsController.this.sendMessage(msg);
                    }

                    public void onCancel() {
                    }

                    public void onError(String errorCode, String des) {
                    }
                });
            }
        });
        dialogLinkManager.showDialog((BaseDialog)tipsDialog2);
    }

    private void showSwitchZaloAccountDialog() {
        DialogLinkManager dialogLinkManager = new DialogLinkManager(this.mContext);
        OkCancelDialog tipsDialog2 = new OkCancelDialog((CharSequence)ResourceUtils.getString((int)R.string.zalo_switch_account), (CharSequence)ResourceUtils.getString((int)R.string.contact_dialog_ok), (CharSequence)ResourceUtils.getString((int)R.string.contact_dialog_cancel), true, new OkCancelDialogListener(){

            public void onCancel() {
            }

            public void onOk() {
                AddFriendsController.this.sendMessage(BaseMsgDef.MSG_ZALO_BIND_SWITCH_ACCOUNT, -1, -1, new IZaloAccountSwitch(){

                    public void onSuccess() {
                        Message msg = Message.obtain();
                        msg.what = BaseMsgDef.GOTO_HOMEPAGE;
                        AddFriendsController.this.sendMessage(msg);
                    }

                    public void onCancel() {
                    }

                    public void onError(int errorCode, Exception e) {
                    }
                });
            }
        });
        dialogLinkManager.showDialog((BaseDialog)tipsDialog2);
    }
}

