/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.cim;

import android.text.TextUtils;
import com.hummer.im.HMR;
import com.hummer.im._internals.mq.Source;
import com.hummer.im.service.MQService;
import com.hummer.im.service.RoamingService;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.NotifySourceBean;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.service.ICIMService;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.unreadmsg.IChannelUnreadMsgNotifyCallbak;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.mvp.base.ExtensionsKt;
import com.yy.im.cim.CIMModule;
import com.yy.im.cim.CIMMsgSource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;

public class CIMServer
extends DefaultController
implements ICIMService {
    private static final String TAG = "CIMServer";
    private boolean inited = false;
    private boolean opened = false;
    private boolean opening = false;
    private boolean initSuccess = false;
    private List<NotifySourceBean> cidsToAdd;
    private RoamingService.RoamingChatListener chatListenerToAdd;

    public CIMServer(Environment env) {
        super(env);
        ExtensionsKt.onUi(() -> {
            NotificationCenter.getGlobalInstance().register(NotificationDef.WSCLIENT_CONNECT_SUCCESS, (INotify)this);
            NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_ACCOUNT_CHANGED, (INotify)this);
            if (RuntimeContext.sIsAppStartFinishAfterThreeSecond) {
                MLog.info((Object)TAG, (String)"try init cim", (Object[])new Object[0]);
                this.initCIM();
            } else {
                NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS, (INotify)this);
            }
            return null;
        });
    }

    public synchronized boolean initCIM() {
        if (this.inited || AccountUtil.getUid() <= 0L) {
            MLog.info((Object)TAG, (String)("Ignore initCIM, inited: " + this.inited + ", uid: " + AccountUtil.getUid()), (Object[])new Object[0]);
            return this.initSuccess;
        }
        this.inited = true;
        this.initSuccess = CIMModule.INSTANCE.init(RuntimeContext.sApplicationContext, this.getAppId(), "indonesia/test/hago");
        MLog.info((Object)TAG, (String)"initCIM result:%d", (Object[])new Object[]{this.initSuccess ? 1 : 0});
        PerfActionLog.add((String)"Net_", (Object[])new Object[]{"initCIM"});
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ((IChannelCenterService)CIMServer.this.getServiceManager().getService(IChannelCenterService.class)).ensureMsgHandler();
                ((ImService)CIMServer.this.getServiceManager().getService(ImService.class)).getReceiveMsg().ensureCimMsgHander();
            }
        });
        return this.initSuccess;
    }

    private long getAppId() {
        EnvSettingType type = EnvSettings.instance().getUriSettingValue();
        if (SystemUtils.isShowEnvSetting() && type == EnvSettingType.Test) {
            return 1414209574L;
        }
        return 1236618350L;
    }

    public synchronized void open() {
        if (AccountUtil.getUid() <= 0L || this.opened) {
            MLog.info((Object)TAG, (String)("Ignore open, opened: " + this.opened + ", uid: " + AccountUtil.getUid()), (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"open", (Object[])new Object[0]);
        this.openInner(null);
    }

    private void openInner(ICIMService.IOpenCallBack callBack) {
        this.openInner(callBack, 0);
    }

    private void openInner(final ICIMService.IOpenCallBack callBack, final int retryTimes) {
        if (this.opened) {
            return;
        }
        this.opening = true;
        CIMModule.INSTANCE.open(AccountUtil.getUid(), new CIMModule.IOpenCallBack(){

            @Override
            public void onsuccess() {
                MLog.info((Object)CIMServer.TAG, (String)"open CIMModule success", (Object[])new Object[0]);
                CIMServer.this.opened = true;
                CIMServer.this.opening = false;
                if (callBack != null) {
                    callBack.onsuccess();
                }
                if (CIMServer.this.cidsToAdd != null) {
                    CIMServer.this.addNotifySources(CIMServer.this.cidsToAdd);
                }
                if (CIMServer.this.chatListenerToAdd != null) {
                    CIMServer.this.addRoamingCahtListener(CIMServer.this.chatListenerToAdd);
                }
            }

            @Override
            public void onError(int errorCode, final String tips) {
                CIMServer.this.opening = false;
                if (retryTimes < 2) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MLog.error((Object)CIMServer.TAG, (String)("open CIMModule failed, tips: " + tips + ", retryTimes = " + retryTimes), (Object[])new Object[0]);
                            CIMServer.this.openInner(callBack, retryTimes + 1);
                        }
                    }, (long)1000L);
                } else {
                    MLog.error((Object)CIMServer.TAG, (String)("open CIMModule failed, tips: " + tips), (Object[])new Object[0]);
                    if (callBack != null) {
                        callBack.onError(errorCode, tips);
                    }
                }
            }
        });
    }

    public boolean isOpened() {
        return this.inited && this.opened;
    }

    public void open(ICIMService.IOpenCallBack callBack) {
        if (this.opened) {
            callBack.onsuccess();
        } else {
            this.openInner(callBack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addNotifySources(List<NotifySourceBean> cids) {
        if (this.cidsToAdd == null) {
            this.cidsToAdd = new ArrayList<NotifySourceBean>();
        }
        CIMServer cIMServer = this;
        synchronized (cIMServer) {
            if (cids != this.cidsToAdd) {
                this.cidsToAdd.addAll(cids);
            }
        }
        final Runnable command = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList cidsCopy = null;
                Object object = CIMServer.this;
                synchronized (object) {
                    if (CIMServer.this.cidsToAdd == null || CIMServer.this.cidsToAdd.size() <= 0) {
                        return;
                    }
                    cidsCopy = new ArrayList(CIMServer.this.cidsToAdd);
                }
                for (NotifySourceBean bean : cidsCopy) {
                    String cid = bean.getCid();
                    CRC32 crc32 = new CRC32();
                    crc32.update(cid.getBytes());
                    long channelIdInt = crc32.getValue();
                    ((MQService)HMR.getService(MQService.class)).addSource((MQService.Source)new Source((Source.Mode)new Source.Shared(channelIdInt, "aggregate_" + cid, bean.getRegion(), MQService.FetchStrategy.IgnoreBefore)));
                    if (!SystemUtils.isShowEnvSetting() || !TextUtils.isEmpty((CharSequence)bean.getRegion())) continue;
                    String msg = StringUtils.format((String)"\u975e\u6cd5\u9891\u9053\u5927\u533a cid: %s, region: %s", (Object[])new Object[]{cid, bean.getRegion()});
                    MLog.error((Object)CIMServer.TAG, (String)msg, (Object[])new Object[0]);
                    throw new IllegalStateException(msg);
                }
                if (RuntimeContext.sIsDebuggable) {
                    MLog.debug((Object)CIMServer.TAG, (String)"addNotifySources:%s", (Object[])new Object[]{CIMServer.this.cidsToAdd.toString()});
                } else {
                    MLog.info((Object)CIMServer.TAG, (String)"addNotifySources!", (Object[])new Object[0]);
                }
                object = CIMServer.this;
                synchronized (object) {
                    CIMServer.this.cidsToAdd.clear();
                }
            }
        };
        if (this.isOpened()) {
            command.run();
        } else if (!this.opening) {
            this.initCIM();
            this.openInner(new ICIMService.IOpenCallBack(){

                public void onsuccess() {
                    command.run();
                }

                public void onError(int errorCode, String tips) {
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteNotifySources(List<NotifySourceBean> cids) {
        CIMServer cIMServer = this;
        synchronized (cIMServer) {
            if (this.cidsToAdd != null) {
                for (NotifySourceBean bean : cids) {
                    Iterator<NotifySourceBean> iterator = this.cidsToAdd.iterator();
                    if (!iterator.hasNext() || !StringUtils.equals((String)iterator.next().getCid(), (String)bean.getCid())) continue;
                    iterator.remove();
                }
            }
        }
        if (RuntimeContext.sIsDebuggable) {
            MLog.debug((Object)TAG, (String)"deleteNotifySources:%s", (Object[])new Object[]{cids});
        } else {
            MLog.info((Object)TAG, (String)"addNotifySources!", (Object[])new Object[0]);
        }
        for (NotifySourceBean bean : cids) {
            CRC32 crc32 = new CRC32();
            crc32.update(bean.getCid().getBytes());
            long channelIdInt = crc32.getValue();
            MQService item = (MQService)HMR.getService(MQService.class);
            if (item == null) continue;
            item.removeSource((MQService.Source)new Source((Source.Mode)new Source.Shared(channelIdInt, "aggregate_" + bean.getCid(), bean.getRegion())));
        }
    }

    public void addRoamingCahtListener(Object listener) {
        if (this.isOpened()) {
            MLog.info((Object)TAG, (String)"addRoamingCahtListener!", (Object[])new Object[0]);
            if (listener instanceof IChannelUnreadMsgNotifyCallbak) {
                ((RoamingService)HMR.getService(RoamingService.class)).addListener((RoamingService.RoamingChatListener)listener);
            }
            ((RoamingService)HMR.getService(RoamingService.class)).addListener((RoamingService.RoamingChatListener)listener);
        } else {
            this.chatListenerToAdd = (RoamingService.RoamingChatListener)listener;
        }
    }

    public void removeRoamingCahtListener(Object listener) {
        RoamingService service2;
        MLog.info((Object)TAG, (String)"removeRoamingCahtListener!", (Object[])new Object[0]);
        if (this.chatListenerToAdd == listener) {
            this.chatListenerToAdd = null;
        }
        if ((service2 = (RoamingService)HMR.getService(RoamingService.class)) != null) {
            service2.removeListener((RoamingService.RoamingChatListener)listener);
        }
    }

    public Object getCimMsgSource() {
        return new CIMMsgSource(this.mEnvironment);
    }

    public boolean isFakeService() {
        return false;
    }

    public synchronized void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationDef.WSCLIENT_CONNECT_SUCCESS) {
            MLog.info((Object)TAG, (String)"notify ws connected inited:%b, uid:%d", (Object[])new Object[]{this.inited, AccountUtil.getUid()});
            if (this.inited) {
                CIMModule.INSTANCE.notifyChannelConncected();
            } else if (AccountUtil.getUid() > 0L) {
                this.initCIM();
            }
        } else if (notification.id == NotificationDef.N_LOGIN_ACCOUNT_CHANGED) {
            long oldUid = -1L;
            if (notification.extObj != null) {
                oldUid = (Long)notification.extObj;
            }
            MLog.info((Object)TAG, (String)"on login account change, oldUid:%d newUid:%d, opened:%b, inited:%b", (Object[])new Object[]{oldUid, AccountUtil.getUid(), this.opened, this.inited});
            if ((oldUid <= 0L || AccountUtil.getUid() != oldUid) && this.opened) {
                MLog.info((Object)TAG, (String)"close", (Object[])new Object[0]);
                CIMModule.INSTANCE.reset();
                this.opened = false;
                this.inited = false;
            }
            if (AccountUtil.getUid() > 0L) {
                if (!this.inited) {
                    this.initCIM();
                }
                this.open();
            }
        } else if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS) {
            MLog.info((Object)TAG, (String)"start after 3s try init cim inited:%b, uid:%d", (Object[])new Object[]{this.inited, AccountUtil.getUid()});
            this.initCIM();
        }
    }
}

