/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.cim;

import androidx.annotation.NonNull;
import biz.IMMsgItem;
import com.hummer.im.HMR;
import com.hummer.im._internals.mq.Source;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.PushContent;
import com.hummer.im.service.ChatService;
import com.hummer.im.service.MQService;
import com.yy.appbase.core.DefaultController;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.bean.ChannelPushContent;
import com.yy.hiyo.channel.base.callback.IMsgReceiver;
import com.yy.hiyo.channel.base.service.IMsgSource;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.im.cim.CIMMsgRequest;
import com.yy.im.cim.GroupCimMsg;

public class CIMMsgSource
extends DefaultController
implements IMsgSource {
    private static final String TAG = "CIMMsgSource";
    private IQueueTaskExecutor taskExecutor = YYTaskExecutor.createAQueueExcuter();
    private IMsgReceiver mMsgReceiver;
    private ChatService.MessageListener mDataListener = new ChatService.MessageListener(){

        public void afterReceivingMessage(final @NonNull Message message) {
            IMMsgItem msg = null;
            if (CIMMsgSource.this.mMsgReceiver != null && message.getContent() instanceof GroupCimMsg && (msg = ((GroupCimMsg)message.getContent()).getMsg()) != null) {
                final IMMsgItem fMsg = msg;
                final PushContent pushContent = message.getPushContent();
                if (msg == null || StringUtils.isEmpty((String)message.getUuid()) || msg.sections == null || msg.sections.size() <= 0) {
                    return;
                }
                if (CIMMsgSource.this.mMsgReceiver.isUnSupportBelow_3_3(msg)) {
                    MLog.info((Object)CIMMsgSource.TAG, (String)"3.3 \u4e4b\u540e\u7684\u7248\u672c\uff0c\u516c\u5c4f\u4e0d\u9700\u8981\u663e\u793a\u4e0d\u517c\u5bb9\u73a9\u6cd5\u6d88\u606f", (Object[])new Object[0]);
                    return;
                }
                CIMMsgSource.this.taskExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ChannelPushContent groupPushContentInner = CIMMsgRequest.transformPushContent(pushContent);
                        final BaseImMsg item = CIMMsgSource.this.mMsgReceiver.transformMsgItem(message.getUuid(), fMsg, groupPushContentInner);
                        if (item != null) {
                            item.setGroupPushContent(groupPushContentInner);
                        }
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (item != null) {
                                    if (!ChannelDefine.sUnEnableLog) {
                                        MLog.info((Object)CIMMsgSource.TAG, (String)"onReceiveChatMessage: %s", (Object[])new Object[]{item.toString()});
                                    }
                                    CIMMsgSource.this.mMsgReceiver.onReceiveMsg(CIMMsgSource.this.channelName(), item);
                                } else if (!ChannelDefine.sUnEnableLog) {
                                    MLog.info((Object)CIMMsgSource.TAG, (String)"onReceiveChatMessage unknown Msg: %s", (Object[])new Object[]{message.toString()});
                                }
                            }
                        });
                    }
                }, 0L);
            } else if (!ChannelDefine.sUnEnableLog) {
                MLog.info((Object)CIMMsgSource.TAG, (String)"onReceiveChatMessage unknown Msg: %s", (Object[])new Object[]{message.toString()});
            }
        }

        public void onRevokeMessage(@NonNull Message message) {
        }

        public void onDeleteMessage(@NonNull Message message) {
        }

        public void beforeSendingMessage(@NonNull Message message) {
        }

        public void afterSendingMessage(@NonNull Message message) {
        }

        public void beforeReceivingMessage(@NonNull Message message) {
        }
    };

    public CIMMsgSource(Environment env) {
        super(env);
    }

    public void init(IMsgReceiver receiver) {
        Source[] hagoSources;
        this.mMsgReceiver = receiver;
        for (Source source : hagoSources = new Source[]{new Source((Source.Mode)new Source.Private("hago_channel")), new Source((Source.Mode)new Source.Private("hago_channel_sig"))}) {
            ((MQService)HMR.getService(MQService.class)).addSource((MQService.Source)source);
        }
        GroupCimMsg.registerCodecs();
        ((ChatService)HMR.getService(ChatService.class)).addMessageListener(null, this.mDataListener);
        if (!ChannelDefine.sUnEnableLog) {
            MLog.info((Object)TAG, (String)"init!", (Object[])new Object[0]);
        }
    }

    public String channelName() {
        return "cim_source";
    }
}

