/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im;

import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.LastMsgAndUnreadData;
import com.yy.hiyo.channel.base.bean.MyJoinChannelItem;
import com.yy.im.IGroupMsgUnreadCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ImGroupManager {
    private static final String TAG = "ImGroupManager";
    private Map<String, Long> mUnreadMap = new HashMap<String, Long>();
    private HashSet<String> groupList = new HashSet();
    private IGroupMsgUnreadCallback mGroupMsgUnreadCallback;
    private boolean isInit = false;
    private boolean mKeepMonitor = false;
    private IChannelCenterService.IControlConfigOrJoinedChannelsListener mChannelsListener = new IChannelCenterService.IControlConfigOrJoinedChannelsListener(){

        public void onMyJoinedChannelsListChange() {
            MLog.debug((Object)ImGroupManager.TAG, (String)"onMyJoinedChannelsListChange", (Object[])new Object[0]);
            ImGroupManager.this.queryChannelList();
        }
    };
    private IChannelCenterService.IControlConfigOrJoinedChannelsListener mJoinedChannelsListener = new IChannelCenterService.IControlConfigOrJoinedChannelsListener(){

        public void onMyJoinedChannelsUnreadNumChange(final String cid, final LastMsgAndUnreadData data2) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (data2 == null) {
                        return;
                    }
                    MLog.debug((Object)ImGroupManager.TAG, (String)"onMyJoinedChannelsUnreadNumChange cid: %s  unReadNum: %s", (Object[])new Object[]{cid, data2.unreadMsgNum});
                    if (StringUtils.isEmpty((String)cid)) {
                        return;
                    }
                    if (!ImGroupManager.this.groupList.contains(cid)) {
                        MLog.debug((Object)ImGroupManager.TAG, (String)"onMyJoinedChannelsUnreadNumChange not my channel", (Object[])new Object[0]);
                        return;
                    }
                    ImGroupManager.this.mUnreadMap.put(cid, data2.unreadMsgNum);
                    long mUnreadMsg = ImGroupManager.this.getUnreadGroupMsgCount();
                    if (ImGroupManager.this.mGroupMsgUnreadCallback != null) {
                        ImGroupManager.this.mGroupMsgUnreadCallback.onUnreadMsgCountChange(mUnreadMsg);
                    }
                }
            });
        }

        public void onMyJoinedChannelsUnreadNumChange(final HashMap<String, LastMsgAndUnreadData> datas) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    MLog.debug((Object)ImGroupManager.TAG, (String)"onMyJoinedChannelsUnreadNumChange size: %s", (Object[])new Object[]{FP.size((Map)datas)});
                    if (FP.empty((Map)datas)) {
                        return;
                    }
                    Iterator iterator = datas.keySet().iterator();
                    LastMsgAndUnreadData item = null;
                    while (iterator.hasNext()) {
                        String gid = (String)iterator.next();
                        item = (LastMsgAndUnreadData)datas.get(gid);
                        if (item == null) continue;
                        ImGroupManager.this.mUnreadMap.put(gid, item.unreadMsgNum);
                    }
                    long mUnreadMsg = ImGroupManager.this.getUnreadGroupMsgCount();
                    if (ImGroupManager.this.mGroupMsgUnreadCallback != null) {
                        ImGroupManager.this.mGroupMsgUnreadCallback.onUnreadMsgCountChange(mUnreadMsg);
                    }
                }
            });
        }
    };

    public void setGroupMsgUnreadCallback(IGroupMsgUnreadCallback mGroupMsgUnreadCallback) {
        this.mGroupMsgUnreadCallback = mGroupMsgUnreadCallback;
    }

    private void initData() {
        this.getChannelService().addConfigOrMyJoinedChannelsListener(this.mChannelsListener);
        this.getChannelService().addConfigOrMyJoinedChannelsListener(this.mJoinedChannelsListener);
        this.queryChannelList();
        this.isInit = true;
    }

    private IChannelCenterService getChannelService() {
        return (IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class);
    }

    public void updateChannelMsgMointer(boolean open) {
        if (RuntimeContext.useOldRoom()) {
            return;
        }
        if (!this.isInit) {
            this.initData();
        }
        if (this.mKeepMonitor) {
            MLog.debug((Object)TAG, (String)"updateChannelMsgMointer mKeepMonitor return!!!!!", (Object[])new Object[0]);
            return;
        }
        MLog.debug((Object)TAG, (String)"updateChannelMsgMointer open: %s", (Object[])new Object[]{open});
        if (open) {
            this.getChannelService().getMyJoinChannelHandler().startRefreshUnreadNum(3, 5000L);
        } else {
            this.getChannelService().getMyJoinChannelHandler().stopRefreshUnreadNum(3);
        }
    }

    public void updateChannelMsgKeep(boolean keep) {
        if (RuntimeContext.useOldRoom()) {
            return;
        }
        if (!this.isInit) {
            this.initData();
        }
        MLog.debug((Object)TAG, (String)"updateChannelMsgKeep keep: %s", (Object[])new Object[]{keep});
        this.mKeepMonitor = keep;
    }

    private void queryChannelList() {
        this.getChannelService().getMyJoinedChannels(new IChannelCenterService.IGetMyJoinedChannelsCallBack(){

            public void onSuccess(final ArrayList<MyJoinChannelItem> groupSummays) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.info((Object)ImGroupManager.TAG, (String)"getChannelData, size = %s", (Object[])new Object[]{FP.size((Collection)groupSummays)});
                        ImGroupManager.this.mUnreadMap.clear();
                        ImGroupManager.this.addChannelMsgListener(groupSummays);
                    }
                });
            }

            public void onError(int errorCode, Exception e) {
            }
        }, false);
    }

    private void addChannelMsgListener(List<MyJoinChannelItem> channelItemList) {
        this.groupList.clear();
        if (FP.empty(channelItemList)) {
            return;
        }
        for (int i = 0; i < channelItemList.size(); ++i) {
            MyJoinChannelItem item = channelItemList.get(i);
            if (item == null || FP.empty((CharSequence)item.cid)) continue;
            this.groupList.add(item.cid);
            if (item.unreadMsgNum > 0L) {
                this.mUnreadMap.put(item.cid, item.unreadMsgNum);
            }
            long mUnreadMsg = this.getUnreadGroupMsgCount();
            if (this.mGroupMsgUnreadCallback == null) continue;
            this.mGroupMsgUnreadCallback.onUnreadMsgCountChange(mUnreadMsg);
        }
    }

    private long getUnreadGroupMsgCount() {
        Iterator<String> iterator = this.mUnreadMap.keySet().iterator();
        long count = 0L;
        while (iterator.hasNext()) {
            String groupId = iterator.next();
            long num = this.mUnreadMap.get(groupId);
            if (num <= 0L) continue;
            count += num;
        }
        return count;
    }
}

