/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.im.base;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;

public class ImMsgReqParam {
    private final String msg;
    private final long msgType;
    private final long innerType;
    private final String sessionId;
    private final String pushContent;
    private final String pushTitle;
    private final String pushPayload;
    private final boolean nopush;
    private final long fromUid;
    private final long toUid;
    private final String uuid;
    private final Map<String, Object> extend;

    private ImMsgReqParam(Builder builder) {
        this.msg = builder.msg;
        this.msgType = builder.msgType;
        this.innerType = builder.innerType;
        this.sessionId = builder.sessionId;
        this.pushContent = builder.pushContent;
        this.pushTitle = builder.pushTitle;
        this.pushPayload = builder.pushPayload;
        this.nopush = builder.nopush;
        this.fromUid = builder.fromUid;
        this.toUid = builder.toUid;
        this.extend = builder.extend;
        this.uuid = builder.uuid;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getMsg() {
        return this.msg == null ? "" : this.msg;
    }

    public long getMsgType() {
        return this.msgType;
    }

    public long getInnerType() {
        return this.innerType;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getPushContent() {
        return this.pushContent == null ? "" : this.pushContent;
    }

    public String getPushTitle() {
        return this.pushTitle == null ? "" : this.pushTitle;
    }

    public String getPushPayload() {
        return this.pushPayload == null ? "" : this.pushPayload;
    }

    public boolean isNopush() {
        return this.nopush;
    }

    public long getFromUid() {
        return this.fromUid;
    }

    public long getToUid() {
        return this.toUid;
    }

    public String getUuid() {
        return this.uuid;
    }

    @Nullable
    public Object getExt(String key) {
        if (this.extend != null && !TextUtils.isEmpty((CharSequence)key)) {
            return this.extend.get(key);
        }
        return null;
    }

    public static final class Builder {
        private String msg;
        private long msgType;
        private long innerType;
        private String sessionId;
        private String pushContent;
        private String pushTitle;
        private String pushPayload;
        private boolean nopush;
        private long fromUid;
        private long toUid;
        private String uuid;
        private Map<String, Object> extend;

        private Builder() {
        }

        public Builder msg(String val) {
            this.msg = val;
            return this;
        }

        public Builder msgType(long val) {
            this.msgType = val;
            return this;
        }

        public Builder innerType(long val) {
            this.innerType = val;
            return this;
        }

        public Builder sessionId(String val) {
            this.sessionId = val;
            return this;
        }

        public Builder pushContent(String val) {
            this.pushContent = val;
            return this;
        }

        public Builder pushTitle(String val) {
            this.pushTitle = val;
            return this;
        }

        public Builder pushPayload(String val) {
            this.pushPayload = val;
            return this;
        }

        public Builder nopush(boolean val) {
            this.nopush = val;
            return this;
        }

        public Builder fromUid(long val) {
            this.fromUid = val;
            return this;
        }

        public Builder toUid(long val) {
            this.toUid = val;
            return this;
        }

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public synchronized Builder putExtend(String key, Object value) {
            if (this.extend == null) {
                this.extend = new HashMap<String, Object>();
            }
            if (!TextUtils.isEmpty((CharSequence)key) && value != null) {
                this.extend.put(key, value);
            }
            return this;
        }

        public synchronized Builder putExtend(Map<String, Object> ext) {
            if (this.extend == null) {
                this.extend = new HashMap<String, Object>();
            }
            if (ext != null) {
                this.extend.putAll(ext);
            }
            return this;
        }

        public ImMsgReqParam build() {
            return new ImMsgReqParam(this);
        }
    }
}

