/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.home.base.perforstat;

import android.content.Context;
import android.os.SystemClock;
import com.yy.appbase.abtest.StartABTestUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.logger.PathLog;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.HardwareUtils;
import com.yy.base.utils.SettingFlagBaseKeys;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.base.utils.xml.CommonUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.apm.PerfAdapterHelper;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import com.yy.yylite.commonbase.hiido.HiidoUtils;
import java.io.File;

public class StartupStatHelper {
    public static boolean sCreateControllerByClass = true;
    private static final int TYPE_FIRST_LAUNCH = 0;
    private static final int TYPE_COLD_LAUNCH = 1;
    private static final int TYPE_WARM_LAUNCH = 2;
    private static final int TYPE_APPPRELOADED_LAUNCH = 3;
    private static volatile LaunchStatItem sStatItem;
    private static volatile long sHomePageDataReadyTime;
    private static PathLog.IPathLogItem sLogItem;
    private static volatile boolean sHasUpload;

    public static void start() {
        sLogItem = StartupStatHelper.createItem();
    }

    public static PathLog.IPathLogItem getStartPathLogger() {
        if (sLogItem != null) {
            return sLogItem;
        }
        sLogItem = StartupStatHelper.createItem();
        return sLogItem;
    }

    private static PathLog.IPathLogItem createItem() {
        final PathLog.IPathLogItem item = PathLog.startWithInfoLevel((String)"StartUp", (String)"onStart!", (Object[])new Object[0]);
        PathLog.IPathLogItem myItem = new PathLog.IPathLogItem(){

            public void add(String msgFormat, Object ... args) {
                item.add(msgFormat, args);
                PerfActionLog.add((String)("StartMainProcess_" + msgFormat), (Object[])args);
            }

            public void end(String msgFormat, Object ... args) {
                item.end(msgFormat, args);
            }

            public void endToFile(File file, String msgFormat, Object ... args) {
            }
        };
        return myItem;
    }

    public static void onAppCreate() {
        sStatItem = new LaunchStatItem();
    }

    public static void onAppDestroy() {
        sStatItem = null;
    }

    public static void onBaseEnv() {
        if (sStatItem != null) {
            StartupStatHelper.sStatItem.baseEnv = SystemClock.uptimeMillis();
        }
    }

    public static void onUnifyconfigController() {
        if (sStatItem != null) {
            StartupStatHelper.sStatItem.unifyconfigController = SystemClock.uptimeMillis();
        }
    }

    public static void onDatabox() {
        if (sStatItem != null) {
            StartupStatHelper.sStatItem.databox = SystemClock.uptimeMillis();
        }
    }

    public static void onHomepageController() {
        if (sStatItem != null) {
            StartupStatHelper.sStatItem.homepageController = SystemClock.uptimeMillis();
        }
    }

    public static void onLoginController() {
        if (sStatItem != null) {
            StartupStatHelper.sStatItem.loginController = SystemClock.uptimeMillis();
        }
    }

    public static void onUnifyconfigLoad() {
        if (sStatItem != null) {
            StartupStatHelper.sStatItem.unifyconfigLoad = SystemClock.uptimeMillis();
        }
    }

    public static void onSetEnv() {
        if (sStatItem != null) {
            StartupStatHelper.sStatItem.setEnv = SystemClock.uptimeMillis();
        }
    }

    public static void onRegisterControllers() {
        if (sStatItem != null) {
            StartupStatHelper.sStatItem.registerControllers = SystemClock.uptimeMillis();
        }
    }

    public static void onEnvInited() {
        if (sStatItem != null) {
            StartupStatHelper.sStatItem.envInitedTime = SystemClock.uptimeMillis();
        }
    }

    public static void onServicesInit() {
        if (sStatItem != null) {
            StartupStatHelper.sStatItem.servicesInitStartTime = SystemClock.uptimeMillis();
        }
    }

    public static void onServicesInited() {
        if (sStatItem != null) {
            StartupStatHelper.sStatItem.servicesInitEndTime = SystemClock.uptimeMillis();
        }
    }

    public static void onStartUpProgressFinish() {
        if (sStatItem != null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"StartupStatHelper", (String)"onStartUpProgressFinish!", (Object[])new Object[0]);
            }
            ++StartupStatHelper.sStatItem.progressFinishCallTimes;
            if (StartupStatHelper.sStatItem.progressFinishTime > 0L) {
                return;
            }
            StartupStatHelper.sStatItem.progressFinishTime = SystemClock.uptimeMillis();
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    StartupStatHelper.uploadStartup();
                }
            }, (long)5000L);
        }
    }

    private static void uploadStartup() {
        if (sHasUpload) {
            return;
        }
        LaunchStatItem statItem = sStatItem;
        if (statItem == null) {
            return;
        }
        if (!NetworkUtils.isNetworkStrictlyAvailable((Context)RuntimeContext.sApplicationContext)) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    StartupStatHelper.uploadStartup();
                }
            }, (long)10000L);
            return;
        }
        sHasUpload = true;
        long startTime = -1L;
        statItem.homePageReadyTime = sHomePageDataReadyTime;
        int lauchType = -1;
        if (RuntimeContext.sIsColdLaunch) {
            lauchType = 1;
            if (RuntimeContext.isStartAtFirstInstalled() || RuntimeContext.isStartAtCoverInstalled()) {
                lauchType = 0;
            }
            long appCreateUse = RuntimeContext.sAppOncreateEndTime - RuntimeContext.sAppOncreateTime;
            if (RuntimeContext.sAppOncreateTime != -1L && RuntimeContext.sMainActivityStartTime > RuntimeContext.sAppOncreateTime) {
                startTime = RuntimeContext.sAppOncreateTime;
                if (RuntimeContext.sMainActivityStartTime > 0L && RuntimeContext.sMainActivityStartTime - startTime - appCreateUse > 3000L) {
                    startTime = RuntimeContext.sMainActivityStartTime;
                }
            } else if (RuntimeContext.sMainActivityStartTime != -1L) {
                startTime = RuntimeContext.sMainActivityStartTime;
            }
        } else {
            lauchType = 2;
            if (RuntimeContext.sMainActivityStartTime != -1L) {
                startTime = RuntimeContext.sMainActivityStartTime;
            }
        }
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoluanch");
        statContent.put("launchtype", lauchType);
        statContent.put("hyguid", HiidoUtils.getHdid());
        statContent.put("finishcalltimes", statItem.progressFinishCallTimes);
        if (statItem.envInitedTime > 0L) {
            if (statItem.envInitedTime - startTime > 500L) {
                statContent.put("baseenv", (int)(statItem.baseEnv - startTime));
                statContent.put("unifyconfigc", (int)(statItem.unifyconfigController - startTime));
                statContent.put("splashc", StartABTestUtil.INSTANCE.isStartTest() ? 1 : 0);
                statContent.put("homepagec", (int)(statItem.homepageController - startTime));
                statContent.put("loginc", (int)(statItem.loginController - startTime));
                statContent.put("unifyconfigl", (int)(statItem.unifyconfigLoad - startTime));
                statContent.put("registerc", (int)(statItem.registerControllers - startTime));
            }
            statContent.put("envcost", (int)(statItem.envInitedTime - startTime));
        }
        if (statItem.servicesInitStartTime > 0L && statItem.servicesInitEndTime > 0L) {
            statContent.put("servicecost", (int)(statItem.servicesInitEndTime - statItem.servicesInitStartTime));
        }
        if (statItem.progressFinishTime > 0L) {
            statContent.put("startupfinish", (int)(statItem.progressFinishTime - startTime));
        }
        if (statItem.homePageStartShow > 0L) {
            statContent.put("homestartshow", (int)(statItem.homePageStartShow - startTime));
        }
        if (statItem.homePageFirstFrame > 0L) {
            statContent.put("homefirstframe", (int)(statItem.homePageFirstFrame - startTime));
            statContent.put("homeshowtime", (int)(statItem.homePageFirstFrame - statItem.homePageStartShow));
        }
        if (statItem.homePageReadyTime > 0L) {
            if (statItem.homePageReadyTime - startTime > 0L) {
                statContent.put("homedataready", (int)(statItem.homePageReadyTime - startTime));
            } else {
                statContent.put("homedataready", 1);
            }
        }
        statContent.put("homedatashow", statItem.homePageShowType);
        if (sCreateControllerByClass) {
            statContent.put("ext", "1");
        } else {
            statContent.put("ext", "0");
        }
        if (statItem.splashShown > 0L) {
            statContent.put("splashshow", "1");
            statContent.put("splashtype", statItem.splashType);
            statContent.put("splashhold", statItem.splashCost);
        } else {
            statContent.put("splashshow", "0");
        }
        if (RuntimeContext.isStartAtFirstInstalled()) {
            statContent.put("fto", "1");
        } else if (RuntimeContext.isStartAtCoverInstalled()) {
            statContent.put("fto", "2");
        } else {
            statContent.put("fto", "0");
        }
        statContent.put("databox", RuntimeContext.sPhoneType);
        statContent.put("setenv", PerfAdapterHelper.INSTANCE.getThreadABValue());
        statContent.put("cpunum", HardwareUtils.getCpuCoreCount());
        statContent.put("ram", CommonUtils.getTotalMemory());
        if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"StartupStatHelper", (String)statContent.toString(), (Object[])new Object[0]);
        }
        HiidoStatis.reportContent((StatisContent)statContent);
        if (SettingFlagBaseKeys.isNormalMetricSwitchOn()) {
            if (statItem.progressFinishTime > 0L) {
                HiidoStatis.reportAppMonitorReturnCode((String)("hystartup/" + (sCreateControllerByClass ? (statItem.splashShown > 0L ? 1 : 0) : (statItem.splashShown > 0L ? 3 : 2))), (long)((int)(statItem.progressFinishTime - startTime)), (String)"0");
            } else {
                HiidoStatis.reportAppMonitorReturnCode((String)("hystartup/" + (statItem.splashShown > 0L ? 1 : 0)), (long)-1L, (String)"0");
            }
        }
    }

    public static void onSplashShown() {
        if (sStatItem != null) {
            StartupStatHelper.sStatItem.splashShown = SystemClock.uptimeMillis();
        }
    }

    public static void onSplashHidden() {
        if (sStatItem != null && StartupStatHelper.sStatItem.splashShown > 0L) {
            StartupStatHelper.sStatItem.splashCost = SystemClock.uptimeMillis() - StartupStatHelper.sStatItem.splashShown;
        }
    }

    public static void updateSplashType(int type) {
        if (sStatItem != null && StartupStatHelper.sStatItem.splashShown > 0L) {
            StartupStatHelper.sStatItem.splashType = type;
        }
    }

    public static void onHomePageDataReady() {
        if (sHomePageDataReadyTime <= 0L) {
            sHomePageDataReadyTime = SystemClock.uptimeMillis();
        }
    }

    public static void onHomePageDataShow(int showType) {
        if (sStatItem != null && StartupStatHelper.sStatItem.homePageShowType == -1) {
            StartupStatHelper.sStatItem.homePageShowType = showType;
        }
    }

    public static void onHomePageFirstFrame() {
        if (sStatItem != null && StartupStatHelper.sStatItem.homePageFirstFrame <= 0L) {
            StartupStatHelper.sStatItem.homePageFirstFrame = SystemClock.uptimeMillis();
        }
    }

    public static void onHomePageStartShow() {
        if (sStatItem != null && StartupStatHelper.sStatItem.homePageStartShow <= 0L) {
            StartupStatHelper.sStatItem.homePageStartShow = SystemClock.uptimeMillis();
        }
    }

    static {
        sHasUpload = false;
    }

    static class LaunchStatItem {
        public long baseEnv;
        public long unifyconfigController;
        public long splashController;
        public long databox;
        public long homepageController;
        public long loginController;
        public long unifyconfigLoad;
        public long setEnv;
        public long registerControllers;
        public long envInitedTime;
        public long servicesInitStartTime;
        public long servicesInitEndTime;
        public long progressFinishTime;
        public long splashShown;
        public int splashType;
        public long splashCost;
        public long homePageReadyTime;
        public int homePageShowType = -1;
        public long homePageStartShow;
        public long homePageFirstFrame;
        public long progressFinishCallTimes = 0L;

        LaunchStatItem() {
        }
    }
}

