/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.billingclient.api;

import android.text.TextUtils;
import com.yy.base.utils.json.JsonParser;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Purchase {
    private final String mOriginalJson;
    private final String mSignature;
    private final JSONObject mParsedJson;

    public Purchase(String jsonPurchaseInfo, String signature) throws JSONException {
        this.mOriginalJson = jsonPurchaseInfo;
        this.mSignature = signature;
        this.mParsedJson = JsonParser.obtainJSONObject((String)this.mOriginalJson);
    }

    public String getOrderId() {
        return this.mParsedJson.optString("orderId");
    }

    public String getPackageName() {
        return this.mParsedJson.optString("packageName");
    }

    public String getSku() {
        return this.mParsedJson.optString("productId");
    }

    public long getPurchaseTime() {
        return this.mParsedJson.optLong("purchaseTime");
    }

    public String getPurchaseToken() {
        return this.mParsedJson.optString("token", this.mParsedJson.optString("purchaseToken"));
    }

    public String getPayload() {
        return this.mParsedJson.optString("developerPayload");
    }

    public boolean isAutoRenewing() {
        return this.mParsedJson.optBoolean("autoRenewing");
    }

    public String getOriginalJson() {
        return this.mOriginalJson;
    }

    public String getSignature() {
        return this.mSignature;
    }

    public String toString() {
        return "Purchase. Json: " + this.mOriginalJson;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Purchase)) {
            return false;
        }
        Purchase purchase = (Purchase)o;
        return TextUtils.equals((CharSequence)this.mOriginalJson, (CharSequence)purchase.getOriginalJson()) && TextUtils.equals((CharSequence)this.mSignature, (CharSequence)purchase.getSignature());
    }

    public int hashCode() {
        return this.mOriginalJson.hashCode();
    }

    public static class PurchasesResult {
        private List<Purchase> mPurchaseList;
        private int mResponseCode;

        PurchasesResult(int responseCode, List<Purchase> purchasesList) {
            this.mPurchaseList = purchasesList;
            this.mResponseCode = responseCode;
        }

        public int getResponseCode() {
            return this.mResponseCode;
        }

        public List<Purchase> getPurchasesList() {
            return this.mPurchaseList;
        }
    }
}

