/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.billingclient.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import com.yy.hiyo.billingclient.api.LocalBroadcastManager;
import com.yy.hiyo.billingclient.util.BillingHelper;

public class ProxyBillingActivity
extends Activity {
    static final String RESPONSE_INTENT_ACTION = "proxy_activity_response_intent_action";
    static final String RESPONSE_CODE = "response_code_key";
    static final String RESPONSE_BUNDLE = "response_bundle_key";
    private static final String TAG = "ProxyBillingActivity";
    private static final int REQUEST_CODE = 100;
    private String customPayload = "";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        BillingHelper.logVerbose(TAG, "Launching Play Store billing flow");
        PendingIntent pendingIntent = (PendingIntent)this.getIntent().getParcelableExtra("BUY_INTENT");
        this.customPayload = this.getIntent().getStringExtra("CUSTOM_DEVELOP_PAYLOAD");
        try {
            this.startIntentSenderForResult(pendingIntent.getIntentSender(), 100, new Intent(), 0, 0, 0);
        }
        catch (IntentSender.SendIntentException e) {
            BillingHelper.logWarn(TAG, "Got exception while trying to start a purchase flow: " + (Object)((Object)e));
            this.broadcastResult(613, null);
            this.finish();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100) {
            int responseCode = BillingHelper.getResponseCodeFromIntent(data, TAG);
            if (resultCode != -1 || responseCode != 0) {
                BillingHelper.logWarn(TAG, "Got purchases updated result with resultCode " + resultCode + " and billing's responseCode: " + responseCode);
            }
            this.broadcastResult(responseCode, data == null ? null : data.getExtras());
        } else {
            BillingHelper.logWarn(TAG, "Got onActivityResult with wrong requestCode: " + requestCode + "; skipping...");
        }
        this.finish();
    }

    private void broadcastResult(int responseCode, Bundle resultBundle) {
        Intent intent = new Intent(RESPONSE_INTENT_ACTION);
        intent.putExtra(RESPONSE_CODE, responseCode);
        intent.putExtra(RESPONSE_BUNDLE, resultBundle);
        intent.putExtra("CUSTOM_DEVELOP_PAYLOAD", this.customPayload);
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
    }
}

