/*
 * Decompiled with CFR 0.152.
 */
package com.hago.billingclient.api;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import com.hago.billingclient.api.AcknowledgePurchaseParams;
import com.hago.billingclient.api.AcknowledgePurchaseResponseListener;
import com.hago.billingclient.api.BillingClientImpl;
import com.hago.billingclient.api.BillingClientStateListener;
import com.hago.billingclient.api.BillingFlowParams;
import com.hago.billingclient.api.BillingResult;
import com.hago.billingclient.api.ConsumeParams;
import com.hago.billingclient.api.ConsumeResponseListener;
import com.hago.billingclient.api.PriceChangeConfirmationListener;
import com.hago.billingclient.api.PriceChangeFlowParams;
import com.hago.billingclient.api.Purchase;
import com.hago.billingclient.api.PurchaseHistoryResponseListener;
import com.hago.billingclient.api.PurchasesUpdatedListener;
import com.hago.billingclient.api.RewardLoadParams;
import com.hago.billingclient.api.RewardResponseListener;
import com.hago.billingclient.api.SkuDetailsParams;
import com.hago.billingclient.api.SkuDetailsResponseListener;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class BillingClient {
    @UiThread
    public static Builder newBuilder(@NonNull Context context) {
        return new Builder(context);
    }

    @UiThread
    public abstract BillingResult isFeatureSupported(String var1);

    @UiThread
    public abstract boolean isReady();

    @UiThread
    public abstract void startConnection(@NonNull BillingClientStateListener var1);

    @UiThread
    public abstract void endConnection();

    @UiThread
    public abstract BillingResult launchBillingFlow(Activity var1, BillingFlowParams var2);

    @UiThread
    public abstract void launchPriceChangeConfirmationFlow(Activity var1, PriceChangeFlowParams var2, @NonNull PriceChangeConfirmationListener var3);

    public abstract Purchase.PurchasesResult queryPurchases(String var1);

    public abstract void querySkuDetailsAsync(SkuDetailsParams var1, @NonNull SkuDetailsResponseListener var2);

    public abstract void consumeAsync(ConsumeParams var1, @NonNull ConsumeResponseListener var2);

    public abstract void queryPurchaseHistoryAsync(String var1, @NonNull PurchaseHistoryResponseListener var2);

    public abstract void loadRewardedSku(RewardLoadParams var1, @NonNull RewardResponseListener var2);

    public abstract void acknowledgePurchase(AcknowledgePurchaseParams var1, AcknowledgePurchaseResponseListener var2);

    public static final class Builder {
        private final Context mContext;
        private int mChildDirected = 0;
        private int mUnderAgeOfConsent = 0;
        private boolean mEnablePendingPurchases;
        private PurchasesUpdatedListener mListener;

        private Builder(Context context) {
            this.mContext = context;
        }

        @UiThread
        public Builder setListener(PurchasesUpdatedListener listener) {
            this.mListener = listener;
            return this;
        }

        @UiThread
        public Builder setChildDirected(int childDirected) {
            this.mChildDirected = childDirected;
            return this;
        }

        @UiThread
        public Builder setUnderAgeOfConsent(int underAgeOfConsent) {
            this.mUnderAgeOfConsent = underAgeOfConsent;
            return this;
        }

        @UiThread
        public Builder enablePendingPurchases() {
            this.mEnablePendingPurchases = true;
            return this;
        }

        @UiThread
        public BillingClient build() {
            if (this.mContext == null) {
                throw new IllegalArgumentException("Please provide a valid Context.");
            }
            if (this.mListener == null) {
                throw new IllegalArgumentException("Please provide a valid listener for purchases updates.");
            }
            if (!this.mEnablePendingPurchases) {
                throw new IllegalArgumentException("Support for pending purchases must be enabled. Enable this by calling 'enablePendingPurchases()' on BillingClientBuilder.");
            }
            return new BillingClientImpl(this.mContext, this.mChildDirected, this.mUnderAgeOfConsent, this.mEnablePendingPurchases, this.mListener);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UnderAgeOfConsent {
        public static final int UNSPECIFIED = 0;
        public static final int UNDER_AGE_OF_CONSENT = 1;
        public static final int NOT_UNDER_AGE_OF_CONSENT = 2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ChildDirected {
        public static final int UNSPECIFIED = 0;
        public static final int CHILD_DIRECTED = 1;
        public static final int NOT_CHILD_DIRECTED = 2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BillingResponseCode {
        public static final int SERVICE_TIMEOUT = -3;
        public static final int FEATURE_NOT_SUPPORTED = -2;
        public static final int SERVICE_DISCONNECTED = -1;
        public static final int OK = 0;
        public static final int USER_CANCELED = 1;
        public static final int SERVICE_UNAVAILABLE = 2;
        public static final int BILLING_UNAVAILABLE = 3;
        public static final int ITEM_UNAVAILABLE = 4;
        public static final int DEVELOPER_ERROR = 5;
        public static final int ERROR = 6;
        public static final int ITEM_ALREADY_OWNED = 7;
        public static final int ITEM_NOT_OWNED = 8;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FeatureType {
        public static final String SUBSCRIPTIONS = "subscriptions";
        public static final String SUBSCRIPTIONS_UPDATE = "subscriptionsUpdate";
        public static final String IN_APP_ITEMS_ON_VR = "inAppItemsOnVr";
        public static final String SUBSCRIPTIONS_ON_VR = "subscriptionsOnVr";
        public static final String PRICE_CHANGE_CONFIRMATION = "priceChangeConfirmation";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SkuType {
        public static final String INAPP = "inapp";
        public static final String SUBS = "subs";
    }
}

