/*
 * Decompiled with CFR 0.152.
 */
package com.hago.billingclient.api;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import androidx.annotation.NonNull;
import com.hago.billingclient.api.BillingResult;
import com.hago.billingclient.api.Purchase;
import com.hago.billingclient.api.PurchasesUpdatedListener;
import com.hago.billingclient.api.util.BillingHelper;
import java.util.List;

class BillingBroadcastManager {
    private static final String TAG = "BillingBroadcastManager";
    private static final String ACTION = "com.android.vending.billing.PURCHASES_UPDATED";
    private final Context mContext;
    private final BillingBroadcastReceiver mReceiver;

    BillingBroadcastManager(Context context, @NonNull PurchasesUpdatedListener listener) {
        this.mContext = context;
        this.mReceiver = new BillingBroadcastReceiver(listener);
    }

    void registerReceiver() {
        this.mReceiver.register(this.mContext, new IntentFilter(ACTION));
    }

    PurchasesUpdatedListener getListener() {
        return this.mReceiver.mListener;
    }

    void destroy() {
        this.mReceiver.unRegister(this.mContext);
    }

    private class BillingBroadcastReceiver
    extends BroadcastReceiver {
        private final PurchasesUpdatedListener mListener;
        private boolean mIsRegistered;

        private BillingBroadcastReceiver(PurchasesUpdatedListener listener) {
            this.mListener = listener;
        }

        public void register(Context context, IntentFilter filer) {
            if (!this.mIsRegistered) {
                context.registerReceiver((BroadcastReceiver)BillingBroadcastManager.this.mReceiver, filer);
                this.mIsRegistered = true;
            }
        }

        public void unRegister(Context context) {
            if (this.mIsRegistered) {
                context.unregisterReceiver((BroadcastReceiver)BillingBroadcastManager.this.mReceiver);
                this.mIsRegistered = false;
            } else {
                BillingHelper.logWarn(BillingBroadcastManager.TAG, "Receiver is not registered.");
            }
        }

        public void onReceive(Context context, Intent intent) {
            BillingResult billingResult = BillingHelper.getBillingResultFromIntent(intent, BillingBroadcastManager.TAG);
            List<Purchase> purchases = BillingHelper.extractPurchases(intent.getExtras());
            this.mListener.onPurchasesUpdated(billingResult, purchases, "");
        }
    }
}

