/*
 * Decompiled with CFR 0.152.
 */
package com.hago.billingclient.api.util;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.hago.billingclient.api.AcknowledgePurchaseParams;
import com.hago.billingclient.api.BillingFlowParams;
import com.hago.billingclient.api.BillingResult;
import com.hago.billingclient.api.ConsumeParams;
import com.hago.billingclient.api.Purchase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONException;

public final class BillingHelper {
    public static final String RESPONSE_CODE = "RESPONSE_CODE";
    public static final String DEBUG_MESSAGE = "DEBUG_MESSAGE";
    public static final String RESPONSE_GET_SKU_DETAILS_LIST = "DETAILS_LIST";
    public static final String CUSTOM_DEVELOP_PAYLOAD = "CUSTOM_DEVELOP_PAYLOAD";
    public static final String RESPONSE_BUY_INTENT_KEY = "BUY_INTENT";
    public static final String RESPONSE_SUBS_MANAGEMENT_INTENT_KEY = "SUBS_MANAGEMENT_INTENT";
    public static final String RESPONSE_INAPP_ITEM_LIST = "INAPP_PURCHASE_ITEM_LIST";
    public static final String RESPONSE_INAPP_PURCHASE_DATA_LIST = "INAPP_PURCHASE_DATA_LIST";
    public static final String RESPONSE_INAPP_SIGNATURE_LIST = "INAPP_DATA_SIGNATURE_LIST";
    public static final String INAPP_CONTINUATION_TOKEN = "INAPP_CONTINUATION_TOKEN";
    private static final String TAG = "BillingHelper";
    private static final String RESPONSE_INAPP_PURCHASE_DATA = "INAPP_PURCHASE_DATA";
    private static final String RESPONSE_INAPP_SIGNATURE = "INAPP_DATA_SIGNATURE";
    public static final String EXTRA_PARAM_KEY_SUBS_PRICE_CHANGE = "subs_price_change";
    public static final String EXTRA_PARAMS_ENABLE_PENDING_PURCHASES = "enablePendingPurchases";
    public static final String EXTRA_PARAMS_DEVELOPER_PAYLOAD = "developerPayload";
    public static final String EXTRA_PARAM_KEY_SKU_DETAILS_TOKEN = "skuDetailsToken";
    public static final String LIBRARY_VERSION_KEY = "playBillingLibraryVersion";
    public static int NUMBER_OF_CORES = Runtime.getRuntime().availableProcessors();
    private static final String INTERNAL_ERROR = "An internal error occurred.";

    public static void logVerbose(String tag, String msg) {
        if (Log.isLoggable((String)tag, (int)2)) {
            Log.v((String)tag, (String)msg);
        }
    }

    public static void logWarn(String tag, String msg) {
        if (Log.isLoggable((String)tag, (int)5)) {
            Log.w((String)tag, (String)msg);
        }
    }

    public static int getResponseCodeFromIntent(Intent intent, String tag) {
        return BillingHelper.getBillingResultFromIntent(intent, tag).getResponseCode();
    }

    public static BillingResult getBillingResultFromIntent(Intent intent, String tag) {
        if (intent == null) {
            BillingHelper.logWarn(TAG, "Got null intent!");
            return BillingResult.newBuilder().setResponseCode(6).setDebugMessage(INTERNAL_ERROR).build();
        }
        return BillingResult.newBuilder().setResponseCode(BillingHelper.getResponseCodeFromBundle(intent.getExtras(), tag)).setDebugMessage(BillingHelper.getDebugMessageFromBundle(intent.getExtras(), tag)).build();
    }

    public static int getResponseCodeFromBundle(Bundle bundle, String tag) {
        if (bundle == null) {
            BillingHelper.logWarn(tag, "Unexpected null bundle received!");
            return 6;
        }
        Object responseCode = bundle.get(RESPONSE_CODE);
        if (responseCode == null) {
            BillingHelper.logVerbose(tag, "getResponseCodeFromBundle() got null response code, assuming OK");
            return 0;
        }
        if (responseCode instanceof Integer) {
            return (Integer)responseCode;
        }
        BillingHelper.logWarn(tag, "Unexpected type for bundle response code: " + responseCode.getClass().getName());
        return 6;
    }

    public static String getDebugMessageFromBundle(Bundle bundle, String tag) {
        String emptyString = "";
        if (bundle == null) {
            BillingHelper.logWarn(tag, "Unexpected null bundle received!");
            return emptyString;
        }
        Object debugMessage = bundle.get(DEBUG_MESSAGE);
        if (debugMessage == null) {
            BillingHelper.logVerbose(tag, "getDebugMessageFromBundle() got null response code, assuming OK");
            return emptyString;
        }
        if (debugMessage instanceof String) {
            return (String)debugMessage;
        }
        BillingHelper.logWarn(tag, "Unexpected type for debug message: " + debugMessage.getClass().getName());
        return emptyString;
    }

    public static List<Purchase> extractPurchases(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        ArrayList purchaseDataList = bundle.getStringArrayList(RESPONSE_INAPP_PURCHASE_DATA_LIST);
        ArrayList dataSignatureList = bundle.getStringArrayList(RESPONSE_INAPP_SIGNATURE_LIST);
        ArrayList<Purchase> resultList = new ArrayList<Purchase>();
        if (purchaseDataList == null || dataSignatureList == null) {
            BillingHelper.logWarn(TAG, "Couldn't find purchase lists, trying to find single data.");
            String purchaseData = bundle.getString(RESPONSE_INAPP_PURCHASE_DATA);
            String dataSignature = bundle.getString(RESPONSE_INAPP_SIGNATURE);
            Purchase tmpPurchase = BillingHelper.extractPurchase(purchaseData, dataSignature);
            if (tmpPurchase == null) {
                BillingHelper.logWarn(TAG, "Couldn't find single purchase data as well.");
                return null;
            }
            resultList.add(tmpPurchase);
        } else {
            for (int i = 0; i < purchaseDataList.size() && i < dataSignatureList.size(); ++i) {
                Purchase tmpPurchase = BillingHelper.extractPurchase((String)purchaseDataList.get(i), (String)dataSignatureList.get(i));
                if (tmpPurchase == null) continue;
                resultList.add(tmpPurchase);
            }
        }
        return resultList;
    }

    public static Bundle constructExtraParamsForLaunchBillingFlow(BillingFlowParams params, boolean isIabV9Supported, boolean enablePendingPurchases, String libraryVersion) {
        Bundle extraParams = new Bundle();
        extraParams.putString(LIBRARY_VERSION_KEY, libraryVersion);
        if (params.getReplaceSkusProrationMode() != 0) {
            extraParams.putInt("prorationMode", params.getReplaceSkusProrationMode());
        }
        if (!TextUtils.isEmpty((CharSequence)params.getAccountId())) {
            extraParams.putString("accountId", params.getAccountId());
        }
        if (params.getVrPurchaseFlow()) {
            extraParams.putBoolean("vr", true);
        }
        if (!TextUtils.isEmpty((CharSequence)params.getOldSku())) {
            extraParams.putStringArrayList("skusToReplace", new ArrayList<String>(Arrays.asList(params.getOldSku())));
        }
        if (!TextUtils.isEmpty((CharSequence)params.getDeveloperId())) {
            extraParams.putString("developerId", params.getDeveloperId());
        }
        if (isIabV9Supported && enablePendingPurchases) {
            extraParams.putBoolean(EXTRA_PARAMS_ENABLE_PENDING_PURCHASES, true);
        }
        return extraParams;
    }

    public static Bundle constructExtraParamsForQueryPurchases(boolean isIabV9Supported, boolean enablePendingPurchases, String libraryVersion) {
        Bundle extraParams = new Bundle();
        extraParams.putString(LIBRARY_VERSION_KEY, libraryVersion);
        if (isIabV9Supported && enablePendingPurchases) {
            extraParams.putBoolean(EXTRA_PARAMS_ENABLE_PENDING_PURCHASES, true);
        }
        return extraParams;
    }

    public static Bundle constructExtraParamsForLoadRewardedSku(String rewardToken, int childDirected, int underAgeOfConsent, String libraryVersion) {
        Bundle extraParams = new Bundle();
        extraParams.putString("rewardToken", rewardToken);
        extraParams.putString(LIBRARY_VERSION_KEY, libraryVersion);
        if (childDirected != 0) {
            extraParams.putInt("childDirected", childDirected);
        }
        if (underAgeOfConsent != 0) {
            extraParams.putInt("underAgeOfConsent", childDirected);
        }
        return extraParams;
    }

    public static Bundle constructExtraParamsForGetSkuDetails(boolean isIabV9Supported, boolean enablePendingPurchases, String libraryVersion) {
        Bundle extraParams = new Bundle();
        if (isIabV9Supported) {
            extraParams.putString(LIBRARY_VERSION_KEY, libraryVersion);
        }
        if (isIabV9Supported && enablePendingPurchases) {
            extraParams.putBoolean(EXTRA_PARAMS_ENABLE_PENDING_PURCHASES, true);
        }
        return extraParams;
    }

    public static Bundle constructExtraParamsForConsume(ConsumeParams consumeParams, boolean isIabV9Supported, String libraryVersion) {
        Bundle extraParams = new Bundle();
        if (isIabV9Supported) {
            extraParams.putString(LIBRARY_VERSION_KEY, libraryVersion);
        }
        String developerPayload = consumeParams.getDeveloperPayload();
        if (isIabV9Supported && !TextUtils.isEmpty((CharSequence)developerPayload)) {
            extraParams.putString(EXTRA_PARAMS_DEVELOPER_PAYLOAD, developerPayload);
        }
        return extraParams;
    }

    public static Bundle constructExtraParamsForAcknowledgePurchase(AcknowledgePurchaseParams acknowledgePurchaseParams, String libraryVersion) {
        Bundle extraParams = new Bundle();
        extraParams.putString(LIBRARY_VERSION_KEY, libraryVersion);
        String developerPayload = acknowledgePurchaseParams.getDeveloperPayload();
        if (!TextUtils.isEmpty((CharSequence)developerPayload)) {
            extraParams.putString(EXTRA_PARAMS_DEVELOPER_PAYLOAD, developerPayload);
        }
        return extraParams;
    }

    private static Purchase extractPurchase(String purchaseData, String signatureData) {
        if (purchaseData == null || signatureData == null) {
            BillingHelper.logWarn(TAG, "Received a bad purchase data.");
            return null;
        }
        Purchase purchase = null;
        try {
            purchase = new Purchase(purchaseData, signatureData);
        }
        catch (JSONException e) {
            BillingHelper.logWarn(TAG, "Got JSONException while parsing purchase data: " + (Object)((Object)e));
        }
        return purchase;
    }
}

