/*
 * Decompiled with CFR 0.152.
 */
package com.hago.billingclient.api;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.yy.base.utils.json.JsonParser;
import org.json.JSONException;
import org.json.JSONObject;

public class PurchaseHistoryRecord {
    private final String mOriginalJson;
    private final String mSignature;
    private final JSONObject mParsedJson;

    public PurchaseHistoryRecord(String jsonPurchaseInfo, String signature) throws JSONException {
        this.mOriginalJson = jsonPurchaseInfo;
        this.mSignature = signature;
        this.mParsedJson = JsonParser.obtainJSONObject((String)this.mOriginalJson);
    }

    public String getSku() {
        return this.mParsedJson.optString("productId");
    }

    public long getPurchaseTime() {
        return this.mParsedJson.optLong("purchaseTime");
    }

    public String getPurchaseToken() {
        return this.mParsedJson.optString("token", this.mParsedJson.optString("purchaseToken"));
    }

    @Nullable
    public String getDeveloperPayload() {
        return this.mParsedJson.optString("developerPayload");
    }

    public String getOriginalJson() {
        return this.mOriginalJson;
    }

    public String getSignature() {
        return this.mSignature;
    }

    public String toString() {
        return "PurchaseHistoryRecord. Json: " + this.mOriginalJson;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PurchaseHistoryRecord)) {
            return false;
        }
        PurchaseHistoryRecord purchase = (PurchaseHistoryRecord)o;
        return TextUtils.equals((CharSequence)this.mOriginalJson, (CharSequence)purchase.getOriginalJson()) && TextUtils.equals((CharSequence)this.mSignature, (CharSequence)purchase.getSignature());
    }

    public int hashCode() {
        return this.mOriginalJson.hashCode();
    }
}

