/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.general.family;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Bundle;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.DpToPxDef;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.widget.EntranceView;
import com.yy.appbase.ui.widget.tablayout.SlidingTabLayout;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.utils.FP;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.URLUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.bbs.base.bean.TagBean;
import com.yy.hiyo.bbs.base.service.IPostService;
import com.yy.hiyo.bbs.base.view.IChannelPostListPage;
import com.yy.hiyo.bbs.bussiness.family.vh.UserOnlineStatusVH;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.ChannelTagItem;
import com.yy.hiyo.channel.plugins.general.R;
import com.yy.hiyo.channel.plugins.general.family.MyFamilyController;
import com.yy.hiyo.channel.plugins.general.family.MyFamilyOnlineController;
import com.yy.hiyo.channel.plugins.general.family.MyFamilyTabFamilyView;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.webservice.WebEnvSettings;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;
import me.drakeet.multitype.ItemViewBinder;
import me.drakeet.multitype.MultiTypeAdapter;
import net.ihago.channel.srv.mgr.MemberWithStatus;
import net.ihago.money.api.family.GetFamilyProfileRes;
import net.ihago.recommend.api.family.Label;

public class MyFamilyPage
extends YYRelativeLayout {
    private static final String TAG = "MyFamilyPage";
    private TextView mTitle;
    private TextView mMemberCount1;
    private TextView mMemberCount2;
    private TextView mId;
    private View mBack;
    private RecycleImageView mLogo;
    private RecycleImageView mBg;
    private RecycleImageView mType;
    private SlidingTabLayout mSlidingTabLayout;
    private ViewPager mViewPager;
    private PagerAdapter mAdapter;
    private IChannelPostListPage mDynamicView;
    private MyFamilyTabFamilyView mFamilyView;
    private RecyclerView mMemberRv;
    private MultiTypeAdapter mMemberAdapter;
    private TextView mMemberTopbarTitle;
    private View mMemberTopbar;
    private View mMemberArrow;
    private View mMemberDivider;
    private EntranceView mPostEntranceView;
    private View mGotoDistribute;
    private IMvpContext mContext;

    public MyFamilyPage(IMvpContext context, int page) {
        super(context.getContext());
        this.mContext = context;
        this.init(page);
    }

    private void init(int page) {
        MyFamilyPage.inflate((Context)this.getContext(), (int)R.layout.activity_my_family, (ViewGroup)this);
        this.mViewPager = (ViewPager)this.findViewById(R.id.amf_pager);
        this.mBg = (RecycleImageView)this.findViewById(R.id.amf_bg);
        this.mLogo = (RecycleImageView)this.findViewById(R.id.amf_logo);
        this.mTitle = (TextView)this.findViewById(R.id.amf_title);
        this.mBack = this.findViewById(R.id.amf_back);
        this.mMemberCount1 = (TextView)this.findViewById(R.id.amf_member_count_1);
        this.mMemberCount2 = (TextView)this.findViewById(R.id.amf_member_count_2);
        this.mId = (TextView)this.findViewById(R.id.amf_id);
        this.mType = (RecycleImageView)this.findViewById(R.id.amf_type);
        this.mSlidingTabLayout = (SlidingTabLayout)this.findViewById(R.id.amf_tab_indicator);
        this.mMemberRv = (RecyclerView)this.findViewById(R.id.memberModuleContainer);
        this.mMemberArrow = this.findViewById(R.id.memberModuleTopBarArrow);
        this.mMemberTopbar = this.findViewById(R.id.memberModuleTopBar);
        this.mMemberTopbarTitle = (TextView)this.findViewById(R.id.memberModuleTopBarTitle);
        this.mMemberDivider = this.findViewById(R.id.memberModuleDivider);
        this.mPostEntranceView = (EntranceView)this.findViewById(R.id.viewEntrance);
        this.mGotoDistribute = this.findViewById(R.id.toDistribute);
        FontUtils.setFontType((TextView)this.mMemberCount1, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.HagoNumber));
        FontUtils.setFontType((TextView)this.mMemberCount2, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.HagoNumber));
        FontUtils.setFontType((TextView)this.mId, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.HagoNumber));
        this.mAdapter = new PagerAdapter(){

            @NonNull
            public Object instantiateItem(@NonNull ViewGroup container, int position) {
                if (RuntimeContext.isHagoPartySdk()) {
                    String url = MyFamilyController.sCurrentMyFamilyDetailInfo == null || MyFamilyController.sCurrentMyFamilyDetailInfo.baseInfo == null ? "" : URLUtils.addParam((String)URLUtils.addParam((String)UriProvider.getFamilyDetailUrl(), (String)"familyId", (String)MyFamilyController.sCurrentMyFamilyDetailInfo.baseInfo.gid), (String)"hideHeader", (String)"true");
                    MyFamilyPage.this.mFamilyView = new MyFamilyTabFamilyView(MyFamilyPage.this.getContext(), url);
                    container.addView((View)MyFamilyPage.this.mFamilyView);
                    return MyFamilyPage.this.mFamilyView;
                }
                if (position == 0) {
                    MyFamilyPage.this.mDynamicView = ((IPostService)ServiceManagerProxy.getService(IPostService.class)).getChannelPostListPage(MyFamilyPage.this.mContext, (Object)MyFamilyController.sCurrentMyFamilyDetailInfo, MyFamilyController.sCurremtMyFamilyRole, Boolean.valueOf(false));
                    if (MyFamilyPage.this.mDynamicView != null) {
                        MyFamilyPage.this.mDynamicView.pageShow();
                        MyFamilyPage.this.mDynamicView.pageRefresh();
                        container.addView(MyFamilyPage.this.mDynamicView.getPageView(), -1, -1);
                        return MyFamilyPage.this.mDynamicView.getPageView();
                    }
                    return new View(MyFamilyPage.this.getContext());
                }
                if (position == 1) {
                    String url = MyFamilyController.sCurrentMyFamilyDetailInfo == null || MyFamilyController.sCurrentMyFamilyDetailInfo.baseInfo == null ? "" : URLUtils.addParam((String)URLUtils.addParam((String)UriProvider.getFamilyDetailUrl(), (String)"familyId", (String)MyFamilyController.sCurrentMyFamilyDetailInfo.baseInfo.gid), (String)"hideHeader", (String)"true");
                    MyFamilyPage.this.mFamilyView = new MyFamilyTabFamilyView(MyFamilyPage.this.getContext(), url);
                    container.addView((View)MyFamilyPage.this.mFamilyView);
                    return MyFamilyPage.this.mFamilyView;
                }
                throw new IllegalArgumentException();
            }

            @Nullable
            public CharSequence getPageTitle(int position) {
                if (RuntimeContext.isHagoPartySdk()) {
                    return MyFamilyPage.this.getContext().getString(R.string.home_drawer_page_family);
                }
                return position == 0 ? MyFamilyPage.this.getContext().getString(R.string.my_family_dynamic) : MyFamilyPage.this.getContext().getString(R.string.home_drawer_page_family);
            }

            public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
                container.removeView((View)object);
            }

            public int getCount() {
                return RuntimeContext.isHagoPartySdk() ? 1 : 2;
            }

            public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
                return view == object;
            }

            public int getItemPosition(@NonNull Object object) {
                return -2;
            }
        };
        this.mViewPager.setOverScrollMode(2);
        this.mViewPager.setClipChildren(false);
        this.mViewPager.setAdapter(this.mAdapter);
        this.mSlidingTabLayout.setViewPager(this.mViewPager);
        this.mAdapter.notifyDataSetChanged();
        if (!RuntimeContext.isHagoPartySdk()) {
            this.mViewPager.setCurrentItem(1);
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60080002").put("function_id", "my_family_pg_show").put("pg_type", "2"));
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60080002").put("function_id", "my_family_pg_show").put("pg_type", position == 0 ? "2" : "1"));
                if (!RuntimeContext.isHagoPartySdk()) {
                    if (position == 0 && MyFamilyController.sCurremtMyFamilyRole > 1) {
                        MyFamilyPage.this.mPostEntranceView.setVisibility(0);
                    } else {
                        MyFamilyPage.this.mPostEntranceView.setVisibility(8);
                    }
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.initListener();
        this.fetchData();
        this.mMemberAdapter = new MultiTypeAdapter();
        this.mMemberAdapter.register(MemberWithStatus.class, (ItemViewBinder)new BaseItemBinder<MemberWithStatus, UserOnlineStatusVH>(){

            @NonNull
            protected UserOnlineStatusVH onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                View itemView = inflater.inflate(R.layout.item_my_family_user_online, parent, false);
                UserOnlineStatusVH holder = new UserOnlineStatusVH(itemView);
                itemView.setOnClickListener(v -> {
                    Message msg;
                    MemberWithStatus data = (MemberWithStatus)holder.getData();
                    if (data.party_status.inroom.booleanValue()) {
                        msg = Message.obtain();
                        msg.what = AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL;
                        msg.obj = EnterParam.obtain((String)data.party_status.cid, (int)147);
                        MsgDispatcher.getInstance().sendMessage(msg);
                    } else {
                        msg = Message.obtain();
                        msg.what = BaseMsgDef.IM_ROOM_SHOW;
                        Bundle bundle = new Bundle();
                        bundle.putLong("target_uid", data.member.uid.longValue());
                        bundle.putInt("im_page_source", 17);
                        msg.setData(bundle);
                        MsgDispatcher.getInstance().sendMessageSync(msg);
                    }
                    String headState = "0";
                    if (data.party_status.inroom.booleanValue()) {
                        headState = "radio_video".equals(data.party_status.plugin) || "multivideo".equals(data.party_status.plugin) ? "2" : "1";
                    } else if (data.party_status.ingame.booleanValue()) {
                        headState = "3";
                    } else if (data.party_status.online.booleanValue()) {
                        headState = "4";
                    }
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60080002").put("function_id", "family_member_head_click").put(" head_state", headState).put("click_source ", "1"));
                });
                return holder;
            }

            protected void onBindViewHolder(@NonNull UserOnlineStatusVH viewHolder, @NonNull MemberWithStatus memberWithStatus) {
                viewHolder.setData(memberWithStatus);
            }
        });
        this.mMemberRv.setAdapter((RecyclerView.Adapter)this.mMemberAdapter);
        this.mMemberRv.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 0, false));
        this.mMemberRv.addItemDecoration(new RecyclerView.ItemDecoration(){

            public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
                super.getItemOffsets(outRect, view, parent, state);
                RecyclerView.ViewHolder holder = parent.findContainingViewHolder(view);
                if (holder != null) {
                    int pos = holder.getAdapterPosition();
                    if (LanguageUtils.isRtl()) {
                        if (pos == 0) {
                            outRect.right = DpToPxDef.RESOLUTION_10_DP;
                            outRect.left = ResolutionUtils.dip2Px((float)4.0f);
                        } else {
                            outRect.left = ResolutionUtils.dip2Px((float)4.0f);
                            outRect.right = ResolutionUtils.dip2Px((float)4.0f);
                        }
                    } else if (pos == 0) {
                        outRect.left = DpToPxDef.RESOLUTION_10_DP;
                        outRect.right = ResolutionUtils.dip2Px((float)4.0f);
                    } else {
                        outRect.left = ResolutionUtils.dip2Px((float)4.0f);
                        outRect.right = ResolutionUtils.dip2Px((float)4.0f);
                    }
                }
            }
        });
        this.initPostEntranceView();
        this.mGotoDistribute.setOnClickListener(v -> {
            String url = UriProvider.getFamilyIndexUrl();
            if (url.startsWith("hago")) {
                ((IYYUriService)ServiceManagerProxy.getServiceManager().getService(IYYUriService.class)).handleUriString(url);
            } else {
                WebEnvSettings wes = new WebEnvSettings();
                wes.url = url;
                wes.backBtnResId = R.drawable.nav_back_white;
                wes.usePageTitle = false;
                wes.isFullScreen = true;
                wes.disablePullRefresh = true;
                ((IWebService)ServiceManagerProxy.getServiceManager().getService(IWebService.class)).loadUrl(wes);
            }
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60080002").put("function_id", "family_more_homepage"));
        });
    }

    public void refresh() {
        if (this.mViewPager.getAdapter() != null) {
            this.mAdapter.notifyDataSetChanged();
        }
        this.initPostEntranceView();
    }

    private void initListener() {
        this.findViewById(R.id.amf_rule).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((IWebService)ServiceManagerProxy.getServiceManager().getService(IWebService.class)).loadUrl(UriProvider.getFamilyRuleUrl(), "");
            }
        });
        this.mBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Message message = Message.obtain();
                message.what = AppbaseMsgDef.ChannelMsgDef.CLOSE_WINDOW_VIEW_MY_FAMILY;
                MsgDispatcher.getInstance().sendMessage(message);
            }
        });
    }

    private void initPostEntranceView() {
        int roleType = MyFamilyController.sCurremtMyFamilyRole;
        ChannelInfo info = MyFamilyController.sCurrentMyFamilyDetailInfo.baseInfo;
        if (!RuntimeContext.isHagoPartySdk() && roleType > 1) {
            this.mPostEntranceView.setOnClickListener(v -> {
                if (info == null) {
                    MLog.info((Object)TAG, (String)"onPostPublic cinfo is null", (Object[])new Object[0]);
                    return;
                }
                MLog.info((Object)TAG, (String)"onPostPublic success", (Object[])new Object[0]);
                ChannelTagItem tagItem = null;
                if (info.tag != null) {
                    tagItem = info.tag.getFirstTag();
                }
                Message msg = Message.obtain();
                msg.what = AppbaseMsgDef.MSG_OPEN_PUBLISH_WINDOW;
                msg.arg1 = 6;
                msg.arg2 = -1;
                Bundle bundle = new Bundle();
                bundle.putString("channelId", info.gid);
                bundle.putInt("userRole", roleType);
                msg.setData(bundle);
                if (tagItem != null && !FP.empty((CharSequence)tagItem.getName()) && !FP.empty((CharSequence)tagItem.getTagId())) {
                    msg.obj = TagBean.newBuilder().text(tagItem.getName() == null ? "" : tagItem.getName()).id(tagItem.getTagId() == null ? "" : tagItem.getTagId()).available(true).build();
                } else {
                    MLog.info((Object)TAG, (String)"onPostPublic success channel null", (Object[])new Object[0]);
                    msg.obj = null;
                }
                MsgDispatcher.getInstance().sendMessage(msg);
            });
            if (this.mViewPager.getCurrentItem() == 0) {
                this.mPostEntranceView.setVisibility(0);
            }
        } else {
            this.mPostEntranceView.setOnClickListener(null);
            this.mPostEntranceView.setVisibility(8);
        }
        if (!RuntimeContext.isHagoPartySdk()) {
            this.mPostEntranceView.updatePostEntranceVisible(true, 6);
        }
    }

    public void setOnlineUser(@Nullable List<MemberWithStatus> onlineUser, int totalUser) {
        if (onlineUser == null || onlineUser.isEmpty()) {
            this.mMemberArrow.setVisibility(8);
            this.mMemberTopbar.setVisibility(8);
            this.mMemberTopbarTitle.setVisibility(8);
            this.mMemberRv.setVisibility(8);
            this.mMemberDivider.setVisibility(8);
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60080002").put("function_id", "family_member_state_show").put("is_online", "2"));
        } else {
            this.mMemberArrow.setVisibility(0);
            this.mMemberTopbar.setVisibility(0);
            this.mMemberTopbarTitle.setVisibility(0);
            this.mMemberRv.setVisibility(0);
            this.mMemberDivider.setVisibility(0);
            this.mMemberTopbarTitle.setText((CharSequence)ResourceUtils.getString((int)R.string.title_family_in_room2, (Object[])new Object[]{totalUser}));
            this.mMemberAdapter.setItems(onlineUser);
            this.mMemberAdapter.notifyDataSetChanged();
            if (totalUser >= 10) {
                this.mMemberTopbar.setOnClickListener(v -> {
                    Message msg = Message.obtain();
                    msg.what = AppbaseMsgDef.ChannelMsgDef.OPEN_WINDOW_VIEW_MY_FAMILY_ONLINE;
                    msg.obj = new MyFamilyOnlineController.Param(MyFamilyController.sCurrentMyFamilyDetailInfo.baseInfo.gid);
                    MsgDispatcher.getInstance().sendMessage(msg);
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60080002").put("function_id", "family_member_more_click"));
                });
                this.mMemberArrow.setVisibility(0);
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60080002").put("function_id", "family_member_more_show"));
            } else {
                this.mMemberTopbar.setOnClickListener(null);
                this.mMemberArrow.setVisibility(8);
            }
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60080002").put("function_id", "family_member_state_show").put("is_online", "1"));
    }

    private void fetchData() {
        ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).getFamilyInfo(MyFamilyController.sCurrentMyFamilyDetailInfo.baseInfo.gid, (ICommonCallback)new ICommonCallback<GetFamilyProfileRes>(){

            public void onSuccess(GetFamilyProfileRes res, Object ... ext) {
                MyFamilyPage.this.mId.setText((CharSequence)("ID:" + res.family_info.info.cute_id));
                MyFamilyPage.this.mTitle.setText((CharSequence)res.family_info.info.name);
                MyFamilyPage.this.mMemberCount1.setText((CharSequence)(res.family_info.info.member_count + ""));
                MyFamilyPage.this.mMemberCount2.setText((CharSequence)(res.family_info.info.member_limit + ""));
                ImageLoader.loadImage((ImageView)MyFamilyPage.this.mLogo, (String)res.family_info.info.avatar);
                ImageLoader.loadImage((ImageView)MyFamilyPage.this.mBg, (String)res.family_info.info.avatar);
                if (res.family_labels.isEmpty()) {
                    MyFamilyPage.this.mType.setVisibility(8);
                } else {
                    MyFamilyPage.this.mType.setVisibility(0);
                    ImageLoader.loadImage((ImageView)MyFamilyPage.this.mType, (String)((Label)res.family_labels.get((int)0)).label_pic);
                }
            }

            public void onFail(int errCode, String msg, Object ... ext) {
                MLog.error((Object)MyFamilyPage.TAG, (String)("fetchData error : " + errCode + ", msg: " + msg), (Object[])new Object[0]);
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.get_my_family_failed);
            }
        });
    }

    public boolean onBack() {
        return this.mFamilyView != null && this.mFamilyView.onBack();
    }
}

