/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.data;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.GamePlayInfoDBBean;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.appbase.unifyconfig.config.CommonConfigData;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.FP;
import com.yy.framework.core.Environment;
import com.yy.game.data.AHC;
import com.yy.game.data.AKC;
import com.yy.game.data.aAC;
import com.yy.game.data.aBC;
import com.yy.game.data.aeC;
import com.yy.game.data.aoC;
import com.yy.game.data.auC;
import com.yy.hiyo.coins.base.ICoinsService;
import com.yy.hiyo.game.base.bean.GameCategory;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInfoSource;
import com.yy.hiyo.game.base.bean.GamePlayInfo;
import com.yy.hiyo.game.kvomodule.GameInfoModule;
import com.yy.hiyo.game.kvomodule.GameInfoModuleData;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.callback.OnGameInfoChangedListener;
import com.yy.hiyo.game.service.callback.OnGetImGameInfosCallback;
import com.yy.hiyo.game.service.callback.OnImGameInfoCHangedListener;
import com.yy.hiyo.game.service.callback.OnPkGameInfoChangedListener;
import com.yy.hiyo.home.base.homepage.HomeReportUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;

@DontProguardClass
public class GameInfoService
extends DefaultController
implements IGameInfoService {
    private static final String TAG = "GameInfoService";
    private final List<GameInfo> mGameInfoList = new CopyOnWriteArrayList<GameInfo>();
    private final List<GameInfo> mImGameInfoList = new CopyOnWriteArrayList<GameInfo>();
    private final List<GameInfo> singleGameInfoList = new CopyOnWriteArrayList<GameInfo>();
    private final List<GameInfo> sameGameInfoList = new CopyOnWriteArrayList<GameInfo>();
    private final List<GameInfo> voiceRoomGameInfoList = new CopyOnWriteArrayList<GameInfo>();
    private final List<GameInfo> floatGameInfoList = new CopyOnWriteArrayList<GameInfo>();
    private final List<GameInfo> inVoiceRoomGameInfoList = new CopyOnWriteArrayList<GameInfo>();
    private final List<GameInfo> createRoomGameList = new CopyOnWriteArrayList<GameInfo>();
    private final List<GameInfo> pkGameInfoList = new CopyOnWriteArrayList<GameInfo>();
    private List<OnImGameInfoCHangedListener> mImGameInfoCHangedListeners = new ArrayList<OnImGameInfoCHangedListener>();
    private OnPkGameInfoChangedListener mPkGameInfoChangedListener;
    private final List<GameInfo> mRandomGameInfoList = new CopyOnWriteArrayList<GameInfo>();
    private final List<GameInfo> mNoneModeGameList = new CopyOnWriteArrayList<GameInfo>();
    private final List<GameCategory> mGameCategory = new CopyOnWriteArrayList<GameCategory>();
    private final List<OnGameInfoChangedListener> mGameInfoListener = new CopyOnWriteArrayList<OnGameInfoChangedListener>();
    private volatile boolean hasLoadRoomGameList = false;
    private volatile boolean hasLoadInRoomGameList = false;

    public GameInfoService(Environment environment) {
        super(environment);
    }

    @Nullable
    public GameInfo getGameInfoByGid(String string2) {
        List list;
        List[] listArray;
        GameInfo gameInfo = null;
        List[] listArray2 = listArray = new List[]{this.mGameInfoList, this.singleGameInfoList, this.sameGameInfoList, this.voiceRoomGameInfoList, this.inVoiceRoomGameInfoList, this.floatGameInfoList, this.mNoneModeGameList};
        int n2 = listArray2.length;
        for (int i2 = 0; i2 < n2 && (gameInfo = this.findGameInfo(list = listArray2[i2], string2)) == null; ++i2) {
        }
        return gameInfo;
    }

    @Nullable
    public GameInfo getGameInfoByIdWithType(String string2, GameInfoSource gameInfoSource) {
        GameInfo gameInfo = null;
        switch (gameInfoSource) {
            case HOME: {
                gameInfo = this.findGameInfo(this.mGameInfoList, string2);
                break;
            }
            case SINGLE: {
                gameInfo = this.findGameInfo(this.singleGameInfoList, string2);
                break;
            }
            case SAMESCEEN: {
                gameInfo = this.findGameInfo(this.sameGameInfoList, string2);
                break;
            }
            case VOICE_ROOM: {
                gameInfo = this.findGameInfo(this.voiceRoomGameInfoList, string2);
                break;
            }
            case IN_VOICE_ROOM: {
                gameInfo = this.findGameInfo(this.inVoiceRoomGameInfoList, string2);
                break;
            }
            case FLOAT_PLAY: {
                gameInfo = this.findGameInfo(this.floatGameInfoList, string2);
                break;
            }
            default: {
                gameInfo = this.getGameInfoByGid(string2);
            }
        }
        return gameInfo;
    }

    private GameInfo findGameInfo(List<GameInfo> list, String string2) {
        if (TextUtils.isEmpty((CharSequence)string2) || FP.empty(list)) {
            return null;
        }
        for (GameInfo gameInfo : list) {
            if (gameInfo == null || !string2.equals(gameInfo.getGid())) continue;
            return gameInfo;
        }
        return null;
    }

    @Nullable
    public List<GameInfo> getHomeGameInfoList() {
        if (!FP.empty(this.mGameInfoList)) {
            return Collections.unmodifiableList(this.mGameInfoList);
        }
        return null;
    }

    @Nullable
    public List<GameInfo> getIMGameInfoList() {
        if (!FP.empty(this.mImGameInfoList)) {
            return Collections.unmodifiableList(this.mImGameInfoList);
        }
        return null;
    }

    @Nullable
    public void getIMMainGameInfoList(OnGetImGameInfosCallback onGetImGameInfosCallback) {
        if (onGetImGameInfosCallback == null) {
            return;
        }
        GameInfoModule gameInfoModule = (GameInfoModule)KvoModuleManager.getModule(GameInfoModule.class);
        long l2 = 604800000L;
        gameInfoModule.getMatchGamePlayInfo((GameInfoModuleData.Matcher)new AKC(this), (GameInfoModuleData.MatchCallback)new aBC(this, onGetImGameInfosCallback));
    }

    @Nonnull
    public List<GameInfo> getVoiceRoomGameInfoList() {
        if (!FP.empty(this.voiceRoomGameInfoList)) {
            return Collections.unmodifiableList(this.voiceRoomGameInfoList);
        }
        return Collections.emptyList();
    }

    @Nonnull
    public List<GameInfo> getFloatGameInfoList() {
        if (!FP.empty(this.floatGameInfoList)) {
            return Collections.unmodifiableList(this.floatGameInfoList);
        }
        return Collections.emptyList();
    }

    @Nonnull
    public List<GameInfo> getInVoiceRoomGameInfoList() {
        if (!FP.empty(this.inVoiceRoomGameInfoList)) {
            return Collections.unmodifiableList(this.inVoiceRoomGameInfoList);
        }
        return Collections.emptyList();
    }

    public List<GameInfo> getCreateRoomGameList() {
        if (FP.empty(this.createRoomGameList)) {
            GameInfo gameInfo = null;
            for (GameCategory gameCategory : this.mGameCategory) {
                if (!gameCategory.isOutter() || FP.empty((Collection)gameCategory.getGameIds())) continue;
                for (String string2 : gameCategory.getGameIds()) {
                    gameInfo = this.findGameInfo(string2, this.inVoiceRoomGameInfoList);
                    if (gameInfo == null || gameInfo.isHide() || "dayingjia".equals(gameInfo.gid)) continue;
                    this.createRoomGameList.add(gameInfo);
                }
            }
        }
        return this.createRoomGameList;
    }

    @Nullable
    private GameInfo findGameInfo(String string2, List<GameInfo> list) {
        for (GameInfo gameInfo : list) {
            if (!TextUtils.equals((CharSequence)gameInfo.gid, (CharSequence)string2)) continue;
            return gameInfo;
        }
        return null;
    }

    @Nonnull
    public List<GameInfo> getAllGameInfoList() {
        ArrayList<GameInfo> arrayList = new ArrayList<GameInfo>();
        arrayList.addAll(this.mGameInfoList);
        arrayList.addAll(this.singleGameInfoList);
        return arrayList;
    }

    @NonNull
    public List<GameInfo> getAllPkGameInfoList() {
        if (!FP.empty(this.pkGameInfoList)) {
            return Collections.unmodifiableList(this.pkGameInfoList);
        }
        return Collections.emptyList();
    }

    @Nullable
    public List<GameInfo> getRandomGameInfoList() {
        if (!FP.empty(this.mRandomGameInfoList)) {
            return Collections.unmodifiableList(this.mRandomGameInfoList);
        }
        return null;
    }

    public GameInfo getVoiceRoomGameInfoByGid(String string2) {
        GameInfo gameInfo = null;
        gameInfo = this.findGameInfo(this.voiceRoomGameInfoList, string2);
        return gameInfo;
    }

    public void addGameInfoListener(OnGameInfoChangedListener onGameInfoChangedListener, boolean bl2) {
        if (onGameInfoChangedListener == null) {
            return;
        }
        if (bl2) {
            this.notifyGameInfoChanged(GameInfoSource.HOME, this.mGameInfoList, onGameInfoChangedListener);
            this.notifyGameInfoChanged(GameInfoSource.SINGLE, this.singleGameInfoList, onGameInfoChangedListener);
            this.notifyGameInfoChanged(GameInfoSource.SAMESCEEN, this.sameGameInfoList, onGameInfoChangedListener);
            this.notifyGameInfoChanged(GameInfoSource.VOICE_ROOM, this.voiceRoomGameInfoList, onGameInfoChangedListener);
            this.notifyGameInfoChanged(GameInfoSource.IN_VOICE_ROOM, this.inVoiceRoomGameInfoList, onGameInfoChangedListener);
        }
        if (!this.mGameInfoListener.contains(onGameInfoChangedListener)) {
            this.mGameInfoListener.add(onGameInfoChangedListener);
        }
    }

    public void setImGameInfoListener(OnImGameInfoCHangedListener onImGameInfoCHangedListener, boolean bl2) {
        this.mImGameInfoCHangedListeners.add(onImGameInfoCHangedListener);
        if (onImGameInfoCHangedListener != null && bl2 && !FP.empty(this.mImGameInfoList)) {
            onImGameInfoCHangedListener.onImGameChanged(Collections.unmodifiableList(this.mImGameInfoList));
        }
    }

    public void addPkGameInfoListener(OnPkGameInfoChangedListener onPkGameInfoChangedListener, boolean bl2) {
        this.mPkGameInfoChangedListener = onPkGameInfoChangedListener;
        if (this.mPkGameInfoChangedListener != null && bl2) {
            this.mPkGameInfoChangedListener.onPkGameInfoChanged(Collections.unmodifiableList(this.pkGameInfoList));
        }
    }

    public void removePkGameInfoListener() {
        this.mPkGameInfoChangedListener = null;
    }

    public void updateHomeGameInfo(List<GameInfo> list, boolean bl2) {
        if (!FP.empty(list)) {
            ArrayList<Object> arrayList;
            MLog.debug((Object)TAG, (String)"updateHomeGameInfo list: %d, update: %b", (Object[])new Object[]{list.size(), bl2});
            ArrayList<GameInfo> arrayList2 = new ArrayList<GameInfo>(this.mGameInfoList);
            this.mGameInfoList.clear();
            if (bl2) {
                arrayList = new ArrayList(list.size());
                for (GameInfo gameInfo : list) {
                    GameInfo gameInfo2 = this.findGameInfo(arrayList2, gameInfo.getGid());
                    if (gameInfo2 != null) {
                        gameInfo2.updateInfo(GameInfo.newBuilder((GameInfo)gameInfo));
                    } else {
                        gameInfo2 = gameInfo;
                    }
                    arrayList.add(gameInfo2);
                }
                if (!arrayList.isEmpty()) {
                    this.mGameInfoList.removeAll(arrayList);
                    this.mGameInfoList.addAll(arrayList);
                }
            } else {
                this.mGameInfoList.addAll(list);
            }
            this.notifyGameInfoChanged(GameInfoSource.HOME, this.mGameInfoList);
            if (!FP.empty(this.mGameInfoList)) {
                arrayList = new ArrayList<GameInfo>(this.mGameInfoList);
                if (this.mImGameInfoList.isEmpty()) {
                    this.mImGameInfoList.clear();
                    for (GameInfo gameInfo : arrayList) {
                        if (gameInfo.isHide() || gameInfo.getGameMode() != 1 && gameInfo.getGameMode() != 4 && gameInfo.getGameMode() != 7) continue;
                        this.mImGameInfoList.add(gameInfo);
                    }
                    this.notifyImGameInfoChanged();
                }
                this.pkGameInfoList.clear();
                for (GameInfo gameInfo : arrayList) {
                    if (gameInfo == null || gameInfo.getGameMode() != 1) continue;
                    this.pkGameInfoList.add(gameInfo);
                }
                this.notifyPkGameInfoListChanged();
                this.mRandomGameInfoList.clear();
                for (GameInfo gameInfo : arrayList) {
                    if (gameInfo == null || !gameInfo.isShowForRandRoom()) continue;
                    this.mRandomGameInfoList.add(gameInfo);
                }
            }
        }
    }

    public void updateImGameInfo(List<GameInfo> list) {
        if (!FP.empty(list)) {
            this.mImGameInfoList.clear();
            this.mImGameInfoList.addAll(list);
            this.notifyImGameInfoChanged();
        }
    }

    public void updateSingleGameInfo(List<GameInfo> list) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"updateSingleGameInfo from %d", (Object[])new Object[]{list != null ? list.size() : 0});
        }
        if (!FP.empty(list)) {
            this.singleGameInfoList.clear();
            this.singleGameInfoList.addAll(list);
            this.notifyGameInfoChanged(GameInfoSource.SINGLE, this.singleGameInfoList);
        }
    }

    public void updateSameScreenGameInfo(List<GameInfo> list) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"updateSameScreenGameInfo list: %s", (Object[])new Object[]{FP.size(list)});
        }
        if (FP.empty(list)) {
            return;
        }
        this.sameGameInfoList.clear();
        this.sameGameInfoList.addAll(list);
        this.notifyGameInfoChanged(GameInfoSource.SAMESCEEN, this.sameGameInfoList);
    }

    public void updateVoiceRoomGameInfo(List<GameInfo> list) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"updateVoiceRoomGameInfo list: %s", (Object[])new Object[]{FP.size(list)});
        }
        if (list == null) {
            return;
        }
        this.voiceRoomGameInfoList.clear();
        this.voiceRoomGameInfoList.addAll(list);
        this.notifyGameInfoChanged(GameInfoSource.VOICE_ROOM, this.voiceRoomGameInfoList);
    }

    public void updateInVoiceRoomGameInfo(List<GameInfo> list, List<GameInfo> list2) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"updateVoiceRoomGameInfo list: %s", (Object[])new Object[]{FP.size(list)});
        }
        if (list == null) {
            return;
        }
        this.inVoiceRoomGameInfoList.clear();
        this.inVoiceRoomGameInfoList.addAll(list);
        this.floatGameInfoList.clear();
        this.floatGameInfoList.addAll(list2);
        this.notifyGameInfoChanged(GameInfoSource.IN_VOICE_ROOM, this.inVoiceRoomGameInfoList);
    }

    public void updateVoiceRoomGameCateInfo(@Nullable List<GameCategory> list) {
        this.mGameCategory.clear();
        if (list != null) {
            this.mGameCategory.addAll(list);
        }
    }

    public List<GameCategory> getVoiceRoomGameCategory() {
        return this.mGameCategory;
    }

    public void addOrUpdateNoneModeGameInfo(List<GameInfo> list) {
        if (FP.empty(list)) {
            MLog.warn((Object)TAG, (String)"addOrUpdateGameInfo fail, gameInfo is null or empty", (Object[])new Object[0]);
            return;
        }
        MLog.debug((Object)TAG, (String)("addOrUpdateGameInfo list: " + list.size()), (Object[])new Object[0]);
        for (GameInfo gameInfo : list) {
            GameInfo gameInfo2 = this.getGameInfoByGid(gameInfo.getGid());
            if (gameInfo2 == null) {
                MLog.debug((Object)TAG, (String)"addOrUpdateGameInfo add gameInfo: %s", (Object[])new Object[]{gameInfo});
                this.mNoneModeGameList.add(gameInfo);
                continue;
            }
            if (gameInfo2.getGameMode() != 0) continue;
            gameInfo2.updateInfo(GameInfo.newBuilder((GameInfo)gameInfo));
            MLog.debug((Object)TAG, (String)"addOrUpdateGameInfo update gameInfo: %s", (Object[])new Object[]{gameInfo2});
        }
    }

    public void onAccountChanged() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onAccountChanged", (Object[])new Object[0]);
        }
        this.inVoiceRoomGameInfoList.clear();
        this.notifyGameInfoChanged(GameInfoSource.IN_VOICE_ROOM, this.inVoiceRoomGameInfoList);
    }

    public void removeGameInfoListener(OnGameInfoChangedListener onGameInfoChangedListener) {
        if (!this.mGameInfoListener.contains(onGameInfoChangedListener)) {
            return;
        }
        this.mGameInfoListener.remove(onGameInfoChangedListener);
    }

    private void notifyImGameInfoChanged() {
        if (FP.empty(this.mImGameInfoList) || this.mImGameInfoCHangedListeners.isEmpty()) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            this.notifyChange();
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new aoC(this));
        }
    }

    private void notifyChange() {
        for (OnImGameInfoCHangedListener onImGameInfoCHangedListener : this.mImGameInfoCHangedListeners) {
            onImGameInfoCHangedListener.onImGameChanged(Collections.unmodifiableList(this.mImGameInfoList));
        }
    }

    private void notifyGameInfoChanged(GameInfoSource gameInfoSource, List<GameInfo> list) {
        if (FP.empty(list) || this.mGameInfoListener.isEmpty()) {
            return;
        }
        ArrayList<GameInfo> arrayList = new ArrayList<GameInfo>(list);
        YYTaskExecutor.postToMainThread((Runnable)new aAC(this, gameInfoSource, arrayList));
    }

    private void notifyGameInfoChanged(GameInfoSource gameInfoSource, List<GameInfo> list, OnGameInfoChangedListener onGameInfoChangedListener) {
        if (FP.empty(list) || onGameInfoChangedListener == null) {
            return;
        }
        ArrayList<GameInfo> arrayList = new ArrayList<GameInfo>(list);
        YYTaskExecutor.postToMainThread((Runnable)new auC(this, onGameInfoChangedListener, gameInfoSource, arrayList));
    }

    public boolean isAllGameListReady() {
        return !FP.empty(this.mGameInfoList);
    }

    public boolean isOftenPlayUser(String string2) {
        boolean bl2 = false;
        KvoSource kvoSource = KvoModuleManager.getModuleData(GameInfoModule.class);
        if (kvoSource instanceof GameInfoModuleData) {
            List list;
            GamePlayInfo gamePlayInfo;
            Map map = ((GameInfoModuleData)kvoSource).getGameCacheInfo();
            if (!TextUtils.isEmpty((CharSequence)string2) && map != null && (gamePlayInfo = (GamePlayInfo)map.get(string2)) != null && !FP.empty((Collection)(list = gamePlayInfo.getGamePlayList()))) {
                CommonConfigData commonConfigData;
                int n2 = 0;
                int n3 = 7;
                int n4 = 15;
                AConfigData aConfigData = UnifyConfig.INSTANCE.getConfigData(BssCode.COMMON_CONFIG);
                if (aConfigData instanceof CommonConfig && (commonConfigData = ((CommonConfig)aConfigData).getData()) != null) {
                    n3 = commonConfigData.oftenPlayUserDays;
                    n4 = commonConfigData.oftenPlayUserTimes;
                }
                for (GamePlayInfoDBBean gamePlayInfoDBBean : list) {
                    long l2;
                    if (gamePlayInfoDBBean == null || (l2 = System.currentTimeMillis() - gamePlayInfoDBBean.getEndTs()) > (long)(n3 * 24 * 60 * 60 * 1000) || gamePlayInfoDBBean.getUid() != AccountUtil.getUid()) continue;
                    ++n2;
                }
                if (n2 >= n4) {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    public boolean hasLoadRoomGameList() {
        return this.hasLoadRoomGameList || !this.voiceRoomGameInfoList.isEmpty();
    }

    public boolean hasLoadInRoomGameList() {
        return this.hasLoadInRoomGameList || !this.inVoiceRoomGameInfoList.isEmpty();
    }

    public void setRoomGameLoaded() {
        this.hasLoadRoomGameList = true;
    }

    public void setRoomInGameLoaded() {
        this.hasLoadInRoomGameList = true;
    }

    public String getAlgorithmTokenUrlencode() {
        return HomeReportUtils.INSTANCE.getAlgorithmTokenUrlencode();
    }

    private void notifyPkGameInfoListChanged() {
        if (this.mPkGameInfoChangedListener == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            this.mPkGameInfoChangedListener.onPkGameInfoChanged(Collections.unmodifiableList(this.pkGameInfoList));
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new AHC(this));
        }
    }

    public void resetGame() {
        ((ICoinsService)ServiceManagerProxy.getService(ICoinsService.class)).resetGame();
        this.voiceRoomGameInfoList.clear();
        YYTaskExecutor.execute((Runnable)new aeC(this));
    }

    static /* synthetic */ void access$000(GameInfoService gameInfoService2) {
        gameInfoService2.notifyChange();
    }

    static /* synthetic */ List access$100(GameInfoService gameInfoService2) {
        return gameInfoService2.mGameInfoListener;
    }

    static /* synthetic */ List access$200(GameInfoService gameInfoService2) {
        return gameInfoService2.pkGameInfoList;
    }

    static /* synthetic */ OnPkGameInfoChangedListener access$300(GameInfoService gameInfoService2) {
        return gameInfoService2.mPkGameInfoChangedListener;
    }
}

